# -*- coding: UTF-8 -*-

import os
import sys
import re
from vmware import Utility

class LoginManager:
   logindefs = '/etc/login.defs'
   logindefs_parser = re.compile(r'^\s*(\w+)\s+(\S+)\s*$')

   config = {}

   def __init__(self, file = logindefs):
      self.logindefs = file
      self.Parse()
      self.dirty = False
   

   """
   Parse the configuration files for login options.

   This method will parse one file:
      /etc/login.defs
   This file defines the login settings.
   """
   def Parse(self):
      file = Utility.read_file(self.logindefs)

      for line in file:
         matches = self.logindefs_parser.match(line)

         if matches is not None:
            key = matches.group(1)
            value = matches.group(2)
            self.config[key] = value

   """
   Write the configuration files to disk

   This method will rewrite the files to the disk, however,
   it does not store comments or order.
   """
   def WriteConfig(self):
      stream = open(self.logindefs, 'w')
      self.__WriteConfig(stream)
      stream.close()

      dirty = False

   """
   Write the configuration files to stdout

   This method will 'print' the files to stdout, however,
   it does not store comments or order
   """
   def PrintConfig(self):
      stream = sys.stdout

      stream.write('%s\n' % self.logindefs)
      self.__WriteConfig(stream)

   def __WriteConfig(self, stream):
      keys = self.config.keys()
      keys.sort()

      stream.write('# Autogenerated by esxcfg-auth\n\n')

      for key in keys:
         value = self.config[key]
         stream.write('%s\t%s\n' % (key, str(value)))

   def SetPassMaxDays(self, value):
      self.dirty = True
      self.config['PASS_MAX_DAYS'] = '%d' % (value)

   def SetPassMinDays(self, value):
      self.dirty = True
      self.config['PASS_MIN_DAYS'] = '%d' % (value)

   def SetPassMinLen(self, value):
      self.dirty = True
      self.config['PASS_MIN_LEN'] = '%d' % (value)

   def SetPassWarnAge(self, value):
      self.dirty = True
      self.config['PASS_WARN_AGE'] = '%d' % (value)

