# -*- coding: UTF-8 -*-

"""
XXX

The {Add,Del,Set}LookupOrder functions do not currently fault on error,
rather silently fail.  If you specify a value that is not fault, you will
not be notified.
"""

import os
import sys
import string
import re
from vmware import Utility

class NSSManager:
   nsswitch = '/etc/nsswitch.conf'
   nsswitch_parser = re.compile(r'\s*(\w+):\s*(.+)$')
  
   config = { }

   def __init__(self, file = nsswitch):
      self.nsswitch = file
      self.Parse()
      self.dirty = False
   

   """
   Parse the configuration files for NSS

   This method will parse one file:
      /etc/nsswitch.conf
   This file defines the NSS client settings.
   """
   def Parse(self):
      file = Utility.read_file(self.nsswitch)

      for line in file:
         matches = self.nsswitch_parser.match(line)

         if matches is not None:
            # service : ( lookup )
            # passwd : ( files, nis, ldap )
            if matches.group(1) not in self.config:
               self.config[matches.group(1)] = [ ]

            self.config[matches.group(1)] = matches.group(2).split(' ')

   """
   Write the configuration file to disk

   This method will rewrite the files back to the disk, however,
   it does not store comments or order.
   """
   def WriteConfig(self):
      stream = open(self.nsswitch, 'w')
      self.__WriteConfig(stream)
      stream.close()

      self.dirty = False

   """
   Writes the configuration files to stdout

   This method will 'print' the files to stdout, however,
   it does not store comments or order.
   """
   def PrintConfig(self):
      stream = sys.stdout

      stream.write('%s\n' % self.nsswitch)
      self.__WriteConfig(stream)

   def __WriteConfig(self, stream):
      stream.write('# Autogenerated by esxcfg-auth\n\n')

      keys = self.config.keys()
      keys.sort()
      for key in keys:
         stream.write('%s:    \t%s\n' % (key, ' '.join(self.config[key])))

   """
   Append a new lookup method

   The service is the feature to be looked up, and the lookup is a
   string containing the new lookup method
   """
   def AddLookupOrder(self, service, lookup):
      self.dirty = True
      if not self.config.has_key(service):
         return

      if lookup not in self.config[service]:
         self.config[service].append(lookup)

   """
   Replace the current lookup methods

   The service is the feature to be looked up, and the lookup is a
   string containing the lookup methods (in order)
   """
   def SetLookupOrder(self, service, lookup):
      self.dirty = True
      if isinstance(lookup, string):
         lookup = lookup.split(' ')

      if isinstance(lookup, tuple):
         lookup = list(lookup)

      if self.config.has_key(service):
         self.config[service] = lookup

   """
   Delete a lookup method

   The service is the feature to be looked up, and the lookup is a
   string of the lookup method to be removed.
   """
   def DelLookupOrder(self, service, lookup):
      self.dirty = True
      if self.config.has_key(service):
         if lookup in self.config[service]:
            self.config[service].remove(lookup)
