# -*- coding: UTF-8 -*-

"""
XXX

The {Add,Del}Module functions do not fault when a value is not found, instead
they silently fail.  If the search string is not found, you will not be
notified.
"""

import os
import sys
import string
import re
from vmware import Utility

class PAMManager:
   systemauth = '/etc/pam.d/system-auth'
   systemauth_parser = re.compile(r'(\w+)\s+(?:(\[[^\]]+\])|(\w+))\s+([^\s]+)\s*(.*)$')

   config = { }
   def __init__(self, sysauth = systemauth):
      self.systemauth = sysauth
      self.Parse()
      self.dirty = False


   """
   Parse the configuration files for PAM (system authentication only!!!)

   This method will parse one file:
      /etc/pam.d/system-auth
   This file is RedHat specific, and is responsible for the user authentication
   settings on the machine.
   """
   def Parse(self):
      file = Utility.read_file(self.systemauth)

      for line in file:
         matches = self.systemauth_parser.match(line)

         if matches is not None:
            # application : [ [ library, requirement, arguments  ] ]
            # account : [ ['/lib/security/pam_unix.so','required',None] ]
            if matches.group(1) not in self.config:
               self.config[matches.group(1)] = []

            if matches.group(2) is None:
               self.config[matches.group(1)].append( \
                     [matches.group(4), matches.group(3), matches.group(5)])
            elif matches.group(3) is None:
               self.config[matches.group(1)].append( \
                     [matches.group(4), matches.group(2), matches.group(5)])

   """
   Write the configuration files back to disk

   This method will rewrite the files back to the disk, however,
   it does not store comments or order.
   """
   def WriteConfig(self):
      stream = open(self.systemauth, 'w')
      self.__WriteConfig(stream)
      stream.close()
      self.dirty = False

   """
   Writes the configuration files to stdout

   This method will 'print' the files to stdout, however,
   it does not store comments or order.
   """
   def PrintConfig(self):
      stream = sys.stdout
      
      stream.write('%s\n' % self.systemauth)
      self.__WriteConfig(stream)

   def __WriteConfig(self, stream):
      stream.write('#%PAM-1.0\n')
      stream.write('# Autogenerated by esxcfg-auth\n\n')

      keys = self.config.keys()
      keys.sort()
      for key in keys:
         for library in self.config[key]:
            stream.write('%s    \t%s    \t%s    \t    %s\n' % (key, library[1], library[0], library[2]))
         stream.write('\n')

   """
   Append an argument to a library

   The application is the application, the library_name is the library name
   (not the full path!), and the argument is the new argument to be passed
   to the library.
   """
   def AddArgument(self, application, library_name, argument):
      self.dirty = True
      for library in self.config[application]:
         if re.search(library_name,library[0]):
            tokens = library[2].split()
            if argument not in tokens:
               tokens.append(argument)
            library[2] = ' '.join(tokens)

   """
   Delete an argument to a library

   The application is the application, the library_name is the library name
   (not the full path!), and the arugment is the old argument to no longer
   be passed to the library.
   """
   def DelArgument(self, application, library_name, argument):
      self.dirty = True
      for library in self.config[application]:
         if re.search(library_name, library[0]):
            tokens = library[2].split()
            if argument in tokens:
               tokens.remove(argument)
            library[2] = ' '.join(tokens)

   def EnableMD5Password(self):
      self.AddArgument('password', 'pam_unix.so', 'md5')
      self.AddArgument('password', 'pam_unix2.so', 'md5')

   def DisableMD5Password(self):
      self.DelArgument('password', 'pam_unix.so', 'md5')
      self.DelArgument('password', 'pam_unix2.so', 'md5')

   def EnableShadowPassword(self):
      self.AddArgument('password', 'pam_unix.so', 'shadow')
      self.AddArgument('password', 'pam_unix2.so', 'shadow')

   def DisableShadowPassword(self):
      self.DelArgument('password', 'pam_unix.so', 'shadow')
      self.DelArgument('password', 'pam_unix2.so', 'shadow')

   def ShadowEnabled(self):
      self.dirty = True
      for library in self.config['password']:
         if re.search('pam_unix', library[0]):
            tokens = library[2].split()
            return 'shadow' in tokens

   """
   Gets the stack for an application

   The entire stack for a realm is returned, which is a copy of the internal
   stack so as to prevent modifications externally.  This is useful for
   finding the insertion point for a new modules.

   NOTE: This method is for future use.  It is currently unused.  Feel free
   to delete.
   """
   def GetStack(self, application):
      if not self.config.has_key(application):
         return None
      else:
         return list(self.config[application])

   """
   Add a library to the stack

   The new_library is the full path to the library, including the library
   name, the application is the application, and the level is the
   requisite level.  Args is a string of arguments to be passed to the
   library.  If there are none, pass in '' or None.  Depth is the depth in
   the stack
   """
   def AddModule(self, new_library, application, level, args, depth):
      self.dirty = True
      if args is None:
         args = ''

      if not self.config.has_key(application):
         return

      self.config[application].insert(depth, [new_library, level, args])

   """
   Delete a library from the stack

   The library_name is the library name (not the full path!), the application
   is the application.
   """
   def DelModule(self, library_name, application):
      self.dirty = True
      if not self.config.has_key(application):
         return

      for library in self.config[application]:
         if library[0].endswith(library_name):
            self.config[application].remove(library)
