#######################################################################
# Copyright (C) 2006 VMWare, Inc.
# All Rights Reserved
########################################################################
#
#    ha.py  -- hostAgent interface management
#

from elementtree.ElementTree import Element, ElementTree, tostring
from vmware.descriptor import utils
import sys


# ----------------------------------------------------------------------------
def ScanOutput(scanhash):
	""" Converts hash from ScanDepot() into XML output for hostagent
	consumption. """
	root = ToElementTree( scanhash ).getroot()
	return tostring(root)

# ----------------------------------------------------------------------------
def ToElementTree( bundles ):
	"""With bundles given in the dict format that ScanDepot() creates,
	this function returns an ElementTree instance that can be converted
	into xml"""
	root = Element( 'scan-response' )
	for bKey, bundle in bundles.items():
		bRoot = Element( 'bulletin' )
		bRoot.attrib['ID'] = bKey
		root.append( bRoot )

		for key in [ 'reqReboot', 'reqVMoff', 'installed',
		             'noDiskSpace', 'applicable', 'obsolete', 
		             'obsoletedByHost',
		             'restartHostd', 'integritySuccess' ]:
			utils.BoolElem( bRoot, key, bundle.get(key, False))

		for key in [ 'integrityDescription', 'systemStates']:
			if utils.IsListLike(bundle[key]):
				utils.SetElem( bRoot, key,
					       ','.join(bundle[key]) )
			else:
				utils.SetElem( bRoot, key, bundle[key] )

		utils.IDListElem( bRoot, 'reqIDs', bundle['reqIDs'],
				  bundle['sysStateDeps'] )
		
		for key in [ 'obsoleteIDs', 'conflictIDs',
		             'missingIDs', 'availableIDs' ]:
			utils.IDListElem( bRoot, key, bundle[key] )

		for key in [ 'conflictDeps', 'missingDeps', ]:
			depsElem = Element( 'DepList' )
			depsElem.attrib['field'] = key
			bRoot.append( depsElem )
			depsElem.text = "TODO: deps not implemented"

	#NOTE, returning an ElementTree instead of a string makes this function
	#      easier to test
	return ElementTree( root )

# ----------------------------------------------------------------------------
def HAProgressCB(done_steps, total_steps, stepname, sub_done, sub_total):
	""" ProgressBar class callback function for host agent interface.
        It outputs to stdout, returns nothing.
        """
        print '%d%%, "%s"' % (done_steps * 100L / total_steps, stepname)
        sys.stdout.flush()
