import constants
import os
import re
import sys
import struct

"""data structure for BlockList Mapping """
class BlockListMapper:
    
    vmdkOffset=[]
    devUUID=[]
    devOffset=[]
    byteCount=[]
    devUUIDMap={}
    BlockListLength=None
    
    def __init__(self,blocklist=[],vmdkOffset=[],devUUID=[],devOffset=[],byteCount=[],devUUIDMap={}):
        
        self.vmdkOffset=vmdkOffset
        self.devUUID=devUUID
        self.devOffset=devOffset
        self.byteCount=byteCount
        self.BlockListLength=len(vmdkOffset)
        self.devUUIDMap=devUUIDMap
        #vmdk file size in bytes
        #self.vmdkSize=long(re.search('\([0-9].*bytes' \
        #                            ,blocklist[0]).group().strip('bytes').strip('(').strip())
        
        #self.vmdkSize=0
        self.fileSize=""
        
            
       
"""main disk class for storing vmdk and physical disk information"""
class Disk:
    
    def __init__(self,diskList):
       
        self.UUID=""                              #UUID for vmfs volume
        self.blockList=[]                         #block list for vmdk
        self.fileName=diskList[1]                 #vmdk file name
        self.scsiID=(diskList[0].split('.'))[0]   #scsiID in vmx
        self.vmhbaDevs={}                         #vmhba to /dev/device map
        self.devUUIDMap={}                        #map dev devices to devUUID for extents
        self.adapterType=0
            

    def getUUID(self):
        return self.UUID
    
    def getDevUUIDMap(self):
        return self.devUUIDMap
    
    def setUUID(self,vmdkPath):
        self.UUID=vmdkPath.split('/')[3]

   
    def readBlockList(self):
        fh=os.popen(constants.vmkfstools + " -t0 " + '"'+ self.getFileName() +'"') 
        self.blockList=fh.readlines()
        return self.blockList
        
    def getBlockList(self):
        return self.blockList
    
    def setDiskPath(self,path):
        """sets the full path of the vmdk file"""
        """needs work?"""
        temp=len(self.fileName.split('/'))                    
        if temp == 1:                                                    #if len is = 1 after split, we only have the vmdk name
            self.fileName=path+"/"+self.fileName                         #set the full path of the vmdk
        
    
    def getFileName(self):
        return self.fileName
    
    
    def getRawBlockList(self):
        """parsed block list used for restoring"""
        i=0
        writeOffset=[]
        byteCount=[]
        readSeek=[]
        devUUID=[]
        i=0
        #------------------------------------------------------------------------------------
        #skip the header line we get from vmkfstools -P causes matches in regex we dont want
        bl=self.blockList[1:]
        #------------------------------------------------------------------------------------
        
        #good place to set the vmdk size
        self.setVMDKFileSize()
        
        for each in bl:
            #debug
            #print "Disk 96:blocklist : %s\n" % (each)
            #debug
            
            temp=re.search("\[\s*[0-9]*",each)                       #find block offset in vmdk
            if temp:
                writeOffset.append(temp.group().strip('[').strip())

            temp=re.search(":\s*[0-9]*]",each)                #find read count in bytes
            if temp:
                byteCount.append(temp.group().strip(':').strip(']').strip())
                #debug
                #print "block count : "+byteCount[i]
                #debug
                
            temp=re.search("\(\s*[0-9]*",each)                #find input seek
            if temp:
                readSeek.append(temp.group().strip("(").strip())
               
                
            temp=re.search("[0-9a-f]{8}-[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{12}",each)
            if temp:
                devUUID.append(temp.group())
                i +=1
            #debug
            #print "Disk 114: devUUIDMap :%s\n" % (self.devUUIDMap)    
            #debug
            
        return BlockListMapper(self.blockList,writeOffset,devUUID,readSeek,byteCount,self.devUUIDMap)

    def readVMHBAs(self):
        
        """find what vmhba Devs are for this disk's UUID and what /dev/devices each vmhba maps to"""
        """more that 1 VMHBA Dev means that this disk is on extents"""
        
        fh=os.popen(constants.vmkfstools + " -P /vmfs/volumes/" + self.UUID) #run vmkfstools -P to see if volume is an extent
        partitionInfo=fh.readlines()  #out from vmkfstools -P
        fh.close()
        fh=os.popen(constants.vmhbadevs)
        devmaps=fh.readlines()  #output from vmhbadevs
        fh.close()
        
        #debug
        #print "Disk 130: devmaps: %s" % (devmaps)
        #debug
        
        numPartitions=0;
        """populate devUUID to Dev Device Map"""       
        for each in partitionInfo:
            #parse out parition info from vmkfstools -P
            result=re.search("\s*vmhba[0-9].*",each,re.IGNORECASE)
            if result:
                
                #get the partition information from the end of the vmhba#
                partitionNumber=re.search(":[0-9]+$",each,re.IGNORECASE)
                
                #strip off : from the beginning of the partition and store it.
                strippedPart=partitionNumber.group().strip(":")
                
                #remove the partition information so we match vmhbadevs              
                result=result.group()
                #debug
                #print "Disk.py Partition Info (result) = %s,partitionNumber = %s" % (result,strippedPart)
                #debug
                result=result[: (-len(partitionNumber.group()))]
                
                #debug
                #print "Disk 151: results: %s\n" % (result)
                #print "Disk 152: partitionNumber: %s\n" % (partitionNumber.group())
                #debug
                
                for line in devmaps: #parse output in devmaps from vmhbadevs
                    test=line.split()
                    #debug
                    #print "Disk 150: test: %s" % (test)
                    #debug
                                         
                    
                    if result.strip() == test[0].strip():
                        
                        #check if the partition > 1. That means we are not from the beginning
                        #of the disk and need to account for this.
                        if int(strippedPart) > 1:
                            
                            #check if we are usin cciss controller. Only valid for local storage.
                            if (re.search("cciss", test[1], re.IGNORECASE)):
                                #debug
                                #print "Backing up on cciss. Adding P to partition"
                                #debug
                                
                                #add pX to /dev/cciss/c0d0 so we get /dev/cciss/c0d0pX
                                test[1]=test[1]+"p"+strippedPart
                                
                            #must be a sdX device
                            else:                                        
                                test[1]=test[1]+strippedPart 
                        
                        #debug
                        #print "Disk 191: test[1]=%s\tstrippedPart=%s\n" %(test[1],strippedPart)
                        #print "Disk 192: result : %s" % (result) 
                        #debug
                        
                        #store data in to array
                        self.vmhbaDevs[result]=test[1].strip()
                        
                        #debug
                        #print "Disk 197 : vmhbaDevs[result] : %s" % (self.vmhbaDevs[result])
                        #debug
                        self.devUUIDMap[self.vmhbaDevs[result]]=self.readDevUUID(self.vmhbaDevs[result])         
            #debug
            #print self.devUUIDMap
            #debug
                     
    def getVMHBAs(self):
        return self.vmhbaDevs
   
   
    def readDevUUID(self,DevDevice):
        """reads devUUID from physical disk (/dev/device) and map it to that /dev/device \
        usefull for extents only"""
        try:
            fh=open(DevDevice,'rb')
            fh.seek(500000)                                                        #lvm does not start till at least 1mb so skip half for speed and safety
        except IOError, e:
            print "Could not open %s, try to rescan and run backup again" % (DevDevice)
            sys.exit(e)
            
        while 1:                                                               #read until lvm magic is found
            lvmMagic=lvm=fh.read(4)                                            #read 4 bytes at a time
            if fh.tell() > 3000000:                                            #read past 3MB adn no lvm
                print "[ERROR Disk:161]: %s can not find VMFS LVM....exiting" % DevDevice
                sys.exit()
                
            if ("%04x" % struct.unpack('I',lvmMagic))== constants.lvmMagic:    #found lvm
                lvmOffset=(fh.tell()-4)
                #print "found lvm magic at %i" % lvmOffset                    #debug
                fh.seek(lvmOffset)                                             #move to where we found the lvm Magic
                fh.seek(lvmOffset+constants.devUUIDOffset)                     #move to devUUID offset 
                devUUID=constants.devUUIDFormat % struct.unpack('IIHBBBBBB',fh.read(constants.devUUIDLenght))
                break
            
        fh.close()
        return devUUID
    
    def readSCSIAdapterType(self,VMDK):
        
        try:
            fh=open(VMDK,'r')
        except IOError ,e:
            print "Could not determine the scsi adapter type used for this disk file"
            return None
        
        lines=fh.readlines()
        fh.close()
        for each in lines:
            found=re.search('lsilogic|buslogic', each, re.IGNORECASE)
        
            if found:
                self.adapterType=found.group()
                break
        
    def getSCSIAdapterType(self):
        return self.adapterType
    


    def setVMDKFileSize(self):
        size=re.search("\([0-9].*bytes in size",str(self.blockList[:1]),re.IGNORECASE).group()
        self.fileSize=long(size.strip('(').split()[0])
        
    
    def checkRDM(self,pathToVMDK):      
        """Check for rdms. There is no point to deal with RDMs"""
        fh=""
        try:
            fh=open(pathToVMDK,'r')
        except IOError ,e:
            print "Disk.py->checkRDM:Can not not open %s to check for RDM.\n" % (pathToVMDK)
            print "Disk %s might not be restorable if it is an rdm." % (pathToVMDK)
            print "Error: %s" % (e)
            return 1
        
        for line in fh.readlines():
            #debug
            #print "Checking for RDMs: %s" % (line)
            #debug
            
            #if we find rdm in the descriptor file
            rdm=re.search("RawDeviceMap", line, re.IGNORECASE)
            if (rdm):
                fh.close()
                return 1
        
        fh.close()    
        return 0

    """
    def dumpBlockList(self):
        return 
    """