"""Restores VMDK from physcial LUN"""
import sys
import pickle
import os
import constants
import sys
import Progress
import re

class restore:
    
    def __init__(self,filename):
        
        self.fileName=filename
        self.fh=""
        self.fileData=[]
        self.volumeList=[]
        self.diskList=[]
        self.restoreDIR=""
        self.vmID=0
        self.destDataStore=0
        self.restoreDisk=0                      #VMDK selected for restore
        self.restoreFileName=""
        self.backupUUID=""                       #vmfs UUID where the original vmdk was backed up from
        self.__open()
        
        
        
    def __open(self):
        """
        private function
        try to open a dump backup dump file for restore
        exit if we can not        
        """
        try:
            self.fh=open(self.fileName,'rb')
        except IOError, e:
            print "Unable to open %s ,%s" % (self.fileName,e)
            print "Please make sure you enter the full path and file name "
            sys.exit()
             
            
    def readOBJ(self):
        
        """load data that was saved during a backup procedure"""
        self.fileData=pickle.load(self.fh)  
        
        
    def selectRestorableVMS(self):
        """
        can not be called be for readOBJ
        de-serialize objects read from file and create menu for each vm we found
        """
        
        print "\n\n\n"
        print "-"*40
        i=1
        for each in self.fileData:
            print "%i) %s" % (i,each.getName())
            i +=1
        print "\nFound %i VMs available to restore\n\n" % (i-1)
        
        while 1:
            try:    
                select=raw_input("select VM to restore ["+str(i-i+1)+" - "+str(i-1)+"] or 'q' to quit:")
            except KeyboardInterrupt:
                print "\nAborting...."
                sys.exit()
                
            if select.isdigit():
                if int(select) in range(i-i+1,i):
                    #return (int(select))
                    self.vmID=int(select)
                    break
                
            elif select == 'q' or select == 'Q':
                sys.exit()
            
    def selectDisktoRestore(self):
        
        print "Available VMDKs to restore: \n"
        print "-"*40
        
        i=1
        for disks in self.fileData[self.vmID-1].getDisks():
            print "%i) %s"  % (i,disks.getFileName())
            self.diskList.append(disks)
            i +=1
        
        while 1:
            try:
                select=raw_input("\nselect VMDK to restore ["+str(i-i+1)+" - "+str(i-1)+" ]: ")
            except KeyboardInterrupt:
                print "\nAborting...."
                sys.exit()
                
            if select.isdigit():
                
                if int(select) in range(i-i+1,i):
                   
                    self.restoreDisk=int(select)
                    break
                   
        
        
    def selectRestoreDS(self):
       
        vmfsUUID={}
        #try get a directory listing to restore to, exit if we can list contents of /vmfs/volumes
        try:
            dirList=os.listdir(constants.VMFSbaseDir)
        except OSError, e:
            sys.exit()
            
        for each in dirList:
            try:            
                #if link then add it to list
                vmfsUUID[constants.VMFSbaseDir+each]=os.readlink(constants.VMFSbaseDir+each)
            except OSError, e:
                #not a link so skip it
                continue

                   
            self.volumeList.append(constants.VMFSbaseDir+each)
            
            
         #check if we are restoring to the same data store that we backed up from
         #do not allow to restore to this datastore
         ###########################################################################
         #                                                                         #
         #  WARNING....WARNING....WARNING....                                      #
         #  DO NOT restore to the same DataStore that you are recovering from.     #
         #  If you do this, loss of data is guaranteed.....                        #
         #                                                                         #
         ###########################################################################   
        index=0
        for volume in self.volumeList:
            #debug
            #print "Volume index-- %i :%s" % (index, self.volumeList[index])
            #debug  
                          
            if self.diskList[self.restoreDisk-1].getFileName().split('/')[3]== vmfsUUID[volume]:
                self.volumeList.pop(index)  
              
            
            index +=1
        ##################################################################################
        #                                                                                #
        ##################################################################################
        
        
        #loop over volume names and display them   
        listNum=1
        for volume in self.volumeList:
                print "%i) %s ------> [VMFS UUID: %s]\n" % (listNum,volume,vmfsUUID[volume])
                listNum +=1
        
        
        while 1:
            try:
                select=raw_input("select VMFS DataStore to restore to ["+str(listNum-listNum+1)+" - "+str(listNum-1)+"] : ")
            except KeyboardInterrupt:
                print "\nAborting..."
                sys.exit()
                
            if select.isdigit():
                if int(select) in range(listNum-listNum+1,listNum):
                    self.destDataStore=int(select)
                    break
                    
   
   
    def selectRestoreDIR(self):
        
        while 1:
            
            try:
                select=raw_input("Enter the directory to restore to: ")
           
            except KeyboardInterrupt:
                print "\nAborting..."
                sys.exit()    
            
            if os.path.exists(self.volumeList[self.destDataStore-1] + "/" + select):
                
                print self.volumeList[self.destDataStore-1] + "/" + select + " already exists"
                check='Are you sure you want to restore to '  +  self.volumeList[self.destDataStore-1] + "/" + select + ' [y/n]: '
                yesno=raw_input(check)
                
                if yesno == 'y':
                    self.restoreDIR=select
                    return
                elif yesno =='n':
                    continue
                else:
                    continue
            
            else:
                
                try:
                    os.mkdir(self.volumeList[self.destDataStore-1] + "/" + select)
                    print self.volumeList[self.destDataStore-1] + "/" + select + " created successfully."
                    self.restoreDIR=select
                    break
                
                except OSError, e:
                    print "Error : %s" % e
                    sys.exit()

   
    """--------------------------------"""
    """ main restore work is done here """
    """--------------------------------"""
    
    def selectRestoreFile(self):
        
        while 1:
            
            try:
                select=raw_input("Enter the file name to restore to: [ex: recovered.vmdk]: ")
            except KeyboardInterrupt:
                print "\nAborting..."
                sys.exit()
                
            if os.path.exists(self.volumeList[self.destDataStore-1] + "/" \
                              + self.restoreDIR \
                              + "/" \
                              + select):
                
                print self.volumeList[self.destDataStore-1] \
                        + "/" + self.restoreDIR + "/" + select + " already exists."
                print "Please select a different filename"
                continue
            
            if re.search("\.vmdk", select, re.I):
                self.restoreFileName=select
                return
                
            else:
                print "Filename needs to have a vmdk extenstion.  Please correct the filename."
                continue
                
            

         
    def restoreVM(self):
         
        #debug 
        #print"vmid=%s \n destDataStore=%s \n vmkdk=%s\n" % (vmID,self.volumeList[destDataStore-1],vmdk)        #debug
        #debug
        
        print "restoring VM: %s\nDisk: %s \nto : %s\n" % (self.fileData[self.vmID-1].getName(),self.diskList[self.restoreDisk-1].getFileName(), \
                                                          self.volumeList[self.destDataStore-1] + \
                                                          "/" + self.restoreDIR + "/" + self.restoreFileName)
        
        #print "creating %s directory in %s " % (restoreDIR,self.volumeList[self.destDataStore-1])
        rbl=self.diskList[self.restoreDisk-1].getRawBlockList()            #get parsed blocklist for selected disk
        
        #get total size in MBytes that we will restore for progress bar#
        total=0
        totalProgress=0
        
        for bytes in rbl.byteCount:
            total=total+long(bytes)
        
        total=(total /(1024*1024))
        #debug
        #print "Total restore in bytes %i" % (total)
        #debug
        #progress bar
        
        prog=Progress.progressBar(0,total,50)
        
        #check space available on destination 
        #filesize is in bytes checkFreeSpace returns KB
        if self.checkFreeSpace(self.volumeList[self.destDataStore-1]) < self.diskList[self.restoreDisk-1].fileSize:
            
            print "not enough free space on %s" % self.volumeList[self.destDataStore-1]
            print "Restore file size %i" % self.diskList[self.restoreDisk-1].fileSize
            print "Destination space available %i" % self.checkFreeSpace(self.volumeList[self.destDataStore-1])
            sys.exit()
                        
        ######################################################################################
        #create a vmdk in the restore dir the same size as the source                        #
        #create in KB or in Bytes?                                                           #
        ######################################################################################
        fh=os.popen(constants.vmkfstools \
                     + " -c " + str(self.diskList[self.restoreDisk-1].fileSize/1024) + "K " \
                     + " -a" + self.diskList[self.restoreDisk-1].getSCSIAdapterType() \
                     + " " + self.volumeList[self.destDataStore-1] \
                     + "/"+self.restoreDIR + "/" + self.restoreFileName)
        
        fh.close()
        
        
        #need to find the flat file to restore to:
        fh=open(self.volumeList[self.destDataStore-1]+"/"+self.restoreDIR+"/"+self.restoreFileName,'r')
        for each in fh.readlines():
            flatFile=re.search('\".*vmdk\"',each,re.I)
            if flatFile:
                flatFile=flatFile.group().strip('"')
                break
        
        fh.close()    
        
        
        
        fh=None   #fh read
        fhw=None  #fh write
        
        #start to write from dev device to vmdk
        print "restoring data....\n"
        
        
        try:
            fhw=open(self.volumeList[self.destDataStore-1]+"/"+self.restoreDIR+"/"+flatFile,'wb')
        except OSError, e:
            print "Failed to write to %s" % self.volumeList[self.destDataStore-1]+"/"+restoreDIR+"/"+flatFile
            sys.exit()
            
        for each in rbl.devUUIDMap.keys():
                       
            #debug
            #print "Restore 327: rbl.devUUIDMap.keys(): %s" %(each)
            #self.numbExtents(rbl.devUUIDMap)
            #debug
            
            
            #openDev=each
            
            #need to test for cciss. Only valid for local scsi 
            #if cciss strip off the partition table
            checkDev=re.search("cciss",each,re.IGNORECASE)
            if (checkDev):
                findPart=re.search("p[0-9]+$",each,re.IGNORECASE)
                #debug
                #print"Restore.py: findPart.group()=%s\n" % (findPart.group())
                #debug
                partLength=len(findPart.group())
                openDev=each[:len(each)-partLength]
                               
            #check for sd device on local storage only  
            #strip off the partition table if exists. Will only exists on local storage or if there 
            #2 or more vmfs volumes on the same lun 
                
            elif (re.search("/dev/sd[a-z]+[0-9]",each,re.IGNORECASE)):
                findPart = re.search("/dev/sd",each,re.IGNORECASE)
                findPart = re.search("[0-9]+$",each,re.IGNORECASE)
                partLength=len(findPart.group())
                
                if partLength >=1: #the dev device has a partition on it
                    
                    openDev=each[:len(each)-partLength]
                    
                    #debug
                    #print "Partition: %s on dev device: %s" % (findPart.group(),each)
                    #print "Restore: 345: partition info: %s\n" % (partLength)
                    #debug
               
            else: #we have no partition information so we can just restore
                openDev=each
                
            try:
                #debug
                #print "Restore:Opening device:%s \n" % (openDev)
                #debug
                fh=open(openDev,'rb')
                
            except OSError, e:
                print "Failed to read from: %s" % each
                sys.exit()
            
            
            
            for block in range(rbl.BlockListLength):   
                
                #debug
                #print "Restore 348: Block #:%i" % (block)
                #print "rbl.devUUID[block]: %s \n rbl.devUUIDMap[each]: %s" % (rbl.devUUID[block],rbl.devUUIDMap[each]) 
                #debug
                """check the devUUID to make sure we are reading from the correct /dev/device
                this is important when dealing with extents
                blocklists have multiple devUUIDs when vmdk files are on extents
                """
                
                if rbl.devUUID[block] == rbl.devUUIDMap[each]:
                    
                    #debug
                    #print "Restore 359-370: rbl.devUUID[block]: %s \n rbl.devUUIDMap[each]: %s" % (rbl.devUUID[block],rbl.devUUIDMap[each]) 
                    #print  (long(rbl.devOffset[block]))
                    #debug
                    
                    try:
                        fh.seek(long(rbl.devOffset[block])) 
                    
                        fhw.seek(long(rbl.vmdkOffset[block]))
                    
                        vOFF=long(rbl.vmdkOffset[block])
                    
                        dOFF=long(rbl.devOffset[block])\
                        
                    except IOError, e:
                        print "\nError:%s\nRead Seek offset: %i\nWrite Seek offset: %i\nVMDK Offset:%i\n Device Offset:%i" % \
                            (e,long(rbl.devOffset[block]),long(rbl.vmdkOffset[block]),vOFF,dOFF)
                        sys.exit()
                    
                    #meat and potatoes 
                    #loop over blocklist entries breaking them in to 1MB chunks
                    for bytes in range((long(rbl.byteCount[block]))/(1024*1024)):
                        
                        #update progress
                        prog(totalProgress)
                        
                        #read 1MB at a time
                        try:
                            data=fh.read(1048576)                                       
                        except IOError, e:
                            print "Can not read from %s, check to make sure the device is present or rescan all HBAs." % (each)
                            print "Error: %s" % (e)
                            sys.exit()
                            
                        try:
                            #write 1MB at a time
                            fhw.write(data)
                            vOFF += 1048576                                            
                            dOFF += 1048576                                            
                            #move to the next 1MB block
                            fh.seek(long(dOFF))                                        
                            fhw.seek(vOFF)
                            totalProgress +=1
                            
                        except IOError, e:
                            print "Can not write  to %s, check to make sure the device is present or rescan all HBAs." % (each)
                            print "Error: %s" % (e)
                            fh.close()
                            fhw.close()
                            sys.exit()
                                                           
        fh.close()
        fhw.close()
        print "\nRestored Successfully"


    
    def checkFreeSpace(self,volumeLabel):
        """returns free space available on a vmfs  volume (volumeLabel) in bytes"""
        """volume label should be full path to the vmfs volume /vmfs/volume/volume1"""
        fh=''
        try:
            fh=os.popen(constants.vmfsFree)
        except OSError, e:
            return None
        
        volumes=fh.readlines()
        for each in volumes:
            if re.search(volumeLabel,each,re.I):
                return long(each.split()[2] * 1024) #vdf produces kb and we need bytes    
    
                   
