import constants
import os
import re
import sys
import types

class Menu:
    
    def __init__(self):
        self.vmList=[]
        self.procedure=""
        self.numVMs=0
        self.strippedList=[]
        
    def printHF(self):
        print "------------------------------------------\n"
    
    def getNumVMS(self):
        return self.numVMs
    
    def __getAllRegisteredVMs(self):
        
       
        vmListFH=os.popen(constants.vmwarecmd + " -l")
        self.vmList=vmListFH.readlines()
        vmListFH.close()
        for eachvm in self.vmList:
            self.strippedList.append(eachvm.strip())
        return self.strippedList

    def displayMenu(self):
        
        """ calls __getAllRegisteredVMS private function
        """
        self.vmList=self.__getAllRegisteredVMs()
        if not self.vmList:
            print "error no Virtual Machines found on this host\n"
            sys.exit()
            
        i=0
        self.printHF();
        for eachvm in self.vmList:
            print i,") "+ eachvm.strip("\\n")
            i+=1
        self.printHF()
        self.numVMs=i
    
    def getUserInput(self):
        
        while (1):
            try:
                selected = raw_input("Choose a VM to backup,  [99] for all registered VMs or [q] to quit: ")
            
            except KeyboardInterrupt:
                print"\nAborting....."
                sys.exit()
                
            if selected.isdigit():
                selected=int(selected)
                        
            if selected >= 0 and selected < (self.numVMs):  
                return self.vmList[selected]
                       
            if selected == 99: #all vms selected
                print "Backing up all VMs on this host\n"
                return self.vmList

            if re.search('q', str(selected),re.IGNORECASE): #user decided to quit
                print "Not backing up any VMs\n"
                sys.exit()
            
           

    def Procedure(self):
        print "VMFS VMDK undelete\n\n\n"
        print "Please select an option\n"
        print "B)ackup\n"
        print "R)restore\n"
        
        while (1):
            selected=raw_input(":")
        

#on esx    

if __name__ == "__main__":
    a=Menu()
    num=a.displayMenu()
    print "found ", num , " vms"
    vmList=a.getUserInput(num)
    print vmList


        
    




