import re #regular expression
import os #os specific functions
import types
import constants



vmToDiskMap={}

class ParseVMX:
        
    def __init__(self):
        self.vmdkList={}
        self.connectedDisks=[]
        self.vmToDiskMap={}
        self.vmList=[]
        self.lvmlist=[]

    
    def lookForDisks(self,vmlist):
        #check if we got string (only 1 vm selected) or list of multiple vms 
        
        #debug
        #print "vmlist = %s" % (vmlist)
        #print "type(vmlist) = %s"  %(type(vmlist))
        #debug       
        
        if type(vmlist)==types.StringType:
            self.vmList.append(vmlist)
        
        else:
            self.vmList=vmlist
        
        #debug
        #print "vmList = %s " % (self.vmList)
        #debug
            
        for eachvm in self.vmList:
            #debug
            #print "each vm= %s" %(eachvm)
            #debug
            
            FH=open(eachvm,'r')
            for i in FH.readlines():
    
                temp=i.split("=")
    
                if  re.search("scsi",temp[0],re.IGNORECASE): #find scsi disks 
                    temp[0]=temp[0].strip().strip("\"") #strip out white spaces and all quotes
                    temp[1]=temp[1].strip().strip("\"")
                    self.connectedDisks.append(temp)
                FH.close()


#parse through and find scsi disks that are connected
#skip disks with false attributes
            
            for i in self.connectedDisks:
                if i[0].find(":") > 0 and re.search("true",i[1],re.IGNORECASE):
                    temp=i[0].split('.')[0]
                    for t in self.connectedDisks:
                        if re.search(temp,t[0],re.IGNORECASE) and re.search("vmdk",t[1],re.IGNORECASE):
                            self.vmdkList[t[0]]=t[1]
            self.vmToDiskMap[eachvm]=self.vmdkList                 #store list in dict using filename as the key'
            self.connectedDisks=[]                             #clear array for next vm
            self.vmdkList={}                                   #clear dict for next vm
        #debug
        #print "returning vmToDiskMap : %s" % (self.vmToDiskMap)
        #debug
        return self.vmToDiskMap
                       
    
    def checkPersistenDisks(self,vmxString=""):
        """
        do not use!!!!!!
        not implimented yet
        """
        print "check %s for persistent" % vmxString
        found=re.search('independent-persistent',vmxString,re.IGNORECASE)
        if found:
            return True
        else:
            return Falses
   
   
if __name__ == "__main__":
    
    parsed=ParseVMX()
    parsed.lookForDisks(["C:\\test.txt","C:\\vm2.txt"])


