#!/bin/sh

# Traditionally, and to some extent still, rpm --freshen upgraded
# packages that matched by RPMTAG_NAME, not RPMTAG_PROVIDENAME.
#
# This freshen.sh script illustrates how to revert to the "traditional"
# behavior for doing, say,
#	rpm -Fvh kernel-bigmem*.rpm
# so that only kernel-bigmem packages are upgraded, rather than
# upgrading (i.e. erasing) every kernel package that contains
#	Provides: kernel = V-R
#
# Copy the freshen.sh script to /usr/lib/rpm, and add the following
# lines to /etc/popt to enable the behavior:
#	rpm alias -F		--freshen
#	rpm exec --freshen	/usr/lib/rpm/freshen.sh
#	

# Debugging, do "dbg=" for actual execution, comment out the rest.
dbg=# echo
#set -x
#echo "args: $*"

# Invoke rpmi from the same directory as freshen.sh.
rpme="`dirname $0`/rpme"
rpmi="`dirname $0`/rpmi"
rpmq="`dirname $0`/rpmq"

# Parse out any options and add to new arglist.
# Note: this fails for options with arguments.
opts=""
while [ $# -gt 0 ]; do
    case $1 in
    -*) opt="$1"
	if [ "$opt" = "--root" ] ; then
	    shift 
	    rootopt="$opt $1"
	    shift
	    opts="$rootopt $opts"
	    opt=""
	else 
 	    opts="$opts $opt" && shift
	fi

	[ "$opt" = "--" ] && break
	;;

    *)	opts="$opts --" && break
	;;
    esac
done
#echo "opts: $opts"

# $opts has the options with final '--', $* has the packages

# If no remaining options, just invoke rpm (which will fail).
[ $# = 0 ] && $dbg exec $rpmi -U $opts

# Split remaining args into erase/install/upgrade invocations
eargs=
iargs=
Uargs=
for fn in $*; do
    # If not a file, just pass to upgrade.
    [ ! -f $fn ] && Uargs="$Uargs $fn" && continue

    # For all occurences of identically named packages installed ...
    N="`$rpmq  -qp --qf '%{NAME}' $fn`"
    # ... special case kernel packages
    case $N in
    kernel*)
        # ... if the package is not already installed, do not install it.
	CUR_VER="$($rpmq $rootopt -qa $N)"
	if [ "" = "$CUR_VER" ] ; then
	    echo "SOE: $N is not installed, skipping"
	    continue
	fi
	NEW_VER="`$rpmq  -qp --qf '%{NAME}-%{VERSION}-%{RELEASE}' $fn`"
	if [ "$CUR_VER" = "$NEW_VER" ] ; then
	    echo "SOE: $N-$NEW_VER is the same as the installed version, skipping"
	    continue
	fi

	if [ $N = "kernel" ] || [ $N = "kernel-smp" ] || [ $N = "kernel-enterpise" ]; then
	    
	    $dbg $rpmi -i $opts $fn && \
		$dbg $rpme -e $opts $CUR_VER

	else 
	    Uargs="$Uargs $fn"
	fi
	;;
    *) Uargs="$Uargs $fn";;
    esac

done

# set -e		# Exit on any error from here on out.

if [ "$Uargs" != "" ] ; then
    exec $dbg $rpmi -F $opts $Uargs
else
   exit 0
fi

