<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<c:set var="VIEW_SETTINGS" value="<%= Constants.BEAN_CONTEXT_VIEWSETTINGS %>" scope="page" />
<c:set var="viewSettings" value="${sessionScope[VIEW_SETTINGS]}" scope="page" />
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />
<gui>
   <var name="handler" type="jsVar">window.mainMenuHandler</var>
   <var name="toolbarMenus" type="docId">toolbarMenus</var>

   <menubar container="toolbarMenus">
      <menu label="<fmt:message key='bars.menu.webCenter.title' bundle='${messageResources}' />">
         <items>
            <header label="<fmt:message key='bars.menu.webCenter.header' bundle='${messageResources}' />" />
            <item label="<fmt:message key='bars.menu.webCenter.about' bundle='${messageResources}' />"
               actionCmd="about"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.webCenter.help' bundle='${messageResources}' />"
               actionCmd="help"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.webCenter.logout' bundle='${messageResources}' />"
               actionCmd="logout"
               actionListener="handler" />
         </items>
      </menu>

      <menu label="<fmt:message key='bars.menu.view.title' bundle='${messageResources}' />">
         <items>
            <header label="<fmt:message key='bars.menu.view.headerInventory' bundle='${messageResources}' />" />
            <radiogroup>
               <radiobutton label="<fmt:message key='bars.menu.view.expandSidebar' bundle='${messageResources}' />"
                  <c:if test="${viewSettings.navVisible}">
                     selected="true"
                  </c:if>
                  <c:if test="${viewSettings.navFrozen}">
                     enabled="false"
                  </c:if>
                  actionCmd="expandSidebar"
                  itemListener="handler" />
               <radiobutton label="<fmt:message key='bars.menu.view.collapseSidebar' bundle='${messageResources}' />"
                  <c:if test="${!viewSettings.navVisible && viewSettings.navResizable}">
                     selected="true"
                  </c:if>
                  <c:if test="${viewSettings.navFrozen}">
                     enabled="false"
                  </c:if>
                  actionCmd="collapseSidebar"
                  itemListener="handler" />
               <radiobutton label="<fmt:message key='bars.menu.view.hideSidebar' bundle='${messageResources}' />"
                  <c:if test="${!viewSettings.navVisible && !viewSettings.navResizable}">
                     selected="true"
                  </c:if>
                  <c:if test="${viewSettings.navFrozen}">
                     enabled="false"
                  </c:if>
                  actionCmd="hideSidebar"
                  itemListener="handler" />
            </radiogroup>
            <header label="<fmt:message key='bars.menu.view.headerTabs' bundle='${messageResources}' />" />
            <radiogroup>
               <radiobutton label="<fmt:message key='bars.menu.view.showTabs' bundle='${messageResources}' />"
                  <c:if test="${viewSettings.tabsVisible}">
                     selected="true"
                  </c:if>
                  <c:if test="${viewSettings.tabsFrozen}">
                     enabled="false"
                  </c:if>
                  actionCmd="showTabs"
                  itemListener="handler" />
               <radiobutton label="<fmt:message key='bars.menu.view.hideTabs' bundle='${messageResources}' />"
                  <c:if test="${!viewSettings.tabsVisible}">
                     selected="true"
                  </c:if>
                  <c:if test="${viewSettings.tabsFrozen}">
                     enabled="false"
                  </c:if>
                  actionCmd="hideTabs"
                  itemListener="handler" />
            </radiogroup>
         </items>
      </menu>

      <menu label="<fmt:message key='bars.menu.vm.title' bundle='${messageResources}' />">
         <items>
            <header label="<fmt:message key='bars.menu.vm.headerPower' bundle='${messageResources}' />" />        
          
            <item label="<fmt:message key='bars.menu.vm.powerOn' bundle='${messageResources}' />"
               actionCmd="powerOn"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.vm.powerOff' bundle='${messageResources}' />"
               actionCmd="powerOff"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.vm.suspend' bundle='${messageResources}' />"
               actionCmd="suspend"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.vm.reset' bundle='${messageResources}' />"
               actionCmd="reset"
               actionListener="handler" />
            <separator />
            <item label="<fmt:message key='bars.menu.vm.shutdown' bundle='${messageResources}' />"
               actionCmd="shutdown"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.vm.restart' bundle='${messageResources}' />"
               actionCmd="restart"
               actionListener="handler" />
            <header label="<fmt:message key='bars.menu.vm.headerConsole' bundle='${messageResources}' />" />
            <item label="<fmt:message key='bars.menu.vm.fullScreen' bundle='${messageResources}' />"
               actionCmd="fullScreen"
               actionListener="handler" />
            <item label="<fmt:message key='bars.menu.vm.ctrlAltDel' bundle='${messageResources}' />"
               actionCmd="ctrlAltDel"
               actionListener="handler" />
         </items>
      </menu>
   </menubar>
</gui>
