<%@ page import="com.vmware.webcenter.control.action.VmPowerOperationsAction,
                 com.vmware.webcenter.control.action.HelpAction,
                 com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.Constants" %>

<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<c:set var="VIEW_SETTINGS" value="<%= Constants.BEAN_CONTEXT_VIEWSETTINGS %>" scope="page" />
<c:set var="viewSettings" value="${sessionScope[VIEW_SETTINGS]}" scope="page" />

<html:html locale="true">
<head>
<link rel="stylesheet" href="css/default.css" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->
<link rel="stylesheet" href="css/toolbar.css" type="text/css" />
<!--[if IE]>
<link href="css/toolbar-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua,win,drag" />
</jsp:include>
<%@ include file="/WEB-INF/jsp/bars/toolbarJs.jsp" %>

<script type="text/javascript" src="js/details/vm/AbstractDeviceButton.js" charset="UTF-8"></script>
<script type="text/javascript" src="js/details/vm/NicDeviceButton.js" charset="UTF-8"></script>
<script type="text/javascript" src="js/details/vm/CdDvdDeviceButton.js" charset="UTF-8"></script>
<script type="text/javascript" src="js/details/vm/FloppyDeviceButton.js" charset="UTF-8"></script>

<script type="text/javascript">
   vpx.context.deviceMenus = null;

var menuVMItems = {
   "powerOn"        : 1,    //powerOn
   "powerOff"       : 2,    //powerOff
   "suspend"        : 3,    //suspend
   "reset"          : 4,    //reset
   //Item 5 is a separator
   "shutdownGuest"  : 6,    //shutdown
   "restartGuest"   : 7,    //reboot
   //Item 8 is a separator
   "fullscreen"     : 9,
   "sendCAD"        : 10
};

<%--
 * disableVMMenuItem --
 *     Given a menu label and an disabled state (bool) toggles
 *     a menu item on the Virtual Machine menu to enabled or disabled.
 *
 --%>
function disableVMMenuItem(menuItemLabel, disabled) {
   if (menuVMItems[menuItemLabel] != null) {
      vmMenu.getMenuComponent(menuVMItems[menuItemLabel]).setEnabled(!disabled);
   }
}

<%--
 * initVMMenu --
 *    Sets all VMMenu Items to disabled because they aren't set until a VM is chosen.
 *
 --%>

function initVMMenu(){
   for(var item in menuVMItems){
      disableVMMenuItem(item, true);
   }
}

   function initViewMenu() {
<c:if test="${viewSettings.navVisible}">
      try {
         var doc = tle.getBrowsersPane();
         var resizeNavPane = vpx.xua.getElement(doc.document.images["resizeNavPane"]);
         vpx.xua.event.listen(resizeNavPane, "click", updateViewMenu);
      } catch (e) {
         window.setTimeout("initViewMenu()", 100);
      }
</c:if>
   }

   var helpFile = "<bean:message bundle="helpFiles" key="help.index"/>";
   function launchHelp() {
      window.open("help.do?<%= HelpAction.PARAM_NAME_HELP_FILE %>=" + helpFile, "helpWindow", "menubar=1,toolbar=1,status=1,scrollbars=1,resizable=1");
   }

<%-- Map local power commands to action class power commands. --%>
var actionsMap = {
   "powerOn"         : "<%= VmPowerOperationsAction.OP_VM_POWERON %>",
   "powerOff"        : "<%= VmPowerOperationsAction.OP_VM_POWEROFF %>",
   "defaultPowerOff" : "<%= VmPowerOperationsAction.OP_VM_POWEROFF_DEFAULT %>",
   "defaultSuspend"  : "<%= VmPowerOperationsAction.OP_VM_SUSPEND_DEFAULT %>",
   "suspend"         : "<%= VmPowerOperationsAction.OP_VM_SUSPEND %>",
   "defaultReset"    : "<%= VmPowerOperationsAction.OP_VM_RESET_DEFAULT %>",
   "reset"           : "<%= VmPowerOperationsAction.OP_VM_RESET %>",
   "shutDown"        : "<%= VmPowerOperationsAction.OP_GUEST_SHUTDOWN %>",
   "reboot"          : "<%= VmPowerOperationsAction.OP_GUEST_REBOOT %>"
}

<%-- Map VMODL power states to local power commands. --%>
var statesMap = {
   "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" : "powerOn",
   "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" : "powerOff",
   "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" : "suspend",
   "<%= Constants.POWERING_ON %>" : "poweringOn",
   "<%= Constants.POWERING_OFF %>" : "poweringOff",
   "<%= Constants.SUSPENDING %>" : "suspending"
}

<%--
 * logout --
 *     Logout from the webcenter.
--%>
function logout(strLogoutAction){
   // tle is initiated in init found in init.js (via commonJs.jsp)
   if (tle.winClientDeviceConnector != null) { // device connections window is open
      if (tle.clientDeviceConnector != null) { // plugin still working in that window (hasn't been browsed away from)
    <%-- TODO: move to using the webCenter modal dialog for confirmation --%>
    if (!confirm("<bean:message key="bars.links.logout.confirmation.clientDevices"/>") == true) {
       return;
    }
      }
      // child window is open, but plugin for some reason is not available anymore
      if (tle.winClientDeviceConnector.unloadConfirmation != null) {
    // might not be avlbl if browsed away from our connections page
    // This should not happen as the connections window implements an unregister when unloading our document, but JIC
    tle.winClientDeviceConnector.unloadConfirmation = false;
      }
      tle.closeClientDeviceConnector(); // always true regardless of the document in the child window
   }

   // all done cleaning up, send the very top window to do the logout
   window.top.location.href = strLogoutAction;
}

function initPage() {
   toolbar = new Toolbar();
   toolbar.init(statesMap, actionsMap);
   tle.menuBar = tle.createGui(this, "barsMenuXml.do")[0];

   //To Select Menus
   vmMenu = tle.getVMMenu();
   viewMenu = tle.getViewMenu();

   initVMMenu();
   initViewMenu();
}

   /**
    * setup the toolbar
    *
    * @param  powerState - current runtime state of the VM
    */

   function setupToolbar(powerState, powerOffType, powerOffPreset, resetType, resetPreset,
                         powerOff, powerOn, suspend, reset, shutdownGuest, restartGuest){

      toolbar.updateToolbarPowerOff(powerOffType, powerOffPreset);
      toolbar.updateToolbarReset(resetType, resetPreset);
      toolbar.setupIcons(powerState, powerOff, powerOn, suspend, reset);
      setupToolbarMenus(powerOff, powerOn, suspend, reset, shutdownGuest, restartGuest);
   }


   function disableToolbarNMenu(){
     toolbar.disablePowerStates();
     setupToolbarMenus("true", "true", "true", "true", "true", "true");
   }

  /**
    * set toolbar power state : This function will be used for updates only.
    * Can't use the <code>setupToolbar</code> function for updates.
    * It makes the toolbar flikering due to window.setTimeout call
    *
    * @param view - vm view
    *
    */

   function setupToolbarMenus(powerOff, powerOn, suspend, reset, shutdownGuest, restartGuest){

      toolbar.setupMenus(powerOff, powerOn, suspend, reset, shutdownGuest, restartGuest);
   }


function showAbout() {
   var rootUrl = "about.do";
   var rs = new vpx.win.RootSpec(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, rootUrl));

   var msgBox = new vpx.win.Frame(null /* contentSpec */, null /* frameSpec */, rs, tle);

   msgBox.listen("ready", function (o) {
      o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
      o.setModal(true);
      o.open();
   });

   msgBox.init();
}

window.mainMenuHandler = {
   actionPerformed : function(event) {
      switch (event.getActionCommand()) {

      case "about":
         showAbout();
         break;

      case "logout":
         logout('logout.do');
         break;

      case "help":
         launchHelp();
         break;

      case "shutdown":
         toolbar.doPowerOpIfPermitted('shutDown');
         break;

      case "suspend":
         toolbar.doPowerOpIfPermitted('suspend');
         break;

      case "powerOn":
         toolbar.doPowerOpIfPermitted('powerOn');
         break;

      case "restart":
         toolbar.doPowerOpIfPermitted('reboot');
         break;

      case "powerOff":
         toolbar.doPowerOpIfPermitted('powerOff');
         break;

      case "reset":
         toolbar.doPowerOpIfPermitted('reset');
         break;

      case "fullScreen":
         toolbar.doMksOp('fullscreen');
         break;

      case "ctrlAltDel":
         toolbar.doMksOp('sendCAD');
         break;

      default:
         break;
      }
   },

   itemStateChanged : function(event) {
      var ItemEvent = tle.vpx.gui.event.ItemEvent;
      var SELECTED = ItemEvent.SELECTED;
      var DESELECTED = ItemEvent.DESELECTED;
      var stateChange = event.getStateChange();
      var item = event.getItemSelectable();

      if (stateChange == DESELECTED) {
         // Do we care about deselected events?
         return;
      }

      switch (item.getActionCommand()) {
      case "expandSidebar":
         tle.setNavVisible(true, false);
         tle.setNavResizable(true, false);
         break;

      case "collapseSidebar":
         tle.setNavVisible(false, false);
         tle.setNavResizable(true, false);
         break;

      case "hideSidebar":
         tle.setNavVisible(false, false);
         tle.setNavResizable(false, false);
         break;

      case "showTabs":
         tle.setTabsVisible(true, false);
         break;

      case "hideTabs":
         tle.setTabsVisible(false, false);
         break;

      default:
         break;

      }
   }
};

window.deviceButtonHandler = {
   actionPerformed : function(event) {
      var btn = event.getSource();
      handleEditDevice(btn);
   }
};

window.deviceMenuHandler = {
   actionPerformed : function(event) {
      var item = event.getSource();
      var btn = item.getParent().getInvoker().getAttribute("splitButton");
      handleEditDevice(btn);
   },

   itemStateChanged : function(event) {
      var ItemEvent = tle.vpx.gui.event.ItemEvent;
      var SELECTED = ItemEvent.SELECTED;
      var DESELECTED = ItemEvent.DESELECTED;
      var stateChange = event.getStateChange();
      var item = event.getItemSelectable();

      if (stateChange == DESELECTED) {
         // Do we care about deselected events?
         return;
      }

      switch (item.getActionCommand()) {

      case "connect":
         alert("CONNECT");
         break;

      case "disconnect":
         alert("DISCONNECT");
         break;

      default:
         break;

      }
   }
};

/**
 * Handles a user action on a split button that directs the app to take the
 * user to the config screen for a device.
 *
 * @param btn vpx.gui.SplitButton
 *    The button that holds the attributes of the device
 */
function handleEditDevice(btn) {
   var configUrl = btn.getAttribute("configUrl");
   var paramVmId = btn.getAttribute("paramVmId");
   var paramKey = btn.getAttribute("paramKey");
   var vmId = btn.getAttribute("vmId");
   var key = btn.getAttribute("key");

   var wsDetails = tle.getWorkspaceDetails();
   var url = configUrl + "?" + paramVmId + "=" + vmId + "&" + paramKey + "=" + key;
   wsDetails.location.href = url;
}

function updateViewMenu() {
   var tmp;
   if (tle.viewSettings.navVisible) {
      tmp = viewMenu.getMenuComponent(1);
   } else if (tle.viewSettings.navResizable) {
      tmp = viewMenu.getMenuComponent(2);
   } else {
      tmp = viewMenu.getMenuComponent(3);
   }
   tmp.setSelected(true);
}

</script>
</head>

<body onload="javascript:initPage();">
<table id="toolbar" cellpading="0" border="0" cellspacing="0">
   <tbody id="toolbarNormal">
      <tr>
    <td valign="top">
       <div id="productHeader"><fmt:message key="title.topBar" bundle="${messageResources}"/></div>
       <div id="toolbarMenus" class="menuBar"></div>
    </td>
    <td width="100%">
       <table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody>
          <tr>
        <td colspan="3" align="right">
           <ul id="globalLinks">
         <li><a href="javascript:launchHelp();" title="<bean:message key="bars.links.help.tip"/>"><bean:message key="bars.links.help.label"/></a></li>
         <li><a href="javascript:logout('logout.do');" title="<bean:message key="bars.links.logout.tip"/>"><bean:message key="bars.links.logout.label"/></a></li>
           </ul>
        </td>
          </tr>
          <tr>
        <td valign="top" class="bottomBar upperCurve"><div id="upperCurve"></div></td>
        <td id="toolbarIcons">
           <ul>
         <li><a href="javascript:toolbar.doPowerOpIfPermitted('defaultPowerOff');"><img title="<bean:message key="bars.btns.poweroff.tip"/>" src="imx/spacer.png" id="powerOff" class="icon disabled" border="0"></a></li>
         <li><a href="javascript:toolbar.doPowerOpIfPermitted('defaultSuspend');"><img title="<bean:message key="bars.btns.suspend.tip"/>" src="imx/spacer.png" id="suspend" class="icon disabled" border="0"></a></li>
         <li><a href="javascript:toolbar.doPowerOpIfPermitted('powerOn');"><img title="<bean:message key="bars.btns.poweron.tip"/>" src="imx/spacer.png" id="powerOn" class="icon disabled" border="0"></a></li>
         <li><a href="javascript:toolbar.doPowerOpIfPermitted('defaultReset');"><img title="<bean:message key="bars.btns.reset.tip"/>" src="imx/spacer.png" id="reset" class="icon disabled" border="0"></a></li>
         <li><img src="imx/spacer.png" class="vr"></li>
         <li><a href="javascript:toolbar.doMksOp('fullscreen');"><img title="<bean:message key="bars.btns.fullscreen.tip"/>" src="imx/spacer.png" id="fullscreen" class="icon disabled" border="0"></a></li>
         <li><img src="imx/spacer.png" class="vr"></li>
           </ul>
        </td>
        <td id="toolbarDeviceMenus">&nbsp;</td>
          </tr>
       </tbody></table>
    </td>
      </tr>
   </tbody>
   <tbody id="toolbarModal" style="display:none;">
      <tr>
    <td valign="top">
       <div id="productHeaderModal"><fmt:message key="title.topBar" bundle="${messageResources}"/></div>
    </td>
    <td width="100%">
       <table border="0" cellpadding="0" cellspacing="0" width="100%"><tbody>
          <tr>
        <td colspan="3" align="right">
           <ul id="globalLinksModal">
         <li><a href="javascript:launchHelp();" title="<bean:message key="bars.links.help.tip"/>"><bean:message key="bars.links.help.label"/></a></li>
         <li><a href="javascript:logout('logout.do');" title="<bean:message key="bars.links.logout.tip"/>"><bean:message key="bars.links.logout.label"/></a></li>
           </ul>
           <div id="toolbarIconsModal"><img id="upperCurveModal" src="imx/spacer.png" /></div>
        </td>
          </tr>
       </tbody></table>
    </td>
      </tr>
   </tbody>
</table>

<%-- Remove the hidden field after QA automation tests--%>
<input type="text" name="_overallPowerStatus" id="_overallPowerStatus" size="10" style="display:none;" />
</body>
</html:html>
