<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="IE" value="true">
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>
</logic:equal>
<%@ include file="/WEB-INF/jsp/common/pluginUtils.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
  
  <title><bean:message key="plugins.remoteConnection.auxWin.title"/></title>
  
  <link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

<script language="JavaScript" type="text/javascript">
var pluginInstalled = isPluginInstalled();

function registerPlugin() {
   // deal with plugin not installed/instantiated
   var plugin = getPlugin();
   var pluginRunning = document.getElementById("pluginRunning");
   var pluginNotRunning = document.getElementById("pluginNotRunning");
   if (pluginInstalled) {
      // it is installed, might not be running yet but we are good to go for now
      pluginRunning.style.display = "";
      pluginNotRunning.style.display = "none";
      plugin.style.width = "1px";
      plugin.style.height = "1px";
      window.onbeforeunload = function() {return confirmUnload();};
      window.onunload = doUnload; 
   } else {
      // no plugin
      pluginRunning.style.display = "none";
      pluginNotRunning.style.display = "";
   }
   if (window.opener && window.opener.setClientDeviceConnector) {
      window.opener.setClientDeviceConnector(plugin);
   }
}

var unloadConfirmation = true;

function confirmUnload() {
   if (unloadConfirmation == true) {
      return "<bean:message key="plugins.remoteConnection.auxWin.buttons.disconnectAll.confirm"/>";
   }
}

function doUnload() {
   if (window.opener && window.opener.clearClientDevicesConnectObjects) {
      window.opener.clearClientDevicesConnectObjects();
   }

   var deviceConnector = document.getElementById("clientDeviceConnector");
   // Do the best we can here, there is the possibility that the detach
   // call is not available or is no longer available.
   try {
      deviceConnector.detachRemoteDevice("",""); // empty means all devices (plugin API)
   } catch (e) {
   }
}

function disconnectAll(){
   unloadConfirmation = false;
   window.close(); // will eventually trigger the doUnload which will attempt to detachAllRemoteDevices    	 
}

var findTleIntervalId = null;
var TLE_INTERVAL_TIME = 100; // in miliseconds

function initRegisterWithTle() {
   findTleIntervalId = window.setInterval("registerWithTle()",TLE_INTERVAL_TIME);
}

function registerWithTle(){
   if (window.opener == null || window.opener.closed) { // case main application window was closed  [null for firefox, closed for IE]
      // The opener window will never come back once closed, and this window won't
      //  be able to find other new application windows to register with.
      // Clear the interval and stop trying.
      window.clearInterval(findTleIntervalId); // null id ok 
   } else if (window.opener.setClientDeviceConnector != null && 
      window.opener.setClientDeviceConnectorWindow != null) { // main application window is back
      window.clearInterval(findTleIntervalId); // null id is ok
      window.opener.setClientDeviceConnectorWindow(window);
      window.opener.setClientDeviceConnector(document.getElementById("clientDeviceConnector"));
   }
}

function getPlugin() {
   return document.getElementById("clientDeviceConnector");
}

function reloadNoConfirm() {
   window.onbeforeunload="";
   window.onunload="";
   unloadConfirmation = false;
   location.reload(true);
}

</script>
</head>
<body style="background-color:#fff" onload="registerPlugin()">

<logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="IE" value="true">
   <object id="clientDeviceConnector" classid="CLSID:338095E4-1806-4ba3-AB51-38A3179200E9" codebase='<bean:message bundle="internalResources" key="links.plugins.cab"/>' width="0" height="0"></object>

   <div id="pluginNotRunning" class="window" style="display:none;">
      <div class="warn">
         <p class="explanation">
            <p><bean:message key="plugins.remoteConnection.activex.notfound"/></p>
            <p><bean:message key="plugins.remoteConnection.activex.reload"/></p>
         </p>
       </div>
  </div>
</logic:equal>

<logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="FF" value="true">
<%@ include file="/WEB-INF/jsp/common/installPlugin.jsp" %>
   <object style="width:100%;height:100%;" id="clientDeviceConnector" type="application/x-vmware-mks;version=<bean:message bundle="internalResources" key="plugins.remoteConnection.xpi.version"/>">
   </object>

   <div id="pluginNotRunning" class="window" style="display:none;">
      <div class="warn">
         <p class="explanation">
            <p><bean:message key="plugins.remoteConnection.xpi.notfound"/></p>
            <p><bean:message key="plugins.remoteConnection.xpi.reload"/></p>
         </p>
       </div>
  </div>
</logic:equal>

  <div id="pluginRunning" class="window" style="display:none;">
    <div class="legend">
      <span id="l10n_plugins_remoteConnection_auxWin_deviceStatus_header">
      	<bean:message key="plugins.remoteConnection.auxWin.deviceStatus.header"/></span>
    </div>
    <div class="warn">
      <div class="title">
        <span id="l10n_plugins_remoteConnection_auxWin_deviceStatus_warning_header">
        	<bean:message key="plugins.remoteConnection.auxWin.deviceStatus.warning.header"/></span>
      </div>
      <p class="explanation">
        <span id="l10n_plugins_remoteConnection_auxWin_deviceStatus_warning_expl">
        	<bean:message key="plugins.remoteConnection.auxWin.deviceStatus.warning.expl"/></span>
      </p>
    </div>
  
    <div class="commandButtons">
      <input type="button" value="<bean:message key="plugins.remoteConnection.auxWin.buttons.disconnectAll"/>" onclick="disconnectAll()"/>
    </div>		
     
  </div>
  

</body>
</html:html>