<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.view.viewhelper.VmConsoleView" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/pluginUtils.jsp" %>

<bean:parameter name="deviceType" id="deviceType" />

<c:set var="BEAN_CONTEXT_SELECTION" value="<%= Constants.BEAN_CONTEXT_SELECTION %>" scope="page" />
<c:set var="selectionModel" value="${sessionScope[BEAN_CONTEXT_SELECTION]}" scope="page"/>

<script language="JavaScript" type="text/javascript">

   var connectorIntervalId = null;

   var pluginInstalled = isPluginInstalled();

   function attemptAttachDevice(){
      // If the plugin is not installed, just open the window and let the user get
      // prompted and install the plugin.  Otherwise do a monitoredInvoke on the attach.
      // In either case make sure the editor gets closed.
      tle.launchClientDeviceConnector('<bean:message bundle="internalResources" key="sysPrefs.clientDevicesWindow.features"/>');
      if (!pluginInstalled) {
         closeConfig('<c:out value="${selectionModel.selectionState.currentVmTab}"/>');
         return;
      }
      attachDevice();
   }
   
   function attachDevice(){
<logic:present name="dvcCnctView" property="mksTicketDataItem.hostName">
         var hostName = "<bean:write name="dvcCnctView" property="mksTicketDataItem.hostName"/>";
</logic:present>
<logic:notPresent name="dvcCnctView" property="mksTicketDataItem.hostName">
  <logic:notEqual name="dvcCnctView" property="webServiceIP" value="127.0.0.1">
         var hostName = "<bean:write name="dvcCnctView" property="webServiceIP"/>";
  </logic:notEqual>
  <logic:equal name="dvcCnctView" property="webServiceIP" value="127.0.0.1">
         var hostName = tle.getLocationHostName();
  </logic:equal>
</logic:notPresent>			
         var port = <bean:write name="dvcCnctView" property="mksTicketDataItem.mksPort"/>;
         var cfgPath = "<bean:write name="dvcCnctView" property="mksTicketDataItem.vmConfigFile"/>";
         var ticket = "<bean:write name="dvcCnctView" property="mksTicketDataItem.mksTicket"/>";
         var deviceNode= "<bean:write name="dvcCnctView_deviceNode"/>";
         var localDrivePath = "<wc:jsSafe name="dvcCnctView_locationPath"/>";
<logic:equal name="deviceType" value="floppy">
         var rBackingType = "<bean:write name="dvcCnctView_rBackingType"/>";
         var driveNumber = <bean:write name="dvcCnctView_driveNumber"/>;
         monitorableAttachFloppy.setMaxRetrials(60);
         monitorableAttachFloppy.setRetrialDelay(500);
         monitorableAttachFloppy.setInvocationListener(this);
         monitorableAttachFloppy.monitoredInvoke(hostName, port, cfgPath, ticket, ticket, deviceNode, rBackingType, driveNumber, localDrivePath);
</logic:equal>
<logic:equal name="deviceType" value="cd">
         var rawDevice = <bean:write name="dvcCnctView_rawDevice"/>;
         var exclusiveDevice = <bean:write name="dvcCnctView_exclusiveDevice"/>;
         var isISO = <bean:write name="dvcCnctView_isFile"/>;
         monitorableAttachCD.setMaxRetrials(60);
         monitorableAttachCD.setRetrialDelay(500);
         monitorableAttachCD.setInvocationListener(this);
         monitorableAttachCD.monitoredInvoke(hostName, port, cfgPath, ticket, ticket, deviceNode, rawDevice, exclusiveDevice, isISO, localDrivePath);
</logic:equal>
   }

   // wrapper function to allow monitored invocation of the call   
   function monitorableAttachCD(hostName, port, cfgPath, ticket, ticket, deviceNode, rawDevice, exclusiveDevice, isISO, localDrivePath) {
      tle.getClientDeviceConnector().attachRemoteCDROM( hostName, port, cfgPath, ticket, ticket, deviceNode, rawDevice, exclusiveDevice, isISO, localDrivePath);
   }
   
   // wrapper function to allow monitored invocation of the call   
   function monitorableAttachFloppy(hostName, port, cfgPath, ticket, ticket, deviceNode, rBackingType, driveNumber, localDrivePath) {
      tle.getClientDeviceConnector().attachRemoteFloppy(hostName, port, cfgPath, ticket, ticket, deviceNode, rBackingType, driveNumber, localDrivePath);
   }
   
   // callback for successful attach of both CD and floppy
   function invocationSucceeded() {
      this.connected = true;
      closeConfig('<c:out value="${selectionModel.selectionState.currentVmTab}"/>');
   }

   // callback for failed attach of both CD and floppy
   function invocationFailed() {
      this.connected = false;
      vpx.win.alert("<bean:message key="errors.vm.configuration.clientDevices.failedConnection"/>");
      closeConfig('<c:out value="${selectionModel.selectionState.currentVmTab}"/>');
   }

</script>

<body onload="attemptAttachDevice()">

  <div id="configWrapDiv">

	<%-- TODO: consider putting a connecting message here, listening for the callback and only then going back to the summary page --%>

<%-- Begin Visual Debug Info --%>
<%--
		<h3>Ticket view is found</h3>
		<ul><li>power state: <bean:write name="dvcCnctView" property="vmDataItem.powerState"/></li></ul>
		<ul> <u>Attach Device params:</u>
			<li> <b>Host Name</b>: 
				<logic:present name="dvcCnctView" property="mksTicketDataItem.hostName"><bean:write name="dvcCnctView" property="mksTicketDataItem.hostName"/></logic:present>
				<logic:notPresent name="dvcCnctView" property="mksTicketDataItem.hostName">
				 Not present ! Resolve from view: <bean:write name="dvcCnctView" property="webServiceIP"/>
				 <logic:equal name="dvcCnctView" property="webServiceIP" value="127.0.0.1">
					<br>[ Is 127.0.0.1 (webCenter and web service are on the ESX server) use javascript to resolve.]
				 </logic:equal>
				</logic:notPresent></li>
			<li><b>Port</b>: </li>
			<li><b>VM cfg path</b>: <bean:write name="dvcCnctView" property="mksTicketDataItem.vmConfigFile"/></li>
			<li><b>User</b>: <bean:write name="dvcCnctView" property="mksTicketDataItem.mksTicket"/></li>
			<li><b>Password</b>: <bean:write name="dvcCnctView" property="mksTicketDataItem.mksTicket"/></li>		
			<li><b>Device node</b>: <bean:write name="dvcCnctView_deviceNode"/></li>		
			<li><b>Local Device Path</b>: <bean:write name="dvcCnctView_locationPath"/></li>
<logic:equal name="deviceType" value="floppy">
			<li><b>File type</b>: <%= VmConsoleView.REMOTE_DEVICE_FILE_TYPE %></li>		
			<li><b>Drive Number</b>: 0 [hard wired]</li>
</logic:equal>
<logic:equal name="deviceType" value="cd">
		 <li><b>rawDevice ?</b>: true (TODO hard wired)</li>
		 <li><b>exclusiveDevice  ?</b>: false (TODO hard wired)</li>
</logic:equal>

		</ul>
		<h3><a href="javascript:closeConfig('<%= Constants.TAB_VM_SUMMARY %>')">close</a></h3>
--%>
<%-- End Visual Debug Info --%>		

  </div> <%-- end configWrapDiv --%>
</body>