<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.control.action.common.GlobalViewAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/contextTest.jsp" %>
<c:set var="GLOBALVIEW_KEY" value="<%= GlobalViewAction.ATTR_VIEW %>" scope="page" />
<c:set var="globalView" value="${requestScope[GLOBALVIEW_KEY]}" scope="page" />
<c:set var="VIEWMANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEWMANAGER_KEY]}" scope="page" />

<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<html>
   <head>
      <title>About</title>
      <link href="css/default.css" rel="stylesheet" type="text/css" />
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->
      <style type="text/css">
         body { margin: 0px; padding: 0px; border: none; overflow: hidden; }
         .titlebar .title { margin-left: 0px; }
         div.commandButtons {
            border-top: solid 1px #e6e6e6;
            margin: 8px;
            margin-top: 0px;
            padding-top: 8px;
         }
      </style>

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,drag" />
      </jsp:include>

      <script type="text/javascript">
         var vpxWin;
         var methods = {};
         methods.setFocus = function () {
            $("button_0").focus();
         };

         methods.getContentDimension = function() {
	    return vpx.xua.getDimension("windowPane");
         };

         function initPane(o) {
            vpxWin = o;
            var handles = $("windowTitleCell");
            if (! isArray(handles)) {
               handles = [handles];
            }

            // XXX: We should locate the draggable context programatically.
            //vpxWin.context.vpx.drag.init(handles, [vpxWin.element]);
            //vpxWin.context.vpx.drag.setBoundaryByElement(handles, vpxWin.context);
            //vpxWin.context.vpx.drag.listen(handles, "start", dragStart);
            //vpxWin.context.vpx.drag.listen(handles, "drag", dragDrag);
            //vpxWin.context.vpx.drag.listen(handles, "end", dragEnd);

            extendObject(vpxWin, methods);

            document.onkeyup = function (e) {
               if (vpx.xua.event.getKeyCode(e) == 27) {
                  vpxWin.cancel();
               }
            };

            vpx.xua.event.listen($("windowClose"), "click", vpxWin.cancel.bind(vpxWin));

            // XXX: Make button widths comfortable manually because width:auto;
            // min-width:72px; aligns the button labels left.
            var btn = $("button_0");
            var w = vpx.xua.getWidth(btn);
            if (w < 72) {
               vpx.xua.setWidth(btn, 72);
            }

            vpxWin.ready();
         };


         dragStart = function (e) {
            vpx.xua.setStyle("windowViewport", "position", "absolute");
            var dim = vpx.xua.getDimension("windowViewport");
            vpx.xua.setPosition("windowViewport", new Position(0,0).subtract(dim.toPosition()));
            vpx.xua.setStyle("windowControls", "display", "none");
         };


         dragDrag = function (e) {
            window.status = vpx.xua.event.getPosition(e);
            return true;
         };

         dragEnd = function (e) {
            vpx.xua.setStyle("windowViewport", "position", "static");
            vpx.xua.setStyle("windowControls", "display", "");
         };
      </script>
   </head>

   <body>
      <div id="windowPane" class="dialog half" style="position:absolute; top:0px; left:0px; border-bottom:solid 1px #b3b3b3; margin:0px; padding-bottom:0px;">
         <div id="windowTitleBar" class="titlebar">
            <table border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td id="windowTitleCell" width="100%"><span id="windowTitle" class="title"><fmt:message key="about.title" bundle="${messageResources}"/></span></td>
                  <td id="windowCloseCell"><div id="windowClose" class="close-12x12 icon" /></td>
               </tr>
            </table>
         </div>
         <!-- div style="width:100%; height:120px; background-color:#c00;" / -->
         <div style="margin: 8px;">
            <table style="border-collapse: collapse;" border="0" cellpadding="0" cellspacing="0">
               <tr>
                  <td valign="top"><div id="windowIcon" class="icon information-32x32" /></td>
                  <td>
                     <div id="windowMessage" style="margin-left:8px;">
                        <fmt:message key="about.versionStr" bundle="${messageResources}" var="versionStr" scope="page"/>
                        <div align="center">
                           <fmt:message key="about.productTitle" bundle="${messageResources}"/> (181232)<br>
                           <fmt:message key="about.productLocale" bundle="${messageResources}" var="abtLocale" scope="page"/>
                           <fmt:message key="about.productLocaleBuild" bundle="${messageResources}" var="abtLocaleBuild" scope="page"/>
                           <c:if test="${abtLocale != 'INTL'}">
                              <c:out value="${abtLocale}"/>-<c:out value="${abtLocaleBuild}"/>
                           </c:if>
                        </div>
                        <div align="center">
                           <c:out value="${globalView.about.productName}"/>:
                           <c:out value="${globalView.about.productVersion}"/> (<c:out value="${globalView.about.build}"/>)<br>
                           <c:if test="${globalView.about.productLocale != 'INTL'}">
                              <c:out value="${globalView.about.productLocale}"/>-<c:out value="${globalView.about.productLocaleBuild}"/>
                           </c:if>
                        </div>
                        <c:if test="${viewManager.multiHost == 'true'}">
                           <div>
                              <%-- XXX Add [vm.runtime.host.summary.config.product.build] if connected to a VM --%>
                           </div>
                        </c:if>
                        <p><fmt:message key="about.copyright" bundle="${messageResources}"/></p>
                     </div>
                  </td>
               </tr>
            </table>
         </div>
         <div id="windowControls">
            <div id="commandButtons" class="commandButtons">
               <input class="buttonCtrl" style="width:auto; min-width:inherit;" type="button" id="button_0" value="<bean:message key="common.label.ok"/>" onclick="vpxWin.okay();" />
            </div>
         </div>
      </div>
   </body>
</html>
