<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.common.browser.BrowserWrapper,
                 com.vmware.webcenter.util.SortCriteria" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="browser" value="${requestScope.browserWrapper}" scope="page" />
<c:set var="locations" value="${browser.locations}" scope="page" />
<c:set var="colHeader" value="${browser.columns}" scope="page" />
<c:set var="eachNode" value="${browser.nodes}" scope="page" />
<c:set var="attMap" value="${browser.attributes}" scope="page" />

<browserPane page="<c:out value='${browser.pageNum}'/>" total="<c:out value='${browser.totalPages}'/>">

   <locations>
   <c:if test="${locations != null}">
      <c:forEach var="node" items="${locations}">
         <location id="<c:out value='${node.id}'/>" iconClass="<c:out value='${node.iconClass}'/>">
            <display><c:out value='${node.displayName}'/></display>
         </location>
      </c:forEach>
   </c:if>
   </locations>

   <%-- TODO:Get the column display names from resource bundle --%>
   <cols sort="<c:out value='${browser.sortColumnName}'/>"
   dir="<c:out value='${browser.sortColumnDirection}'/>" >
   <c:if test="${colHeader != null}">
     <c:forEach var="node" items="${colHeader}">
       <col name="<c:out value='${node.name}'/>"
         display="<c:out value='${node.displayName}'/>"
         canSort="<c:out value='${node.canSort}'/>"
         widest="<c:out value='${node.widest}'/>">
       </col>
     </c:forEach>
   </c:if>
   </cols>

  <nodes>
     <c:if test="${eachNode != null}">
       <c:forEach var="item" items="${eachNode}">
          <node
          <c:if test='${item.children}'>
            children="true"
          </c:if>
          id="<c:out value='${item.id}'/>" iconClass="<c:out value='${item.iconClass}'/>">

       <%-- Node contains a map of columns. Each column contains
            array list of cells --%>
       <c:forEach var="eachColumnMap" items="${item.cells}">
       <col>
         <%-- Map contains arrayList of cells with column name as key --%>
          <c:forEach var="eachCell" items="${eachColumnMap.value}">
             <c:if test='${eachCell.html != null}'>
               <cell class="<c:out value='${eachCell.cssClass}'/>">
                 <c:out value='${eachCell.html}'/>
               </cell>
             </c:if>
          </c:forEach>
          </col>
       </c:forEach>

           <%-- Set the node attributes i.e fileType, capacity, freespace, diskSize etc --%>
           <c:set var="nodeAttrs" value='${item.attributes}'/>
           <attrs>
           <c:forEach var='map' items='${nodeAttrs}'>
              <attr name="<c:out value='${map.key}'/>" value="<c:out value='${map.value}'/>" />
           </c:forEach>
           </attrs>
          </node>
       </c:forEach>
     </c:if>
   </nodes>

   <attrs>
      <c:forEach var='item' items='${attMap}'>
        <attr name="<c:out value='${item.key}'/>" value="<c:out value='${item.value}'/>" />
      </c:forEach>
   </attrs>
   <c:if test="${browser.selectedId != null}">
      <selections>
         <selection id="<c:out value='${browser.selectedId}'/>" />
      </selections>
   </c:if>
</browserPane>
