<%@ page import="com.vmware.webcenter.context.BasicMessageVO" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="MESSAGEVO_KEY" value="<%= BasicMessageVO.SESSION_ATTR %>" scope="page" />
<c:set var="msg" value="${sessionScope[MESSAGEVO_KEY]}" scope="page" />
<c:set var="TYPE_INFO" value="<%= BasicMessageVO.TYPE_INFO %>" scope="page" />
<c:set var="TYPE_QUESTION" value="<%= BasicMessageVO.TYPE_QUESTION %>" scope="page" />
<c:set var="TYPE_WARNING" value="<%= BasicMessageVO.TYPE_WARNING %>" scope="page" />
<c:set var="TYPE_ERROR" value="<%= BasicMessageVO.TYPE_ERROR %>" scope="page" />

<c:if test="${sessionScope[MESSAGEVO_KEY] != null}">
   <c:set var="msg" value="${sessionScope[MESSAGEVO_KEY]}" scope="page" />

   <link rel="stylesheet" type="text/css" href="css/messageBox.css" />
   <jsp:include page="/WEB-INF/jsp/common/js/vpx_xua.jsp" />
   <jsp:include page="/WEB-INF/jsp/common/js/vpx_win.jsp" />
   <jsp:include page="/WEB-INF/jsp/common/js/vpx_drag.jsp" />
   <script type="text/javascript">
      function _vpx_context_showMsg() {
         var w = vpx.win;
         var cs = new w.SourceSpec(w.SOURCE_TYPE_URL, "html/messageBoxContent.html");
         var rs = new w.RootSpec(new w.SourceSpec(w.SOURCE_TYPE_URL, "html/alertRoot.html"));
         var msgBox = new w.Frame(cs, null /* frameSpec */, rs, tle /* context */);

         msgBox.listen("ready", function (o) {
            <c:choose>
               <c:when test="${msg.type == TYPE_INFO}">
                  var title = "<fmt:message key='dialog.title.info' bundle='${messageResources}'/>";
                  var cssClass = "information-32x32";
               </c:when>
               <c:when test="${msg.type == TYPE_QUESTION}">
                  var title = "<fmt:message key='dialog.title.question' bundle='${messageResources}'/>";
                  var cssClass = "question-32x32";
               </c:when>
               <c:when test="${msg.type == TYPE_WARNING}">
                  var title = "<fmt:message key='dialog.title.warning' bundle='${messageResources}'/>";
                  var cssClass = "warning-32x32";
               </c:when>
               <c:when test="${msg.type == TYPE_ERROR}">
                  var title = "<fmt:message key='dialog.title.error' bundle='${messageResources}'/>";
                  var cssClass = "error-32x32";
               </c:when>
            </c:choose>

            var msg = '<div class="titleText">';
            msg += "<fmt:message key='${msg.titleKey}' bundle='${messageResources}'/>";
            msg += '</div>';
            <c:forEach items="${msg.descKeys}" var="descKey">
               msg += '<div class="detailsText">';
               msg += "<fmt:message key='${descKey}' bundle='${messageResources}'/>";
               msg += '</div>';
            </c:forEach>

            o.setTitle(new w.SourceSpec(o.SOURCE_TYPE_STRING, title));
            o.setIcon(new w.SourceSpec(w.SOURCE_TYPE_CSS_CLASS, cssClass));
            o.setMessage(new w.SourceSpec(w.SOURCE_TYPE_STRING, msg));
            o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
            o.setModal(true);
            o.open();
         });

         msgBox.init();
      }
      vpx.xua.event.listen(window, "load", _vpx_context_showMsg);
      <c:remove var="com.vmware.webcenter.context.BasicMessageVO.instance" scope="session" />
   </script>
</c:if>
