<%-- the includer of this file is responsable for providing the vmId parameter --%>
<%@ page import="com.vmware.webcenter.control.action.VmPowerOperationsAction" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>


  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
    <jsp:param name="packages" value="xua,win,drag" />
  </jsp:include>
  
  <%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
  
<script type="text/javascript">
   powerOpObj = new Object();
   var gOSRunningPowerOffMsg = '<div class="synopsis"><bean:message key="errors.vm.operations.powerOperations.guestOSRunning.powerOff.warning" /></div> ' +
                               '<div class="description"><bean:message key="errors.vm.operations.powerOperations.guestOSRunning.powerOff.confirm" /></div>';
   var gOSRunningResetMsg = '<div class="synopsis"><bean:message key="errors.vm.operations.powerOperations.guestOSRunning.reset.warning" /></div> ' +
                            '<div class="description"><bean:message key="errors.vm.operations.powerOperations.guestOSRunning.reset.confirm" /></div>';
         
   
   powerOpObj.responseReceived = function (event) {
      var statusCode = null;
      var errorMessage = null;
      var response = event.getSource();

      // ensure that content type is text/xml      
      if (response.getContentType() != 'text/xml') {
         vpx.log.error("powerOpObj: response is not XML. Received content type is: "+response.getContentType());
         return;
      }
   
      <%-- NOTICE: exceptions thrown here would be caught in 
           HttpRequest#_fireResponseReceived(). Log the errors instead and return.
      --%>
      var xml = response.getXml();
      var root = xml.documentElement;
      
      if (root == null) {
         vpx.log.error("powerOpObj: XML was not well formed");
         return;
      }
      
      var statusNode = root.getElementsByTagName("status");
      if (!isNull(statusNode) && statusNode.length > 0) {
         statusCode = statusNode[0].getAttribute("code");
      }
     
      if (isNull(statusCode)) {
         return;
      }
      
      //remove white space
      statusCode = statusCode.replace(/^\s+/g, '').replace(/\s+$/g, '');

      if ( statusCode == '<%= VmPowerOperationsAction.OP_VM_SUCCESS %>' ) {
         // now we are sure that power cmd will be processed
      } else if ( statusCode == '<%= VmPowerOperationsAction.OP_VM_FAILED_INVALID_STATE %>' ) {
         var errorNode = root.getElementsByTagName("error");
         if (!isNull(errorNode) && errorNode.length > 0) {
            errorMessage = errorNode[0].getAttribute("message");
         }
         if (!isNull(errorMessage)) {
            <%-- expose error to UI --%>
            vpx.win.error(errorMessage, '<%= Constants.POWEROPS_EXCEPTION_HANDLER %>', tle.getWorkspacePane());
         }
      } else {
         vpx.log.debug("powerOp#responseReceived(): received illegal status code");
      }
   }
   
  
   /* doPowerOp --
    *   Fire a power operation. 
    *   
    * @op power operation as specified in VmPowerOperationsAction.OP_VM_*
    */
   function doPowerOp(op) {
      if (op == "<%= VmPowerOperationsAction.OP_VM_POWEROFF %>"){
         vpx.win.confirm(gOSRunningPowerOffMsg, tle.getWorkspacePane(), doPowerOffVMCallback);
      } else if (op == "<%= VmPowerOperationsAction.OP_VM_RESET %>"){
         vpx.win.confirm(gOSRunningResetMsg, tle.getWorkspacePane(), doResetVMCallback);
      } else {
         _doPowerOp(op);
      }
   }
   
   function _doPowerOp(op) {
      // TODO change GUI preemtively, speculating that power cmd will be successful
      cmdStr = 'vmPowerOps.do?powerOp='+op+'&vmId=<% out.print(request.getParameter("vmId")); %>';
      req = tle.getRequest(cmdStr);
      req.addResponseListener(powerOpObj);
      try {
         setTimeout("req.send();", 100);
      } finally {    
         tle.releaseRequest(req);  
      }
   }
   
   function doPowerOffVMCallback (query) {
      if (query) {
         _doPowerOp("<%= VmPowerOperationsAction.OP_VM_POWEROFF %>");
      }
      return;
   }
   
   function doResetVMCallback (query) {
      if (query) {
         _doPowerOp("<%= VmPowerOperationsAction.OP_VM_RESET %>");
      }
      return;
   }
</script>