<%@ taglib uri="/tags/c" prefix="c" %>
<%@ page import="java.util.HashMap,
                 java.util.Map,
                 java.util.Arrays,
                 java.util.List,
                 java.util.Set,
                 java.util.HashSet,
                 com.vmware.webcenter.util.CommonUtils" %>
<%@ page isELIgnored="false" %>

<%
   // The order in which packages MUST be loaded
   String[] packageOrder = new String[] {
      "ext",
      "xua",
      "core",
      "net",
      "logging",
      "gui",
      "updates",
      "browser",
      "util",
      "win",
      "drag",
   };

   // Packages that have dependencies are specified here
   // the packages included in commonJs.jsp can be safely assumed as always available
   // as of now, these are "ext", "logging" and "net"
   Map dependencies = new HashMap();
   dependencies.put("net",     new String[] {"xua", "core"});
   dependencies.put("gui",     new String[] {"xua", "core", "net"});
   dependencies.put("updates", new String[] {"xua", "net"});
   dependencies.put("browser", new String[] {"xua", "net", "gui"});
   dependencies.put("util",    new String[] {"xua", "core", "net"});
   dependencies.put("logging", new String[] {"net"});

   String pkgStr = pageContext.getRequest().getParameter("packages");
   String[] pkgArr = pkgStr.split(",");
   Set requestedPackages = new HashSet( Arrays.asList( pkgArr ) );

   List packagesToLoad = CommonUtils.closureVpxLibs(requestedPackages, dependencies, packageOrder);

   pageContext.setAttribute("packages", packagesToLoad);
%>


<%@ include file="/WEB-INF/jsp/common/js/vpx.jsp" %>
<c:forEach items="${packages}" var="package">
<jsp:include page="/WEB-INF/jsp/common/js/vpx_${package}.jsp" />
</c:forEach>