<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants" %>
<%@ page import="com.vmware.webcenter.control.action.vmconfiguration.ConfigureCdDvdAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">

<head>

  <link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
  <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

  <%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>

  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
    <jsp:param name="packages" value="xua,win,drag" />
  </jsp:include>
  <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
    
  <script src="js/configuration/commonConfig.js"></script>
  <script src="js/configuration/vm/cdDvd.js"></script>

<logic:notPresent name="dvcCnctView">
  <logic:notPresent name="configDone">

<script language="JavaScript" type="text/javascript">      
  var REMOTE_BACKING_FILE = 4;

  var hostPassthrough = ("<bean:write name="vmCdDvdView" property="passthroughBackingOption"/>" != "");
  
  function init() {
     setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.cd"/>");
     initConfigPage();
  }
  
  function tearDown() {
     resetHelp();
  }
  
  function setFormInputs (){
    var powerState = "<bean:write name="vmCdDvdView" property="vmEntity.powerState"/>";
    if (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" ){
    	poweredOn = true;
    }
	var mediaType = "<bean:write name="vmCdDvdView" property="cdDvd.mediaType"/>";
	var connected = <bean:write name="vmCdDvdView" property="cdDvd.connected"/>;	
	
    // first initialize the cusomizable file input 
    initFileInput();  

	var currentNode = nodeToMksNode("<bean:write name="vmCdDvdView" property="currentNode"/>");
	var cdw = tle.getClientDeviceConnector();
	var remoteISO = null;
	if (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" &&
	  mediaType ==  "<%= Constants.CLIENT_MEDIA %>" && connected){
	  if (cdw == null  || 
        cdw.getLocalDevicePath(currentNode, "<bean:write name="vmCdDvdView" property="vmEntity.cfgUrl"/>") == null ||
        cdw.getLocalDevicePath(currentNode, "<bean:write name="vmCdDvdView" property="vmEntity.cfgUrl"/>") == "") {
	      var canConnect = true;
	      <logic:equal name="vmCdDvdView" property="canInteractConnect" value="false">
	      canConnect = false;
	      </logic:equal>
	      <logic:equal name="vmCdDvdView" property="canConfigure" value="false">
	      canConnect = false;
	      </logic:equal>
	      clientDeviceLock(true, canConnect);
	      document.forms[0].clientConnectionLock.value = "locked";
	      document.forms[0].connected.value = false;
	      return;
	      /**************************************************************
	      * Lock the screen, no more client side processing from hereon
	      **************************************************************/
	    } else {
			if(cdw.getRemoteBackingType(currentNode, "<bean:write name="vmCdDvdView" property="vmEntity.cfgUrl"/>") == REMOTE_BACKING_FILE) {
			  remoteISO = cdw.getLocalDevicePath(currentNode, "<bean:write name="vmCdDvdView" property="vmEntity.cfgUrl"/>");
			}
	    }
	}

	clientDeviceLock(false);
    
    // initialize form state (disable/enable according to options
  <logic:equal name="vmCdDvdView" property="cdDvd.mediaType" value="<%= Constants.CLIENT_MEDIA %>">
	document.getElementById("clientMedia").checked = true;
  </logic:equal>
  <logic:equal name="vmCdDvdView" property="cdDvd.mediaType" value="<%= Constants.HOST_MEDIA %>">
    document.getElementById("hostMedia").checked = true;
  </logic:equal>
  
  <logic:equal name="vmCdDvdView" property="cdDvd.backingType" value="<%= Constants.DEVICE_ISO_BACKING %>">
    document.getElementById("iso").checked = true;
    document.forms[0]["isoLocation"].value = "<wc:jsSafe name="vmCdDvdView" property="cdDvd.isoBacking.fileName"/>";
  </logic:equal>
  <logic:equal name="vmCdDvdView" property="cdDvd.backingType" value="<%= Constants.DEVICE_LEGACY_BACKING %>">
    document.getElementById("device").checked = true;
    document.getElementById("emulate").checked = true;
    document.forms[0]["deviceLocation"].value = "<wc:jsSafe name="vmCdDvdView" property="cdDvd.legacyBacking.deviceName"/>";
  </logic:equal>
    if (remoteISO == null) {
  <logic:equal name="vmCdDvdView" property="cdDvd.backingType" value="<%= Constants.DEVICE_REMOTE_LEGACY_BACKING %>">
      document.getElementById("device").checked = true;
      document.getElementById("emulate").checked = true;
	  document.forms[0]["deviceLocation"].value = "<wc:jsSafe name="vmCdDvdView" property="cdDvd.remoteLegacyBacking.deviceName"/>";
  </logic:equal>
  <logic:equal name="vmCdDvdView" property="cdDvd.backingType" value="<%= Constants.DEVICE_REMOTE_PASS_THROUGH_BACKING %>">
      document.getElementById("device").checked = true;
      document.getElementById("passthru").checked = true;
	  document.forms[0]["deviceLocation"].value = "<wc:jsSafe name="vmCdDvdView" property="cdDvd.remotePassthroughBacking.deviceName"/>";
  </logic:equal>
    } else {
      document.getElementById("iso").checked = true;
      document.forms[0]["isoLocation"].value = remoteISO;
      document.forms[0]["initClientFileBacking"].value = "fileBacking";
      document.forms[0]["initClientFileValue"].value = remoteISO;
    }
    setIdeNode("<bean:write name="vmCdDvdView" property="currentNode"/>");
		
	setFormState(powerState);
  }
  
  function setFormState (strPowerState) {
<logic:notPresent name="vmCdDvdView" property="remotePassthroughBackingOption">
	disableClientMedia();
</logic:notPresent>

    toggleMedia();
    toggleDriveSource();
    // set the browse href only after setting the media and drive source states !
    setBrowseSrc();
    if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" ){
      disableAll();
    } else if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>"){
      disableStatusSettings(true);
    } else if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>"){
      disableVirtualDevice();
    }
    
    setFormPrivilages();
  }
  
  function setFormPrivilages() {
     if (!<bean:write name="vmCdDvdView" property="canInteractConnect"/>) {
        canInteractConnect = false; <%-- canInteractConnect defined in cdDvd.js --%>
        disableAllStatusSettings()
     }
     if (!<bean:write name="vmCdDvdView" property="canSetMedia"/>) {
        disableMedia();
        disableConnection();
     } 
     if (!<bean:write name="vmCdDvdView" property="canEditDevice"/>) {
     	disableVirtualDevice();
     } 
     if (!<bean:write name="vmCdDvdView" property="canConfigure"/>) {
     	disableAll();
     } 
  }

<%-- validation alert variables --%>
  <bean:define id="msg_vmConfiguration_device_connection_physicalDrive">
    <bean:message key="vmConfiguration.device.connection.physicalDrive"/>
  </bean:define>
  <bean:define id="msg_vmConfiguration_device_connection_isoImage">
    <bean:message key="vmConfiguration.device.connection.isoImage"/>
  </bean:define>
  
  
  function preValidateConfigureVmCdDvdForm(configForm) {
    if (!bCancel) { <%-- TODO : do not hardcode the Struts value here. Find out where it's declared and use that constant --%>
      var deviceCon = document.getElementById("device");
      var isoCon = document.getElementById("iso");
      var ideNode = document.getElementById("ideNode");
      if (!deviceCon.disabled && deviceCon.checked == true) {
        configForm.deviceLocation.value = trimAll(configForm.deviceLocation.value);
        if (configForm.deviceLocation.value == "") {
          vpx.win.alert("<bean:message key="errors.required.specify" arg0="<%= msg_vmConfiguration_device_connection_physicalDrive %>"/>");
          configForm.deviceLocation.focus();
          toggleOk(true);
          return false;
        } 
      }
      if (!isoCon.disabled && isoCon.checked == true) {
		configForm.isoLocation.value = trimAll(configForm.isoLocation.value);
        if (configForm.isoLocation.value == "") {
          vpx.win.alert("<bean:message key="errors.required.specify" arg0="<%= msg_vmConfiguration_device_connection_isoImage %>"/>");
          configForm.isoLocation.focus();
          toggleOk(true);
          return false;
        } 
      } 
      if (!ideNode.disabled) {
        if (ideNode.options[ideNode.selectedIndex].getAttribute("used") == "true" &&
            !( ideNode.options[ideNode.selectedIndex].value == "<bean:write name="vmCdDvdView" property="currentNode"/>")){
          vpx.win.alert("<bean:message key="vmConfiguration.virtualDevice.nodeInUse"/>");
          ideNode.value = "<bean:write name="vmCdDvdView" property="currentNode"/>";
          ideNode.focus();
          toggleOk(true);
          return false;
        }
      }
    }
    var boolValidate = validateConfigureVmCdDvdForm(configForm);
    if (!boolValidate) {
      toggleOk(true);
    }
    return boolValidate;
  }
  
</script>

  </logic:notPresent>	
</logic:notPresent>	


</head>

<logic:present name="dvcCnctView">
  <jsp:include page="/WEB-INF/jsp/clientDevicesConnection/deviceConnection.jsp" >
    <jsp:param name="deviceType" value="cd"/>
  </jsp:include>
</logic:present>

<logic:notPresent name="dvcCnctView">


<logic:present name="configDone">
	<c:set var="BEAN_CONTEXT_SELECTION" value="<%= Constants.BEAN_CONTEXT_SELECTION %>" scope="page" />
	<c:set var="selectionModel" value="${sessionScope[BEAN_CONTEXT_SELECTION]}" scope="page"/>
	<body onload="closeConfig('<c:out value="${selectionModel.selectionState.currentVmTab}"/>')">
		&nbsp;
	</body>
</logic:present>

<logic:notPresent name="configDone">
<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigCdDvd" method="post" onsubmit="toggleOk(false);return preValidateConfigureVmCdDvdForm(this)">

<div class="dialog half"> <%-- dialog half --%>

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="cdDvdDrive-16x16 icon"></div></td>
        <td width="100%">
          <span class="title">
          	<bean:write name="vmCdDvdView" property="cdDvd.name"/> (IDE <%-- TODO get type from view, in any case no need for I18N for hardwired value--%>
          	<bean:write name="vmCdDvdView" property="cdDvd.controllerBusNumber"/>:<bean:write name="vmCdDvdView" property="cdDvd.deviceNumber"/>)</span>
        </td>
        <%-- Bug 98525
        <td><div class="close-12x12 icon" 
        		title="<bean:message key="vmConfiguration.cancel"/>" 
        		onclick="document.forms[0].btnCancel.click()"></div>
        </td> --%>
      </tr>
    </table>
  </div>
  
 <div id="noLock">

  <div class="radioPaneControls">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td class="bulletCtrl">
          <input type="radio" name="media" id="hostMedia" value="<%= Constants.HOST_MEDIA%>" 
          	class="radioCtrl" onclick="toggleMedia()" />
        </td>
        <td>
          <label class="title" for="hostMedia">
            <span id="l10n_vmConfiguration_device_media_hostMedia">
            	<bean:message key="vmConfiguration.device.media.hostMedia"/></span>
          </label>
          <div class="description">
            <span id="l10n_vmConfiguration_device_media_hostMedia_expl">
            	<bean:message key="vmConfiguration.device.media.hostMedia.expl"/></span>
          </div>
        </td>
      </tr>
      <tr>
        <td class="bulletCtrl">
          <input type="radio" name="media" id="clientMedia" value="<%= Constants.CLIENT_MEDIA%>" 
          	onclick="toggleMedia()" class="radioCtrl" />
        </td>
        <td>
          <label id="ttl_clientMedia" class="title" for="clientMedia">
            <span id="l10n_vmConfiguration_device_media_clientMedia">
            	<bean:message key="vmConfiguration.device.media.clientMedia"/></span>
          </label>
          <div id="desc_clientMedia" class="description">
            <span id="l10n_vmConfiguration_device_media_clientMedia_expl">
              <bean:message key="vmConfiguration.device.media.clientMedia.expl"/></span>
          </div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">
    <div class="fieldset">
      <span id="l10n_vmConfiguration_device_status" class="legend">
      	<bean:message key="vmConfiguration.device.status"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="connected" id="connected" 
          <logic:equal name="vmCdDvdView" property="cdDvd.connected" value="true">
          		checked
          </logic:equal> class="checkboxCtrl"/>
          </td>
          <td>
            <label for="connected">
              <span id="l10n_vmConfiguration_device_status_connected">
              	<bean:message key="vmConfiguration.device.status.connected"/></span>
            </label>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="connectAtPowerOn" id="connectAtPowerOn" 
          <logic:equal name="vmCdDvdView" property="cdDvd.startConnected" value="true">
          		checked
          </logic:equal> class="checkboxCtrl"/>
          </td>
          <td>
            <label for="connectAtPowerOn" id="connectAtPowerOnLabel">
              <span id="l10n_vmConfiguration_device_status_connectPowerOn">
              	<bean:message key="vmConfiguration.device.status.connectPowerOn"/></span>
            </label>
          </td>
        </tr>
      </table>
    </div>
    <div class="fieldset">
      <span id="l10n_vmConfiguration_device_connection" class="legend">
      	<bean:message key="vmConfiguration.device.connection"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="connection" id="device" value="device" 
            	class="radioCtrl" onclick="toggleDriveSource()" />
          </td>
          <td>
            <label class="title" for="device">
              <span id="l10n_vmConfiguration_device_connection_physicalDrive">
              	<bean:message key="vmConfiguration.device.connection.physicalDrive"/></span>
            </label>
            <div class="description" id="deviceLocationLabel">
              <span id="l10n_vmConfiguration_cdDvd_connection_physicalDrive_expl">
              	<bean:message key="vmConfiguration.cdDvd.connection.physicalDrive.expl"/></span>:
            </div>
          </td>
        </tr>
        <tr id="deviceOpts">
          <td></td>
          <td>
            <table class="description" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td colspan="2">
                  <input type="text" name="deviceLocation" id="deviceLocation" 
                  		class="text" style="width:250px;" />
                </td>
              </tr>
              <tr id="trRdoEmulate">
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="emulation" id="emulate" onclick="toggleEmulationType()" 
                  		value="<%= ConfigureCdDvdAction.CD_DVD_EMULATION_ATAPI %>" class="radioCtrl"/>
                </td>
                <td>
                  <label for="emulate" id="emulateLabel">
                    <span id="l10n_vmConfiguration_cdDvd_connection_physicalDrive_atapi">
                    	<bean:message key="vmConfiguration.cdDvd.connection.physicalDrive.atapi"/></span>
                  </label>
                </td>
              </tr>
              <tr id="trRdopassthrough">
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="emulation" id="passthru" onclick="toggleEmulationType()" 
                  	value="<%= ConfigureCdDvdAction.CD_DVD_EMULATION_PASSTHRU %>" class="radioCtrl" />
                </td>
                <td>
                  <label for="passthru" id="passthruLabel">
                    <span id="l10n_vmConfiguration_cdDvd_connection_physicalDrive_direct">
                    	<bean:message key="vmConfiguration.cdDvd.connection.physicalDrive.direct" /></span>
                  </label>
                </td>
              </tr>
              <c:if test="${vmCdDvdView.remotePassthroughBackingOption.exclusiveSupported}">  
                <tr id="trRdoExclusive">  
                  <td></td>  
                  <td>  
                    <input type="checkbox" name="exclusive" id="exclusive"  
                      <logic:equal name="vmCdDvdView" property="cdDvd.remotePassthroughBacking.exclusive" value="true">  
                      checked  
                      </logic:equal> class="checkboxCtrl"/>  
                    <label for="exclusive" id="exclusiveLabel">  
                      <span id="l10n_vmConfiguration_cdDvd_connection_physicalDrive_direct_exclusive">  
                        <bean:message key="vmConfiguration.cdDvd.connection.physicalDrive.direct.exclusive" />  
                      </span>  
                    </label>  
                  </td>  
                </tr>  
              </c:if>               
            </table>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="connection" id="iso" value="iso" 
            	onclick="toggleDriveSource()" class="radioCtrl" />
          </td>
          <td>
            <label class="title" for="iso">
              <span id="l10n_vmConfiguration_device_connection_isoImage">
              	<bean:message key="vmConfiguration.device.connection.isoImage"/></span>
            </label>
            <div class="description" id="isoLocationLabel">
              <span id="l10n_vmConfiguration_cdDvd_connection_iso_expl">
              	<bean:message key="vmConfiguration.cdDvd.connection.iso.expl"/></span>:
            </div>
          </td>
        </tr>
        <tr id="isoOpts">
          <td></td>
          <td>
            <table class="description vertLast" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td>
                  <input type="text" name="isoLocation" id="isoLocation" 
                  	class="text" style="width:240px;position:relative;" />
                </td>
                <td>
                  <a href="javascript:;" id="browseIso"><bean:message key="vmConfiguration.cdDvd.connection.iso.browse"/></a>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </div>
    
    <div class="fieldset">
      <span id="l10n_vmConfiguration_virtualDevice" class="legend">
      	<bean:message key="vmConfiguration.virtualDevice"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label class="selectLabel" for="ideNode">
              <span id="l10n_vmConfiguration_virtualDevice_node_ide">
              	<bean:message key="vmConfiguration.virtualDevice.node.ide"/></span>:
            </label>
          </td>
          <td width="100%" align="right">
            <select id="ideNode" name="ideNode">
            <logic:iterate id="ideNode" name="vmCdDvdView" property="ideNodes">
              <option value="<bean:write name="ideNode" property="ctrlrBusNum"/><%= Constants.DEVICE_TOKENIZER %><bean:write name="ideNode" property="deviceUnitNum"/><%= Constants.DEVICE_TOKENIZER %><bean:write name="ideNode" property="ctrlrKey"/>" used="<bean:write name="ideNode" property="used"/>">
              <bean:write name="ideNode" property="name"/></option>
            </logic:iterate>
            </select>
          </td>
        </tr>
      </table>
    </div>
    
    <div class="commandButtons">

<logic:equal name="vmCdDvdView" property="canConfigure" value="true">
   <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
   	<bean:message key="vmConfiguration.button.ok"/>
   </html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
   	<bean:message key="vmConfiguration.button.cancel"/>
   </html:cancel>
</logic:equal>
<logic:equal name="vmCdDvdView" property="canConfigure" value="false">
   <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
   	<bean:message key="vmConfiguration.button.close"/>
   </html:cancel>
</logic:equal>


    </div>
  
  </div> <%-- end window --%>
 </div> <%-- end noLock div--%>
 
 <%@ include file="/WEB-INF/jsp/configuration/vm/shared/clientConnectionConfigLock.jsp" %>  
 
</div> <%-- end dialog half --%>

	<!-- End device config inputs section -->

<input type="hidden" name="clientConnectionLock" value="">
<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmCdDvdView" property="ID"/>">
<input type="hidden" name="initClientFileBacking" value="">
<input type="hidden" name="initClientFileValue" value="">

</html:form>

<div id="file" style="position:absolute;">
  <form>
    <input class="text" type="file" name="fileinput" id="fileinput" 
    	onfocus="this.blur();vpx.xua.getElement('isoLocation').focus();" 
    	onchange="vpx.xua.getElement('isoLocation').value=this.value;" style="cursor:pointer;" onmouseover="vpx.xua.getElement('browseIso').style.color='#F90';" 
    	onmouseout="vpx.xua.getElement('browseIso').style.color='#06F';" />
  </form>
</div>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div> <%-- end configWrap div --%>

<html:javascript formName="configureVmCdDvdForm"/>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmCdDvdView" property="ID"/></li>
	<li>powerState: <bean:write name="vmCdDvdView" property="vmEntity.powerState"/></li>
	
</ul>

<br>
<ul> cd info:
<li>name: <bean:write name="vmCdDvdView" property="cdDvd.name"/><br></li>
<li>controllerType: <bean:write name="vmCdDvdView" property="cdDvd.controllerType"/></li>
<li>controllerId: <bean:write name="vmCdDvdView" property="cdDvd.controllerId"/></li>
<li>deviceNumber: <bean:write name="vmCdDvdView" property="cdDvd.deviceNumber"/></li>
<li>mediaType: <bean:write name="vmCdDvdView" property="cdDvd.mediaType"/></li>
<li>startConnected: <bean:write name="vmCdDvdView" property="cdDvd.startConnected"/></li>
<li>connected: <bean:write name="vmCdDvdView" property="cdDvd.connected"/></li>
<li>backingType: <bean:write name="vmCdDvdView" property="cdDvd.backingType"/></li>
<li>deviceName: <bean:write name="vmCdDvdView" property="cdDvd.legacyBacking.deviceName"/></li>
<li>fileBacking.fileName: <bean:write name="vmCdDvdView" property="cdDvd.isoBacking.fileName"/></li>
</ul>

<br>
<ul> IDE nodes:
<li>Current Node: <bean:write name="vmCdDvdView" property="currentNode"/></li>
<logic:iterate id="ideNode" name="vmCdDvdView" property="ideNodes">
<li> name: <bean:write name="ideNode" property="name"/> ; value: <bean:write name="ideNode" property="value"/> ; used: <bean:write name="ideNode" property="used"/>
</logic:iterate>
</ul>

<ul> Backing Options :
<li>PassthroughBackingOption: <bean:write name="vmCdDvdView" property="passthroughBackingOption"/></li>
<li>IsoBackingOption: <bean:write name="vmCdDvdView" property="isoBackingOption"/></li>
<li>atapiBackingOption: <bean:write name="vmCdDvdView" property="atapiBackingOption"/></li>
<li>remoteAtapiBackingOption: <bean:write name="vmCdDvdView" property="remoteAtapiBackingOption"/></li>
<li>remotePassthroughBackingOption: <bean:write name="vmCdDvdView" property="remotePassthroughBackingOption"/></li>
--%>
<%-- XXX visual debugging section XXX --%>

</body> 
</logic:notPresent> <%-- end configDone not present--%>

</logic:notPresent> <%-- end dvcCnctView not present --%>
</html:html>