<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/deafult-ie.css" />
<![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
	<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
	  <jsp:param name="packages" value="xua,win,drag" />
	</jsp:include>
   <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/cpu.js"></script>

<script language="JavaScript" type="text/javascript">
  function init() {
    setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.processors"/>");
    initConfigPage();  
  }
  
  function tearDown() {
    resetHelp();
  }
  
  function setFormInputs (){
    var sltCpu = document.getElementById("processorCount");
    sltCpu.value = "<bean:write name="vmCpuView" property="vmDataItem.numCpus"/>";
	setFormState("<bean:write name="vmCpuView" property="vmDataItem.powerState"/>");
  }

  function setFormState (strPowerState) {
    if (strPowerState != "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" ){
	  disableAll();
    }
    setFormPrivilages();
  }
  
  function setFormPrivilages(){
	if (!(<bean:write name="vmCpuView" property="canConfigureCPU"/>)) {
	  disableAll();
	} 
  }
  

	</script>

</head>

<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigCpu" method="post" onsubmit="toggleOk(false);">

<div class="dialog half">
  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="processor-16x16 icon"></div></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_cpu_header" class="title">
            <bean:message key="vmConfiguration.cpu.header"/></span><span class="title">(<bean:write name="vmCpuView" property="vmDataItem.numCpus"/>)
          </span>
        </td>
        <td><div class="close-12x12 icon" title="<bean:message key="vmConfiguration.cancel"/>" 
        	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">
    <div class="fieldset">
      <span id="l10n_vmConfiguration_cpu_vCpus" class="legend">
        <bean:message key="vmConfiguration.cpu.vCpus"/></span>
        
        <table id="unlockedCount" border="0" cellspacing="0" cellpadding="0"
        	class="ctrlGrp" style="display:block;">
          <tr>
            <td>
              <label for="processorCount" id="lbl_ProcessorCount">
                <span id="l10n_vmConfiguration_cpu_vCpus_count">
                  <bean:message key="vmConfiguration.cpu.vCpus.count"/></span>:
              </label>
            </td>
            <td width="100%" align="right">
              <c:set var="cpuList" value="${vmCpuView.processorList}" />
              	<c:if test="${!empty cpuList}">
              		<html:select property="processorCount" styleId="processorCount">
              			<html:options name="cpuList"  />
              		</html:select>
                </c:if>
            </td>
          </tr>
        </table>
        
        <div id="lockedCount" class="warn">
    	<div class="title">
    		<span id="l10n_dialog_title_warning">
    			<bean:message key="dialog.title.warning"/></span>
    	</div>
			<p class="explanation">
    		<span id="l10n_vmConfiguration_cpu_vCpus_warn">
    			<bean:message key="vmConfiguration.cpu.vCpus.warn"/></span>
			</p>
		</div>
        

<%-- XXX: When the messages are brought back in, the disableAll function should 
		also be modified to take care of disabling the modify and more info links, 
		as well as the text of the message.
--%>
<%--
    <div id="lockedCount" class="lock">
    	<div class="title">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_multiProcessor">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.multiProcessor"/></span>
    	</div>
			<p class="explanation">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_multiProcessor_expl">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.multiProcessor.expl"/></span>
			</p>
			<p>
				<a href="javascript:unlockCountCtrl();">
    			<span id="l10n_vmConfiguration_cpu_vCpus_modify">
    				<bean:message key="vmConfiguration.cpu.vCpus.modify"/></span>
				</a>
			</p>
			<p>
				<a href="javascript:;">
    			<span id="l10n_vmConfiguration_moreInfo">
    				<bean:message key="vmConfiguration.moreInfo"/></span>
				</a>
			</p>
		</div>

    <div id="lockedCount" class="lock">
    	<div class="title">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_singleProcessor">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.singleProcessor"/></span>
    	</div>
			<p class="explanation">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_singleProcessor_expl">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.singleProcessor.expl"/></span>
			</p>
			<p>
				<a href="javascript:unlockCountCtrl();">
    			<span id="l10n_vmConfiguration_cpu_vCpus_modify">
    				<bean:message key="vmConfiguration.cpu.vCpus.modify"/></span>
				</a>
			</p>
			<p>
				<a href="javascript:;">
    			<span id="l10n_vmConfiguration_moreInfo">
    				<bean:message key="vmConfiguration.moreInfo"/></span>
				</a>
			</p>
		</div>

    <div id="lockedCount" class="lock">
    	<div class="title">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_noPermit_os">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.noPermit.os"/></span>
    	</div>
			<p class="explanation">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_noPermit_os_expl">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.noPermit.os.expl"/></span>
			</p>
			<p>
				<a href="javascript:;">
    			<span id="l10n_vmConfiguration_cpu_vCpus_lock_noPermit_os_reconfig">
    				<bean:message key="vmConfiguration.cpu.vCpus.lock.noPermit.os.reconfig"/></span>
				</a>
			</p>
			<p>
				<a href="javascript:;">
    			<span id="l10n_vmConfiguration_moreInfo">
    				<bean:message key="vmConfiguration.moreInfo"/></span>
				</a>
			</p>
		</div>

    <div id="lockedCount" class="lock">
    	<div class="title">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_legacyHardware">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.legacyHardware"/></span>
    	</div>
			<p class="explanation">
    		<span id="l10n_vmConfiguration_cpu_vCpus_lock_advise_legacyHardware_expl">
    			<bean:message key="vmConfiguration.cpu.vCpus.lock.advise.legacyHardware.expl"/></span>
			</p>
			<p>
				<a href="javascript:;">
    			<span id="l10n_vmConfiguration_cpu_vCpus_modify">
    				<bean:message key="vmConfiguration.cpu.vCpus.modify"/></span>
				</a>
			</p>
		</div>

--%>

    </div>

    <div class="commandButtons">

<logic:equal name="vmCpuView" property="canConfigureCPU" value="true">
      <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
        <bean:message key="vmConfiguration.button.ok"/>
      </html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
        <bean:message key="vmConfiguration.button.cancel"/>
      </html:cancel>
</logic:equal>

<logic:notEqual name="vmCpuView" property="canConfigureCPU" value="true">
      <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
        <bean:message key="vmConfiguration.button.close"/>
      </html:cancel>
</logic:notEqual>

    </div>

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

	<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmCpuView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>


<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmCpuView" property="ID"/></li>

</ul>

<ul> CPU info:
<li>vmDataItem.powerState: <bean:write name="vmCpuView" property="vmDataItem.powerState"/><br></li>
<li>vmDataItem.numCpus: <bean:write name="vmCpuView" property="vmDataItem.numCpus"/><br></li>
</ul>
--%>
<%-- XXX visual debugging section XXX --%>

</body>
</html:html>

