<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- TODO: Remove the constant values after migration from JSTL RT to EL --%>
<c:set var="diskType" value="${vmDiskView.diskType}"/>		  
<c:set var="VIRTUAL_DISK" value="<%= String.valueOf(Constants.VIRTUAL_DISK) %>"/>
<c:set var="VIRTUAL_DISK_SNAPSHOT" value="<%= String.valueOf(Constants.VIRTUAL_DISK_SNAPSHOT) %>"/>
<c:set var="RAW_DISK_MAPPING" value="<%= String.valueOf(Constants.RAW_DISK_MAPPING) %>"/>
<c:set var="RAW_DISK_MAPPING_SNAPSHOT" value="<%= String.valueOf(Constants.RAW_DISK_MAPPING_SNAPSHOT) %>"/>
<c:if test="${diskType == RAW_DISK_MAPPING_SNAPSHOT  || diskType == RAW_DISK_MAPPING}">
	<c:set var="diskMode" value="${vmDiskView.rawDiskMappingVer1Backing.diskMode}"/>	
</c:if>
<c:if test="${diskType == VIRTUAL_DISK  || diskType == VIRTUAL_DISK_SNAPSHOT}">
	<c:set var="diskMode" value="${vmDiskView.flatVer2Backing.diskMode}"/>	
</c:if>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">

<head>

  <link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
    <jsp:param name="packages" value="xua,win,drag" />
  </jsp:include>
  <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
  
  <script src="js/configuration/commonConfig.js"></script>
  <script src="js/configuration/vm/disk.js"></script>
	  	
  <script language="JavaScript" type="text/javascript">
    function init() {
      setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.disk"/>");
      initConfigPage();
    }
    
    function tearDown() {
      resetHelp();
    }
    
    function setFormInputs () {

      var powerState = "<c:out value='${vmDiskView.vmEntity.powerState}'/>"; 

	  <%-- SCSI controller --%>
	  document.forms[0].scsiNode.value = "<c:out value='${vmDiskView.disk.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.controllerKey}'/>";

<c:choose>
  <c:when test="${vmDiskView.bootDevice}">
	  toggleScsiCtrl(true);
  </c:when>
  <c:otherwise>
	  toggleScsiCtrl(false);
  </c:otherwise>
</c:choose>
<logic:notEmpty name="vmDiskView" property="rawDiskMappingVer1Backing.compatibilityMode">
  <logic:equal name="vmDiskView" property="rawDiskMappingVer1Backing.compatibilityMode" value="<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_PHYSICALMODE %>">
      document.getElementById("physical").checked = true;
  </logic:equal>
  <logic:equal name="vmDiskView" property="rawDiskMappingVer1Backing.compatibilityMode" value="<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_VIRTUALMODE %>">
      document.getElementById("virtual").checked = true;
  </logic:equal>
      setCompatibility()
</logic:notEmpty>
<c:if test="${diskType == RAW_DISK_MAPPING_SNAPSHOT || diskType == VIRTUAL_DISK_SNAPSHOT}">
      document.getElementById("independent").checked = false;
  <logic:notEmpty name="diskMode">
    <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_INDEPENDENT_PERSISTENT %>">
      document.getElementById("independent").checked = true;
      document.getElementById("persistent").checked = true;
    </logic:equal>
    <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_INDEPENDENT_NONPERSISTENT %>">
      document.getElementById("independent").checked = true;
      document.getElementById("nonPersistent").checked = true;
    </logic:equal>
  </logic:notEmpty>
      toggleIndp();
</c:if>
<c:if test="${diskType == VIRTUAL_DISK || diskType == RAW_DISK_MAPPING}">
<logic:notEmpty name="diskMode">
  <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_PERSISTENT %>">
      document.getElementById("persistent").checked = true;
  </logic:equal>
  <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_NONPERSISTENT %>">
      document.getElementById("nonPersistent").checked = true;
  </logic:equal>
  <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_UNDOABLE %>">
      document.getElementById("undoable").checked = true;
  </logic:equal>
  <logic:equal name="diskMode" value="<%= VMODLConstants.VIRTUALDISKMODE_APPEND %>">
      document.getElementById("append").checked = true;
  </logic:equal>
</logic:notEmpty>
</c:if>

	  setFormState(powerState);
    }
		
    function setFormState(strPowerState){
      if (strPowerState != "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>") {
        disableAll();
      }
      setFormPrivileges();
    }
    
    function setFormPrivileges() {
      if (!<bean:write name="vmDiskView" property="canEditDevice"/>) {
        disableAll();
      }
    }
    
    function preValidateConfigureGenericScsi(configForm){
      var sltScsiNode = configForm.scsiNode;
      if(sltScsiNode.options[sltScsiNode.selectedIndex].getAttribute("used") == "true" &&
        sltScsiNode.value != "<c:out value='${vmDiskView.disk.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.controllerKey}'/>") {
        vpx.win.alert("<bean:message key="vmConfiguration.virtualDevice.nodeInUse"/>");
        configForm.scsiNode.value = "<c:out value='${vmDiskView.disk.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmDiskView.disk.controllerKey}'/>";
        sltScsiNode.focus();
        toggleOk(true);
        return false;
      }
    }
    
    </script>
</head>

<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigHd" method="post" onsubmit="toggleOk(false);return preValidateConfigureGenericScsi(this)"> 

<div class="dialog half"> <%-- dialog half --%>
		
  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="virtualDisk-16x16 icon"></div></td>
        <td width="100%">
          <span class="title"><c:out value="${vmDiskView.disk.name}"/></span>
        </td>
        <td><div class="close-12x12 icon" 
          title="<bean:message key="vmConfiguration.cancel"/>" 
          onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">

<c:if test="${diskType == VIRTUAL_DISK || diskType == VIRTUAL_DISK_SNAPSHOT}">
<%-- Virtual Disk Image (regardless of snapshots support) --%>
    <div id="fldSet_DiskImage" class="fieldset">
      <span id="l10n_vmConfiguration_hd_virtual_diskImage" class="legend">
      	<bean:message key="vmConfiguration.hd.virtual.diskImage"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="lbl_datastore">
              <span id="l10n_vmConfiguration_hd_rdm_datastore" >
              	<bean:message key="vmConfiguration.hd.rdm.datastore"/></span>:
            </label>
          </td>
          <td><span id="vl_datastore"><c:out value="${vmDiskView.datastoreName}"/></span></td>
        </tr>
        <tr>
          <td>
            <label id="lbl_fileName">
              <span id="l10n_vmConfiguration_hd_rdm_fileName" >
               	<bean:message key="vmConfiguration.hd.rdm.fileName"/></span>:
            </label>
          </td>
          <td><span id="vl_fileName"><c:out value="${vmDiskView.flatVer2Backing.fileName}"/></span></td>
        </tr>
        <tr>
          <td>
            <label id="lbl_capacity">
              <span id="l10n_vmConfiguration_hd_sysLun_capacity" >
              	<bean:message key="vmConfiguration.hd.sysLun.capacity"/></span>:
            </label>
          </td>
          <td><span id="vl_capacity"><wc:out name="vmDiskView" property="disk.capacityInKB" in="kb"/></span></td>
        </tr>
      </table>
    </div>
</c:if>

<c:if test="${diskType == RAW_DISK_MAPPING || diskType == RAW_DISK_MAPPING_SNAPSHOT}">
<%-- System LUN/Disk - Disk volume located on SAN for RDM --%>
    <div id="fldSet_systemLUN" class="fieldset">
      <span id="l10n_vmConfiguration_hd_sysLun" class="legend">
      	<bean:message key="vmConfiguration.hd.sysLun"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="lbl_tgtDevice">
              <span id="l10n_vmConfiguration_hd_sysLun_targetDevice" >
              	<bean:message key="vmConfiguration.hd.sysLun.targetDevice"/></span>:
            </label>
          </td>
          <td>
            <span id="vl_tgtDevice"><c:out value="${vmDiskView.rawDiskMappingVer1Backing.targetDevice}"/></span>
          </td>
        </tr>
        <tr>
          <td>
            <label id="lbl_capacity">
              <span id="l10n_vmConfiguration_hd_sysLun_capacity" >
              	<bean:message key="vmConfiguration.hd.sysLun.capacity"/></span>:
            </label>
          </td>
          <td>
            <span id="vl_capacity"><wc:out name="vmDiskView" property="disk.capacityInKB" in="kb"/></span>
          </td>
        </tr>
      </table>
    </div>
    
<%-- Metadata for RDM and RDM with Snapshot --%>
    <div id="fldSet_metadata" class="fieldset">
      <span id="l10n_vmConfiguration_hd_metadata" class="legend">
      	<bean:message key="vmConfiguration.hd.metadata"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="lbl_datastore">
              <span id="l10n_vmConfiguration_hd_rdm_datastore">
              	<bean:message key="vmConfiguration.hd.rdm.datastore"/></span>:
            </label>
          </td>
          <td>
            <span id="vl_datastore"><c:out value="${vmDiskView.datastoreName}"/></span>
          </td>
        </tr>
        <tr>
          <td>
            <label id="lbl_fileName">
              <span id="l10n_vmConfiguration_hd_rdm_fileName" >
              	<bean:message key="vmConfiguration.hd.rdm.fileName"/></span>:
            </label>
          </td>
          <td>
            <span id="vl_fileName"><c:out value="${vmDiskView.rawDiskMappingVer1Backing.fileName}"/></span>
          </td>
        </tr>
      </table>
    </div>

</c:if>

<%-- Virtual Device section - common for all disk types --%>
    <div class="fieldset">
      <span id="l10n_vmConfiguration_virtualDevice" class="legend">
      	<bean:message key="vmConfiguration.virtualDevice"/></span>
    <div id="lockedScsi" class="lock">
      <div class="title">
        <span id="l10n_vmConfiguration_hd_virtualDevice_bootLock_warning">
        	<bean:message key="vmConfiguration.hd.virtualDevice.bootLock.warning"/></span>
      </div>
      <p class="explanation">
        <span id="l10n_vmConfiguration_hd_virtualDevice_bootLock_reason">
        	<bean:message key="vmConfiguration.hd.virtualDevice.bootLock.reason"/></span>
      </p>
      <p>
        <a href="javascript:toggleScsiCtrl(false)"><span id="l10n_vmConfiguration_hd_virtualDevice_bootLock_modify">
        	<bean:message key="vmConfiguration.hd.virtualDevice.bootLock.modify"/></span></a>
      </p>
    </div>
    <table id="unlockedScsi" border="0" cellspacing="0" cellpadding="0" 
      	class="ctrlGrp">
      <tr>
        <td width="1%">
          <label id="lbl_scsiNode" for="scsiNode">
            <span id="l10n_vmConfiguration_virtualDevice_node_scsi">
            	<bean:message key="vmConfiguration.virtualDevice.node.scsi"/></span>:
          </label>
        </td>
        <td>
          <td width="100%" align="right">
             <select name="scsiNode" id="scsiNode">
<c:set var="scsiNodesList" value="${vmDiskView.scsiNodes}" />	
<c:if test="${scsiNodesList != null}">			        
  <c:forEach var="node" items="${scsiNodesList}">
			   <option value="<c:out value="${node.ctrlrBusNum}" /><%= Constants.DEVICE_TOKENIZER %><c:out value="${node.deviceUnitNum}" /><%= Constants.DEVICE_TOKENIZER %><c:out value="${node.ctrlrKey}" />" 
			   	used="<c:out value="${node.used}"/>">
			     <c:out value="${node.name}" /> 
			   </option>
  </c:forEach>
</c:if>
             </select>
          </td>
        </tr>
      </table>
    </div>

<c:if test="${diskType == RAW_DISK_MAPPING || diskType == RAW_DISK_MAPPING_SNAPSHOT}">
<%-- Compatibility for RDM and RDM with snapshot --%>
    <div id="fldSet_compatibility" class="fieldset">
      <span id="l10n_vmConfiguration_hd_rdm_comptability" class="legend">
      	<bean:message key="vmConfiguration.hd.rdm.comptability"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="compatibility" id="physical" 
            	value="<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_PHYSICALMODE %>" 
            	class="radioCtrl" />
          </td>
          <td>
            <label id="lbl_physical" class="title" for="physical">
              <span id="l10n_vmConfiguration_hd_rdm_comptability_physical_label">
              	<bean:message key="vmConfiguration.hd.rdm.comptability.physical.label"/></span>
            </label>
            <div id="desc_physical" class="description">
              <span id="l10n_vmConfiguration_hd_rdm_comptability_physical_desc">
              	<bean:message key="vmConfiguration.hd.rdm.comptability.physical.desc"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="compatibility" id="virtual" 
            	value="<%= VMODLConstants.VIRTUALDISKCOMPATIBILITYMODE_VIRTUALMODE %>" 
            	class="radioCtrl" />
          </td>
          <td>
            <label id="lbl_virtual" class="title" for="virtual">
              <span id="l10n_vmConfiguration_hd_rdm_comptability_virtual_label">
              	<bean:message key="vmConfiguration.hd.rdm.comptability.virtual.label"/></span>
            </label>
            <div id="desc_virtual" class="description">
              <span id="l10n_vmConfiguration_hd_rdm_comptability_virtual_desc">
              	<bean:message key="vmConfiguration.hd.rdm.comptability.virtual.desc"/></span>
            </div>
          </td>
        </tr>
      </table>
    </div>
</c:if>

<c:if test="${diskType == VIRTUAL_DISK  || diskType == RAW_DISK_MAPPING}">
<%-- Disk Mode for FLAT2 and RDM - NO snapshots--%>

    <div class="fieldset" id="fldSet_diskMode">
      <span id="l10n_vmConfiguration_hd_diskMode" class="legend">
      	<bean:message key="vmConfiguration.hd.diskMode"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="diskMode" id="persistent" 
            	value="<%=VMODLConstants.VIRTUALDISKMODE_PERSISTENT%>" 
            	class="radioCtrl">
          </td>
          <td>
            <label id="lbl_persistent" class="title" for="persistent">
              <span id="l10n_vmConfiguration_hd_diskMode_persistent_label" >
              	<bean:message key="vmConfiguration.hd.diskMode.persistent.label"/></span>
            </label>
            <div  id="desc_persistent" class="description">
              <span id="l10n_vmConfiguration_hd_diskMode_persistent_desc" >
              	<bean:message key="vmConfiguration.hd.diskMode.persistent.desc"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="diskMode" id="nonPersistent" 
            	value="<%=VMODLConstants.VIRTUALDISKMODE_NONPERSISTENT%>" 
            	class="radioCtrl">
          </td>
          <td>
            <label id="lbl_nonPersistent" class="title" for="nonPersistent">
              <span id="l10n_vmConfiguration_hd_diskMode_nonPersistent_label" >
              	<bean:message key="vmConfiguration.hd.diskMode.nonPersistent.label"/></span>
            </label>
            <div id="desc_nonPersistent" class="description">
              <span id="l10n_vmConfiguration_hd_diskMode_nonPersistent_desc" >
              	<bean:message key="vmConfiguration.hd.diskMode.nonPersistent.desc"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="diskMode" id="undoable" 
            	value="<%=VMODLConstants.VIRTUALDISKMODE_UNDOABLE%>" 
            	class="radioCtrl">
          </td>
          <td>
            <label id="lbl_undoable" class="title" for="undoable">
              <span id="l10n_vmConfiguration_hd_diskMode_undoable_label" >
              	<bean:message key="vmConfiguration.hd.diskMode.undoable.label"/></span>
            </label>
            <div id="desc_undoable" class="description">
              <span id="l10n_vmConfiguration_hd_diskMode_undoable_desc" >
              	<bean:message key="vmConfiguration.hd.diskMode.undoable.desc"/>
              </span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="diskMode" id="append" 
            	value="<%=VMODLConstants.VIRTUALDISKMODE_APPEND%>" 
            	class="radioCtrl">
          </td>
          <td>
            <label id="lbl_append" class="title" for="append">
              <span id="l10n_vmConfiguration_hd_diskMode_append_label" >
              	<bean:message key="vmConfiguration.hd.diskMode.append.label"/></span>
            </label>
            <div id="desc_append" class="description">
              <span id="l10n_vmConfiguration_hd_diskMode_append_desc">
              	<bean:message key="vmConfiguration.hd.diskMode.append.desc"/></span>
            </div>
          </td>
        </tr>
      </table>
    </div>

</c:if>

<c:if test="${diskType == VIRTUAL_DISK_SNAPSHOT  || diskType == RAW_DISK_MAPPING_SNAPSHOT }">
<%-- Disk Mode for FLAT2 and RDM - snapshots supported --%>
    
    <div class="fieldset" id="fldSet_diskMode">
      <span id="l10n_vmConfiguration_hd_diskMode" class="legend">
      	<bean:message key="vmConfiguration.hd.diskMode"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="independent" id="independent" 
            	class="radioCtrl" value="1" onclick="toggleIndp()" />
          </td>
          <td>
            <label id="lbl_independent" class="title" for="independent">
              <span id="l10n_vmConfiguration_hd_diskMode_independent_label">
                	<bean:message key="vmConfiguration.hd.diskMode.independent.label"/></span>
            </label>
            <div id="desc_independent" class="description">
              <span id="l10n_vmConfiguration_hd_diskMode_independent_desc">
                	<bean:message key="vmConfiguration.hd.diskMode.independent.desc"/></span>
            </div>
          </td>
        </tr>
        <tr id="deviceOpts">
          <td></td>
          <td>
            <table class="description" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="diskMode" id="persistent" 
                	value="<%=VMODLConstants.VIRTUALDISKMODE_INDEPENDENT_PERSISTENT%>" 
                	class="radioCtrl" />
                </td>
                <td>
                  <label id="lbl_persistent" class="title" for="persistent">
                    <span id="l10n_vmConfiguration_hd_diskMode_persistent_label">
                    	<bean:message key="vmConfiguration.hd.diskMode.persistent.label"/></span>
                  </label>
                  <div id="desc_persistent" class="description">
                    <span id="l10n_vmConfiguration_hd_diskMode_persistent_desc">
                    	<bean:message key="vmConfiguration.hd.diskMode.persistent.desc"/></span>
                  </div>
                </td>
              </tr>
              <tr>
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="diskMode" id="nonPersistent" 
                    value="<%=VMODLConstants.VIRTUALDISKMODE_INDEPENDENT_NONPERSISTENT%>" 
                    class="radioCtrl">
                </td>
                <td>
                  <label id="lbl_nonPersistent" class="title" for="nonPersistent">
                    <span id="l10n_vmConfiguration_hd_diskMode_nonPersistent_label">
                    	<bean:message key="vmConfiguration.hd.diskMode.nonPersistent.label"/></span>
                  </label>
                  <div id="desc_nonPersistent" class="description">
                    <span id="l10n_vmConfiguration_hd_diskMode_nonPersistent_desc">
                    	<bean:message key="vmConfiguration.hd.diskMode.nonPersistent.desc"/></span>
                  </div>
                </td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
    </div>
</c:if>
		  

    <div class="commandButtons">
<logic:equal name="vmDiskView" property="canEditDevice" value="true">
			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>
</logic:equal>
<logic:notEqual name="vmDiskView" property="canEditDevice" value="true">
			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>
</logic:notEqual>
    </div>		 

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>
		
<!-- End device config inputs section -->

  <input type="hidden" name="viewId" id="viewId" value="<c:out value="${vmDiskView.ID}"/>">

</html:form>
		
		
<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>
		
</div> <%-- end configWrap div --%>

<%-- XXX Begin visual debugging section XXX --%>
<%--
<ul> View:
	<li>ID: <bean:write name="vmDiskView" property="ID"/></li>
</ul>

<br>
<ul> <b>VM</b>
	<li>powerState: <bean:write name="vmDiskView" property="vmEntity.powerState"/></li>
</ul>	

<br>
<ul> <b>Disk</b>
	<li>name: <bean:write name="vmDiskView" property="disk.name"/></li>
	<li>key: <bean:write name="vmDiskView" property="disk.key"/></li>
	<li>capacityInKB: <bean:write name="vmDiskView" property="disk.capacityInKB"/></li>

	<li>controllerKey: <bean:write name="vmDiskView" property="disk.controllerKey"/></li>
	<li>controllerNumber: <bean:write name="vmDiskView" property="disk.controllerNumber"/></li>
	<li>deviceNumber: <bean:write name="vmDiskView" property="disk.deviceNumber"/></li>
	<li>ctrlInfo.busNumber: <bean:write name="vmDiskView" property="disk.deviceNumber"/></li>
	

	<li>backingType: <bean:write name="vmDiskView" property="disk.backingType"/></li>
	<li>isBootDevice: <bean:write name="vmDiskView" property="bootDevice"/></li>
</ul>

<br>
<ul><b>datastore</b>
  <li>datastore: <bean:write name="vmDiskView" property="datastoreName"/></li>
</ul>
<br>
<ul><b>RDM backing type</b>
  <li>targetDevice: <bean:write name="vmDiskView" property="rawDiskMappingVer1Backing.targetDevice"/></li>
  <li>compatibilityMode: <bean:write name="vmDiskView" property="rawDiskMappingVer1Backing.compatibilityMode"/></li>
  <li>diskMode: <bean:write name="vmDiskView" property="rawDiskMappingVer1Backing.diskMode"/></li>
  <li>fileName: <bean:write name="vmDiskView" property="rawDiskMappingVer1Backing.fileName"/></li>
</ul>

<br>
<ul><b>FlatVer2 backing type</b>
  <li>diskMode: <bean:write name="vmDiskView" property="flatVer2Backing.diskMode"/></li>
  <li>fileName: <bean:write name="vmDiskView" property="flatVer2Backing.fileName"/></li>
</ul>
--%>
<%-- XXX End visual debugging section XXX --%>

</body> 
</html:html>