<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
  <link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

  <%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>
  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
    <jsp:param name="packages" value="xua,win,drag" />
  </jsp:include>
  <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>

  <script src="js/configuration/commonConfig.js"></script>
  <script src="js/configuration/vm/memory.js"></script>

<script language="JavaScript" type="text/javascript">
  function init() {
    setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.memory"/>");
    initConfigPage();  
  }
  
  function tearDown() {
    resetHelp();
  }

  function setFormInputs (){
    document.forms[0].sizeMb.value = "<wc:jsSafe name="vmMemoryView" property="vmDataItem.memorySize"/>";
    setFormState("<bean:write name="vmMemoryView" property="vmDataItem.powerState"/>");
  }

  function setFormPrivilages(){
    if (!(<bean:write name="vmMemoryView" property="canConfigureMemory"/>)) {
      disableAll();
    }
  }
  
  function setFormState (strPowerState) {
    if (strPowerState != "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>"){
      disableAll();
    }
    setFormPrivilages();
  }

  function preValidateConfigureVmMemoryForm(configForm) {
    if(!bCancel){ <%-- TODO : do not hardcode the Struts value here. Find out where it's declared and use that constant --%>
      configForm.sizeMb.value = trimAll(configForm.sizeMb.value);
    }
    var boolValidate = validateConfigureVmMemoryForm(configForm);
    if (!boolValidate) {
      toggleOk(true);
    }
    return boolValidate;
  }

</script>

</head>

<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigMemory" method="post" focus="sizeMb"  onsubmit="toggleOk(false);return preValidateConfigureVmMemoryForm(this)">
<div class="dialog half">

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="memory-16x16 icon"></div></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_memory_header"
            name="l10n_vmConfiguration_memory_header" class="title">
            <bean:message key="vmConfiguration.memory.header"/></span>
        </td>
        <td><div class="close-12x12 icon"
              title="<bean:message key="vmConfiguration.cancel"/>"
              onclick="document.forms[0].btnCancel.click()">
            </div>
        </td>
      </tr>
    </table>
  </div>

  <div class="window">

    <div class="fieldset">
      <span name="l10n_vmConfiguration_memory_setting"
            id="l10n_vmConfiguration_memory_setting" class="legend">
        <bean:message key="vmConfiguration.memory.setting"/></span>
       <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="lbl_sizeMb" for="sizeMb">
              <span id="l10n_vmConfiguration_memory_setting_size"
                name="l10n_vmConfiguration_memory_setting_size">
                <bean:message key="vmConfiguration.memory.setting.size"/></span>
              </label>
            </td>
            <td width="100%" class="ledger">
              <input class="text ledger" type="text" name="sizeMb" id="sizeMb"
                style="width:34px;" />
            </td>
            <td>
              <span id="spn_unitLabel" class="unitLabel">
                 <bean:message key="common.diskCapacity.size.MB"/>
              </span></td> <%-- no need to I18N MB --%>
          </tr>
      </table>
    </div>

    <div class="fieldset">
      <span name="l10n_vmConfiguration_memory_guestOsConstraints"
          id="l10n_vmConfiguration_memory_guestOsConstraints" class="legend">
            <bean:message key="vmConfiguration.memory.guestOsConstraints"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="lbl_memMin">
              <span id="l10n_vmConfiguration_memory_guestOsConstraints_min"
                name="l10n_vmConfiguration_memory_guestOsConstraints_min">
                <bean:message key="vmConfiguration.memory.guestOsConstraints.min"/></span>:
            </label>
          </td>
          <td width="100%" class="ledger">
            <span id="input_memMin" class="inputPeer">
            <logic:empty name="vmMemoryView" property="OSConstraint.minMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.minMb"><wc:out name="vmMemoryView" property="OSConstraint.minMb" in="mb"/></logic:notEmpty>
            </span>
          </td>
        </tr>
        <tr>
          <td>
            <label id="lbl_memSuggested">
              <span id="l10n_vmConfiguration_memory_guestOsConstraints_suggested"
                name="l10n_vmConfiguration_memory_guestOsConstraints_suggested">
                <bean:message key="vmConfiguration.memory.guestOsConstraints.suggested"/></span>:
            </label>
          </td>
          <td width="100%" class="ledger">
            <span id="input_memSuggested" class="inputPeer">
            <logic:empty name="vmMemoryView" property="OSConstraint.defaultMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.defaultMb"><wc:out name="vmMemoryView" property="OSConstraint.defaultMb" in="mb"/></logic:notEmpty>
            </span>
          </td>
        </tr>
        <tr>
          <td>
            <label id="lbl_memMax">
              <span id="l10n_vmConfiguration_memory_guestOsConstraints_max"
                name="l10n_vmConfiguration_memory_guestOsConstraints_max">
                <bean:message key="vmConfiguration.memory.guestOsConstraints.max"/></span>:
            </label>
          </td>
          <td width="100%" class="ledger">
            <span id="input_memMax" class="inputPeer">
            <logic:empty name="vmMemoryView" property="OSConstraint.maxMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.maxMb"><wc:out name="vmMemoryView" property="OSConstraint.maxMb" in="mb"/></logic:notEmpty>
            </span>
          </td>
        </tr>
      </table>
    </div>

    <div class="commandButtons">

<logic:equal name="vmMemoryView" property="canConfigureMemory" value="true">
      <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
        <bean:message key="vmConfiguration.button.ok"/>
      </html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
        <bean:message key="vmConfiguration.button.cancel"/>
      </html:cancel>
</logic:equal>

<logic:notEqual name="vmMemoryView" property="canConfigureMemory" value="true">
      <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
        <bean:message key="vmConfiguration.button.close"/>
      </html:cancel>
</logic:notEqual>

    </div>

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

  <!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmMemoryView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>

<html:javascript formName="configureVmMemoryForm"/>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
  <li>ID: <bean:write name="vmMemoryView" property="ID"/></li>

</ul>
<ul> memory info:
<li>vmDataItem.runtime.powerState: <bean:write name="vmMemoryView" property="vmDataItem.powerState"/><br></li>
<li>vmDataItem.memorySize: <bean:write name="vmMemoryView" property="vmDataItem.memorySize"/><br></li>
<li>OSConstraint.minMb: 
            <logic:empty name="vmMemoryView" property="OSConstraint.minMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.minMb"><wc:out name="vmMemoryView" property="OSConstraint.minMb" in="mb"/></logic:notEmpty>
</li>
<li>OSConstraint.defaultMb: 
            <logic:empty name="vmMemoryView" property="OSConstraint.defaultMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.defaultMb"><wc:out name="vmMemoryView" property="OSConstraint.defaultMb" in="mb"/></logic:notEmpty>
</li>
<li>OSConstraint.maxMb: 
            <logic:empty name="vmMemoryView" property="OSConstraint.maxMb"><bean:message key="vmConfiguration.memory.guestOsConstraints.unknown"/></logic:empty>
            <logic:notEmpty name="vmMemoryView" property="OSConstraint.maxMb"><wc:out name="vmMemoryView" property="OSConstraint.maxMb" in="mb"/></logic:notEmpty>
</li>

</ul>
--%>
<%-- XXX visual debugging section XXX --%>

</body>
</html:html>