<%-- 
	VC2.0 Beta1 comment (Oren) !
	============================
	
	The original jsp included radio buttons for the type of network to specify.
	Further more, the legacy network options were broken to 5 or so radio buttons.
	The latest spec is available in the UI specs but is different in the fact that
	legacy network options are now under a drop down list.
	
	GSX is the only case where we support legacy networks.
	Beta1 (and possibly future) releases are not supposed to support GSX and therefore:
	1. The jsp was NOT modified to change to the drop down list for legacy networks. 
		It still uses the radio buttons.
	2. The legacy network section was COMMENTED OUT all together.
	3. The legacy network section was not checked for correct code and logic, 
		nor was it tested. 
       It will NOT work as written if uncommented. 
--%>


<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ page import="com.vmware.webcenter.view.viewhelper.VmEthernetCardView" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>

<html:html locale="true">

<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->
    <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
    <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
    </jsp:include>
	<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/nic.js"></script>
	
<script language="JavaScript" type="text/javascript">
function init() {
   setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.ethernet"/>");
   initConfigPage();
}
    
function tearDown() {
  resetHelp();
}

function setFormInputs (){

   var powerState = "<bean:write name="vmNicView" property="vmEntity.powerState"/>";
   
   document.forms[0].connected.checked = <bean:write name="vmNicView" property="ethernetCard.connected" />;
   document.forms[0].connectAtPowerOn.checked = <bean:write name="vmNicView" property="ethernetCard.startConnected" />
   document.forms[0].namedConnection.value = "<bean:write name="vmNicView" property="ethernetCard.networkBacking.deviceName"/>";
	
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VLANCE %>">
   if (document.getElementById("vlance") != null) {
      document.getElementById("vlance").checked = true;
   }
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VMXNET %>">
   if (document.getElementById("vmxnet") != null) {
      document.getElementById("vmxnet").checked = true;
   }
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
   if (document.getElementById("e1000") != null) {
      document.getElementById("e1000").checked = true;
   }
	</logic:equal>
	
   setFormState(powerState);

}

function setFormState (strPowerState) {
   if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" ) {
      disableAll();
   } else if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>") {
      disableStatusSettings(true);
   } else if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>") {
      disableVirtualDevice();
   }
   
   setFormPrivileges();
}

function setFormPrivileges() {
   if (!<bean:write name="vmNicView" property="canInteractConnect"/>) {
      disableAllStatusSettings();
   }
   if (!<bean:write name="vmNicView" property="canAddRemoveDevice"/>) {
      disableAllVirtualDevice();
   }
   if (!<bean:write name="vmNicView" property="canEditDevice"/>) {
      disableAllConnection();
      disableAllVirtualDevice();
   }
   if (!<bean:write name="vmNicView" property="canConfigure"/>) {
      disableAll();
   }
}

</script>
</head>

<c:set var="namedNetworks" value="${vmNicView.networkBackingOptions}" />

<c:if test="${empty namedNetworks}">
<body onload="tle.toggleModal(true);">
</c:if>
<c:if test="${!empty namedNetworks}">
<body onload="init();" onunload="tearDown();">
</c:if>

<div id="configWrapDiv">
<html:form action="vmConfigNic" method="post" onsubmit="toggleOk(false);">

<div class="dialog half">

  <div class="titlebar" >
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="networkAdapter-16x16 icon"></div></td>
        <td width="100%">
          <span class="title">
          	<bean:write name="vmNicView" property="ethernetCard.name"/></span>
        </td>
        <td>
          <div class="close-12x12 icon" 
          	title="<bean:message key="vmConfiguration.cancel"/>" 
          	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
<c:if test="${empty namedNetworks}">				
  <div id="nicLock" class="window">
    <div class="fieldset">
      <span id="l10n_vmConfiguration_device_status" class="legend">
      	<bean:message key="vmConfiguration.device.status"/></span>
      <div class="lock">
        <div class="title">
          <span id="l10n_vmConfiguration_nic_noNetworks_lock">
          	<bean:message key="vmConfiguration.nic.noNetworks.lock"/></span>
        </div>
        <p class="explanation">
          <span id="l10n_vmConfiguration_nic_noNetworks_lock_expl">
          	<bean:message key="vmConfiguration.nic.noNetworks.lock.expl"/></span>
        </p>
      </div>      
    </div>
    <div class="commandButtons">
      <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
        <bean:message key="vmConfiguration.button.close"/>
      </html:cancel>
    </div>    
  </div>
</c:if>
  
<c:if test="${!empty namedNetworks}"> <%-- begin if network names exist and screen is not locked--%>
  <div id="noLock" class="window">
  	<div class="fieldset">
	  	<span id="l10n_vmConfiguration_device_status" class="legend">
	    	<bean:message key="vmConfiguration.device.status"/></span>
  		<table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
  			<tr>
	    		<td class="bulletCtrl">
					<input type="checkbox" name="connected" id="connected" class="checkboxCtrl"/> <%-- XXX disabled="1" if powered off --%>
	    		</td>
	    		<td>
	      		<label for="connected"> <%-- XXX class="disabled" if powered off --%>
	      			<span id="l10n_vmConfiguration_device_status_connected">
	      				<bean:message key="vmConfiguration.device.status.connected"/></span>
	      		</label>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td class="bulletCtrl">
	    			<input type="checkbox" name="connectAtPowerOn" id="connectAtPowerOn" class="checkboxCtrl"/>
	    		</td>
	    		<td>
	      		<label for="connectAtPowerOn">
	      			<span id="l10n_vmConfiguration_device_status_connectPowerOn">
	      					<bean:message key="vmConfiguration.device.status.connectPowerOn"/></span>
	      		</label>
	    		</td>
	  		</tr>
			</table>
    </div>
	
      
<%--	
		The following was commented out for Beta1 of VC2.0 which does not support
		legacyNetworkBackings (existing on GSX) --%>
<%--		
		<c:set var="backingType" value="${vmNicView.ethernetCard.backingType}"/>
		<c:choose>
		<c:when test="${backingType=='legacyNetworkBacking'}">
	    <!-- Named network for GSX-->
		<div class="fieldset">
	  	<span id="l10n_vmConfiguration_nic_networkConnection" class="legend">
	    	<bean:message key="vmConfiguration.nic.networkConnection"/></span>
			<table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
				<tr>
	    		<td class="bulletCtrl">
	    			<input type="radio" name="connectionType" id="named" 
	    				value="<%=VmEthernetCardView.TYPE_NAMED%>" class="radioCtrl" 
	    				onclick="toggleConnectionInputs()" />
	    		</td>
	    		<td>
	      		<label class="title" for="named">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_named">
	      				<bean:message key="vmConfiguration.nic.networkConnection.named"/></span>
	      		</label>
	      		<div class="description" id="namedLabel">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_named_label">
	      				<bean:message key="vmConfiguration.nic.networkConnection.named.label"/></span>:
	      		</div>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td></td>
	    		<td>
		      	<table width="100%" class="description vertLast" border="0" cellspacing="0" cellpadding="0">
		      		<tr>
					<td>
						<c:set var="namedNetworks" value="${vmNicView.networkBackingOptions}" />															
						<c:if test="${!empty namedNetworks}">				
						   <html:select property="namedConnection" styleId="namedConnection">
							  <html:options collection="namedNetworks" property="key" labelProperty="value" />
						   </html:select> 
						</c:if>								
					</td>
					</tr>
		      	</table>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td></td>
	    		<td>
	      		<div class="description">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_named_desc">
	      				<bean:message key="vmConfiguration.nic.networkConnection.named.desc"/></span>
	      		</div>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td class="bulletCtrl">
	    			<input type="radio" name="connectionType" id="bridged" 
	    				value="<%=VMODLConstants.VIRTUALETHERNETCARDLEGACYNETWORKDEVICENAME_BRIDGED%>" class="radioCtrl" 
	    				onclick="toggleConnectionInputs()" />
	    		</td>
	    		<td>
	      		<label class="title" for="bridged">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_bridged">
	      				<bean:message key="vmConfiguration.nic.networkConnection.bridged"/></span>
	      		</label>
	      		<div class="description">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_bridged_label">
	      				<bean:message key="vmConfiguration.nic.networkConnection.bridged.label"/></span>
	      		</div>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td class="bulletCtrl">
	    			<input type="radio" name="connectionType" id="nat" 
	    				value="<%=VMODLConstants.VIRTUALETHERNETCARDLEGACYNETWORKDEVICENAME_NAT%>" class="radioCtrl" 
	    				onclick="toggleConnectionInputs()" />
	    		</td>
	    		<td>
	      		<label class="title" for="nat">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_nat">
	      				<bean:message key="vmConfiguration.nic.networkConnection.nat"/></span>
	      		</label>
	      		<div class="description">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_nat_label">
	      				<bean:message key="vmConfiguration.nic.networkConnection.nat.label"/></span>
	      		</div>
	    		</td>
	  		</tr>
	  		<tr>
	    		<td class="bulletCtrl">
	    			<input type="radio" name="connectionType" id="hostOnly" 
	    				value="<%=VMODLConstants.VIRTUALETHERNETCARDLEGACYNETWORKDEVICENAME_HOSTONLY%>" class="radioCtrl"
	    				onclick="toggleConnectionInputs()" />
	    		</td>
	    		<td>
	      		<label class="title" for="hostOnly">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_hostOnly">
	      				<bean:message key="vmConfiguration.nic.networkConnection.hostOnly"/></span>
	      		</label>
	      		<div class="description">
	      			<span id="l10n_vmConfiguration_nic_networkConnection_hostOnly_label">
	      				<bean:message key="vmConfiguration.nic.networkConnection.hostOnly.label"/></span>
	      		</div>
	    		</td>
	  		</tr>
			
			<!-- Show only if the custom networks are available -->
			<c:set var="customNetworks" value="${vmNicView.legacyNetworkBackingOptions}" />
			<c:if test="${!empty customNetworks}">			
				<tr>
					<td class="bulletCtrl">
						<input type="radio" name="connectionType" id="custom" 
							value="<%=VMODLConstants.VIRTUALETHERNETCARDOPTIONLEGACYNETWORKBACKINGOPTIONNETWORKBACKINGTYPES_CUSTOM%>" class="radioCtrl" 
							onclick="toggleConnectionInputs()" />
					</td>
					<td>
					<label class="title" for="custom">
						<span id="l10n_vmConfiguration_nic_networkConnection_custom">
							<bean:message key="vmConfiguration.nic.networkConnection.custom"/></span>
					</label>
					<div class="description" id="customLabel">
						<span id="l10n_vmConfiguration_nic_networkConnection_custom_label">
							<bean:message key="vmConfiguration.nic.networkConnection.custom.label"/></span>:
					</div>
					</td>
				</tr>
				<tr>
					<td></td>
					<td>
					<table width="100%" class="description" border="0" cellspacing="0" cellpadding="0">
					<tr>
					  <td>
						<c:set var="customConnection" value="${vmNicView.ethernetCard.legacyNetworkBacking.virtualSwitch}" />
						 <html:select property="customConnection" styleId="customNetwork">
						   <html:options collection="customNetworks" property="key" labelProperty="value" />
						 </html:select>
					  </td>
					</tr>
					</table>
				    </td>
				</tr>
			</c:if>
			</table>
		</div>
		</c:when>
		<c:otherwise>
--%>		
		 <div class="fieldset">
	  	  <span id="l10n_vmConfiguration_nic_networkConnection" class="legend">
	    	<bean:message key="vmConfiguration.nic.networkConnection"/></span>
			<table width="90%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td>
				   <html:select property="namedConnection" styleId="namedConnection">
						  <html:options collection="namedNetworks" property="key" labelProperty="value" />
				   </html:select> 
				</td>
	    	</tr>
	       </table>
		</div>
<%--
		</c:otherwise>
		</c:choose>
--%>
		

	<div class="fieldset">
	  	<span id="l10n_vmConfiguration_virtualDevice" class="legend">
	    	<bean:message key="vmConfiguration.virtualDevice"/></span>
<logic:equal name="vmNicView" property="supportsMorphing" value="false"> <%-- Begin Morphing not supported, give option between vlance and vmxnet --%>
	<logic:notEqual name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
		<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/noMorph.jsp"/>
	</logic:notEqual>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
		<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/incmptblNic_E1000.jsp">
		   <jsp:param name="incmpReason" value="host" />
		</jsp:include>
	</logic:equal>
</logic:equal> <%-- End morphing not supported --%>

<logic:equal name="vmNicView" property="supportsMorphing" value="true"> <%-- Begin Morphing supported --%>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VMXNET %>">
		<%-- vmxnet is deprecated when morphing is supported --%>
		<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/incmptbl_vmxnet.jsp"/>
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VLANCE %>">
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_VLANCE%>">
			<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/noChoice.jsp"/>
		</logic:equal>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_E1000%>">
			<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/incmptblNic_Flexible.jsp" />
		</logic:equal>
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_VLANCE%>">
		  <jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/incmptblNic_E1000.jsp">
		    <jsp:param name="incmpReason" value="vm" />
		  </jsp:include>
		</logic:equal>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_E1000%>">
			<jsp:include page ="/WEB-INF/jsp/configuration/vm/nic/noChoice.jsp"/>
		</logic:equal>
	</logic:equal>
</logic:equal> <%-- end morphing supported --%>
	
	 </div>	
		
		<div class="commandButtons">

<logic:equal name="vmNicView" property="canConfigure" value="true">
			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>
</logic:equal>

<logic:notEqual name="vmNicView" property="canConfigure" value="true">
			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>
</logic:notEqual>


		</div>

  </div> 	<%-- end window div --%>
</c:if> <%-- end if network names exist and screen is not locked--%>
</div> 		<%-- end dialog div --%>
	<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<c:out value="${vmNicView.ID}"/>">

<%-- <input type="hidden" name="backingType" id="backingType" value="<c:out value="${vmNicView.ethernetCard.backingType}"/>"> --%>

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>
</body> 

<%-- XXX visual debugging section XXX --%>
<%--
<logic:equal name="vmNicView" property="supportsMorphing" value="false">
 <br>
	No morphing support
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VMXNET %>">
		Current is: vmxnet. mark and give choice.
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VLANCE %>">
		Current is: vlance, mark and give choice.
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
		Current is: e1000, show incompatibility messge [ ], show 3 radio buttons and let choose the other 2
	</logic:equal>
 <br>
</logic:equal>
<logic:equal name="vmNicView" property="supportsMorphing" value="true">
 <br>
	Morphing supported
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VMXNET %>">
		current type is vmxnet; show deprecated, give option to switch to:
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_VLANCE%>">
			<b>Vlance</b>
		</logic:equal>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_E1000%>">
			<b>E1000</b>
		</logic:equal>
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_VLANCE %>">
		current type is vlance; <br>Recommended is <bean:write name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard"/><br>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_VLANCE%>">
			<br> All is good, just show type, no choice given
		</logic:equal>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_E1000%>">
			<br> Show message to move to E1000
		</logic:equal>
	</logic:equal>
	<logic:equal name="vmNicView" property="ethernetCard.classType" value="<%= Constants.ETHERNETCARD_E1000 %>">
		current type is e1000; Recommended is <bean:write name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard"/>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_VLANCE%>">
			<br> Show message to move to Vlance
		</logic:equal>
		<logic:equal name="vmNicView" property="guestOSDescriptor.recommendedEthernetCard" value="<%= Constants.ETHERNETCARD_E1000%>">
			<br> All is good, just show type, no choice given
		</logic:equal>
	</logic:equal>
 <br>
</logic:equal>

<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmNicView" property="ID"/></li>
	<li>NAME: <bean:write name="vmNicView" property="ethernetCard.name"/></li>
	<li>powerState: <bean:write name="vmNicView" property="vmEntity.powerState"/></li>
	
	
	<li>startConnected: <bean:write name="vmNicView" property="ethernetCard.startConnected"/></li>
	<li>connected: <bean:write name="vmNicView" property="ethernetCard.connected"/></li>
	
	<li>backingType: <bean:write name="vmNicView" property="ethernetCard.backingType"/></li>
	
	<li>deviceName: <bean:write name="vmNicView" property="ethernetCard.networkBacking.deviceName"/></li>
	
	<li>networkType: <bean:write name="vmNicView" property="ethernetCard.legacyNetworkBacking.networkType"/></li>
	
	<li>Class Type: <bean:write name="vmNicView" property="ethernetCard.classType"/></li>
		
</ul>
--%>

</html:html>
