<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants, com.vmware.webcenter.control.action.vmconfiguration.ConfigureAdvancedOptionsAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/deafult-ie.css" />
<![endif]-->

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
   </jsp:include>
   <script src="js/configuration/commonConfig.js"></script>
   <script src="js/configuration/vm/options/advanced.js"></script>

  <script>
  
    function setFormInputs () {
      document.forms[0].recordEnabled.checked = <bean:write name="vmAdvancedOptionsView" property="runWithInfo"/>;
<%--  // no stats in ESX - 2.5 RC1 194836	--%>
<%--  
	  document.getElementById("recordDebugInfo").checked = <bean:write name="vmAdvancedOptionsView" property="vmDataItem.runWithDebugInfo"/>;
      document.getElementById("recordStats").checked = <bean:write name="vmAdvancedOptionsView" property="vmDataItem.runWithStatsInfo"/>;
--%>
      toggleRecordInformationOpts();
      document.forms[0].enableLogging.checked = <bean:write name="vmAdvancedOptionsView" property="vmDataItem.enableLogging"/>;
      document.forms[0].disableAcceleration.checked = <bean:write name="vmAdvancedOptionsView" property="vmDataItem.disableAcceleration"/>;
      
      setFormState("<bean:write name="vmAdvancedOptionsView" property="vmDataItem.powerState"/>");
    }
    
    function setFormState (strPowerState) {
      switch (strPowerState) {
        case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>":
          disableAll();
          break;
        case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>":
          disableRecordInformation();
          disableAcceleration();
          break;
      }
      
      setFormPrivileges();
    }
    
    function setFormPrivileges() {
      if (!<bean:write name="vmAdvancedOptionsView" property="canEditSettings"/>) {
	    disableAll();
	  }
    }

	</script>

</head>

<body onload="initConfigPage()">

<div id="configWrapDiv">
<html:form action="vmConfigAdvancedOptions" method="post" onsubmit="toggleOk(false);">

<div class="dialog half">

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="vmwareLogo-16x16 icon" /></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_options_advanced_header" class="title">
          	<bean:message key="vmConfiguration.options.advanced.header"/></span>
        </td>
        <td><div class="close-12x12 icon" 
        	title="<bean:message key="vmConfiguration.cancel"/>" 
        	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">
    
    <div class="legend"><span id="legend_advanced"><bean:message key="vmConfiguration.options.advanced.settings"/></span></div>
    <div id="l10n_vmConfiguration_options_advanced_settings" class="fieldset">
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <colgroup>
          <col />
          <col style="width:100%;" />
        </colgroup>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="recordEnabled" id="recordEnabled" value="1" 
            	class="checkboxCtrl" 
            	onclick="toggleRecordInformationOpts()"/>
          </td>
          <td>
            <label for="recordEnabled">
              <span id="l10n_vmConfiguration_options_advanced_settings_recordInfo">
              	<bean:message key="vmConfiguration.options.advanced.settings.recordInfo"/>
              </span>
            </label>
          </td>
        </tr>
        <tr id="recordOpts">
          <td></td>
          <td>
            <table class="description" border="0" cellspacing="0" cellpadding="0">
              <tr>
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="recordInfo" id="recordDebugInfo" 
                	value="<%= ConfigureAdvancedOptionsAction.RECORD_INFO_DEBUG%>" 
                	class="radioCtrl" />
                </td>
                <td>
                  <label id="lbl_recordDebug" for="recordDebugInfo">
                    <span id="l10n_vmConfiguration_options_advanced_settings_recordInfo_debug">
                    	<bean:message key="vmConfiguration.options.advanced.settings.recordInfo.debug"/></span>
                  </label>
                </td>
              </tr>
              <tr>
                <td class="bulletCtrl" width="1%">
                  <input type="radio" name="recordInfo" id="recordStats" 
                	value="<%= ConfigureAdvancedOptionsAction.RECORD_INFO_STATS%>" 
                	class="radioCtrl" />
                </td>
                <td>
                  <label id="lbl_recordStats" for="recordStats">
                    <span id="l10n_vmConfiguration_options_advanced_settings_recordInfo_stats">
                    	<bean:message key="vmConfiguration.options.advanced.settings.recordInfo.stats"/></span>
                  </label>
                </td>
              </tr>
            </table>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="enableLogging" id="enableLogging" 
            	value="1" class="checkboxCtrl" />
          </td>
          <td>
            <label for="enableLogging">
              <span id="l10n_vmConfiguration_options_advanced_settings_enableLogging">
                <bean:message key="vmConfiguration.options.advanced.settings.enableLogging"/></span>
            </label>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox" name="disableAcceleration" id="disableAcceleration" 
            	value="1" class="checkboxCtrl" />
          </td>
          <td>
            <label for="disableAcceleration">
              <span id="l10n_vmConfiguration_options_advanced_settings_disableAcceleration">
                <bean:message key="vmConfiguration.options.advanced.settings.disableAcceleration"/>
              </span>
            </label>
          </td>
        </tr>
      </table>
    </div>
    
    <div class="commandButtons">

<logic:equal name="vmAdvancedOptionsView" property="canEditSettings" value="true">

	   <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
	   	<bean:message key="vmConfiguration.button.ok"/>
	   </html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
	   	<bean:message key="vmConfiguration.button.cancel"/>
	   </html:cancel>

</logic:equal>

<logic:notEqual name="vmAdvancedOptionsView" property="canEditSettings" value="true">

	   <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
	   	<bean:message key="vmConfiguration.button.close"/>
	   </html:cancel>

</logic:notEqual>    

    </div>

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

	<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmAdvancedOptionsView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmAdvancedOptionsView" property="ID"/></li>
	
</ul>

<ul> Advancned options info:
<li>VM power state: <bean:write name="vmAdvancedOptionsView" property="vmDataItem.powerState"/></li>
<li>runWithDebugInfo: <bean:write name="vmAdvancedOptionsView" property="vmDataItem.runWithDebugInfo"/></li>
<li>runWithStatsInfo: <bean:write name="vmAdvancedOptionsView" property="vmDataItem.runWithStatsInfo"/></li>
<li>runWithInfo: <bean:write name="vmAdvancedOptionsView" property="runWithInfo"/></li>
<li>disableAcceleration: <bean:write name="vmAdvancedOptionsView" property="vmDataItem.disableAcceleration"/></li>
<li>enableLogging: <bean:write name="vmAdvancedOptionsView" property="vmDataItem.enableLogging"/></li>

</ul>
--%>
<%-- XXX visual debugging section XXX --%>

</body> 
</html:html>
