<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/deafult-ie.css" />
<![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>
   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
   </jsp:include>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/options/general.js"></script>

  <script>
   
   var customizableOsFamily = "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_OTHERGUESTFAMILY%>";
   var customizableOsNames = new Array("<%= VMODLConstants.VIRTUALMACHINEGUESTOSIDENTIFIER_OTHERGUEST%>","<%= VMODLConstants.VIRTUALMACHINEGUESTOSIDENTIFIER_OTHERGUEST64%>");

   function setFormInputs (){
      document.forms[0].vmName.value = "<wc:jsSafe name="vmGeneralOptionsView" property="vmDataItem.name"/>";
      
    <logic:notEmpty name="vmGeneralOptionsView" property="guestOsDescriptor">
      initGuestVersion('<bean:write name="vmGeneralOptionsView" property="guestOsDescriptor.guestFamily"/>','<bean:write name="vmGeneralOptionsView" property="guestOsDescriptor.guestId"/>');
    </logic:notEmpty>      
      setFormState("<bean:write name="vmGeneralOptionsView" property="vmDataItem.powerState"/>");
    }
    
    function setFormState (strPowerState) {
      switch (strPowerState) {
        case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED%>":
           disableAll();
           break;
        case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON%>":
           disableGuestOs();
           disableWorkingDir();
           break;
      }
      
      setFormPrivileges();
    }
    
    function setFormPrivileges() {
      if (!<bean:write name="vmGeneralOptionsView" property="canRenameVM"/>) {
        disableVmName();
      }
      if (!<bean:write name="vmGeneralOptionsView" property="canConfigureSettings"/>) {
        disableGuestOs();
        disableWorkingDir();
      }
      if (!<bean:write name="vmGeneralOptionsView" property="canConfigureGeneralOptions"/>) {
         disableAll();
      }
    }
    
    function preValidateConfigureVmGeneralOptionsForm(configForm) {
      configForm.vmName.value = trimAll(configForm.vmName.value);
      var boolValidate = validateConfigureVmGeneralOptionsForm(configForm);
      if (!boolValidate) {
      	toggleOk(true);
      }
      return boolValidate;
    }
    
  </script>

</head>

<body onload="initConfigPage()">

<div id="configWrapDiv">
<html:form action="vmConfigGeneralOptions" method="post" onsubmit="toggleOk(false);setHiddenGuestVersion();return preValidateConfigureVmGeneralOptionsForm(this)">

<div class="dialog half">

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="vmwareLogo-16x16 icon" /></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_options_general_header" class="title">
          	<bean:message key="vmConfiguration.options.general.header"/></span>
        </td>
        <td><div class="close-12x12 icon" 
        	title="<bean:message key="vmConfiguration.cancel"/>" 
        	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">
  
      <div class="legend"><span id="legend_vmName"><bean:message key="vmConfiguration.options.general.vmName"/></span></div>
      <div id="l10n_vmConfiguration_options_general_vmName" class="fieldset">
      
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0" width="100%">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
        <tr>
          <td class="field">
			<logic:equal name="vmGeneralOptionsView" property="canRenameVM" value="false">
              <input type="text" name="vmNameDsbl" id="vmNameDsbl" class="text" 
            	style="width:100%;" value="<wc:jsSafe name="vmGeneralOptionsView" property="vmDataItem.name"/>"/>
              <input type="hidden" name="vmName" id="vmName" />
			</logic:equal>
			<logic:notEqual name="vmGeneralOptionsView" property="canRenameVM" value="false">
            <input type="text" name="vmName" id="vmName" class="text" 
            	style="width:100%;" />
			</logic:notEqual>
          </td>
        </tr>
      </table>
    </div>
    
    <div class="legend"><span id="legend_configFile"><bean:message key="vmConfiguration.options.general.configFile"/></span></div>
    <div id="l10n_vmConfiguration_options_general_configFile" class="fieldset">
      	
      <table class="ctrlGrp" width="100%" border="0" cellpadding="0" cellspacing="0">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
        <tr>
          <td class="field">
            <span id="configFileLocation"><bean:write name="vmGeneralOptionsView" property="vmDataItem.cfgFilePath"/></span>
          </td>
        </tr>
      </table>
    </div>
    
    <div class="legend"><span id="legend_os"><bean:message key="vmConfiguration.options.general.guestOsName"/></span></div>
    <div class="fieldset" id="l10n_vmConfiguration_options_general_guestOsName">
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
<logic:notEmpty name="vmGeneralOptionsView" property="winOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="winOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>" 
            	value="<bean:write name="familyName"/>" class="radioCtrl"
            	onclick="toggleGuestFamily()" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_windows">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.windows"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" id="guestOsVer_<bean:write name="familyName"/>" style="width:100%" >
                  <logic:iterate id="winOsVer" name="vmGeneralOptionsView" property="winOsFamily">
                    <option value="<bean:write name="winOsVer" property="guestId"/>">
                      <bean:write name="winOsVer" property="guestFullName"/>
                    </option>
                  </logic:iterate>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>

<logic:notEmpty name="vmGeneralOptionsView" property="linuxOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="linuxOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>" 
            	value="<bean:write name="familyName"/>" class="radioCtrl"
            	onclick="toggleGuestFamily()" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_linux">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.linux"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" 
                  	id="guestOsVer_<bean:write name="familyName"/>" 
                  	style="width:100%" >
                  	<logic:iterate id="linuxOsVer" name="vmGeneralOptionsView" property="linuxOsFamily">
                  	<option value="<bean:write name="linuxOsVer" property="guestId"/>">
                  	  <bean:write name="linuxOsVer" property="guestFullName"/>
                  	</option>
					</logic:iterate>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>

<logic:notEmpty name="vmGeneralOptionsView" property="netwareOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="netwareOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>" 
            	value="<bean:write name="familyName"/>" class="radioCtrl"
                onclick="toggleGuestFamily();" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_netware">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.netware"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" 
                  	id="guestOsVer_<bean:write name="familyName"/>" 
                  	style="width:100%" >
                    <logic:iterate id="netwareOsVer" name="vmGeneralOptionsView" property="netwareOsFamily">
                    <option value="<bean:write name="netwareOsVer" property="guestId"/>">
                      <bean:write name="netwareOsVer" property="guestFullName"/>
                    </option>
                    </logic:iterate>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>

<logic:notEmpty name="vmGeneralOptionsView" property="solarisOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="solarisOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>" 
            	value="<bean:write name="familyName"/>" class="radioCtrl"
            	onclick="toggleGuestFamily()" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_solaris">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.solaris"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" 
                  	id="guestOsVer_<bean:write name="familyName"/>" 
                  	style="width:100%" >
                  	<logic:iterate id="solarisOsVer" name="vmGeneralOptionsView" property="solarisOsFamily">
                  	<option value="<bean:write name="solarisOsVer" property="guestId"/>">
                  	  <bean:write name="solarisOsVer" property="guestFullName"/>
                  	</option>
					</logic:iterate>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>

<logic:notEmpty name="vmGeneralOptionsView" property="freeBsdOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="freeBsdOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>"  
            	value="<bean:write name="familyName"/>" class="radioCtrl"
            	onclick="toggleGuestFamily()" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_freeBsd">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.freeBsd"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" 
                  	id="guestOsVer_<bean:write name="familyName"/>" 
                  	style="width:100%" >
                  	<logic:iterate id="freeBsdOsVer" name="vmGeneralOptionsView" property="freeBsdOsFamily">
                  	<option value="<bean:write name="freeBsdOsVer" property="guestId"/>">
                  	  <bean:write name="freeBsdOsVer" property="guestFullName"/>
                  	</option>
                    </logic:iterate>
                  </select>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>

<%-- additional OSs collection should be iterated here --%>

<logic:notEmpty name="vmGeneralOptionsView" property="otherOsFamily">
<bean:define id="familyName" name="vmGeneralOptionsView" property="otherOsFamily[0].guestFamily"/>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="guestOsFamily" 
            	id="guestOsFamily_<bean:write name="familyName"/>" 
            	value="<bean:write name="familyName"/>" class="radioCtrl"
            	onclick="toggleGuestFamily()" />
          </td>
          <td>
            <label for="guestOsFamily_<bean:write name="familyName"/>">
              <span id="l10n_vmConfiguration_options_general_guestOsFamily_other">
              	<bean:message key="vmConfiguration.options.general.guestOsFamily.other"/></span>
            </label>
          </td>
        </tr>
        <tr id="guestOsVerTr_<bean:write name="familyName"/>" style="display:none">
          <td></td>
          <td width="100%">
            <table class="description" border="0" cellspacing="0" cellpadding="0" width="100%">
              <tr>
                <td colspan="2">
                  <select name="guestOsVer_<bean:write name="familyName"/>" 
                  	id="guestOsVer_<bean:write name="familyName"/>" 
                  	style="width:100%" onchange="toggleGuestFamily()">
                  	<logic:iterate id="otherOsVer" name="vmGeneralOptionsView" property="otherOsFamily">
                  	<option value="<bean:write name="otherOsVer" property="guestId"/>" onclick="enableCustomName()">
                  	  <bean:write name="otherOsVer" property="guestFullName"/>
                  	</option>
                    </logic:iterate>
                    <logic:iterate id="additionalOsVer" name="vmGeneralOptionsView" property="additionalOsFamily">
                    <option value="<bean:write name="additionalOsVer" property="guestId"/>" onclick="enableCustomName(false)">
                      <bean:write name="additionalOsVer" property="guestFullName"/>
                    </option>
                    </logic:iterate>
                  </select>
                </td>
              </tr>
              <tr>
                <td colspan="2" style="width:100%">
                  <table border="0" width="100%">
                    <tr>
                      <td nowrap>
                        <span id="l1on_vmConfiguration_options_general_guestOsName_customName">
                        	<bean:message key="vmConfiguration.options.general.guestOsName.customName"/></span>
                      </td>
                      <td width="100%">
                        <input name="customName" id="customName" type="text" style="width:100%" value="<bean:write name="vmGeneralOptionsView" property="vmDataItem.gosFullName"/>"></td>
                    </tr>
                  </table>
                </td>
              </tr>
            </table>
          </td>
        </tr>
</logic:notEmpty>
      </table>
    </div>
		
	<div class="legend"><span id="legend_workDir"><bean:message key="vmConfiguration.options.general.workingDir"/></span></div>
	<div class="fieldset" id="l10n_vmConfiguration_options_general_workingDir">
      <table class="ctrlGrp" width="100%" border="0" cellpadding="0" cellspacing="0">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
        <tr>
          <td class="field">
            <div id="workingDir">
<logic:equal name="vmGeneralOptionsView" property="vmDataItem.suspendDir" value="">
              <span id="l10n_vmConfiguration_options_general_workingDir_vmLocation">
              	<bean:message key="vmConfiguration.options.general.workingDir.vmLocation"/></span>
</logic:equal>
<logic:notEqual name="vmGeneralOptionsView" property="vmDataItem.suspendDir" value="">
	<bean:write name="vmGeneralOptionsView" property="vmDataItem.suspendDir"/>
</logic:notEqual>
            </div>
          </td>
        </tr>
      </table>
    </div>
		
    <div class="commandButtons">
		
<logic:equal name="vmGeneralOptionsView" property="canConfigureGeneralOptions" value="true">

	  <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
    		<bean:message key="vmConfiguration.button.cancel"/>
      </html:cancel>

</logic:equal>
<logic:notEqual name="vmGeneralOptionsView" property="canConfigureGeneralOptions" value="true">

      <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
    		<bean:message key="vmConfiguration.button.close"/>
      </html:cancel>

</logic:notEqual>

    </div>

	</div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

<input type="hidden" name="guestOsVer" id="guestOsVer" value=""/>

	<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmGeneralOptionsView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>

<html:javascript formName="configureVmGeneralOptionsForm"/>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmGeneralOptionsView" property="ID"/></li>
	
</ul>

<ul> General options info:
<li>VM name: <bean:write name="vmGeneralOptionsView" property="vmDataItem.name"/></li>
<li>VM power state: <bean:write name="vmGeneralOptionsView" property="vmDataItem.powerState"/></li>
<li>cfgFilePath: <bean:write name="vmGeneralOptionsView" property="vmDataItem.cfgFilePath"/></li>
<li>suspendDir: <bean:write name="vmGeneralOptionsView" property="vmDataItem.suspendDir"/></li>
<li>gosFullName: <bean:write name="vmGeneralOptionsView" property="vmDataItem.gosFullName"/></li>
<li>
	<ul>current guestOsDescriptor
		<li>id: <bean:write name="vmGeneralOptionsView" property="guestOsDescriptor.guestId"/></li>
		<li>family: <bean:write name="vmGeneralOptionsView" property="guestOsDescriptor.guestFamily"/></li>
	</ul>
</li>

</ul>
--%>
<%-- XXX visual debugging section XXX --%>

</body> 
</html:html>
