<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

  <link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
  <link rel="stylesheet" type="text/css" href="css/deafult-ie.css" />
<![endif]-->

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
   </jsp:include>
   <script src="js/configuration/commonConfig.js"></script>
   <script src="js/configuration/vm/options/power.js"></script>

  <script>
  
    function setFormInputs () {
    
      document.forms[0].runScriptAfterResuming.checked = <bean:write name="vmPowerOptionsView" property="vmDataItem.afterResume"/>;
      document.forms[0].runScriptBeforeSuspending.checked = <bean:write name="vmPowerOptionsView" property="vmDataItem.beforeGuestStandby"/>;
      document.forms[0].powerOffCtrl.value = "<bean:write name="vmPowerOptionsView" property="vmDataItem.powerOffType"/>";
      document.forms[0].resetCtrl.value = "<bean:write name="vmPowerOptionsView" property="vmDataItem.resetType"/>";
      
      setFormState("<bean:write name="vmPowerOptionsView" property="vmDataItem.powerState"/>");
    }
    
    function setFormState (strPowerState) {
      if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>") {
        disableAll();
      }
      setFormPrivileges();
    }
    
    function setFormPrivileges(){
      if (!<bean:write name="vmPowerOptionsView" property="canEditSettings"/>) {
        disableAll();
      }
    }
    
  </script>

</head>

<body onload="initConfigPage()">

<div id="configWrapDiv">
<html:form action="vmConfigPowerOptions" method="post" onsubmit="toggleOk(false);">

<div class="dialog half">

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="vmwareLogo-16x16 icon" /></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_options_power_header" class="title">
            <bean:message key="vmConfiguration.options.power.header"/></span>
        </td>
        <td><div class="close-12x12 icon"
              title="<bean:message key="vmConfiguration.cancel"/>"
              onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>

  <div class="window">

    <div class="legend"><span id="legend_power"><bean:message key="vmConfiguration.options.power.controls"/></span></div>
    <div id="l10n_vmConfiguration_options_power_controls" class="fieldset">
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
        <tr>
          <td colspan="2">
            <div id="l10n_vmConfiguration_options_power_controls_description"
              class="description">
              <bean:message key="vmConfiguration.options.power.controls.description"/>
            </div>
          </td>
        </tr>
        <tr>
          <td><div class="powerOff-16x16 icon" style="margin-right: 6px;" /></td>
          <td>
            <select id="powerOffCtrl" name="powerOffCtrl" style="width:100%">
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>" id="l10n_vmConfiguration_options_power_controls_shutdown">
                <bean:message key="vmConfiguration.options.power.controls.shutdown"/>
              </option>
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>" id="l10n_vmConfiguration_options_power_controls_poweroff">
                <bean:message key="vmConfiguration.options.power.controls.poweroff"/>
              </option>
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_PRESET %>" id="l10n_vmConfiguration_options_power_controls_systemDefault">
                <bean:message key="vmConfiguration.options.power.controls.systemDefault"/>
                <logic:equal name="vmPowerOptionsView" property="vmDataItem.powerOffPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">(<bean:message key="vmConfiguration.options.power.controls.poweroff"/>)</logic:equal>
                <logic:equal name="vmPowerOptionsView" property="vmDataItem.powerOffPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">(<bean:message key="vmConfiguration.options.power.controls.shutdown"/>)</logic:equal>
              </option>
            </select>
          </td>
        </tr>
        <tr>
          <td><div class="reset-16x16 icon" style="margin-right: 6px;" /></td>
          <td>
            <select id="resetCtrl" name="resetCtrl"  style="width:100%">
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>" id="l10n_vmConfiguration_options_power_controls_restart">
                <bean:message key="vmConfiguration.options.power.controls.restart"/>
              </option>
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>" id="l10n_vmConfiguration_options_power_controls_reset">
                <bean:message key="vmConfiguration.options.power.controls.reset"/>
              </option>
              <option value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_PRESET %>" id="l10n_vmConfiguration_options_power_controls_systemDefault">
                <bean:message key="vmConfiguration.options.power.controls.systemDefault"/>
                <logic:equal name="vmPowerOptionsView" property="vmDataItem.resetPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">(<bean:message key="vmConfiguration.options.power.controls.reset"/>)</logic:equal>
                <logic:equal name="vmPowerOptionsView" property="vmDataItem.resetPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">(<bean:message key="vmConfiguration.options.power.controls.restart"/>)</logic:equal>
              </option>
            </select>
          </td>
        </tr>
      </table>
    </div>

    <div class="legend"><span id="legend_tScripts"><bean:message key="vmConfiguration.options.power.tscripts"/></span></div>
      <div class="fieldset" id="l10n_vmConfiguration_options_power_tscripts">
        
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <colgroup>
          <col /> <col style="width:100%;" />
        </colgroup>
        <tr>
          <td colspan="2">
            <div id="l10n_vmConfiguration_options_power_tscripts_description"
              class="description">
              <bean:message key="vmConfiguration.options.power.tscripts.description"/>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox"
              name="runScriptAfterResuming" id="runScriptAfterResuming"
              value="1" class="checkboxCtrl" />
          </td>
          <td>
            <label for="runScriptAfterResuming">
              <span id="l10n_vmConfiguration_options_power_tscripts_afterResume">
                <bean:message key="vmConfiguration.options.power.tscripts.afterResume"/>
              </span></label>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="checkbox"
              name="runScriptBeforeSuspending" id="runScriptBeforeSuspending"
              value="1" class="checkboxCtrl" />
          </td>
          <td>
            <label for="runScriptBeforeSuspending">
              <span id="l10n_vmConfiguration_options_power_tscripts_beforeSuspend">
                <bean:message key="vmConfiguration.options.power.tscripts.beforeSuspend"/>
              </span></label>
          </td>
        </tr>
      </table>
    </div>

    <div class="commandButtons">

<logic:equal name="vmPowerOptionsView" property="canEditSettings" value="true">

      <html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
        <bean:message key="vmConfiguration.button.ok"/>
      </html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
        <bean:message key="vmConfiguration.button.cancel"/>
      </html:cancel>

</logic:equal>

<logic:notEqual name="vmPowerOptionsView" property="canEditSettings" value="true">

      <html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
        <bean:message key="vmConfiguration.button.close"/>
      </html:cancel>

</logic:notEqual>

    </div>

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

  <!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmPowerOptionsView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
  <li>ID: <bean:write name="vmPowerOptionsView" property="ID"/></li>
</ul>
<ul>Power options info:
  <li>powerState: <bean:write name="vmPowerOptionsView" property="vmDataItem.powerState"/></li>
  <li>powerOffType: <bean:write name="vmPowerOptionsView" property="vmDataItem.powerOffType"/></li>

  <li>powerOffPreset: <bean:write name="vmPowerOptionsView" property="vmDataItem.powerOffPreset"/></li>
  <li>resetPreset: <bean:write name="vmPowerOptionsView" property="vmDataItem.resetPreset"/></li>
  
  <li>resetType: <bean:write name="vmPowerOptionsView" property="vmDataItem.resetType"/></li>
  <li>afterResume: <bean:write name="vmPowerOptionsView" property="vmDataItem.afterResume"/></li>
  <li>beforeGuestStandby: <bean:write name="vmPowerOptionsView" property="vmDataItem.beforeGuestStandby"/></li>

</ul>
--%>
<%-- XXX visual debugging section XXX --%>
</body>
</html:html>
