<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/deafult-ie.css" />
<![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>
	<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
	<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
	  <jsp:param name="packages" value="xua,win,drag" />
	</jsp:include>
	<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/parallelPort.js"></script>

    <script language="JavaScript" type="text/javascript">
      function init() {
         setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.parallel"/>");
         initConfigPage();  
      }
  
      function tearDown() {
         resetHelp();
      }
      
      function setFormInputs (){
        var powerState = "<bean:write name="vmParallelPortView" property="vmDataItem.powerState"/>";
        var configForm = document.forms[0];
        
        <%-- connected property is valid only when the VM is powered on --%>
        if (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>") {
          configForm.hostConnected.checked = <bean:write name="vmParallelPortView" property="parallelPort.connected"/>;
        }
        
        configForm.hostConnectAtPowerOn.checked = <bean:write name="vmParallelPortView" property="parallelPort.startConnected"/>;
        configForm.physicalLocation.value = "<bean:write name="vmParallelPortView" property="parallelPort.deviceBacking.deviceName"/>";
        configForm.fileLocation.value = "<wc:jsSafe name="vmParallelPortView" property="parallelPort.fileBacking.fileName"/>";
        
        var backingType = "<bean:write name="vmParallelPortView" property="parallelPort.backingType"/>";
        if (backingType == "<%= Constants.DEVICE_DEVICEBACKING %>" ) {
          document.getElementById("physicalConnection").checked = true;
        } else if (backingType == "<%= Constants.DEVICE_FILEBACKING %>" ) {
          document.getElementById("fileConnection").checked = true;
        }
        
        toggleConnection();
        
        setFormState(powerState);
      }
      
      function setFormState (strPowerState) {
        if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>") {
          disableAll();
        } else if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>"){
          disableStatusSettings(true);
        }

        setFormPrivileges();
      }
      
      function setFormPrivileges(){
        if (!<bean:write name="vmParallelPortView" property="canInteractConnect"/>) {
          disableAllStatusSettings()
        }
        if (!<bean:write name="vmParallelPortView" property="canEditDevice"/>) {
          disableConnectionSettings();
        }
        if (!<bean:write name="vmParallelPortView" property="canConfigure"/>) {
          disableAll();
        }
      }
      
      <%-- validation alert variables --%>
		<bean:define id="msg_vmConfiguration_parallelPort_connection_file">
			<bean:message key="vmConfiguration.parallelPort.connection.file"/>
		</bean:define>

      function preValidateConfigureVmParallelPortForm(configForm) {
        if (!bCancel) { <%-- TODO : do not hardcode the Struts value here. Find out where it's declared and use that constant --%>
          var fileConnection = document.getElementById("fileConnection");
          if (!fileConnection.disabled && fileConnection.checked == true) {
            configForm.fileLocation.value = trimAll(configForm.fileLocation.value);
            if (configForm.fileLocation.value == "") {
              vpx.win.alert("<bean:message key="errors.required.specify" arg0="<%= msg_vmConfiguration_parallelPort_connection_file%>"/>");
              configForm.fileLocation.focus();
              toggleOk(true);
              return false;
            }
          }
        }
        return true;
        <%-- 
			 The below was commented out since the Struts validator does not
			 supply methods equivalent for requiredIf for the client javascript side.
			 What ended up happening is that the output for the html:javascript tag 
			 was returning true in any case.
			 If further validations supplied by the Struts validator are added
			 and those provide good client side code, the line below should be 
			 uncommented, as well as html:javascript tag at the bottom of this
			 jsp page.
			--%>
			<%-- // return validateConfigureVmParallelPortForm(configForm); --%>
      }
    </script>

</head>

<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigParallelPort" method="post" onsubmit="toggleOk(false);return preValidateConfigureVmParallelPortForm(this)">

<div class="dialog half">

	<div class="titlebar">
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td><div class="parallelPort-16x16 icon" /></td>
				<td width="100%">
					<span class="title"><bean:write name="vmParallelPortView" property="parallelPort.name"/></span>
				</td>
				<td><div class="close-12x12 icon"
							title="<bean:message key="vmConfiguration.cancel"/>"
							onclick="document.forms[0].btnCancel.click()"></div>
				</td>
			</tr>
		</table>
	</div>

	<div class="window">
		<div class="legend"><span id="l10n_vmConfiguration_device_status">
			<bean:message key="vmConfiguration.device.status"/></span></div>
			<div class="fieldset">
				<table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="bulletCtrl">
							<input type="checkbox" name="hostConnected" id="hostConnected"
							class="checkboxCtrl" />
						</td>
						<td>
							<label for="hostConnected" id="l10n_vmConfiguration_device_status_connected">
								<bean:message key="vmConfiguration.device.status.connected"/></label>
						</td>
					</tr>
					<tr>
						<td class="bulletCtrl">
							<input type="checkbox" name="hostConnectAtPowerOn" id="hostConnectAtPowerOn"
							class="checkboxCtrl" />
						</td>
						<td>
							<label for="hostConnectAtPowerOn" id="l10n_vmConfiguration_device_status_connectPowerOn">
								<bean:message key="vmConfiguration.device.status.connectPowerOn"/></label>
						</td>
					</tr>
				</table>
			</div>

			<div class="legend">
				<span id="l10n_vmConfiguration_device_connection">
					<bean:message key="vmConfiguration.device.connection"/></span>
			</div>
			<div class="fieldset">
				<table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td class="bulletCtrl">
							<input type="radio" name="connection" id="physicalConnection"
								value="<%= Constants.DEVICE_DEVICEBACKING %>"
								onclick="toggleConnection()"
								class="radioCtrl" />
						</td>
						<td>
							<label class="title" for="physicalConnection"
								id="l10n_vmConfiguration_parallelPort_connection_physical">
								<bean:message key="vmConfiguration.parallelPort.connection.physical"/>
							</label>
							<div class="description" id="physicalConnectionExpl">
								<span id="l10n_vmConfiguration_parallelPort_connection_physical_expl">
									<bean:message key="vmConfiguration.parallelPort.connection.physical.expl"/></span>
							</div>
						</td>
					</tr>
					<tr id="clientDeviceOpts">
						<td width="1%"></td>
						<td>
							<table class="description" border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td style="width:258px;">
										<select id="physicalLocation" name="physicalLocation"
											style="width:100%;" >
<logic:iterate id="pp" name="vmParallelPortView" property="avaliableParallelPorts">
											<option value="<bean:write name="pp"/>"><bean:write name="pp"/></option>
</logic:iterate>
										</select>
									</td>
								</tr>
							</table>
						</td>
					</tr>
					<tr>
						<td class="bulletCtrl">
							<input type="radio" name="connection" id="fileConnection"
								onclick="toggleConnection()"
								value="<%= Constants.DEVICE_FILEBACKING %>" class="radioCtrl" />
						</td>
						<td>
							<label class="title" for="fileConnection"
								id="l10n_vmConfiguration_parallelPort_connection_file"><span>
								<bean:message key="vmConfiguration.parallelPort.connection.file"/></span>
							</label>
							<div class="description" id="fileConnectionExpl">
									<span id="l10n_vmConfiguration_parallelPort_connection_file_expl">
										<bean:message key="vmConfiguration.parallelPort.connection.file.expl"/>
									</span>
							</div>
						</td>
					</tr>
					<tr>
						<td width="1%"></td>
						<td>
							<table class="description" border="0" cellspacing="0" cellpadding="0">
								<tr>
									<td>
										<input type="text" name="fileLocation" id="fileLocation"
											value=""
											class="text" style="width:250px;"  />
									</td>
									<td>
										<a class="browse disabled" href="javascript:;" id="browseFile">
											<span id="l10n_vmConfiguration_browse"><bean:message key="vmConfiguration.browse"/></span></a>
									</td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
			</div>

		<div class="commandButtons">

<logic:equal name="vmParallelPortView" property="canConfigure" value="true">

			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>

</logic:equal>

<logic:notEqual name="vmParallelPortView" property="canConfigure" value="true">

			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>

</logic:notEqual>

		</div>

	</div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>

	<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmParallelPortView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div>	<%-- end configWrap div --%>

<%-- 
* The below was commented out since the Struts validator does not
* supply methods equivalent for requiredIf for the client javascript side.
* What ended up happening is that the output for the html:javascript tag 
* was returning true in any case.
* If further validations supplied by the Struts validator are added
* and those provide good client side code, the line below should be 
* uncommented, as well as the call to validateConfigureVmParallelPortForm(configForm)
* in preValidateConfigureVmParallelPortForm(configForm)
--%>
<%-- <html:javascript formName="configureVmParallelPortForm"/> --%>
<script language="JavaScript" type="text/javascript">
var bCancel = false;
</script>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <bean:write name="vmParallelPortView" property="ID"/></li>

</ul>

<ul> Parallel Port info:
<li>VM name: <bean:write name="vmParallelPortView" property="vmDataItem.name"/></li>
<li>VM power state: <bean:write name="vmParallelPortView" property="vmDataItem.powerState"/></li>
<li>Parallel Port Name: <bean:write name="vmParallelPortView" property="parallelPort.name"/></li>
<li>Connected: <bean:write name="vmParallelPortView" property="parallelPort.connected"/></li>
<li>Connect at poweron: <bean:write name="vmParallelPortView" property="parallelPort.startConnected"/></li>
<li>backingType: <bean:write name="vmParallelPortView" property="parallelPort.backingType"/></li>
<li>DeviceName: <bean:write name="vmParallelPortView" property="parallelPort.deviceBacking.deviceName"/></li>
<li>FileName: <bean:write name="vmParallelPortView" property="parallelPort.fileBacking.fileName"/></li>


</ul>
--%>
<%-- XXX visual debugging section XXX --%>

</body>
</html:html>
