<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">

<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
   </jsp:include>
   <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/scsiCtrl.js"></script>
	
	<script language="JavaScript" type="text/javascript">
      function init() {
         setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.scsi"/>");
         initConfigPage();  
      }
  
      function tearDown() {
         resetHelp();
      }
      
      function setFormInputs (){

        <logic:equal name="vmScsiCtrlView" property="scsiController.sharedBus" value="<%= VMODLConstants.VIRTUALSCSISHARING_NOSHARING %>">
        document.getElementById("noBusSharing").checked = true;
        </logic:equal>
        <logic:equal name="vmScsiCtrlView" property="scsiController.sharedBus" value="<%= VMODLConstants.VIRTUALSCSISHARING_VIRTUALSHARING %>">
        document.getElementById("virtualBusSharing").checked = true;
        </logic:equal>
        <logic:equal name="vmScsiCtrlView" property="scsiController.sharedBus" value="<%= VMODLConstants.VIRTUALSCSISHARING_PHYSICALSHARING %>">
        document.getElementById("physicalBusSharing").checked = true;
        </logic:equal>
        
		document.forms[0].deviceType.value = "<bean:write name="vmScsiCtrlView" property="scsiController.scsiType"/>";
        
        setFormState();
      }
      
      function setFormState(){
<logic:equal name="vmScsiCtrlView" property="scsiController.hasBootDevice" value="true">		
		toggleTypeCtrl(true);
</logic:equal>
<logic:equal name="vmScsiCtrlView" property="scsiController.hasBootDevice" value="false">
		toggleTypeCtrl(false);
</logic:equal>

        setFormPrivileges();
      }
      
      function setFormPrivileges() {
        if (!<bean:write name="vmScsiCtrlView" property="canAddRemoveDevice"/>) {
          toggleTypeCtrl(false); <%-- no need to show the config type warning for boot device --%>
          disableDeviceType();
        } 
        if (!<bean:write name="vmScsiCtrlView" property="canEditDevice"/>) {
          toggleTypeCtrl(false); <%-- no need to show the config type warning for boot device --%>
          disableAll();
        } 
      }
		
	</script>

</head>

<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigScsiCtrl" method="post" onsubmit="toggleOk(false);">

<div class="dialog half"> <%-- dialog half --%>

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="scsiDevice-16x16 icon"></div></td>
        <td width="100%">
          <span class="title"><bean:write name="vmScsiCtrlView" property="scsiController.name"/></span>
        </td>
        <td><div class="close-12x12 icon" 
        	title="<bean:message key="vmConfiguration.cancel"/>" 
        	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">

    <div class="fieldset">
      <span id="l10n_vmConfiguration_virtualDevice" 
      	class="legend"><bean:message key="vmConfiguration.virtualDevice"/></span>
<%-- 
	The following is a lock section presented if the boot device is attached to the controller 
	If displayed, clicking the modify link will hide it, and display the select control
--%>
      <div id="lockedType" class="lock">
        <div class="title">
          <span id="l10n_vmConfiguration_scsiCtrl_virtualDevice_bootLock_warning">
          	<bean:message key="vmConfiguration.scsiCtrl.virtualDevice.bootLock.warning"/></span>
        </div>
        <p class="explanation">
          <span id="l10n_vmConfiguration_scsiCtrl_virtualDevice_bootLock_reason">
          	<fmt:message key="vmConfiguration.scsiCtrl.virtualDevice.bootLock.reason" bundle="${messageResources}">
          		<fmt:param value="${vmScsiCtrlView.scsiController.scsiType}"/>
          	</fmt:message>
          </span>
        </p>
        <p><a href="javascript:toggleTypeCtrl(false);">
          <span id="l10n_vmConfiguration_scsiCtrl_virtualDevice_modifyType">
          	<bean:message key="vmConfiguration.scsiCtrl.virtualDevice.modifyType"/></span>
           </a>
        </p>
<%--
      	<p><a href="javascript:;">
      	  <span id="l10n_vmConfiguration_moreInfo">
      	  	<bean:message key="vmConfiguration.moreInfo"/></span>
      	   </a>
      	</p>
--%>      	
      </div>

      <table class="ctrlGrp" id="unlockedType" border="0" cellspacing="0" cellpadding="0">
      	 <tr>
      	   <td width="1%">
      	     <label id="lbl_deviceType" for="deviceType"><span id="l10n_vmConfiguration_device_deviceType">
      					<bean:message key="vmConfiguration.device.deviceType"/></span>
      		 </label>
      	   </td>
      	   <td width="99%" valign="right">
      	     <select name="deviceType" id="deviceType" style="width:100%;">
      	       <option value="<%= Constants.DEVICE_SCSI_LSILOGIC%>">
      	         <span id="l10n_vmConfiguration_scsiCtrl_virtualDevice_type_lsiLogic">
      	         	<bean:message key="vmConfiguration.scsiCtrl.virtualDevice.type.lsiLogic"/></span>
      	       </option>
      	       <option value="<%= Constants.DEVICE_SCSI_BUSLOGIC%>"><span id="l10n_vmConfiguration_scsiCtrl_virtualDevice_type_busLogic">
      	         	<bean:message key="vmConfiguration.scsiCtrl.virtualDevice.type.busLogic"/></span>
      	       </option>
      	     </select>
      	   </td>
        </tr>
      </table>
    </div>    

    <div class="fieldset">
      <span id="l10n_vmConfiguration_scsiCtrl_busSharing" class="legend">
        <bean:message key="vmConfiguration.scsiCtrl.busSharing"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td colspan="2">
            <div id="desc_busSharing" class="description">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_expl">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.expl"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="busSharing" id="noBusSharing" 
            	value="<%= VMODLConstants.VIRTUALSCSISHARING_NOSHARING %>" 
            	class="radioCtrl" />
          </td>
          <td>
            <label id="lbl_noBusSharing" class="title" for="noBusSharing">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_none">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.none"/></span>
            </label>
            <div id="desc_noBusSharing" class="description">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_none_expl">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.none.expl"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="busSharing" id="virtualBusSharing" 
            	value="<%= VMODLConstants.VIRTUALSCSISHARING_VIRTUALSHARING %>" 
            	class="radioCtrl" />
          </td>
          <td>
            <label id="lbl_virtualBusSharing" class="title" for="virtualBusSharing">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_virtual">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.virtual"/></span>
            </label>
            <div id="desc_virtualBusSharing" class="description">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_virtual_expl">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.virtual.expl"/></span>
            </div>
          </td>
        </tr>
        <tr>
          <td class="bulletCtrl">
            <input type="radio" name="busSharing" id="physicalBusSharing" 
            	value="<%= VMODLConstants.VIRTUALSCSISHARING_PHYSICALSHARING %>" 
            	class="radioCtrl" />
          </td>
          <td>
            <label id="lbl_physicalBusSharing" class="title" for="physicalBusSharing">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_physical">
                <bean:message key="vmConfiguration.scsiCtrl.busSharing.physical"/></span>
            </label>
            <div id="desc_physicalBusSharing" class="description">
              <span id="l10n_vmConfiguration_scsiCtrl_busSharing_physical_expl">
              	<bean:message key="vmConfiguration.scsiCtrl.busSharing.physical.expl"/></span>
            </div>
          </td>
        </tr>
      </table>
    </div>

	<div class="commandButtons">
	
<logic:equal name="vmScsiCtrlView" property="canEditDevice" value="true">
			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>
</logic:equal>

<logic:notEqual name="vmScsiCtrlView" property="canEditDevice" value="true">
			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>
</logic:notEqual>

	</div>

   </div> <%-- end window --%>
</div> <%-- end dialog half --%>

<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<bean:write name="vmScsiCtrlView" property="ID"/>">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>

</div> <%-- end configWrap div --%>

<%-- XXX visual debugging section XXX --%>
<%--
<ul> View:
	<li>ID: <bean:write name="vmScsiCtrlView" property="ID"/></li>
</ul>

<ul> VM
	<li>powerState: <bean:write name="vmScsiCtrlView" property="vmEntity.powerState"/></li>
<ul> SCSI controller info:
<li>name: <bean:write name="vmScsiCtrlView" property="scsiController.name"/><br></li>
<li>scsiType: <bean:write name="vmScsiCtrlView" property="scsiController.scsiType"/><br></li>
<li>hasBootDevice: <bean:write name="vmScsiCtrlView" property="scsiController.hasBootDevice"/><br></li>
<li>sharedBus: <bean:write name="vmScsiCtrlView" property="scsiController.sharedBus"/><br></li>
</ul>

--%>
</body> 
</html:html>