<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>


<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">

<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag" />
   </jsp:include>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/scsiPt.js"></script>

    <script language="JavaScript" type="text/javascript">
      
      function setFormInputs (){
      
        var powerState = "<c:out value="${vmScsiPassthroughView.vmEntity.powerState}"/>";
        
        document.forms[0].deviceLocation.value = "<c:out value="${vmScsiPassthroughView.scsiPassthrough.deviceBacking.deviceName}"/>";
        document.forms[0].scsiNode.value = "<c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerKey}'/>";
        
        setFormState(powerState);
      }
      
      function setFormState(strPowerState){
        if (strPowerState != "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>") {
          disableAll();
        }
        
        setFormPrivileges();
      }


      function setFormPrivileges() {
        if (!<bean:write name="vmScsiPassthroughView" property="canConfigRawDevice"/>) {
          disableAll();
        } 
        if (!<bean:write name="vmScsiPassthroughView" property="canConfigure"/>) {
          disableAll();
        } 
      }
      
      function preValidateConfigureGenericScsi(configForm) {
        var sltScsiNode = configForm.scsiNode;
        if (sltScsiNode.options[sltScsiNode.selectedIndex].getAttribute("used") == "true" &&
          sltScsiNode.value != "<c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerKey}'/>") {
            vpx.win.alert("<bean:message key="vmConfiguration.virtualDevice.nodeInUse"/>");
            sltScsiNode.value = "<c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.deviceNumber}'/><%= Constants.DEVICE_TOKENIZER%><c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerKey}'/>";
            sltScsiNode.focus();
            toggleOk(true);
            return false;
        }
      }
      
		
	</script>

</head>

<body onload="initConfigPage()">

<div id="configWrapDiv">
<html:form action="vmConfigGenericScsi" method="post" onsubmit="toggleOk(false);return preValidateConfigureGenericScsi(this)">

<div class="dialog half"> <%-- dialog half --%>

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td><div class="scsiDevice-16x16 icon"></div></td>
        <td width="100%">
          <span id="l10n_vmConfiguration_genericSCSI_device_name" class="title">
          	<c:out value="${vmScsiPassthroughView.scsiPassthrough.name}"/>
			(<bean:message key="vmDetails.tab.summary.hardware.controller.scsi"/> <c:out value='${vmScsiPassthroughView.scsiPassthrough.controllerNumber}'/>:<c:out value='${vmScsiPassthroughView.scsiPassthrough.deviceNumber}'/>)</span>
		</td>
        <td>
          <div class="close-12x12 icon" 
          	title="<bean:message key="vmConfiguration.cancel"/>" 
          	onclick="document.forms[0].btnCancel.click()"></div>
        </td>
      </tr>
    </table>
  </div>
  
  <div class="window">

    <div id="legend_connection" class="legend">
      <span id="l10n_vmConfiguration_device_connection">
      	<bean:message key="vmConfiguration.device.connection"/></span>
    </div>
    <div class="fieldset">
      <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <div id="desc_connection" class="description">
              <span id="l10n_vmConfiguration_device_connection_physicalDrive_expl">
              	<bean:message key="vmConfiguration.device.connection.physicalDrive.expl"/></span>:
            </div>
          </td>
        </tr>
        <tr>
          <td>
<c:set var="deviceList" value="${vmScsiPassthroughView.scsiPassthroughDevices}"/>
            <select name="deviceLocation" id="deviceLocation" style="width:100%;">
<c:if test="${deviceList != null}">			        
  <c:forEach var="device" items="${deviceList}">
              <option value="<c:out value='${device.deviceName}'/>">
              	<c:out value='${device.scsiClass}'/> (<c:out value='${device.deviceName}'/>)</option>
  </c:forEach>
</c:if>			       
            </select>
          </td>
        </tr>
      </table>
    </div>
    
    <div id="legend_virtualDevice" class="legend">
      <span id="l10n_vmConfiguration_virtualDevice">
      	<bean:message key="vmConfiguration.virtualDevice"/></span>
    </div>
    <div class="fieldset">
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <td>
            <label id="sltLbl_scsiNode" class="selectLabel" for="scsiNode">
              <span id="l10n_vmConfiguration_virtualDevice_node_scsi">
              	<bean:message key="vmConfiguration.virtualDevice.node.scsi"/></span>:
            </label>
          </td>
          <td width="100%" align="right">
             <select name="scsiNode" id="scsiNode">
<c:set var="scsiNodesList" value="${vmScsiPassthroughView.scsiNodes}" />	
<c:if test="${scsiNodesList != null}">			        
  <c:forEach var="node" items="${scsiNodesList}">
			   <option value="<c:out value="${node.ctrlrBusNum}" /><%= Constants.DEVICE_TOKENIZER %><c:out value="${node.deviceUnitNum}" /><%= Constants.DEVICE_TOKENIZER %><c:out value="${node.ctrlrKey}" />" 
			   	used="<c:out value="${node.used}"/>">
			     <c:out value="${node.name}" /> 
			   </option>
  </c:forEach>
</c:if>
             </select>
           </td>
         </tr>
       </table>
      <div class="warn">
        <div class="title">
          <span id="l10n_vmConfiguration_note">
          	<bean:message key="vmConfiguration.note"/></span>
        </div>
        <p class="explanation">
          <span id="l10n_vmConfiguration_scsiPt_virtualDevice_warn">
          	<bean:message key="vmConfiguration.scsiPt.virtualDevice.warn"/></span>
        </p>
      </div>
    </div>

    <div class="commandButtons">
<logic:equal name="vmScsiPassthroughView" property="canConfigure" value="true">
			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>
</logic:equal>
<logic:notEqual name="vmScsiPassthroughView" property="canConfigure" value="true">
			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>
</logic:notEqual>
    </div>		 

  </div> 	<%-- end window div --%>
</div> 		<%-- end dialog div --%>
		
<!-- End device config inputs section -->

  <input type="hidden" name="viewId" id="viewId" value="<c:out value="${vmScsiPassthroughView.ID}"/>">

</html:form>
		
		
<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>
		
</div> <%-- end configWrap div --%>

<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <c:out value="${vmScsiPassthroughView.ID}"/></li>
</ul>
<ul> VM
	<li>powerState: <c:out value="${vmScsiPassthroughView.vmEntity.powerState}"/></li>
</ul>
<ul> Generic SCSI info:
<li>name: <c:out value="${vmScsiPassthroughView.scsiPassthrough.name}"/><br></li>
<li>summary: <c:out value="${vmScsiPassthroughView.scsiPassthrough.summary}"/><br></li>
<li>controllerNumber: <c:out value="${vmScsiPassthroughView.scsiPassthrough.controllerNumber}"/></li>
<li>deviceNumber: <c:out value="${vmScsiPassthroughView.scsiPassthrough.deviceNumber}"/></li>
<li>controllerKey: <c:out value="${vmScsiPassthroughView.scsiPassthrough.controllerKey}"/></li>
<li>backing.deviceName: <c:out value="${vmScsiPassthroughView.scsiPassthrough.deviceBacking.deviceName}"/></li>
</ul>
--%>
<%-- XXX End visual debugging section XXX --%>

</body> 
</html:html>
