<%@ page import="com.vmware.webcenter.view.viewhelper.Constants, com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">

<head>

	<link rel="stylesheet" type="text/css" href="css/default.css" />
<!--[if IE]>
	<link rel="stylesheet" type="text/css" href="css/default-ie.css" />
<![endif]-->

	<%@ include file="/WEB-INF/jsp/common/commonValidations.jsp" %>
	<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
	<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
	  <jsp:param name="packages" value="xua,win,drag" />
	</jsp:include>
	<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
	<script src="js/configuration/commonConfig.js"></script>
	<script src="js/configuration/vm/serialPort.js"></script>

    <script language="JavaScript" type="text/javascript">
      function init() {
         setupHelp("<bean:message bundle="helpFiles" key="help.vm.edit.serial"/>");
         initConfigPage();  
      }
  
      function tearDown() {
         resetHelp();
      }
      
      
      function setFormInputs (){
      
        var powerState = "<c:out value='${vmSerialPortView.vmEntity.powerState}'/>";
        var configForm = document.forms[0];
        
        configForm.connected.checked = <c:out value='${vmSerialPortView.serialPort.connected}'/>;
        configForm.connectAtPowerOn.checked = <c:out value='${vmSerialPortView.serialPort.startConnected}'/>;
        configForm.yieldOnPoll.checked = <c:out value='${vmSerialPortView.serialPort.yieldOnPoll}'/>;
        
        <logic:equal name="vmSerialPortView" property="serialPort.backingType" value="<%= Constants.DEVICE_DEVICEBACKING %>">
        document.getElementById("physicalConnection").checked = true;
        document.forms[0]["physicalLocation"].value = "<c:out value='${vmSerialPortView.serialPort.deviceBacking.deviceName}'/>";
		</logic:equal>
		<logic:equal name="vmSerialPortView" property="serialPort.backingType" value="<%= Constants.DEVICE_FILEBACKING %>">
        document.getElementById("fileConnection").checked = true;
        document.forms[0]["fileLocation"].value = "<wc:jsSafe name="vmSerialPortView" property="serialPort.fileBacking.fileName"/>";
		</logic:equal>
		<logic:equal name="vmSerialPortView" property="serialPort.backingType" value="<%= Constants.DEVICE_PIPEBACKING %>">
        document.getElementById("pipeConnection").checked = true;
        configForm.pipeLocation.value = "<wc:jsSafe name="vmSerialPortView" property="serialPort.pipeBacking.pipeName"/>";
        configForm.nearEndType.value = "<c:out value="${vmSerialPortView.serialPort.pipeBacking.endpoint}"/>";
          <logic:equal name="vmSerialPortView" property="serialPort.pipeBacking.noRxLoss" value="true">
        configForm.farEndType.value = "<%= Constants.SERIAL_PORT_FAR_END_APPLICATION %>";
		  </logic:equal>
		  <logic:equal name="vmSerialPortView" property="serialPort.pipeBacking.noRxLoss" value="false">
        configForm.farEndType.value = "<%= Constants.SERIAL_PORT_FAR_END_VM %>";
		  </logic:equal>
		</logic:equal>
		
        toggleConnection();
        
        setFormState(powerState);
      }
      
      function setFormState(strPowerState) {
        switch (strPowerState) {
          case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" :
            disableAll();
            break;
          case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" :
            disableStatusSettings(true);
            break;
        }
        
        setFormPrivileges();
      }
      
      function setFormPrivileges(){
        if (!<bean:write name="vmSerialPortView" property="canInteractConnect"/>) {
          disableAllStatusSettings()
        }
        if (!<bean:write name="vmSerialPortView" property="canEditDevice"/>) {
          disableConnectionSettings();
          disableIOMode();
        }
        if (!<bean:write name="vmSerialPortView" property="canConfigure"/>) {
          disableAll();
        }
      }

		<%-- validation alert variables --%>
		<bean:define id="msg_vmConfiguration_serialPort_connection_file">
			<bean:message key="vmConfiguration.serialPort.connection.file"/>
		</bean:define>
		<bean:define id="msg_vmConfiguration_serialPort_connection_namedPipe">
			<bean:message key="vmConfiguration.serialPort.connection.namedPipe"/>
		</bean:define>

      function preValidateConfigureVmSerialPortForm(configForm) {
        if (!bCancel) { <%-- TODO : do not hardcode the Struts value here. Find out where it's declared and use that constant --%>
          var fileConnection = document.getElementById("fileConnection");
          if (!fileConnection.disabled && fileConnection.checked == true) {
            configForm.fileLocation.value = trimAll(configForm.fileLocation.value);
            if (configForm.fileLocation.value == "") {
              vpx.win.alert("<bean:message key="errors.required.specify" arg0="<%= msg_vmConfiguration_serialPort_connection_file %>"/>");
              configForm.fileLocation.focus();
              toggleOk(true);
              return false;
            }
          }
          var pipeConnection = document.getElementById("pipeConnection");
          if (!pipeConnection.disabled && pipeConnection.checked == true) {
            configForm.pipeLocation.value = trimAll(configForm.pipeLocation.value);
            if (configForm.pipeLocation.value == "") {
              vpx.win.alert("<bean:message key="errors.required.specify" arg0="<%= msg_vmConfiguration_serialPort_connection_namedPipe %>"/>");
              configForm.pipeLocation.focus();
              toggleOk(true);
              return false;
            }
          }
        }
        return true;
        <%--
			 The below was commented out since the Struts validator does not
			 supply methods equivalent for requiredIf for the client javascript side.
			 What ended up happening is that the html:javascript tag was returning 
			 true in any case.
			 If further validations supplied by the Struts validator are added
			 and those provide good client side code, the line below should be 
			 uncommented, as well as the html:javascript at the bottom of the file.
			--%>
			<%-- return validateConfigureVmSerialPortForm(configForm); --%>
      }

	</script>
</head>


<body onload="init();" onunload="tearDown();">

<div id="configWrapDiv">
<html:form action="vmConfigSerialPort" method="post" onsubmit="toggleOk(false);return preValidateConfigureVmSerialPortForm(this)">

<div class="dialog half"> <%-- dialog half --%>

  <div class="titlebar">
    <table border="0" cellspacing="0" cellpadding="0">
      <tr>
				<td><div class="serialPort-16x16 icon"></div></td>
				<td width="100%">
				   <span id="l10n_vmConfiguration_serialPort_device_name" class="title">
				    <bean:message key="vmConfiguration.serialPort.device.name"/></span><span class="title"><c:out value="${vmSerialPortView.serialPort.name}"/></span>
				</td>
				<td><div class="close-12x12 icon"
							title="<bean:message key="vmConfiguration.cancel"/>"
							onclick="document.forms[0].btnCancel.click()"></div>
				</td>
      </tr>
    </table>
  </div>

  <div class="window">

	<div class="fieldset">
      <span id="l10n_vmConfiguration_device_status" class="legend">
      	<bean:message key="vmConfiguration.device.status"/></span>
      <table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
      	<tr>
      		<td class="bulletCtrl">
      			<input type="checkbox" name="connected" id="connected" class="checkboxCtrl"/>
			</td>
	    	<td>
	      		<label for="connected">
	      			<span id="l10n_vmConfiguration_device_status_connected">
	      				<bean:message key="vmConfiguration.device.status.connected"/></span>
	      		</label>
	      	</td>
		</tr>
	    <tr>
	    	<td class="bulletCtrl">
	      		<input type="checkbox" name="connectAtPowerOn" id="connectAtPowerOn" class="checkboxCtrl" />
	      	</td>
	      	<td>
	      		<label for="connectAtPowerOn">
	      			<span id="l10n_vmConfiguration_device_status_connectPowerOn">
	    					<bean:message key="vmConfiguration.device.status.connectPowerOn"/></span>
	      		</label>
	      	</td>
		</tr>
	  </table>
	</div>

    <div class="fieldset">
      <span id="l10n_vmConfiguration_device_connection" class="legend">
      	<bean:message key="vmConfiguration.device.connection"/></span>
      <table width="100%" class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
      	<tr>
      		<td class="bulletCtrl">
      			<input type="radio" name="connection" id="physicalConnection"
      				value="<%= Constants.DEVICE_DEVICEBACKING %>"
					class="radioCtrl" onclick="toggleConnection()"/>
      		</td>
      		<td>
      			<label id="title_physicalConnection" class="title" for="physicalConnection">
      				<span id="l10n_vmConfiguration_serialPort_connection_physical">
	      				<bean:message key="vmConfiguration.serialPort.connection.physical"/></span>
	      		</label>
	      		<div class="description" id="physicalPortLabel">
	      			<span id="l10n_vmConfiguration_serialPort_connection_physical_expl">
	      				<bean:message key="vmConfiguration.serialPort.connection.physical.expl"/></span>:
    			</div>
    		</td>
    	</tr>
    	<tr id="clientDeviceOpts">
    		<td width="1%"></td>
    		<td>
    			<table class="description" border="0" cellspacing="0" cellpadding="0">
    				<tr>
    					<td style="width:258px;">
   						<c:set var="portList" value="${vmSerialPortView.avaliableSerialPorts}" />
   							<select name="physicalLocation"	id="physicalLocation" style="width:100%;">
						<c:if test="${portList != null}">
						  <c:forEach var="port" items="${portList}">
						  		<option value="<c:out value="${port}"/>"><c:out value="${port}" /></option>
						  </c:forEach>
						</c:if>
							</select>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td class="bulletCtrl">
				<input type="radio" name="connection" id="fileConnection" 
					value="<%= Constants.DEVICE_FILEBACKING %>"
					class="radioCtrl" onclick="toggleConnection()"/>
			</td>
			<td>
				<label id="title_fileConnection" class="title" for="fileConnection">
					<span id="l10n_vmConfiguration_serialPort_connection_file">
						<bean:message key="vmConfiguration.serialPort.connection.file"/></span>
				</label>
				<div class="description" id="filePortLabel">
					<span id="l10n_vmConfiguration_serialPort_connection_file_expl">
						<bean:message key="vmConfiguration.serialPort.connection.file.expl"/></span>:
				</div>
			</td>
		</tr>
		<tr>
			<td width="1%"></td>
			<td>
				<table class="description" border="0" cellspacing="0" cellpadding="0">
					<tr>
						<td>
							<input type="text" name="fileLocation" id="fileLocation"
	    							value="" 
	    							class="text" style="width:250px;"/>
	    				</td>
	    				<td>
	    					<a class="browse disabled" href="javascript:;" id="browseFile">
	    						<span id="l10n_vmConfiguration_browse">
	    							<bean:message key="vmConfiguration.browse"/></span></a>
	    				</td>
	    			</tr>
	    		</table>
	    	</td>
	    </tr>
	    <tr>
	    	<td class="bulletCtrl">
	    		<input type="radio" name="connection" id="pipeConnection"
	    			value="<%= Constants.DEVICE_PIPEBACKING %>"
	    			class="radioCtrl" onclick="toggleConnection()"/>
	    	</td>
	    	<td>
	    		<label id="title_pipeConnection" class="title" for="pipeConnection">
	    			<span id="l10n_vmConfiguration_serialPort_connection_namedPipe">
	      				<bean:message key="vmConfiguration.serialPort.connection.namedPipe"/></span>
	      		</label>
	      		<div class="description" id="pipePortLabel">
	      			<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_expl">
	      				<bean:message key="vmConfiguration.serialPort.connection.namedPipe.expl"/></span>:
	 			</div>
	 		</td>
	 	</tr>
	 	<tr>
	 		<td width="1%"></td>
	 		<td>
	 			<table width="250px" class="description vertLast" border="0" cellspacing="0" cellpadding="0">
	 				<tr>
	 					<td colspan="2">
	 						<input type="text" name="pipeLocation" id="pipeLocation"
	  								value="" 
	  								class="text" style="width:250px;" />
	  					</td>
	  				</tr>
	  				<tr>
	  					<td>
	  						<label for="nearEndType" class="selectLabel" id="nearEndTypeLabel">
	  							<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_nearEnd">
	  								<bean:message key="vmConfiguration.serialPort.connection.namedPipe.nearEnd"/></span>:
	  						</label>
	  					</td>
	  					<td align="right">
	  						<select name="nearEndType" id="nearEndType" style="width:175px;">
	  							<option value="<%= VMODLConstants.VIRTUALSERIALPORTENDPOINT_SERVER%>">
	  								<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_nearEnd_server">
	  									<bean:message key="vmConfiguration.serialPort.connection.namedPipe.nearEnd.server"/></span>
	  							</option>
	  							<option value="<%= VMODLConstants.VIRTUALSERIALPORTENDPOINT_CLIENT%>">
	  								<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_nearEnd_client">
	  									<bean:message key="vmConfiguration.serialPort.connection.namedPipe.nearEnd.client"/></span>
	  							</option>
	  						</select>
	  					</td>
	  				</tr>
	  				<tr>
	  					<td>
	  						<label for="farEndType" class="selectLabel" id="farEndTypeLabel">
	  							<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_farEnd">
	  								<bean:message key="vmConfiguration.serialPort.connection.namedPipe.farEnd"/></span>:
	  						</label>
	  					</td>
	  					<td align="right">
	  						<select name="farEndType" id="farEndType" style="width:175px;">
	  							<option value="<%= Constants.SERIAL_PORT_FAR_END_VM %>">
	  								<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_farEnd_vm">
	  									<bean:message key="vmConfiguration.serialPort.connection.namedPipe.farEnd.vm"/></span>
	  							</option>
	  							<option value="<%= Constants.SERIAL_PORT_FAR_END_APPLICATION %>">
	  								<span id="l10n_vmConfiguration_serialPort_connection_namedPipe_farEnd_app">
	  									<bean:message key="vmConfiguration.serialPort.connection.namedPipe.farEnd.app"/></span>
	  							</option>
	  						</select>
	  					</td>
					</tr>
				</table>
			</td>
		</tr>
	  </table>
	</div>

	<div class="fieldset">
		<span id="l10n_vmConfiguration_serialPort_ioMode" class="legend">
			<bean:message key="vmConfiguration.serialPort.ioMode"/></span>
		<table class="ctrlGrp" border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td class="bulletCtrl">
					<input type="checkbox" name="yieldOnPoll" id="yieldOnPoll" 
						class="checkboxCtrl"/>
				</td>
				<td>
					<label id="title_yieldOnPoll" for="yieldOnPoll" class="title">
						<span id="l10n_vmConfiguration_serialPort_ioMode_yield">
							<bean:message key="vmConfiguration.serialPort.ioMode.yield"/></span>
					</label>
					<div class="description">
						<span id="l10n_vmConfiguration_serialPort_ioMode_yield_expl">
							<bean:message key="vmConfiguration.serialPort.ioMode.yield.expl"/></span>
					</div>
				</td>
			</tr>
		</table>
	</div>
	
	<div class="commandButtons">

<logic:equal name="vmSerialPortView" property="canConfigure" value="true">

			<html:submit styleId="btnSubmit" styleClass="buttonCtrl" titleKey="vmConfiguration.button.ok.tip">
				<bean:message key="vmConfiguration.button.ok"/>
			</html:submit><html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.cancel.tip">
				<bean:message key="vmConfiguration.button.cancel"/>
			</html:cancel>

</logic:equal>

<logic:notEqual name="vmSerialPortView" property="canConfigure" value="true">

			<html:cancel styleId="btnCancel" styleClass="buttonCtrl" titleKey="vmConfiguration.button.close.tip">
				<bean:message key="vmConfiguration.button.close"/>
			</html:cancel>

</logic:notEqual>

	</div>

   </div> <%-- end window --%>
</div> <%-- end dialog half --%>

<!-- End device config inputs section -->

<input type="hidden" name="viewId" id="viewId" value="<c:out value='${vmSerialPortView.ID}'/>">
<input type="hidden" name="yieldOnPollDisabled" value="">

</html:form>

<%-- BEGIN ERRORS SECTION --%>
<%@ include file="/WEB-INF/jsp/configuration/vm/shared/serverErrors.jsp" %>
<%-- END ERRORS SECTION --%>


</div> <%-- end configWrap div --%>

<%-- 
* The below was commented out since the Struts validator does not
* supply methods equivalent for requiredIf for the client javascript side.
* What ended up happening is that the output for the html:javascript tag 
* was returning true in any case.
* If further validations supplied by the Struts validator are added
* and those provide good client side code, the line below should be 
* uncommented, as well as the call to validateConfigureVmSerialPortForm(configForm)
* in preValidateConfigureVmSerialPortForm(configForm)
--%>
<%-- <html:javascript formName="configureVmSerialPortForm"/> --%>
<script language="JavaScript" type="text/javascript">
var bCancel = false;
</script>


<%-- XXX visual debugging section XXX --%>
<%--
<br><br><br>
<ul> View:
	<li>ID: <c:out value="${vmSerialPortView.ID}"/></li>
	<li>Vm power state: <c:out value="${vmSerialPortView.vmEntity.powerState}"/>
</ul>
<br>
<ul> Serail Port info:
<li>name: <c:out value="${vmSerialPortView.serialPort.name}"/><br></li>
<li>controllerKey: <c:out value="${vmSerialPortView.serialPort.controllerKey}"/></li>
<li>startConnected: <c:out value="${vmSerialPortView.serialPort.startConnected}"/></li>
<li>connected: <c:out value="${vmSerialPortView.serialPort.connected}"/></li>
<li>backingType: <c:out value="${vmSerialPortView.serialPort.backingType}"/></li>
<li>deviceName: <c:out value="${vmSerialPortView.serialPort.deviceBacking.deviceName}"/></li>
<li>fileName: <c:out value="${vmSerialPortView.serialPort.fileBacking.fileName}"/></li>
<li>pipeName: <c:out value="${vmSerialPortView.serialPort.pipeBacking.pipeName}"/></li>
<li>endpoint: <c:out value="${vmSerialPortView.serialPort.pipeBacking.endpoint}"/></li>
<li>noRxLoss: <c:out value="${vmSerialPortView.serialPort.pipeBacking.noRxLoss}"/></li>
<li>yieldOnPoll: <c:out value="${vmSerialPortView.serialPort.yieldOnPoll}"/></li>
</ul>
--%>
</body>
</html:html>