<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.control.action.LoadViewAction" %>
<c:set var="CONNECTED" value="<%= VMODLConstants.VIRTUALMACHINECONNECTIONSTATE_CONNECTED %>" />
<c:set var="DEVICE_BACKING" value="<%= Constants.DEVICE_DEVICEBACKING %>" scope="page" />
<c:set var="FILE_BACKING" value="<%= Constants.DEVICE_FILEBACKING %>" scope="page" />
<c:set var="REMOTE_BACKING" value="<%= Constants.DEVICE_REMOTE_BACKING %>" scope="page" />
<c:set var="CONTROLLER_SCSI" value="<%= Constants.CONTROLLER_SCSI %>" scope="page" />
<c:set var="CONTROLLER_IDE" value="<%= Constants.CONTROLLER_IDE %>" scope="page" />
<c:set var="ATTR_VIEW" value="<%= LoadViewAction.ATTR_VIEW %>" scope="page" />
<c:set var="view" value="${requestScope[ATTR_VIEW]}" scope="page" />

<%-- Resources used many places in this page; only look them up once --%>
<fmt:message key="vmDetails.deviceMenus.label.disconnect"
   bundle="${messageResources}"
   var="txtDisconnect"
   scope="page"/>
<fmt:message key="vmDetails.deviceMenus.label.disconnected"
   bundle="${messageResources}"
   var="txtDisconnected"
   scope="page"/>
<fmt:message key="vmDetails.deviceMenus.label.edit"
   bundle="${messageResources}"
   var="txtEdit"
   scope="page"/>

<gui>
   <c:if test="${view.connectionState == CONNECTED}">
      <var name="menuHandler" type="jsVar">window.deviceMenuHandler</var>
      <var name="btnHandler" type="jsVar">window.deviceButtonHandler</var>
      <var name="container" type="docId">toolbarDeviceMenus</var>

      <%-- Network adapters --%>
      <c:forEach items="${view.networkAdaptors}" var="nic">
         <component class="vpx.context.NicDeviceButton"
            container="container"
            actionCmd="edit"
            actionListener="btnHandler">

            <constructor>
               <arg name="view" type="jsVar">self</arg>
               <arg name="vmViewId" type="string"><c:out value="${view.ID}" /></arg>
               <arg name="dataItemId" type="string"><c:out value="${nic.ID}" /></arg>
               <arg name="name" type="string"><c:out value="${nic.name}" /></arg>
               <arg name="connected" type="boolean"><c:out value="${nic.connected}" /></arg>
            </constructor>

            <attrs>
               <attr name="configUrl" value="vmConfigNicSetup.do" />
               <attr name="paramVmId" value="vmId" />
               <attr name="paramKey" value="nicKey" />
               <attr name="vmId" value="<c:out value='${view.vmDataItem.ID}' />" />
               <attr name="key" value="<c:out value='${nic.key}' />" />
            </attrs>

            <items>
               <header label="<c:out value='${nic.name}' />" />
               <%--
               <radiogroup>
                  <c:choose>
                     <c:when test="${nic.connected == 'true'}">
                        <fmt:message key="vmDetails.deviceMenus.label.connected"
                           bundle="${messageResources}"
                           var="txtConnected">
                           <fmt:param value="${nic.networkName}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnect}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler" />
                        <radiobutton label="<c:out value='${txtConnected}' />"
                           actionCmd="connect"
                           itemListener="menuHandler"
                           selected="true" />
                     </c:when>
                     <c:otherwise>
                        <fmt:message key="vmDetails.deviceMenus.label.connect"
                           bundle="${messageResources}"
                           var="txtConnect">
                           <fmt:param value="${nic.networkName}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnected}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler"
                           selected="true" />
                        <radiobutton label="<c:out value='${txtConnect}' />"
                           actionCmd="connect"
                           itemListener="menuHandler" />
                     </c:otherwise>
                  </c:choose>
               </radiogroup>
               <separator />
               --%>
               <item label="<c:out value='${txtEdit}' />"
                  actionCmd="edit"
                  actionListener="menuHandler" />
            </items>
         </component>
      </c:forEach>

      <%-- CD/DVD drives --%>
      <c:forEach items="${view.cdDvds}" var="cd">
         <component class="vpx.context.CdDvdDeviceButton"
            container="container"
            actionCmd="edit"
            actionListener="btnHandler">

            <constructor>
               <arg name="view" type="jsVar">self</arg>
               <arg name="vmViewId" type="string"><c:out value="${view.ID}" /></arg>
               <arg name="dataItemId" type="string"><c:out value="${cd.ID}" /></arg>
               <arg name="name" type="string"><c:out value="${cd.name}" /></arg>
               <arg name="connected" type="boolean"><c:out value="${cd.connected}" /></arg>
               <arg name="controllerType" type="string"><c:out value="${cd.controllerType}" /></arg>
               <arg name="controllerId" type="string"><c:out value="${cd.controllerId}" /></arg>
               <arg name="deviceNumber" type="string"><c:out value="${cd.deviceNumber}" /></arg>
            </constructor>

            <attrs>
               <attr name="configUrl" value="vmConfigCdDvdSetup.do" />
               <attr name="paramVmId" value="vmId" />
               <attr name="paramKey" value="cdKey" />
               <attr name="vmId" value="<c:out value='${view.vmDataItem.ID}' />" />
               <attr name="key" value="<c:out value='${cd.key}' />" />
            </attrs>

            <items>
               <c:choose>
                  <c:when test="${cd.controllerType == CONTROLLER_SCSI}">
                     <fmt:message key="vmDetails.tab.summary.hardware.controller.scsi"
                        bundle="${messageResources}"
                        var="controllerType"
                        scope="page" />
                  </c:when>
                  <c:when test="${cd.controllerType == CONTROLLER_IDE}">
                     <fmt:message key="vmDetails.tab.summary.hardware.controller.ide"
                        bundle="${messageResources}"
                        var="controllerType"
                        scope="page" />
                  </c:when>
               </c:choose>
               <header label="<c:out value='${cd.name} (${controllerType} ${cd.controllerId}:${cd.deviceNumber})' />" />
               <%--
               <radiogroup>
                  <c:choose>
                     <c:when test="${cd.backingType == DEVICE_BACKING}">
                        <c:set value="${cd.deviceBacking.deviceName}" var="deviceName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.deviceBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${deviceName}" />
                        </fmt:message>
                     </c:when>
                     <c:when test="${cd.backingType == FILE_BACKING}">
                        <c:set value="${cd.fileBacking.fileName}" var="fileName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.fileBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${fileName}" />
                        </fmt:message>
                     </c:when>
                     <c:when test="${cd.backingType == REMOTE_BACKING}">
                        <c:set value="${cd.remoteDeviceBacking.deviceName}" var="deviceName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.remoteDeviceBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${deviceName}" />
                        </fmt:message>
                     </c:when>
                  </c:choose>
                  <c:choose>
                     <c:when test="${cd.connected == 'true'}">
                        <fmt:message key="vmDetails.deviceMenus.label.connected"
                           bundle="${messageResources}"
                           var="txtConnected">
                           <fmt:param value="${backing}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnect}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler" />
                        <radiobutton label="<c:out value='${txtConnected}' />"
                           actionCmd="connect"
                           itemListener="menuHandler"
                           selected="true" />
                     </c:when>
                     <c:otherwise>
                        <fmt:message key="vmDetails.deviceMenus.label.connect"
                           bundle="${messageResources}"
                           var="txtConnect">
                           <fmt:param value="${backing}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnected}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler"
                           selected="true" />
                        <radiobutton label="<c:out value='${txtConnect}' />"
                           actionCmd="connect"
                           itemListener="menuHandler" />
                     </c:otherwise>
                  </c:choose>
               </radiogroup>
               <separator />
               --%>
               <item label="<c:out value='${txtEdit}' />"
                  actionCmd="edit"
                  actionListener="menuHandler" />
            </items>
         </component>
      </c:forEach>

      <%-- Floppy drives --%>
      <c:forEach items="${view.floppies}" var="flp">
         <component class="vpx.context.FloppyDeviceButton"
            container="container"
            actionCmd="edit"
            actionListener="btnHandler">

            <constructor>
               <arg name="view" type="jsVar">self</arg>
               <arg name="vmViewId" type="string"><c:out value="${view.ID}" /></arg>
               <arg name="dataItemId" type="string"><c:out value="${flp.ID}" /></arg>
               <arg name="name" type="string"><c:out value="${flp.name}" /></arg>
               <arg name="connected" type="boolean"><c:out value="${flp.connected}" /></arg>
            </constructor>

            <attrs>
               <attr name="configUrl" value="vmConfigFloppySetup.do" />
               <attr name="paramVmId" value="vmId" />
               <attr name="paramKey" value="flpKey" />
               <attr name="vmId" value="<c:out value='${view.vmDataItem.ID}' />" />
               <attr name="key" value="<c:out value='${flp.key}' />" />
            </attrs>

            <items>
               <header label="<c:out value='${flp.name}' />" />
               <%--
               <radiogroup>
                  <c:choose>
                     <c:when test="${flp.backingType == DEVICE_BACKING}">
                        <c:set value="${flp.deviceBacking.deviceName}" var="deviceName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.deviceBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${deviceName}" />
                        </fmt:message>
                     </c:when>
                     <c:when test="${flp.backingType == FILE_BACKING}">
                        <c:set value="${flp.fileBacking.fileName}" var="fileName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.fileBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${fileName}" />
                        </fmt:message>
                     </c:when>
                     <c:when test="${flp.backingType == REMOTE_BACKING}">
                        <c:set value="${flp.remoteDeviceBacking.deviceName}" var="deviceName" scope="page" />
                        <fmt:message key="vmDetails.deviceMenus.hardware.remoteDeviceBacking"
                           bundle="${messageResources}"
                           var="backing"
                           scope="page">
                           <fmt:param value="${deviceName}" />
                        </fmt:message>
                     </c:when>
                  </c:choose>
                  <c:choose>
                     <c:when test="${flp.connected == 'true'}">
                        <fmt:message key="vmDetails.deviceMenus.label.connected"
                           bundle="${messageResources}"
                           var="txtConnected">
                           <fmt:param value="${backing}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnect}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler" />
                        <radiobutton label="<c:out value='${txtConnected}' />"
                           actionCmd="connect"
                           itemListener="menuHandler"
                           selected="true" />
                     </c:when>
                     <c:otherwise>
                        <fmt:message key="vmDetails.deviceMenus.label.connect"
                           bundle="${messageResources}"
                           var="txtConnect">
                           <fmt:param value="${backing}" />
                        </fmt:message>
                        <radiobutton label="<c:out value='${txtDisconnected}' />"
                           actionCmd="disconnect"
                           itemListener="menuHandler"
                           selected="true" />
                        <radiobutton label="<c:out value='${txtConnect}' />"
                           actionCmd="connect"
                           itemListener="menuHandler" />
                     </c:otherwise>
                  </c:choose>
               </radiogroup>
               <separator />
               --%>
               <item label="<c:out value='${txtEdit}' />"
                  actionCmd="edit"
                  actionListener="menuHandler" />
            </items>
         </component>
      </c:forEach>
   </c:if>
</gui>
