<%-- USAGE: request MUST contain parameter or attribute "pageType" and
            dependingly MAY provide "messageKey" or "rawMessage"
            and "powerState" and "vmId"
            See under each status page type for more specific requirements and options
--%>
<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.control.action.HelpAction,
                 com.vmware.webcenter.control.action.VmPowerOperationsAction,
                 com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- CONSTRUCT CONVENIENCE BEENS HERE --%>

<logic:empty name="pageType">
   <bean:parameter id="pageType" name="pageType" />
</logic:empty>

<bean:parameter id="vmId" name="vmId" value="" />
<bean:parameter id="powerState" name="powerState" value="" />
<bean:define id="powerOp" value="" />
<bean:define id="operation" value="" />
<bean:define id="statusPageOnLoadFunctionBody" value="" />

<%-- VM NOT READY --%>
<logic:equal name="pageType" value="<%= Constants.VM_NOT_READY %>">
   <bean:define id="mode" value="Console" />
   <bean:define id="hasMessage" value="false" />
</logic:equal>

<%-- NO PLUGIN --%>
<logic:equal name="pageType" value="<%= Constants.NO_PLUGIN %>">
   <bean:define id="mode" value="Console" />
   <bean:define id="hasMessage" value="true" />

   <logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="FF" value="true">
      <bean:define id="title" >
         <bean:message key="plugins.xpi.failure.title"/>
      </bean:define>
      <bean:define id="details" >
         <p>
            <bean:message key="plugins.xpi.failure.details"/>
         </p>
         <p>
            <bean:message key="plugins.xpi.failure.note" />
         </p>
      </bean:define>
      <bean:define id="operation" >
         <ul class="operation">
            <li class="operation">
               <a href="javascript:installPlugin();" class="operationText">
                  <bean:message key="plugins.xpi.failure.operation"/>
               </a>
            </li>
            <li class="operation">
               <a href="javascript:launchHelp('<bean:message bundle="helpFiles" key="help.vm.noplugin"/>');" class="operationText">
                  <bean:message key="plugins.failure.help"/>
               </a>
            </li>
         </ul>
      </bean:define>
   </logic:equal>

   <logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="IE" value="true">
      <bean:define id="title" >
         <bean:message key="plugins.cab.failure.title"/>
      </bean:define>
      <bean:define id="details" >
         <p>
            <bean:message key="plugins.cab.failure.details"/>
         </p>
         <p>
            <bean:message key="plugins.cab.failure.note" />
         </p>
      </bean:define>
      <bean:define id="operation" >
         <ul class="operation">
            <li class="operation">
               <a  href="javascript:parent.location.reload(true);" class="operationText">
                  <bean:message key="plugins.cab.failure.operation"/>
               </a>
            </li>
            <li class="operation">
               <a href="javascript:launchHelp('<bean:message bundle="helpFiles" key="help.vm.noplugin"/>');" class="operationText">
                  <bean:message key="plugins.failure.help"/>
               </a>
            </li>
         </ul>
      </bean:define>
   </logic:equal>

</logic:equal>

<%-- DISCONNECTED --%>
<logic:equal name="pageType" value="<%= Constants.DISCONNECTED %>">
   <bean:define id="mode" value="Console" />
   <bean:define id="hasMessage" value="true" />
   <bean:parameter id="rawMessage" name="rawMessage" />
   <bean:define id="statusPageOnLoadFunctionBody">
      var rawMessage=insertWordBreak(unescape('<bean:write name="rawMessage" filter="false" />'), '');
      document.getElementById('rawMessageDiv').innerHTML=rawMessage;
   </bean:define>
   <bean:define id="title" >
      <bean:message key="vmDetails.tab.console.disconnected.title"/>
   </bean:define>
   <bean:define id="operation" >
      <a href="javascript:parent.location.reload(true);">
         <div class="operationText">
            <bean:message key="vmDetails.tab.console.disconnected.operation"/>
         </div>
      </a>
   </bean:define>

   <bean:define id="details">
      <div id="rawMessageDiv"></div>
   </bean:define>
</logic:equal>

<%-- NO PERMISSION --%>
<logic:equal name="pageType" value="<%= Constants.NO_PERMISSION %>">
   <bean:define id="mode" value="Summary" />
   <bean:define id="hasMessage" value="true" />
   <bean:define id="statusPageOnLoadFunctionBody">
      window.parent.initEntityDetails('VM','<wc:jsSafe name="vmView" property="vmDataItem.name"/>');
   </bean:define>
   <bean:define id="title" >
      <bean:message key="errors.permissionDenied"/>
   </bean:define>
   <bean:define id="details">
      <%-- the messageKey attribute stores the *key* we have to look up --%>
      <bean:message key="${messageKey}" />
   </bean:define>
</logic:equal>

<%-- VM UNAVAILABLE --%>
<logic:equal name="pageType" value="<%= Constants.VM_UNAVAILABLE %>">
   <bean:define id="mode" value="Summary" />
   <bean:define id="hasMessage" value="true" />

   <bean:define id="tryAgain">
      <li class="operation">
         <a href="javascript:tryAgain();" class="operationText">
            <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.operation.tryAgain" />
         </a>
      </li>
   </bean:define>
<%--
   -- The operations "removeFromInventory", "selectHost" and "deleteFromDisk" are commented
   -- out b/c the server does not support them yet

   <bean:define id="removeFromInventory">
      <li class="operation">
         <a href="javascript:removeFromInventory();" class="operationText">
            <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.operation.removeFromInventory" />
         </a>
      </li>
   </bean:define>
   <bean:define id="selectHost">
      <li class="operation">
         <a href="javascript:selectHost();" class="operationText">
            <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.operation.selectHost" />
         </a>
      </li>
   </bean:define>
   <bean:define id="deleteFromDisk">
      <li class="operation">
         <a href="javascript:deleteFromDisk();" class="operationText">
            <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.operation.deleteFromDisk" />
         </a>
      </li>
   </bean:define>
--%>
   <bean:define id="operation" >
      <ul class="operation">
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.orphaned">
            <bean:write name="tryAgain" filter="false"/>
            <%--<bean:write name="removeFromInventory" filter="false"/>--%>
            <%--<bean:write name="deleteFromDisk" filter="false"/>--%>
         </logic:equal>
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.disconnected">
            <bean:write name="tryAgain" filter="false"/>
            <%--<bean:write name="removeFromInventory" filter="false"/>--%>
            <%--<bean:write name="deleteFromDisk" filter="false"/>--%>
         </logic:equal>
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.invalid">
            <bean:write name="tryAgain" filter="false"/>
            <%--<bean:write name="removeFromInventory" filter="false"/>--%>
            <%--<bean:write name="deleteFromDisk" filter="false"/>--%>
         </logic:equal>
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.inaccessible">
            <bean:write name="tryAgain" filter="false"/>
            <%--<bean:write name="removeFromInventory" filter="false"/>--%>
            <%--<bean:write name="deleteFromDisk" filter="false"/>--%>
         </logic:equal>
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.inProgress">
            <bean:write name="tryAgain" filter="false"/>
         </logic:equal>
         <logic:equal name="messageKey" value="vmDetails.tab.statusPage.vmNotAvailiable.details.unknown">
            <bean:write name="tryAgain" filter="false"/>
            <%--<bean:write name="removeFromInventory" filter="false"/>--%>
         </logic:equal>
      </ul>
   </bean:define>

   <bean:define id="statusPageOnLoadFunctionBody">
      window.parent.initEntityDetails('VM','<wc:jsSafe name="vmView" property="vmDataItem.name"/>');
      //disable all tabs
      var tabs = tle.getWorkspacePane().workspaceTabs;
      var toolbar = tle.getTopBarPane().toolbar;

      if (!isDefined(tabs) || !isFunction(tabs.disableAllTabs) || !isDefined(toolbar) ) {
         window.setTimeout(statusPageOnLoad.bind(this), 500);
         return;
      }
      tabs.disableAllTabs();

      //disable toolbar and menus
      toolbar.disableIcons();
      toolbar.setupMenus("true", "true", "true", "true", "true", "true", "true");
      toolbar.disableMKSControls(true);
   </bean:define>
   <bean:define id="title" >
      <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.title"/>
   </bean:define>
   <bean:define id="details">
      <%-- the messageKey attribute stores the *key* we have to look up --%>
      <bean:message key="${messageKey}" />
   </bean:define>
</logic:equal>

<%-- POWER STATE VARS when available --%>
<bean:define id="powerStateImgTagContent" value='src="imx/spacer.png" class="powerStateImg" border="0"' />
<bean:define id="status">
   <bean:message key="vmDetails.tab.statusPage.vmNotAvailiable.status" /> 
</bean:define>

<logic:notEqual name="powerState" value="">
   <%-- stationary states --%>
   <logic:equal name="powerState" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.poweredOff" />" src="imx/spacer.png" id="vmStatePoweredOff" name="powerStateImg" class="powerStateImg" border="0" />
      </bean:define>
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.poweredOff" />
      </bean:define>
      <bean:define id="powerOp" >
         <a id="powerOn">
            <bean:message key="vmDetails.tab.console.operation.powerOn" />
         </a>
      </bean:define>
   </logic:equal>

   <logic:equal name="powerState" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.suspended" />" src="imx/spacer.png" id="vmStateSuspended" name="powerStateImg" class="powerStateImg" border="0" />
      </bean:define>       
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.suspended" />
      </bean:define>
      <bean:define id="powerOp" >
         <a id="powerOn">
            <bean:message key="vmDetails.tab.console.operation.resume" />
         </a>
      </bean:define>
   </logic:equal>

   <logic:equal name="powerState" value="<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.poweredOn" />" src="imx/spacer.png" id="vmStatePoweredOn" name="powerStateImg" class="powerStateImg" border="0" />
      </bean:define>
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.poweredOn" />
      </bean:define>

   </logic:equal>

   <%-- intermediate states --%>
   <logic:equal name="powerState" value="<%= Constants.POWERING_ON%>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.poweringOn" />" src="imx/spacer.png" id="vmStatePoweredOn" name="powerStateImg" class="powerStateImg" border="0"' />
       </bean:define>
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.poweringOn" />
      </bean:define>
   </logic:equal>

   <logic:equal name="powerState" value="<%= Constants.SUSPENDING %>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.suspending" />" src="imx/spacer.png" id="vmStateSuspended" name="powerStateImg" class="powerStateImg" border="0"' />
      </bean:define>
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.suspending" />
      </bean:define>
   </logic:equal>

   <logic:equal name="powerState" value="<%= Constants.POWERING_OFF %>">
      <bean:define id="powerStateImgTagContent">
         title="<bean:message key="vmDetails.tab.summary.status.powerState.poweringOff" />" src="imx/spacer.png" id="vmStatePoweredOff" name="powerStateImg" class="powerStateImg" border="0"' />
      </bean:define>
      <bean:define id="status">
         <bean:message key="vmDetails.tab.summary.status.powerState.poweringOff" />
      </bean:define>
   </logic:equal>

</logic:notEqual>

<%-- BEGIN WITH EFFECTIVE HTML HERE --%>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
   <link rel="stylesheet" type="text/css" href="css/messageBox.css" />
   <link rel="stylesheet" type="text/css" href="css/details/statusPage.css" />
   <!--[if IE]>
      <link rel="stylesheet" type="text/css" href="css/details/statusPage-ie.css" />
   <![endif]-->
   <link rel="stylesheet" type="text/css" href="css/details/statusPage<bean:write name="mode" />.css" />
   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <script type="text/javascript">
      function statusPageOnLoad() {
         <bean:write name="statusPageOnLoadFunctionBody" filter="false" />
         disableCommand('powerOn', <c:out value='${vmView.vmDataItem.PowerOnVM}' default='false'/>);
      }

      function launchHelp(helpFile) {
         window.open("help.do?<%= HelpAction.PARAM_NAME_HELP_FILE %>=" + helpFile , "helpWindow", "menubar=1,toolbar=1,status=1,scrollbars=1");
      }
      
      function doPowerOp(op) {
         tle.getTopBarPane().toolbar.doPowerOpIfPermitted(op);
      }
      
      function disableCommand(command, disabled) {
         var cmd = document.getElementById(command);
         if (isNull(cmd)) {
            return;
         }
         
         if (disabled){
            cmd.className = "disabled";
            cmd.href = "javascript:;";
         } else {
            cmd.className = "operation";
            cmd.href = "javascript:doPowerOp('" + command + "');";
         }
      }
      
      
   </script>

   <logic:equal name="pageType" value="<%= Constants.VM_UNAVAILABLE %>">
      <script type="text/javascript" src="js/details/vm/statusPageVmUnavailable.js">
   </logic:equal>

   <logic:equal name="<%= Constants.BEAN_CLIENT_CAPABILITIES %>" property="FF" value="true">
      <%@ include file="/WEB-INF/jsp/common/installPlugin.jsp" %>
   </logic:equal>

   <script type="text/javascript" src="js/util/string.js"></script>
</head>

<body onload="statusPageOnLoad();">

   <div class="coverAllFrame" align="center">

          <div class="statusPageSection">

                <%-- INTRODUCTION --%>
               <div class="introduction">
                  <table class="introduction" border="0" cellspacing="0" cellpadding="0" >
                     <tr>
                        <td valign="bottom" align="right" class="introduction introductionText" nowrap>
                          <bean:message key="vmDetails.tab.console.status.thisVMis"/>
                        </td>
                     </tr>
                  </table>
               </div>

            <%-- CONTENT: VMWARE LOGO OR TEXTUAL EXPLANATION --%>
            <div class="frame">


               <%-- message based screen --%>
               <logic:equal name="hasMessage" value="true">

                  <div class="content" align="left">
                     <%-- ugly table necessary for positioning vertically in the middle --%>
                        <table class="content" cellspacing="0" cellpadding="0" border="0">
                           <tr>
                              <td>

                                 <div class="titleText">
                                    <img title="" src="imx/spacer.png" id="warning-12x12" class="" border="0" align="left">
                                    <table border="0" cellspacing="0" cellpadding="0">
                                       <tr><td><bean:write name="title" /></td></tr>
                                    </table>
                                 </div>

                                 <div class="detailsAndOperation">

                                    <div class="detailsText">
                                       <bean:write name="details" filter="false" />
                                    </div>

                                    <div class="operation">
                                       <bean:write name="operation" filter="false" />
                                    </div>

                                 </div>

                              </td>
                           </tr>
                        </table>

                  </div>

               </logic:equal>

               <logic:equal name="hasMessage" value="false">
                  <img title="VMware, Inc." src="imx/spacer.png" id="VMwareLogo" class="" border="0">
               </logic:equal>

            </div>

            <%-- STATUS --%>
            <div class="status">
               <table class="status" border="0" cellspacing="0" cellpadding="0">
                  <tr>
                     <td valign="bottom" align="left" class="status statusText" id="powerStateTxt">
                        <bean:write name="status" />
                     </td>
                  </tr>
               </table>
            </div>

            <%-- STATE SYMBOL --%>
            <div class="stateSymbol">
               <img <bean:write name="powerStateImgTagContent" filter="false" /> />
            </div>

            <%-- POWER OPERATION  --%>
            <div class="powerOp">
               <table class="powerOp" cellspacing="0" cellpadding="0">
                  <tr>
                     <td valign="bottom" align="right" class="powerOp operationText" id="operationTxt">
                        <bean:write name="powerOp" filter="false" />
                     </td>
                  </tr>
               </table>
            </div>

        </div>

   </div>

</body>
</html:html>

