<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp"%>
<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 java.util.Date,
                 com.vmware.webcenter.view.viewhelper.VmAlarmListView,
                 com.vmware.webcenter.util.SortCriteria "%>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>
<c:set var="GRAY" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_GRAY %>" scope="page"/>
<c:set var="GREEN" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_GREEN %>" scope="page"/>
<c:set var="RED" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_RED %>"/>
<c:set var="YELLOW" value="<%= VMODLConstants.MANAGEDENTITYSTATUS_YELLOW %>" scope="page"/>

<bean:parameter id="sortColumns" name="sortColumns" value="<%= VmAlarmListView.ALARM_TRIGGERED_INMILLIS %>"/>
<bean:parameter id="sortOrder" name="sortOrder" value="<%= SortCriteria.SORT_ORDER_DSC %>"/>

<browserPane page="<c:out value='${vmAlarmsListView.currentPageNumber}' />"
             total="<c:out value='${vmAlarmsListView.totalSize}' />">
   <cols sort="<c:out value='${sortColumns}' />" dir="<c:out value='${sortOrder}' />">
      <col name="<%= VmAlarmListView.ALARM_TRIGGERED_INMILLIS %>"
           display="<fmt:message key='vmDetails.tab.alarms.list.col.triggered' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmAlarmListView.ALARM_STATUS %>"
           display="<fmt:message key='vmDetails.tab.alarms.list.col.status' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmAlarmListView.ALARM_NAME %>"
           display="<fmt:message key='vmDetails.tab.alarms.list.col.name' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmAlarmListView.ALARM_MESSAGE %>"
           display="<fmt:message key='vmDetails.tab.alarms.list.col.desc' bundle='${messageResources}' />"
           canSort="true"
           widest="true"/>
   </cols>

   <nodes>
      <c:forEach var="alarm" items="${vmAlarmsListView.currentPage}">
         <c:set var="statusIcon" value="${alarm.statusIcon}"/>
         <c:out value="${alarm.status}"/>

         <c:if test="${statusIcon != GREEN}">
            <node selectable="false" id="<c:out value='${alarm.name}'/>"
               <c:if test="${statusIcon == YELLOW}">
                  iconClass="alarmWarning"
               </c:if>
               <c:if test="${statusIcon == RED}">
                  iconClass="alarmAlert"
               </c:if>
            >

            <col>
               <cell>
                  <fmt:formatDate value="${alarm.triggered}"  type="both" timeStyle="long" dateStyle="short"/>
               </cell>
            </col>

            <col>
               <cell>
                  <c:if test="${statusIcon == YELLOW}">
                     <span id="l10n_vmDetails_tab_alarms_status_col_warning">
                        <bean:message key="vmDetails.tab.alarms.status.col.warning"/>
                     </span>
                  </c:if>

                  <c:if test="${statusIcon == RED}">
                     <span id="l10n_vmDetails_tab_alarms_status_col_alert">
                        <bean:message key="vmDetails.tab.alarms.status.col.alert"/>
                     </span>
                  </c:if>
               </cell>
            </col>

            <col>
               <cell>
                  <![CDATA[<c:out value="${alarm.name}"/>]]>
               </cell>
            </col>

            <col>
               <cell>
                  <![CDATA[<c:out value="${alarm.description}"/>]]>
               </cell>
            </col>

            </node>
         </c:if>
      </c:forEach>
   </nodes>

   <attrs>
      <attr name="viewId" value="<c:out value='${vmAlarmsListView.ID}' />"/>
   </attrs>

   <c:if test="${param.selectionID != null}">
       <selections>
          <selection id="<c:out value="${param.selectionID}" />"/>
       </selections>
   </c:if>
   </browserPane>
