<%@ page import="com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>


<center>

<object id="mks" type="application/x-vmware-mks;version=<bean:message bundle="internalResources" key="vmDetails.tab.console.plugin.xpi.version"/>" width="90%" height="90%">
   Your browser is not supported.
</object>

<div id="instructions" style="display:none"></div>

<script language="JavaScript" type="text/javascript">

const IMessageListener = Components.interfaces.xpcomIMessageListener;
const IGrabStateListener = Components.interfaces.xpcomIGrabStateListener;
const IWindowStateListener = Components.interfaces.xpcomIWindowStateListener;
const ISizeChangeListener = Components.interfaces.xpcomISizeChangeListener;
const IConnectionStateListener = Components.interfaces.xpcomIConnectionStateListener;

var mks = null;
var instructions = null;
var secondsCountDown = null;

function setupPluginPage() {
   mks = document.getElementById("mks");
   mks.messageListener = new MessageListener();
   mks.grabStateListener = new GrabStateListener();
   mks.windowStateListener = new WindowStateListener();
   mks.sizeChangeListener = new SizeChangeListener();
   mks.connectionStateListener = new ConnectionStateListener();

   instructions = document.getElementById("instructions");
   initMksInstructions();
   
   secondsCountDown = document.getElementById("secondsCountDown");
}

function MessageListener()
{
}

MessageListener.prototype =
{
   onMessage : function (msgType, message) {
      if (msgType == IMessageListener.MT_HINT) {
          tle.setStatusBar(message);
      }
      else if (msgType == IMessageListener.MT_ERROR) {
         displayStatusPageWithRawMessage('<%= Constants.DISCONNECTED %>', '<c:out value='${vmView.overallPowerStatus}' />', message);
      }
      else {
         window.alert(message);
      }
   }
};


function GrabStateListener()
{
}

GrabStateListener.prototype =
{
   onGrabStateChange : function (grabState) {
      if (grabState == IGrabStateListener.GS_GRABBED) {
         tle.setStatusBar('<bean:message key="vmDetails.tab.console.cursor.release"/>');
      } else {
         tle.setStatusBar("");
      }
   }
};


function WindowStateListener()
{
}

WindowStateListener.prototype =
{
   onWindowStateChange : function (windowState) {

      if (windowState == IWindowStateListener.WS_ENTER_FULLSCREEN) {
      	mksControls.enterFullScreen();
      }
   }
};


function SizeChangeListener()
{
}

SizeChangeListener.prototype = {
   onSizeChange : function () {
      mks.width = mks.vmScreenWidth + 1;
      mks.height = mks.vmScreenHeight + 1;
   }
};

function ConnectionStateListener() {
}

ConnectionStateListener.prototype = {
   onConnectionStateChange : function (isConnected) {
     connected = isConnected;
     if (!connected) {
        eventLogger.logUserEvent("<bean:message key="log.userEvent.console.disconnected"/>");
        updatesId = tle.listenForUpdates("<c:out value='${vmTabView.ID}' />", "VmConsoleView", handleUpdates);
        toolbar.disableMKSControls(true);
     } else {
        eventLogger.logUserEvent("<bean:message key="log.userEvent.console.connected"/>");
        toolbar.disableMKSControls(false);
     }
   },

   onDeviceConnectionStateChange : function(isConnected) {
   }
};

function connect(host, port, ticket, path, reconnect)
{
   var ret = false;
   if (pluginLoaded) {
      if (reconnect) {
         ret = mks.reconnect(host, port, path, ticket, ticket);
      } else {
         ret = mks.connect(host, port, path, ticket, ticket);
         if (ret == false) {
            displayStatusPageWithRawMessage('<%= Constants.DISCONNECTED %>', '<c:out value='${vmView.overallPowerStatus}' />');
         }
      }
   }

   return ret;
}

function isPluginLoaded() {
   if (!pluginLoaded) {
      if (!isNull(navigator.mimeTypes["application/x-vmware-mks;version=<bean:message bundle="internalResources" key="vmDetails.tab.console.plugin.xpi.version"/>"])) {
         pluginLoaded = true;
      }
   }
   return pluginLoaded;
}

</script>
</center>
