<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.view.viewhelper.VmConsoleView,
                 com.vmware.webcenter.view.viewhelper.VmView" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<html:html locale="true">
<head>
  <LINK rel="stylesheet" type="text/css" href="css/default.css" />
  <LINK rel="stylesheet" type="text/css" href="css/details/console.css" />

  <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
  <%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
  <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
     <jsp:param name="packages" value="xua" />
  </jsp:include>
  <%@ include file="/WEB-INF/jsp/common/eventLogger.jsp" %>

  <script type="text/javascript" src="js/details/tabs/common.js"></script>
  <script language="JavaScript" type="text/javascript">
     var toolbar = null;
     var connected = false;
     var updatesId = null;
     var powerStatesId = null;
     var webServiceIP = '<bean:write name="vmTabView" property="webServiceIP"/>';
     var pluginLoaded = false;
     var hostName = null;
     var mksControls = null;

     function handleBodyLoad() {
        window.parent.switchTab("<%= Constants.TAB_VM_CONSOLE %>");
        window.parent.setTitleIcon("VM");

        <%-- TODO:(Chandra) Remove the updates from each tab and migrate the design to the unique page (vmDetails.jsp). --%>
        setupHelp("<bean:message bundle="helpFiles" key="help.vm.console"/>");

        // Sync view to persistent state
        tle.syncView();
        pluginLoaded = isPluginLoaded();

        checkVMisReady();

        <%--
           If the web center and the web service are on the same machine then the IP
           address of the web service will resolve to 127.0.0.1. However, to establish
           a successful connection the MKS requires the actual IP address of the ESX.
           The IP address of the ESX can be obtained from the window.location object.
           Note: The webServiceIP will only be used if host information is not available
           on the MKS ticket.
        --%>
        if (webServiceIP == "127.0.0.1") {
           webServiceIP = window.location.host.split(":")[0];
        }
        
        if (pluginLoaded) {
           init();
        }
     }

     function handleBodyUnload() {
        if (connected) {
           eventLogger.logUserEvent("<bean:message key="log.userEvent.console.disconnected"/>");
        }

        resetHelp();
     }

  <%--
  displayStatusPage --
     Displays user information by calling statusPage.jsp into the hidden iframe "statusPageIFrame".
     It makes the corresponding hidden div/iframe visible and
     renders a statusConsole jsp status page in it.

     @param pType
           Mandatory parameter that indicates the page type (VM_NOT_READY,
           DISCONNECTED, NO_PLUGIN etc. )
     @param pwrState
           current powerstate of the selected VM
     @param mKey
           Optional parameter: this message _key_ will be looked up (webCenter.properties)
           and its content rendered into the body of the status page

  --%>

   function displayStatusPage(pType, pwrState, mKey) {
      // grab the hidden form
      var hiddenForm = document.getElementById('displayStatusPageForm');

      // propagate power state, pageType, error message
      hiddenForm.elements['powerState'].value=pwrState;
      hiddenForm.elements['pageType'].value=pType;
      hiddenForm.elements['messageKey'].value=mKey;
      <%--
        // Introduce a small delay before submitting the form because
        // for some reason the submission is canceling out the vmDetails
        // page load, on certain circumstances, therefore leaving the  
        // power icons in the toolbar disabled. 
      --%>
      setTimeout("document.displayStatusPageForm.submit()", 100);

      // flip visibilities if necessary
      var statusPageDiv = document.getElementById("statusPageDiv");
      if (statusPageDiv.style.visibility != 'visible') {
         flipVisibilities();
      }
   }

  <%--
  displayStatusPageWithRawMessage -- DISCOURAGED
     Displays statusPage.jsp like displayStatusPage(). This function allows to pass raw message
     _text_ *as is* instead of a message _key_. Its use is discouraged and only meant as a
     last resort where there is no way to look up a message key in a properties file.

     @param pType
           Mandatory parameter that indicates the page type (VM_NOT_READY,
           DISCONNECTED, NO_PLUGIN etc. )
     @param pwrState
           current powerstate of the selected VM
     @param rawMsg
           This message text will be passed trough *as is* to the body of the status page

  --%>
   function displayStatusPageWithRawMessage(pType, pwrState, rawMsg) {
      // grab the hidden form
      var hiddenForm = document.getElementById('displayStatusPageForm');

      // propagate power state, pageType, error message
      hiddenForm.elements['powerState'].value=pwrState;
      hiddenForm.elements['pageType'].value=pType;
      hiddenForm.elements['rawMessage'].value=escape(rawMsg);
      <%--
        // Introduce a small delay before submitting the form because
        // for some reason the submission is canceling out the vmDetails
        // page load, on certain circumstances, therefore leaving the  
        // power icons in thetoolbar disabled. 
      --%>
      setTimeout("document.displayStatusPageForm.submit()", 100);

      // flip visibilities if necessary
      var statusPageDiv = document.getElementById("statusPageDiv");
      if (statusPageDiv.style.visibility != 'visible') {
         flipVisibilities();
      }
   }


  <%--
  flipVisibilities --
     Flips the visibility of pluginDiv (area reserved for the plugin) and statusPageDiv
     (area used for displaying failures)
  --%>

   function flipVisibilities() {
      // grab the hidden form
      var statusPageDiv = document.getElementById("statusPageDiv");
      var pluginDiv = document.getElementById("pluginDiv");

      if (statusPageDiv.style.visibility == 'visible') {
         // make plugin visible
         statusPageDiv.style.visibility='hidden';
         statusPageDiv.style.display='none';
         statusPageDiv.style.height='0px';
         pluginDiv.style.visibility='visible';
         pluginDiv.style.height='100%';

      } else {
         // make failure box visible
         pluginDiv.style.visibility='hidden';
         pluginDiv.style.height='1px';
         statusPageDiv.style.visibility='visible';
         statusPageDiv.style.display='block';
         statusPageDiv.style.height='400px';
         statusPageDiv.style.width='99%';
      }
   }

   <%--
      handlePowerStateChange --
         Callback function for changed power states

         @param agent vpx.updates.Agent
            Agent that triggered the update
         @param refresh boolean
            true if full refresh of view is required; false if line-item
            updates apply
         @param changeSets Object[]
            Array containing changes since the last updated version
  --%>

   function handlePowerStateChange(agent, refresh, changeSets) {
      if(refresh) {
         <%-- there is nothing we can do here --%>
         return;
      }

      // extract the new power state
      var overallPowerState = null;
      for (var i = 0; i < changeSets.length; i++) {
         var changeSet = changeSets[i];
         for (var j = 0; j < changeSet.changes.length; j++) {
            var change = changeSet.changes[j];
            if (change.property == "<%= VmView.OVERALL_POWER_STATUS %>") {
               overallPowerState = changeSet.changes[j].value;
            }
         }
      }

      // references to DOM objects
      var powerStateImg = window.frames['statusPageIFrame'].document.getElementsByName('powerStateImg')[0];
      var powerStateTxt = window.frames['statusPageIFrame'].document.getElementById('powerStateTxt');
      var operationTxt = window.frames['statusPageIFrame'].document.getElementById('operationTxt');
      var hiddenDiv = document.getElementById("statusPageDiv");
      var pluginDiv = document.getElementById("pluginDiv");

      // change apprearance according to new power state
      //
      // if hiddenDiv is already visible, there is no reason for calling displayStatusPage() and thus
      // reloading the iframe, but we access the elements by means of DOM (hence avoiding flicker)
      if ( overallPowerState == '<%= Constants.SUSPENDING %>' ) {
         if(hiddenDiv.style.visibility=='visible') {
            powerStateImg.src='imx/spacer.png';
            powerStateImg.id = 'vmStateSuspended';
            powerStateTxt.firstChild.nodeValue='<bean:message key="vmDetails.tab.summary.status.powerState.suspending" />';
            operationTxt.style.visibility='hidden';
            //operationTxt.removeChild(operationTxt.firstChild);
         } else {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= Constants.SUSPENDING %>');
         }
      }
      else if ( overallPowerState == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>' ) {
         displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>');
      }
      else if ( overallPowerState == '<%= Constants.POWERING_OFF %>' ) {
         if(hiddenDiv.style.visibility=='visible') {
            powerStateImg.src='imx/spacer.png';
            powerStateImg.id = 'vmStatePoweredOff';
            powerStateTxt.firstChild.nodeValue='<bean:message key="vmDetails.tab.summary.status.powerState.poweringOff" />';
            operationTxt.style.visibility='hidden';
         } else {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= Constants.POWERING_OFF %>');
         }
      }
      else if ( overallPowerState == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>' ) {
         displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>');
      }
      else if ( overallPowerState == '<%= Constants.POWERING_ON %>') {
         powerStateImg.src='imx/spacer.png';
         powerStateImg.id = 'vmStatePoweredOn';
         powerStateTxt.firstChild.nodeValue='<bean:message key="vmDetails.tab.summary.status.powerState.poweringOn" />';
         operationTxt.style.visibility='hidden';
      }
      else if ( overallPowerState == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>' ) {
         if(isPluginLoaded()) {
            if (pluginDiv.style.visibility != 'visible') {
               flipVisibilities();
            }
         } else {
            displayStatusPage('<%= Constants.NO_PLUGIN %>', ''); //<c:out value='${vmView.overallPowerStatus}' />
         }
      }
   }

   <%--
   checkVMisReady --
      Check whether all conditions are met for displaying a running VM with the console plugin.
      Calls displayStatusPage() otherwise.

   --%>
  function checkVMisReady() {
      if (!isPluginLoaded() ) {
         displayStatusPage('<%= Constants.NO_PLUGIN %>', '<c:out value='${vmView.overallPowerStatus}' />');
      } else {
         var overallPowerState = '<c:out value='${vmView.overallPowerStatus}'/>';

         if (overallPowerState == "<%= Constants.SUSPENDING %>") {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= Constants.SUSPENDING %>');
         }
         if (overallPowerState == "<%= Constants.POWERING_OFF %>") {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= Constants.POWERING_OFF %>');
         }
         if (overallPowerState == "<%= Constants.POWERING_ON %>") {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= Constants.POWERING_ON %>');
         }
         if (overallPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>") {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>');
         }
         if (overallPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>") {
            displayStatusPage('<%= Constants.VM_NOT_READY %>', '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>');
         }
      }
   }

   <%--
       init --
         Sets up the toolbar and attempts to connect to mks. Initializes the callbacks for power state change
     --%>
     function init() {        
        powerStatesId = tle.listenForUpdates("<c:out value='${vmView.ID}' />",
                                             "VmView", handlePowerStateChange);
        toolbar = tle.getTopBarPane().toolbar;

        if (!isNull(toolbar)) {
          mksControls = new MksControls();
          if (isDefined(this.setupPluginPage)) {
             this.setupPluginPage();
          }
          eventLogger = new EventLogger("<c:out value='${vmTabView.vmDataItem.ID}' />");
          <logic:equal name="vmTabView" property="acquireMksTicketEnabled" value="true">
           var args = {
              "<%= VmConsoleView.PROP_HOST_NAME %>"      : '<bean:write name="vmTabView" property="mksTicketDataItem.hostName"/>',
              "<%= VmConsoleView.PROP_MKS_PORT %>"       : '<bean:write name="vmTabView" property="mksTicketDataItem.mksPort"/>',
              "<%= VmConsoleView.PROP_MKS_TICKET %>"     : '<bean:write name="vmTabView" property="mksTicketDataItem.mksTicket"/>',
              "<%= VmConsoleView.PROP_VM_CONFIG_FILE %>" : '<wc:jsSafe name="vmTabView" property="mksTicketDataItem.vmConfigFile" />'
            };
            attemptConnection.monitoredInvoke(args);
         </logic:equal>

         <logic:equal name="vmTabView" property="acquireMksTicketEnabled" value="false">
            toolbar.disableMKSControls(true);
            updatesId = tle.listenForUpdates("<c:out value='${vmTabView.ID}' />",
                                             "VmConsoleView", handleUpdates);
         </logic:equal>
        } else {
           setTimeout("init()", 100);
        }
     }

     <%--
        shut --
           Called when the document unloads. Stop listening for
           power state updates (if applicable).
     --%>
     function shut() {
        if (updatesId != null) {
           tle.ignoreUpdates(updatesId);
           updatesId = null;
        }
        if (powerStatesId != null) {
           tle.ignoreUpdates(powerStatesId);
           powerStatesId = null;
        }
     }

     <%--
       attemptConnection --
           Tries to connect to the mks process. If connected successfully then
           enables the mks-controls on the toolbar and stops the thread listening
           for power state updates. If cannot connect then disables the mks-
           controls and starts the thread to listen for power state updates,
           provided there is no other thread listening for the updates.
       @param args
           Contains the MKS connection parameters and the current power state of the VM.
     --%>
     function attemptConnection(args) {
        if (connected || isNull(args)) {
           return;
        }
        if (args.mksTicket != null && args.mksTicket.length > 0) {
        <logic:equal name="vmTabView" property="multiHost" value="false">
           if (updatesId != null) {
              tle.ignoreUpdates(updatesId);
              updatesId = null;
           }
        </logic:equal>
           <%--
              The host field, in the mks ticket, is optional and therefore
              the clients should provide the server name information if
              the field is not populated. Fix bug 74179
              Note: hostd will never populate this field, however, vpxd will.
           --%>
           if (isNull(args.hostName) || args.hostName == "") {
              args.hostName = webServiceIP;
           }

           // The host name variable will be non-null and different if and only if
           // the user was on the console tab and the VM has migrated to a new host.
           var canReconnect = false;

        <logic:equal name="vmTabView" property="multiHost" value="true">
           canReconnect = (!isNull(hostName) && hostName != args.hostName);
        </logic:equal>
         <%-- connection attempt here assumes that 'mks' thus the plugin *is* present --%>
           if (connect(args.hostName, args.mksPort, args.mksTicket, args.vmConfigFile, canReconnect)) {
              vpx.log.info("VM Console: hostName=" + hostName + ", ticket.hostName=" + args.hostName + ", canReconnect=" + canReconnect);
              toolbar.setMKSControls(mksControls);
              <logic:equal name="vmTabView" property="multiHost" value="true">
                 hostName = args.hostName;
                 if (updatesId == null) {
                    updatesId = tle.listenForUpdates("<c:out value='${vmTabView.ID}' />", "VmConsoleView", handleUpdates);
                 }
              </logic:equal>
           } else {
              vpx.log.error("Connection Failed For: Host: " + args.hostName + " Port : " + args.mksPort + " Ticket : " + args.mksTicket + " Config Path : " + args.vmConfigFile);
           }
        } else {
           if (updatesId == null) {
              updatesId = tle.listenForUpdates("<c:out value='${vmTabView.ID}' />",
                                               "VmConsoleView", handleUpdates);
           }
           if (powerStatesId == null) {
             powerStatesId = tle.listenForUpdates("<c:out value='${vmView.ID}'/>",
                                                  "VmView",
                                                  handlePowerStateChange);
           }

           toolbar.disableMKSControls(true);
        }
     }

     <%--
       handleUpdates --
           Callback triggered when changes are available.

       @param agent vpx.updates.Agent
           Agent that triggered the update
       @param refresh boolean
           true if full refresh of view is required; false if line-item
           updates apply
       @param changeSets Object[]
           Array containing changes since the last updated version
     --%>
     function handleUpdates(agent, refresh, changeSets) {
        if (refresh) {
           <%-- Should never happen --%>
           return;
        }
        var args = {
           "<%= VmConsoleView.PROP_HOST_NAME %>"      : null,
           "<%= VmConsoleView.PROP_MKS_PORT %>"       : 0,
           "<%= VmConsoleView.PROP_MKS_TICKET %>"     : null,
           "<%= VmConsoleView.PROP_VM_CONFIG_FILE %>" : null,
           "<%= VmConsoleView.PROP_TASK_NAME %>"      : null
        };

        for (var i = 0; i < changeSets.length; i++) {
           var changeSet = changeSets[i];
           for (var j = 0; j < changeSet.changes.length; j++) {
              var change = changeSet.changes[j];
              args[change.property] = change.value;
              vpx.log.debug("VM Console Update: " + change.property + " : " + change.value);
           }
        }
     <logic:equal name="vmTabView" property="multiHost" value="true">
       if (args["<%= VmConsoleView.PROP_TASK_NAME %>"] != null) {
          mks.setAttemptReconnect(args["<%= VmConsoleView.PROP_TASK_NAME %>"] == "<%= VmConsoleView.TASK_MIGRATE_VM %>");
       }
     </logic:equal>

       attemptConnection.monitoredInvoke(args);
     }

     function fullScreenDisplayInstructions(seconds){
        if(seconds > 0){
            instructions.style.display = '';
            secondsCountDown.innerHTML = seconds;
            seconds -= 1;
            setTimeout('fullScreenDisplayInstructions(' + seconds + ');', 1000);
        } else {
            instructions.style.display = 'none';
        }
     }

     function initMksInstructions(){
        instructions.innerHTML =
            "<bean:message key="vmDetails.tab.console.window.fullscreen.entering"/>" +
            "<br><bean:message key="vmDetails.tab.console.window.fullscreen.press"/>" +
            " <div id='keyCombo'><bean:message key="vmDetails.tab.console.window.fullscreen.keyCombo"/></div>" +
            "<br><br><bean:message key="vmDetails.tab.console.window.fullscreen.enteringIn"/>" +
            " <div id='secondsCountDown'>0</div>&nbsp;<bean:message key="vmDetails.tab.console.window.fullscreen.seconds"/>";
     }

    function MksControls() {
    }

    MksControls.prototype = {
       sendCAD : function (){
          if (isPluginLoaded()) {
             mks.sendCAD();
          }
       },

       //mks Full Screen
       enterFullScreen : function (){
          if (!isPluginLoaded()) {
             return;
          }

          mks.height = 1;
          var displayTime = <bean:message bundle="internalResources" key="vmDetails.tab.console.window.fullscreen.instructionsDelay"/>;

          fullScreenDisplayInstructions(displayTime/1000);
          setTimeout('mks.setFullScreen(true);', displayTime);
          setTimeout('mks.height = mks.vmScreenHeight + 1;', displayTime);
       }
    };

  </script>
</head>
   <body onload="handleBodyLoad();" onbeforeunload="shut();" onunload="handleBodyUnload();">
      <form action="statusPage.do" target="statusPageIFrame" method="GET" id="displayStatusPageForm" name="displayStatusPageForm" style="visibility:hidden; display:none">
         <bean:parameter id="entityId" name="entityId" value="" />
         <input type="hidden" name="entityId" value="<bean:write name="entityId" />" />
         <input type="hidden" name="powerState" value="" />
         <input type="hidden" name="vmId" value="<bean:write name="vmTabView" property="vmDataItem.ID"/>" />
         <input type="hidden" name="pageType" value="" />
         <input type="hidden" name="messageKey" value="" />
         <input type="hidden" name="rawMessage" value="" />
      </form>

      <div id="statusPageDiv" style="visibility:hidden; display:none; overflow:hidden; height:1px; width:1px; border:0px; border-color:#000; ">
         <iframe id="statusPageIFrame" name="statusPageIFrame" src="html/blank.html" scrolling="no" border="0" frameborder="0" height="97%" width="99%" style="border:0px;  border-color:#000; display:block "></iframe>
      </div>

      <div id="pluginDiv" style="visibility:visible">

      <logic:equal name="context_clientCaps" property="IE" value="true">
         <jsp:include page="/WEB-INF/jsp/details/vm/tabs/console/msieConsole.jsp"/>
      </logic:equal>

      <logic:equal name="context_clientCaps" property="FF" value="true">
         <jsp:include page="/WEB-INF/jsp/details/vm/tabs/console/firefoxConsole.jsp"/>
      </logic:equal>

      </div>

   </body>
</html:html>