<%@ page import="com.vmware.webcenter.util.VMODLConstants, com.vmware.webcenter.util.SortCriteria, com.vmware.webcenter.dynaDataItemBean.DynaDataItemBean, com.vmware.vim25.VmEventArgument, java.text.SimpleDateFormat, com.vmware.webcenter.view.viewhelper.VmEventsListView" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<c:set var="ERROR" value="<%= VMODLConstants.EVENTCATEGORY_ERROR %>" scope="page"/>
<c:set var="WARNING" value="<%= VMODLConstants.EVENTCATEGORY_WARNING %>" scope="page"/>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
 <link href="css/default.css" rel="stylesheet" type="text/css" />
 <!--[if IE]>
 <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
 <![endif]-->
 <link href="css/details/eventsView.css" rel="stylesheet" type="text/css" />
 <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
</head>
<body topmargin="0" leftmargin="0" rightmargin="0" bottommargin="0">
<bean:define id="item" name="vmEventsView" property="selectedEventItem"/>
<div style="margin:5px">
 <table width="100%">
  <tr>
   <td align="left" style="width:1%">
    <c:set var="category" value="${item.eventType}"/>
    <c:choose>
     <c:when test="${category == ERROR}">
      <div class="error-16x16 icon" />
     </c:when>
     <c:otherwise>
      <c:choose>
       <c:when test="${category == WARNING}">
        <div class="warning-16x16 icon" />
       </c:when>
       <c:otherwise>
        <%-- Default all other event categories to "info". --%>
        <div class="information-16x16 icon" />
       </c:otherwise>
      </c:choose>
     </c:otherwise>
    </c:choose>
   </td>
   <td>
    <div class="heading">
     <c:set var="timeItem" value="${item.triggered}"/>
     <fmt:formatDate type="time" timeStyle="short" value="${timeItem}"/>
     <fmt:formatDate type="date" dateStyle="short" value="${timeItem}"/>
     (<bean:write name="item" property="triggeredBy"/>)
    </div>
   </td>
  </tr>
  <tr>
   <td colspan="2">
    <div>
     <bean:write name="item" property="fullFormattedMessage" />
    </div>
   </td>
  </tr>
 </table>
 <table width="100%" >
  <tr>
   <th class="lcol" align="left" colspan="2"><div class="heading"><bean:message key="vmDetails.tab.events.related.header"/></div></th>
  </tr>
  <tr>
   <td >
    <table class="listView" border="0" cellpadding="0" cellspacing="0" width="100%" >
     <colgroup>
      <col/> <col style="width:100%;" /> <col span="4" />
     </colgroup>
     <tr class="listHeadings">
      <th colspan="2"><div><bean:message key="vmDetails.tab.events.list.col.triggered"/></div></th>
      <th><div><bean:message key="vmDetails.tab.events.list.col.triggeredBy"/></div></th>
      <th><div><bean:message key="vmDetails.tab.events.list.col.type"/></div></th>
      <th><div><bean:message key="vmDetails.tab.events.list.col.message"/></div></th>
     </tr>
     <c:forEach var="event" items="${vmEventsView.currentPage}">
      <c:set var="category" value="${event.eventType}"/>
      <tr>
      <c:choose>
       <c:when test="${category == ERROR}">
        <td class="lcol listKeyIcon" nowrap="1"><div class="error-16x16 icon" /></td>
       </c:when>
       <c:otherwise>
        <c:choose>
         <c:when test="${category == WARNING}">
          <td class="lcol listKeyIcon" nowrap="1"><div class="warning-16x16 icon" /></td>
         </c:when>
         <c:otherwise>
          <%-- Default all other event categories to "info". --%>
          <td class="lcol listKeyIcon" nowrap="1"><div class="information-16x16 icon" /></td>
         </c:otherwise>
        </c:choose>
       </c:otherwise>
      </c:choose>
      <td nowrap="1">
       <div>
       <c:set var="timeItem" value="${event.triggered}"/>
       <fmt:formatDate type="time" timeStyle="short" value="${timeItem}"/>
       <fmt:formatDate type="date" dateStyle="short" value="${timeItem}"/>
       </div>
      </td>
      <td nowrap="1"><div><bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_TRIGGERED_BY %>"/></div></td>
      <td nowrap="1"><div><bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_TYPE %>"/></div></td>
      <td nowrap="1"><div><bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_MESSAGE %>"/></div></td>
      </tr>
     </c:forEach>
    </table>
   </td>
  <tr>
 </table>
 </div>
</body>
</html:html>