<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants, com.vmware.webcenter.view.viewhelper.VmEventsListView, com.vmware.webcenter.util.SortCriteria, java.text.SimpleDateFormat" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<c:set var="ERROR" value="<%= VMODLConstants.EVENTCATEGORY_ERROR %>" scope="page"/>
<c:set var="WARNING" value="<%= VMODLConstants.EVENTCATEGORY_WARNING %>" scope="page"/>

<browserPane page="<bean:write name="vmEventsView" property="currentPageNumber"/>" total="<bean:write name="vmEventsView" property="totalSize"/>">
   <cols sort="<c:out value='${vmEventsView.primarySortCriteria.property}' />"
      dir="<c:out value='${vmEventsView.primarySortCriteria.sortOrder}' />">

      <col name="<%= VmEventsListView.EVENT_TRIGGERED %>" display="<bean:message key="vmDetails.tab.events.list.col.triggered"/>" canSort="true" />
      <col name="<%= VmEventsListView.EVENT_TRIGGERED_BY %>" display="<bean:message key="vmDetails.tab.events.list.col.triggeredBy"/>" canSort="true" />
      <col name="<%= VmEventsListView.EVENT_TYPE %>" display="<bean:message key="vmDetails.tab.events.list.col.type"/>" canSort="true" />
      <col name="<%= VmEventsListView.EVENT_MESSAGE %>" display="<bean:message key="vmDetails.tab.events.list.col.message"/>" canSort="true" widest="true" />
   </cols>
   <nodes>
      <c:forEach var="event" items="${vmEventsView.currentPage}">
         <c:set var="category" value="${event.eventType}"/>
         <node id="<bean:write name="event" scope="page" property="ID"/>"
            <c:choose>
             <c:when test="${category == ERROR}">
              iconClass="error-16x16">
             </c:when>
             <c:otherwise>
              <c:choose>
               <c:when test="${category == WARNING}">
                iconClass="warning-16x16">
               </c:when>
               <c:otherwise>
                <%-- Default all other event categories to "info". --%>
                iconClass="information-16x16">
               </c:otherwise>
              </c:choose>
             </c:otherwise>
            </c:choose>
            <col>
             <cell>
               <c:set var="timeItem" value="${event.triggered}"/>
               <fmt:formatDate type="time" timeStyle="short" value="${timeItem}"/>
               <fmt:formatDate type="date" dateStyle="short" value="${timeItem}"/>
             </cell>
            </col>
            <col><cell><bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_TRIGGERED_BY %>"/></cell></col>
            <col><cell><bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_TYPE %>"/></cell></col>
            <col><cell><![CDATA[<bean:write name="event" scope="page" property="<%= VmEventsListView.EVENT_MESSAGE %>"/>]]></cell></col>
         </node>
      </c:forEach>
   </nodes>
   <attrs>
      <attr name="viewId" value="<bean:write name="vmEventsView" property="ID" />" />
   </attrs>
</browserPane>
