<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<snapshots>
   <c:if test="${empty vmSnapshotsView.vmDataItem.snapshotInfo.root}">
      <hasSnapshots>false</hasSnapshots>
   </c:if>
   <c:if test="${not empty vmSnapshotsView.vmDataItem.snapshotInfo.root}">
      <hasSnapshots>true</hasSnapshots>
      <currentSnapshot><c:out value="${vmSnapshotsView.vmDataItem.snapshotInfo.current}" /></currentSnapshot>
      <browserWidth><c:out value="${vmSnapshotsView.snapshotHelper.browserWidth}" /></browserWidth>
      <browserHeight><c:out value="${vmSnapshotsView.snapshotHelper.browserHeight}" /></browserHeight>
      <nodeList>
         <c:forEach var="item" items="${vmSnapshotsView.snapshotHelper.snapshotItems}" >
               <node>
                  <id><c:out value="${item.id}" /></id>
                  <snapshotID><c:out value="${item.snapshotID}" /></snapshotID>
                  <name><c:out value="${item.vmSnapshotTree.name}" /></name>
                  <desc><c:out value="${item.vmSnapshotTree.description}" /></desc>
                  <date><c:out value="${item.vmSnapshotTree.createTime.time}" /></date>
                  <isLeaf><c:out value="${item.leaf}" /></isLeaf>
                  <parentId><c:out value="${item.parent.id}" /></parentId>
                  <children>
                     <c:forEach var="child" items="${item.children}">
                        <childID><c:out value="${child.id}" /></childID>
                     </c:forEach>
                  </children>
                  <c:if test="${ vmSnapshotsView.vmDataItem.snapshotInfo.current == item.vmSnapshotTree.snapshot }">
                     <%-- this is the current snapshot --%>
                     <isCurrentSnapshot>true</isCurrentSnapshot>
                  </c:if>
                  <c:if test="${ vmSnapshotsView.vmDataItem.snapshotInfo.current != item.vmSnapshotTree.snapshot }">
                     <%-- this is the current snapshot --%>
                     <isCurrentSnapshot>false</isCurrentSnapshot>
                  </c:if>
                  <isFakeRoot><c:out value="${item.fakeRoot}" /></isFakeRoot>
               </node>
         </c:forEach>
      </nodeList>
   </c:if>
</snapshots>