<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.VmSnapshotsView,
                 com.vmware.webcenter.view.viewhelper.VmView,
                 com.vmware.vim25.VirtualMachineSnapshotTree" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
   <link rel="stylesheet" type="text/css" href="css/default.css" />
   <link rel="stylesheet" type="text/css" href="css/details/snapshots.css" />
   <!--[if IE]>
   <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
   <link rel="stylesheet" type="text/css" href="css/details/snapshots-ie.css" />
   <![endif]-->
   <link rel="stylesheet" type="text/css" href="css/details/vmDetails.css" />

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="net,xua,browser,win,drag" />
   </jsp:include>

   <script type="text/javascript" src="js/details/tabs/common.js"></script>
   <script type="text/javascript">
      var powerStatesUpdatesId = null;
      var snapshotUpdatesId = null;
      var isSessionAutoCommit = null;

      vpx.context["snapshots"] = {
         "context" :   window,
         "currentSnapshot" : '<c:if test="${not empty vmSnapshotsView.vmDataItem.snapshotInfo.root}"><c:out value="${vmSnapshotsView.snapshotHelper.currentSnapshotID}" /></c:if>',
         "currentSnapshotID" : null,
         "selectedNode" : null,
         "responseListener" : responseListener,
         "isVmPoweredOff" : eval('<c:out value="${vmView.overallPowerStatus}" />'=='<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>'),
         "operationsSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.snapshotOperationsSupported}" />,
         "memorySnapshotsSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.memorySnapshotsSupported}" />,
         "multipleSnapshotsSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.multipleSnapshotsSupported}" />,
         "poweredOffSnapshotsSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.poweredOffSnapshotsSupported}" />,
         "revertToSnapshotSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.revertToSnapshotSupported}" />,
         "quiescedSnapshotsSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.quiescedSnapshotsSupported}" />,
         "configSupported" : <c:out value="${vmSnapshotsView.vmDataItem.capability.snapshotConfigSupported}" />
      };

      var responseListener = new Object();
      responseListener.responseReceived = function (event) {
         var response = event.getSource();

         // ensure that content type is text/xml
         if (response.getContentType() != 'text/xml') {
            vpx.log.error("responseListener (vmSnapshots.jsp): response is not XML. Received content type is: "+response.getContentType());
            return;
         }

         <%-- NOTICE: exceptions thrown here would be caught in
              HttpRequest#_fireResponseReceived(). Log the errors instead and return.
         --%>
         xml = response.getXml();
         root = xml.documentElement;

         if (root == null) {
            vpx.log.error("responseListener (vmSnapshots.jsp): XML was not well formed");
            return;
         }

         var statusNode = root.getElementsByTagName("status");

         if (!isNull(statusNode) && statusNode.length > 0) {
            statusCode = statusNode[0].getAttribute("code");
         }
         if (isNull(statusCode)) {
            return;
         }
         //remove white space
         statusCode = statusCode.replace(/^\s+/g, '').replace(/\s+$/g, '');

         if ( statusCode == vpx.browser.SnapshotNode.STATUS_SUCCESS ) {
            //snapshot operation succeded.');
         } else if ( statusCode == vpx.browser.SnapshotNode.STATUS_FAILURE ) {
            var errorNode = root.getElementsByTagName("error");
            if (!isNull(errorNode) && errorNode.length > 0) {
              errorMessage = errorNode[0].getAttribute("message");
            }
            if (!isNull(errorMessage)) {
               toggleProcessing('snapshotInspector', false);
               toggleProcessing('snapshotBrowser', false);
               toggleProcessing('snapshotOperations', false);
               <%-- expose error to UI --%>
               vpx.win.error(errorMessage, '<%= Constants.SNAPSHOTOPS_EXCEPTION_HANDLER %>', tle.getWorkspacePane());
            }
         } else {
            vpx.log.debug("responseListener (vmSnapshots.jsp): received illegal status code");
         }
      };

      function initBrowser(width, height) {
         var container = $('browser');
         var table = document.createElement('table');
         var tr, td;

         for (h=0; h<=height; h++) {
            tr = document.createElement('tr');

            for (w=0; w<=width; w++) {
               td = document.createElement('td');
               td.id = w + '_' + h;
               tr.appendChild(td);
            }
            table.appendChild(tr);
         }
         <%-- ugly, but appendChild does not work with IE here --%>
         container.innerHTML = '<table>' + table.innerHTML + '</table>';
      }

      function processXml(root) {
         if (root.nodeName != "snapshots") {
            return;
         }
         var hasSnapshots = root.getElementsByTagName('hasSnapshots')[0].firstChild.nodeValue;

         if (hasSnapshots != 'true') {
            // show empty browser
         } else {
            var w = root.getElementsByTagName('browserWidth')[0].firstChild.nodeValue;
            var h = root.getElementsByTagName('browserHeight')[0].firstChild.nodeValue;
            initBrowser(w, h);

            var nodeList = root.getElementsByTagName('nodeList')[0].getElementsByTagName('node');

            var node, children, sn;
            // params necessary for instantiating SnapshotNode
            var id, snapshotID, name, desc, date, isLeaf, parentId, childrenIds, domNode;

            for (i=0; i<nodeList.length; i++) {
               node = nodeList[i];

               isLeaf = node.getElementsByTagName('isLeaf')[0].firstChild.nodeValue == 'true';

               children = node.getElementsByTagName('children')[0];
               if (children != null ) {
                  children = children.getElementsByTagName('childID');
               }
               childrenIds = [];
               for (c=0; c<children.length; c++) {
                  childrenIds.push(children[c].firstChild.nodeValue);
               }
               id = node.getElementsByTagName('id')[0].firstChild.nodeValue;
               domNode = $(id);

               if (isLeaf) {
                  vpx.xua.addClass(domNode, 'leaf');
               } else {
                  vpx.xua.addClass(domNode, 'node');
               }

               if (node.getElementsByTagName('isFakeRoot')[0].firstChild.nodeValue == 'true' ) {
                  sn = new vpx.browser.SnapshotNode(id, snapshotID, name, desc, date,
                                                     isLeaf, parentId, childrenIds, domNode);
               } else {

                  snapshotID = node.getElementsByTagName('snapshotID')[0].firstChild.nodeValue;
                  name = node.getElementsByTagName('name')[0].firstChild.nodeValue;
                  desc = node.getElementsByTagName('desc')[0].firstChild.nodeValue;
                  date = node.getElementsByTagName('date')[0].firstChild.nodeValue;

                  parentId = node.getElementsByTagName('parentId')[0].firstChild;
                  if (parentId != null) {
                     parentId = parentId.nodeValue;
                  }
                  sn = new vpx.browser.SnapshotNode(id, snapshotID, name, desc, date,
                                                        isLeaf, parentId, childrenIds, domNode);
               }
               if (node.getElementsByTagName('isCurrentSnapshot')[0].firstChild.nodeValue == 'true' )
               {
                  vpx.context.snapshots.currentSnapshotID = id;
                  vpx.context.snapshots.currentSnapshot = snapshotID;
               }
               sn.init();
            }
            vpx.context.snapshots[vpx.context.snapshots.currentSnapshotID].showInfo();
            vpx.browser.SnapshotNode.getRootNode().expand();
         }
      }

      function retrieveSnapshotXml() {
         var obj = new Object();
         obj.responseReceived = function (e) {
            var resp = e.getSource();
            var contentType = resp.getContentType();
            if (contentType != "text/xml") {
               throw new Error("retrieveSnapshotXml(): invalid content-type: " +
                               contentType + " (status " + status + ")");
            }

            vpx.log.trace("retrieveSnapshotXml(): Processing data from server");
            var xml = resp.getXml();
            var root = xml.documentElement;
            if (root == null) {
               // XML was not well-formed
               throw new Error("retrieveSnapshotXml(): xml was not well-formed " +
                               "while processing " + req.getUrl());
            }
            root.normalize();
            processXml(root);
         };

         var req = tle.getRequest("snapshotsXml.do?viewId=<c:out value='${vmSnapshotsView.ID}' />&viewName=vmSnapshotsView");
         try {
            req.addResponseListener(obj);
            req.send();
         } finally {
            tle.releaseRequest(req);
         }
      }

      function toggleShadeState(elem) {
         var o = $(elem);
         if (vpx.xua.hasClass(o, "shaded")) {
            vpx.xua.removeClass(o, "shaded");
         } else {
            vpx.xua.addClass(o, "shaded");
         }
      }

      function toggleShadeIcon(elem) {
         var o = $(elem);
         if (vpx.xua.hasClass(o, "collapsed")) {
            vpx.xua.removeClass(o, "collapsed");
            vpx.xua.addClass(o, "expanded");
         } else {
            vpx.xua.removeClass(o, "expanded");
            vpx.xua.addClass(o, "collapsed");
         }
      }

      /*
       * Displays the Loading status indicator.
       * Sets the browser table to be translucent, and displays the loading message.
       *
       * @param sectionStr
       * @param processing bool
       *    True if loading status is to be displayed.
       *
       */
      function toggleProcessing(sectionStr, processing) {
         var sectionDiv    = $(sectionStr) ;
         var wrapperDiv    = sectionDiv.getElementsByTagName('div')[2];
         var processingDiv = sectionDiv.getElementsByTagName('div')[3];
         var contentDiv    = sectionDiv.getElementsByTagName('div')[5];

         if (processing) {
            vpx.xua.setOpacity(contentDiv, 0.1);
            vpx.xua.setStyle(processingDiv,"display", "inline");
         } else {
            vpx.xua.setOpacity(contentDiv, 1);
            vpx.xua.setOpacity.monitoredInvoke(contentDiv, 1);
            vpx.xua.setStyle(processingDiv, "display", "none");
         }
      }


      <%--
      handlePowerStateChange --
         Callback function for changed power states

         @param agent vpx.updates.Agent
            Agent that triggered the update
         @param refresh boolean
            true if full refresh of view is required; false if line-item
            updates apply
         @param changeSets Object[]
            Array containing changes since the last updated version
      --%>

      function handlePowerStateChange(agent, refresh, changeSets) {
         if(refresh) {
            <%-- there is nothing we can do here --%>
            return;
         }
         <%--  extract the new power state --%>
         var changeSet = changeSets[0]; // we can assume only one change
         var overallPowerState = null;
         for (var j = 0; j < changeSet.changes.length; j++) {
            var change = changeSet.changes[j];
            if (change.property == "<%= VmView.OVERALL_POWER_STATUS %>") {
               overallPowerState = change.value;
            }
         }
         <%--  on powerstate change recalc: vpx.context.snapshots.isVmPoweredOff --%>
         vpx.context.snapshots.isVmPoweredOff = overallPowerState == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>';
      }


      <%--
      handleSnapshotChange --
         Callback function for changed power states

         @param agent vpx.updates.Agent
            Agent that triggered the update
         @param refresh boolean
            true if full refresh of view is required; false if line-item
            updates apply
         @param changeSets Object[]
            Array containing changes since the last updated version
      --%>

      function handleSnapshotChange(agent, refresh, changeSets) {
         if(refresh) {
            <%-- there is nothing we can do here --%>
            return;
         }
         <%--  extract the new power state --%>
         var changeSet = changeSets[0]; // we can assume only one change

         for (var j = 0; j < changeSet.changes.length; j++) {
            var change = changeSet.changes[j];

            // current snapshot has changed (from a revert op)
            if (change.property == 'current') {
               vpx.context.snapshots.currentSnapshot = 'VirtualMachineSnapshot|'+ change.value;
            }
         }

         //vpx.session.removeAttribute("isSnapshotCmdPending");

         window.setTimeout("retrieveSnapshotXml()", 500);
         toggleProcessing('snapshotInspector', false);
         toggleProcessing('snapshotBrowser', false);
         toggleProcessing('snapshotOperations', false);
      }

      function handleBodyLoad() {
         window.parent.switchTab("<%= Constants.TAB_VM_SNAPSHOTS %>");
         window.parent.setTitleIcon("VM");

         powerStatesUpdatesId = tle.listenForUpdates("<c:out value='${vmView.ID}' />",
                                             "VmView", handlePowerStateChange);

         snapshotUpdatesId = tle.listenForUpdates("<c:out value='${vmSnapshotsView.ID}' />",
                                             "VmSnapshotsView", handleSnapshotChange);

         //isSessionAutoCommit = vpx.session.isAutoCommit();
         //vpx.session.setAutoCommit(true);

         retrieveSnapshotXml();

         <%-- toggle to processing state if --%>
         if (<c:out value="${sessionScope.isSnapshotCmdPending}" default="false" />) {
            toggleProcessing('snapshotInspector', true);
            toggleProcessing('snapshotBrowser', true);
            toggleProcessing('snapshotOperations', true);
         }

      }

      function handleOnBodyUnload() {
         var tmp;
         // memory cleanup
         try {
            for( var id in vpx.context.snapshots ) {
               tmp = vpx.context.snapshots[id];
               if ( isDefined(tmp) && isDefined(tmp.destroy) && isFunction(tmp.destroy) ) {
                  tmp.destroy();
                }
               delete id;
            }
         } finally {
            tmp = null;
            delete vpx.context.snapshots;
         }
         //vpx.session.setAutoCommit(isSessionAutoCommit);
      }

   </script>
</head>

<body onload="handleBodyLoad();" onunload="handleOnBodyUnload();">
<div style="overflow:auto">
   <%-- start row0 --%>
   <div id="row0">

      <%-- Browser Section --%>
      <div id="snapshotBrowser" class="dialog">
         <div class="titlebar">
            <table border="0" cellspacing="0" cellpadding="0">
               <tr>
                  <td width="100%">
                     <span id="l10n_vmDetails_tab_summary_tasks_header" class="sectionTitle">
                        <fmt:message key='vmDetails.tab.snapshots.browser.header' bundle='${messageResources}' />&nbsp;(<c:out value="${vmSnapshotsView.vmDataItem.name}" />)
                     </span>
                  </td>
                  <td><div class="shadeCtrl-12x12 icon" title="<fmt:message key='sectionWindow.fold.tip"' bundle='${messageResources}' />"
                     onclick="toggleShadeState($('browser').parentNode);" />
                  </td>
               </tr>
            </table>
         </div>

         <div id="wrapper" class="enum scrollable">
            <div class="processing">
               <div class="title">
                  <fmt:message key='common.message.processing' bundle='${messageResources}' />
               </div>
            </div>
            <div id="browser"><span class="disabled"><fmt:message key='vmDetails.tab.snapshots.browser.empty' bundle='${messageResources}' /></span></div>
         </div>
      </div>

   </div>
   <%-- end row0 --%>

   <%-- start row1 --%>
   <div>

      <%-- start column0 --%>
      <div id="column0">

         <%-- Inspector Section --%>
         <div id="snapshotInspector" class="dialog">
            <div class="titlebar">
               <table border="0" cellspacing="0" cellpadding="0">
                  <tr>
                     <td width="100%">
                        <span id="l10n_vmDetails_tab_summary_tasks_header" class="sectionTitle">
                           <fmt:message key='vmDetails.tab.snapshots.inspector.header' bundle='${messageResources}' />
                        </span>
                     </td>
                     <td><div class="shadeCtrl-12x12 icon" title="<fmt:message key='sectionWindow.fold.tip' bundle='${messageResources}' />"
                        onclick="toggleShadeState($('inspector').parentNode);" />
                     </td>
                  </tr>
               </table>
            </div>

            <div id="wrapper" class="enum">
               <div class="processing">
                  <div class="title">
                     <fmt:message key='common.message.processing' bundle='${messageResources}' />
                  </div>
               </div>
               <div id="inspector">
                  <span class="disabled"><fmt:message key='vmDetails.tab.snapshots.inspector.empty' bundle='${messageResources}' /></span>
               </div>
            </div>

         </div>


      </div>
      <%-- end column0 --%>

      <%-- start column1 --%>
      <div id="column1">

         <%-- Operations Section --%>
         <div id="snapshotOperations" class="dialog">
            <div class="titlebar">
               <table border="0" cellspacing="0" cellpadding="0">
                  <tr>
                     <td width="100%">
                        <span id="l10n_vmDetails_tab_summary_tasks_header" class="sectionTitle">
                           <fmt:message key='vmDetails.tab.snapshots.operations.header' bundle='${messageResources}' />
                        </span>
                     </td>
                     <td><div class="shadeCtrl-12x12 icon" title="<fmt:message key='sectionWindow.fold.tip"' bundle='${messageResources}' />"
                        onclick="toggleShadeState($('operations').parentNode);" />
                     </td>
                  </tr>
               </table>
            </div>

             <div id="wrapper" class="enum">
               <div class="processing">
                  <div class="title">
                     <fmt:message key='common.message.processing' bundle='${messageResources}' />
                  </div>
               </div>
               <div id="operations">
                 <%-- establish if we can show the option for creating a snapshot.
                      following conditions must be met:
                       - snapshot operations are supported AND
                       - either -> poweredOff is supported OR
                                -> current VM state is not powered off
                 --%>
                 <c:set var="VM_POWEREDOFF"><%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %></c:set>
                 <c:set var="showSnapshotCreateOption"
                    value="${ vmSnapshotsView.vmDataItem.capability.snapshotOperationsSupported == 'true' &&
                              ( vmSnapshotsView.vmDataItem.capability.poweredOffSnapshotsSupported == 'true' ||
                                vmView.overallPowerStatus != VM_POWEREDOFF
                              )
                            }" />

                  <c:if test="${showSnapshotCreateOption == 'true'}" >

                  <ul>
                     <script type="text/javascript">
                        document.write( vpx.browser.SnapshotNode.getSnapshotCreateEntry(<c:out value="${vmSnapshotsView.vmDataItem.capability.memorySnapshotsSupported}" />, <c:out value="${vmSnapshotsView.vmDataItem.capability.quiescedSnapshotsSupported}" />) );
                     </script>

                  </ul>
                  </c:if>
                  <c:if test="${showSnapshotCreateOption == 'false'}" >
                     <span class="disabled">No snapshot operations are supported on this VM.</span>
                  </c:if>
               </div>

            </div>
         </div>


      </div>
      <%-- end column1 --%>

   </div>
   <%-- end row1 --%>

</div>
</body>
</html:html>