<%@ page import="com.vmware.webcenter.view.viewhelper.Constants"%>
<%@ page import="com.vmware.webcenter.util.VMODLConstants"%>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<bean:parameter name="dialogId" id="dialogId" />

<script type="text/javascript">
var c = vpx.context["<c:out value='${dialogId}' />"] = {
   xmlSpec        : null,
   paginator      : null,
   browser        : null,
   updatesId      : null,
   updatesRunning : false
};

c.browserInit = function() {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   c.xmlSpec = vpx.net.XmlSpec.fromUrl("vmActiveTasksView.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}' />");
   c.paginator = new vpx.browser.Paginator($("<c:out value='${dialogId}' />_paginatorContainer"));
   c.browser = new vpx.browser.Browser($("<c:out value='${dialogId}' />_browserContainer"), "<%= Constants.VM_SUMMARY_BROWSER_PAGE_DEFAULT_SIZE %>", false, true);
   c.paginator.setProvider(c.browser);
   c.browser.registerListener(vpx.browser.EVENT.SORT, c.sortDataCollection);
   c.browser.registerListener(vpx.browser.EVENT.PAGE, c.pageDataCollection);
   c.browser.registerListener(vpx.browser.EVENT.DATA, c.handleDataProcessed);
   c.xmlSpec.setAttribute("pageSize", c.browser.getPageSize());
   c.browser.requestData(c.xmlSpec);

};

c.destroy = function() {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   if (c.updatesRunning) {
      tle.ignoreUpdates(c.updatesId);
      c.updatesRunning = false;
   }
};

c.handleDataProcessed = function(browser, xmlSpec) {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   var key = "viewId";
   if (!c.updatesRunning && xmlSpec.hasAttribute(key)) {
      c.updatesRunning = true;
      var viewId = xmlSpec.getAttribute(key);
      c.updatesId = tle.listenForUpdates(viewId, "ActiveTasksView", c.handleUpdates);
   }
};

c.sortDataCollection = function(objBrowser, objColumn, cnstType) {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   var viewId = c.xmlSpec.getAttribute("viewId");
   c.xmlSpec.clearAttributes();
   c.xmlSpec.setAttribute("viewId", viewId);
   c.xmlSpec.setAttribute("sortOrder", cnstType);
   c.xmlSpec.setAttribute("sortColumns", objColumn.getName());
   c.browser.requestData(c.xmlSpec);
};

c.pageDataCollection = function(objBrowser, objPage) {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   var viewId = c.xmlSpec.getAttribute("viewId");
   c.xmlSpec.clearAttributes();
   c.xmlSpec.setAttribute("viewId", viewId);
   c.xmlSpec.setAttribute("pageAction", objPage);
   c.browser.requestData(c.xmlSpec);
};

c.handleUpdates = function(agent, refresh, changeSets) {
   var c = vpx.context["<c:out value='${dialogId}' />"];

   if (refresh) {
      c.browser.requestData(c.xmlSpec);
      return;
   }


   for (var i = 0; i < changeSets.length; i++) {
      var changeSet = changeSets[i];
      vpx.log.debug("received changeSet: (id=" + changeSet.id + "; type=" + changeSet.type + ")");
      for (var j = 0; j < changeSet.changes.length; j++) {
	 var change = changeSet.changes[j];
	 vpx.log.debug("received change: (property=" + change.property + "; value=" + change.value + ")");

	 var node = c.browser.getNodeById(changeSet.id);
	 var column = c.browser.getColByName(change.property);

	 var success = "<bean:message key="vmDetails.tab.summary.activeTasks.status.success"/>";
	 var error = "<bean:message key="vmDetails.tab.summary.activeTasks.status.error"/>";
	 var running = "<bean:message key="vmDetails.tab.summary.activeTasks.status.running"/>";
	 var queued = "<bean:message key="vmDetails.tab.summary.activeTasks.status.queued"/>";

	 // If the status was running -- update the table with innerHTML to
	 // display the progress bar. Otherwise update the progressbar percentage
	 // and label only


     if (change.property == "progress" && change.value > 0) {

        var taskId = node.getAttribute("taskId");
        var runningTaskId  = document.getElementById("runningTask:" + taskId);
        if (runningTaskId != null) {

           var progressBarTableId = document.getElementById("progressBarTable:" + taskId);
           if (isDefined(progressBarTableId)) {

              var html = "";
              html += '<td>';
              html += '<div id="taskBarPct:' + taskId +'" class="perfBarCompact" style="background-position:' + change.value + 'px;">';
              html += '<img src="spacer.png" class="vstrut"/>';
              html += '<table class="perfBarFg">';
              html += '<tr><td class="lcol"/><td/><td/><td/><td/><td/><td/><td/><td/><td/></tr>';
              html += '</table>';
              html += '</div>';
              html += '</td>';
              html += '<td>';
              html += '<div class="perfBarLabelCompact nowrap">';
              html += '<span id="taskBarLabel:' + taskId +'">' + change.value + '%</span>';
              html += '</div>';
              html += '</td>';
              progressBarTableId.innerHTML = html;
          }
        } else {

           var taskBarPct = document.getElementById("taskBarPct:" + taskId);
           var taskBarLabel = document.getElementById("taskBarLabel:" + taskId);
           if (isDefined(taskBarPct)) {
             vpx.xua.setStyle(taskBarPct, "backgroundPosition", change.value + "px");
           }
           if (isDefined(taskBarLabel)) {
           taskBarLabel.innerHTML = change.value + "%";
           }
        }

    } else if (isDefined(node) && isDefined(column)) {
	     var className = "<div class=\"loading-9x9 icon\"/>";
	     var value = null;
         if (change.property == "state") {

            if (change.value == "<%= VMODLConstants.TASKINFOSTATE_SUCCESS %>" ||
                change.value == "<%= VMODLConstants.TASKINFOSTATE_QUEUED %>") {
                className = "<div class=\"okay-12x12 icon\"/>";
                value = "<table><tr><td>"+ className + "</td><td class='nowrap'>" + success + "</td></tr></table>";

            } else if (change.value == "<%= VMODLConstants.TASKINFOSTATE_ERROR %>") {
               className = "<div class=\"error-12x12 icon\"/>";
               value = "<table><tr><td>"+ className + "</td><td class='nowrap'>" + error + "</td></tr></table>";

            } else if (change.value == "<%= VMODLConstants.TASKINFOSTATE_RUNNING %>"){
               value = "<table><tr><td>"+ className + "</td><td class='nowrap'>" + running + "</td></tr></table>";
            }

               node.setCellHtml(column, 0, value);
           } else {
               node.setCellHtml(column, 0, change.value);
           }
	 }



      }
   }
};
</script>

<div id="<c:out value='${dialogId}' />" class="dialog">
   <div class="titlebar">
      <table border="0" cellspacing="0" cellpadding="0">
         <tr>
            <td width="100%">
               <span id="l10n_vmDetails_tab_summary_tasks_header" class="sectionTitle">
                  <bean:message key="vmDetails.tab.summary.tasks.header"/>
               </span>
            </td>
            <td><div class="shadeCtrl-12x12 icon" title="<bean:message key="sectionWindow.fold.tip"/>"
               onclick="toggleShadeState('<c:out value='${dialogId}' />');" />
            </td>
         </tr>
      </table>
   </div>

   <div class="enum" style="border-bottom: solid 1px #B3B3B3;padding: 0px">
      <div id="<c:out value='${dialogId}' />_browserContainer" class="cntnr" style="overflow:auto;"></div>
      <div id="<c:out value='${dialogId}' />_paginatorContainer"></div>
   </div>
</div>