<%@ page import="com.vmware.webcenter.control.action.VmPowerOperationsAction, com.vmware.webcenter.util.VMODLConstants, com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />

<jsp:include page="/WEB-INF/jsp/common/powerOpJs.jsp">
   <jsp:param name="vmId" value="" />
</jsp:include>
<script language="JavaScript" type="text/javascript">

   var mapPowerCmds = {
      "PowerOffVM" : "<%= VmPowerOperationsAction.OP_VM_POWEROFF %>",
      "PowerOnVM"  : "<%= VmPowerOperationsAction.OP_VM_POWERON %>",
      "SuspendVM" : "<%= VmPowerOperationsAction.OP_VM_SUSPEND %>",
      "ResetVM" : "<%= VmPowerOperationsAction.OP_VM_RESET %>",
      "ShutdownGuest" : "<%= VmPowerOperationsAction.OP_GUEST_SHUTDOWN %>",
      "RebootGuest" : "<%= VmPowerOperationsAction.OP_GUEST_REBOOT %>",
      "ResumeVM" : "<%= VmPowerOperationsAction.OP_RESUME %>"
   };
   
   var mapDefaultPowerCmds = {      
      <%-- poweroff --%>
		<logic:equal name="vmTabView" property="vmDataItem.powerOffType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_PRESET %>">
			<logic:equal name="vmTabView" property="vmDataItem.powerOffPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">
				"ShutdownGuest" : true,
				"PowerOffVM" : false,
			</logic:equal>
			<logic:equal name="vmTabView" property="vmDataItem.powerOffPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">
				"ShutdownGuest" : false,
				"PowerOffVM" : true,
			</logic:equal>
		</logic:equal>
		<logic:equal name="vmTabView" property="vmDataItem.powerOffType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">
				"ShutdownGuest" : true,
				"PowerOffVM" : false, 
		</logic:equal>
		<logic:equal name="vmTabView" property="vmDataItem.powerOffType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">
				"ShutdownGuest" : false,
				"PowerOffVM" : true,
		</logic:equal>
		<%-- reset --%>
		<logic:equal name="vmTabView" property="vmDataItem.resetType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_PRESET %>">
			<logic:equal name="vmTabView" property="vmDataItem.resetPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">
				"RebootGuest" : true, 
				"ResetVM" : false,
			</logic:equal>
			<logic:equal name="vmTabView" property="vmDataItem.resetPreset" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">
				"RebootGuest" : false,
				"ResetVM" : true,
			</logic:equal>
		</logic:equal>
		<logic:equal name="vmTabView" property="vmDataItem.resetType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_SOFT %>">
				"RebootGuest" : true,
				"ResetVM" : false,
		</logic:equal>
		<logic:equal name="vmTabView" property="vmDataItem.resetType" value="<%= VMODLConstants.VIRTUALMACHINEPOWEROPTYPE_HARD %>">
				"RebootGuest" : false,
				"ResetVM" : true,
		</logic:equal>
      "PowerOnVM"  : true,      
      "ResumeVM" : true,      
      "SuspendVM" : true
   };
   
   var sortedChangeSet = {
      "overallPowerStatus" : null,
      "PowerOnVM" : null,
      "ResetVM" : null,
      "ShutdownGuest" : null,
      "RebootGuest" : null,
      "SuspendVM" : null,
      "PowerOffVM" : null     
   };

   /* powerState - stores the current power state so showHardwareCommands can
      check what it should display */
   var powerState = null;
   /* canRemoveHardware - stores if the currently selected hardware can be
      removed, so updateHardwareCommands can keep the correct state */
   var canRemoveHardware = null;
   /* fileOperation - stores if the currently selected hardware has an extra
      link offered to remove the hardware with a specific fileOp */
   var fileOperation = null;
   var hardwareSelected = null;

   function setCommands(strPowerState) {
      powerState = strPowerState;
      
      initSortedChangeSet(strPowerState, 
                          <c:out value='${vmView.vmDataItem.PowerOnVM}'/>,
                          <c:out value='${vmView.vmDataItem.ResetVM}'/>,
                          <c:out value='${vmView.vmDataItem.ShutdownGuest}'/>,
                          <c:out value='${vmView.vmDataItem.RebootGuest}'/>,
                          <c:out value='${vmView.vmDataItem.SuspendVM}'/>,
                          <c:out value='${vmView.vmDataItem.PowerOffVM}'/>);
      processSortedChangeSet();
      toggleAddHardware();
            
   }
   
   function initSortedChangeSet (overallPowerStatus, PowerOnVM, ResetVM, ShutdownGuest, RebootGuest, SuspendVM, PowerOffVM) {
      sortedChangeSet["overallPowerStatus"] = overallPowerStatus;
      sortedChangeSet["PowerOnVM"] = PowerOnVM;
      sortedChangeSet["ResetVM"] = ResetVM;
      sortedChangeSet["ShutdownGuest"] = ShutdownGuest;
      sortedChangeSet["RebootGuest"] = RebootGuest;
      sortedChangeSet["SuspendVM"] = SuspendVM;
      sortedChangeSet["PowerOffVM"] = PowerOffVM;
   }

   function disableCommands (disable) {
      disableCommand("PowerOffVM", disable);
      disableCommand("SuspendVM", disable);
      disableCommand("ResetVM", disable);
      disableCommand("ShutdownGuest", disable);
      disableCommand("RebootGuest", disable);
      
      disableCommand("PowerOnVM", disable);
      disableCommand("ResumeVM", disable);
      toggleAddHardware();
      
   }
   
   function toggleAddHardware() {
      var aAddHardware = document.getElementById("aAddHardware");
      var canEnableAddhardware = "<c:out value='${vmTabView.vmDataItem.canAddHardwarePrivilege}'/>";
       
      if (canEnableAddhardware == "true" && 
          ((powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>") ||
          (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>"))){ 
         aAddHardware.className = "";
         aAddHardware.href = "wzrdHardwareInit.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>";
      } else {
         aAddHardware.className = "disabled";
         aAddHardware.href = "javascript:;";
      }
   }

   function isTransientState (powerState){
      switch (powerState){
         case "<%= Constants.POWERING_ON %>":
         case "<%= Constants.POWERING_OFF %>":
         case "<%= Constants.SUSPENDING %>" :
            return true;
            break;
         default:
            return false;
            break;
      }
   }
   
   function isSuspended (powerState) {
      return (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>");
   }
   
   function sortChangeSet (changeSet) {
      for (var j = 0; j < changeSet.changes.length; j++) {
         var change = changeSet.changes[j];        
         if (sortedChangeSet[change.property] != null || change.property == "overallPowerStatus") {
            if(change.property == "overallPowerStatus"){
               sortedChangeSet["overallPowerStatus"] = change.value;
            //The change.value's are passed as strings of "true" or "false"   
            } else if(change.value == "false"){
               sortedChangeSet[change.property] = false;
            } else {
               sortedChangeSet[change.property] = true;
            }
         }
      }
   }
   
      
   /**
    * updateCommands --
    *    Takes a command to be disabled on the vmSummary commands section.
    */

   this.updateCommands = function(changeSets) {
      for (var i = 0; i < changeSets.length; i++) {        
         var changeSet = changeSets[i];         
         sortChangeSet(changeSet);
         processSortedChangeSet();
      }
   }
   
   function processSortedChangeSet() {
      //"overallPowerStatus"
      var prevPowerState = powerState;
      powerState = sortedChangeSet["overallPowerStatus"];
     
      updateHardwareCommands(canRemoveHardware, fileOperation); 
      toggleAddHardware(powerState); 
           
      if (isTransientState(powerState)) {
         disableCommands(true);
      } else {
         if (isTransientState(prevPowerState)) {
             disableCommands(false);
         }
         
         //PowerOnVM/ResumeVM
         hideCommand("PowerOnVM", sortedChangeSet["PowerOnVM"] || isSuspended(powerState));
         hideCommand("ResumeVM", sortedChangeSet["PowerOnVM"] || !isSuspended(powerState));
         
         //Suspend
         hideCommand("SuspendVM", sortedChangeSet["SuspendVM"]);
         
         
         //RebootGuest/ResetVM
         if (mapDefaultPowerCmds["RebootGuest"]) {
            if (sortedChangeSet["RebootGuest"]) {
               hideCommand("ResetVM", sortedChangeSet["ResetVM"]);
            } else {
               hideCommand("ResetVM", true);
            }
            hideCommand("RebootGuest", sortedChangeSet["RebootGuest"]);    
        
         } else {
            hideCommand("ResetVM", sortedChangeSet["ResetVM"]);
            hideCommand("RebootGuest", true)
         }
         
         //"ShutdownGuest"/"PowerOffVM"
          if (mapDefaultPowerCmds["ShutdownGuest"]) {
            if (sortedChangeSet["ShutdownGuest"]) {
               hideCommand("PowerOffVM", sortedChangeSet["PowerOffVM"]);
            } else {
               hideCommand("PowerOffVM", true);
            }
            hideCommand("ShutdownGuest", sortedChangeSet["ShutdownGuest"]);
            
         } else {
            hideCommand("PowerOffVM", sortedChangeSet["PowerOffVM"]);
            hideCommand("ShutdownGuest", true);
         }
      } 
   }

   /**
    * disableCommand --
    *   Greys out the link, and remove the action.
    *
    */
   function disableCommand(command, disabled) {
      var cmd = document.getElementById(mapPowerCmds[command]);
      if (disabled){
         cmd.className = "disabled";
         cmd.href = "javascript:;";
      } else {
         cmd.className = "";
         cmd.href = "javascript:doPowerOp('" + mapPowerCmds[command] + "');";
      }
   }
   
   function hideCommand(command, disabled) {
      var cmd = document.getElementById("cmd_" + mapPowerCmds[command]);

      if (disabled) {
         cmd.style.display = "none";
      } else {
         cmd.style.display = "";
         cmd.href = "javascript:doPowerOp('" + mapPowerCmds[command] + "');";
      }
   }

   
   /**
    *  updateHardwareCommands -
    *     Only calls showHardwareCommands if the commands are already showing
    *
    */
   function updateHardwareCommands(canRemove, fileOpOffer) {
      if (hardwareSelected) {
         showHardwareCommands(canRemove, fileOpOffer);
      }
   }
   
   /*
    * Show the following commands only when the VM was powered off
    * and have AddRemoveDevice privilege
    *
    * Remove, remove-delete (when the fileOpOffer was available).
    *
    */

   function showHardwareCommands(canRemove, fileOpOffer) {
      document.getElementById("cmd_hardware").style.display = "";
      document.getElementById("cmd_hardware_edit").style.display = "";
      document.getElementById("cmd_hardware_none").style.display = "none";
      document.getElementById("cmd_hardware_remove").style.display = "none";
      document.getElementById("cmd_hardware_remove-delete").style.display = "none";  
      
      if (powerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" &&
        <c:out value="${vmTabView.vmDataItem.canRemoveHardwarePrivilege}"/>) {
         if (canRemove) {
            document.getElementById("cmd_hardware_remove").style.display = "";
            if (fileOpOffer != null) {
               document.getElementById("cmd_hardware_remove-delete").style.display = "";
            } 
         } 
      }
     
      
      canRemoveHardware = canRemove;
      fileOperation = fileOpOffer;
      hardwareSelected = true;      
   }

</script>


<div class="titlebar">
   <table border="0" cellspacing="0" cellpadding="0">
      <tr>
         <td width="100%"><span class="sectionTitle" id="l10n_vmDetails_tab_summary_commands_header"><bean:message key="vmDetails.tab.summary.commands.header"/></span></td>
         <td><div class="shadeCtrl-12x12 icon" title="<bean:message key="sectionWindow.fold.tip"/> "onclick="toggleShadeState('commands');" /></td>
      </tr>
   </table>
</div>

<div class="enum">
   <div class="cntnr">
      <div>
         <dl>
            <dt id="cmd_hardware"><bean:message key="vmDetails.tab.summary.commands.hardware.heading"/></dt>
            <dd>
               <ul>
                  <!-- <li id="cmd_hardware_disconnect"><a href="javascript:;">Disconnect</a></li> -->
                  <li id="cmd_hardware_none" class="disabled"><bean:message key="vmDetails.tab.summary.commands.hardware.none"/></li>
                  <li id="cmd_hardware_edit" style="display:none;"><a href="#"><bean:message key="vmDetails.tab.summary.commands.hardware.edit"/></a></li>
                  <li id="cmd_hardware_remove" style="display:none;"><a href="#"><bean:message key="vmDetails.tab.summary.commands.hardware.remove"/></a></li>
                  <li id="cmd_hardware_remove-delete" style="display:none;"><a href="#"><bean:message key="vmDetails.tab.summary.commands.hardware.removeDelete"/></a></li>
               </ul>
            </dd>
            <dt>
               <span id="l10n_vmDetails_tab_summary_commands_virtualMachine">
                  <bean:message key="vmDetails.tab.summary.commands.virtualMachine"/>
               </span>
            </dt>
            <dd>
               <ul>
                  <li id="cmd_<%= VmPowerOperationsAction.OP_VM_POWERON %>"><a id="<%= VmPowerOperationsAction.OP_VM_POWERON %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_VM_POWERON %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_poweron">
                        <bean:message key="vmDetails.tab.summary.commands.poweron"/>
                     </span></a>
                  </li>
                  
                  <li id="cmd_<%= VmPowerOperationsAction.OP_RESUME %>"><a id="<%= VmPowerOperationsAction.OP_RESUME %>"  href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_RESUME %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_resume">
                        <bean:message key="vmDetails.tab.summary.commands.resume"/>
                     </span></a>
                  </li>

                  <li id="cmd_<%= VmPowerOperationsAction.OP_VM_POWEROFF %>"><a id="<%= VmPowerOperationsAction.OP_VM_POWEROFF %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_VM_POWEROFF %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_poweroff">
                        <bean:message key="vmDetails.tab.summary.commands.poweroff"/>
                     </span></a>
                  </li>
                  
                  <li id="cmd_<%= VmPowerOperationsAction.OP_GUEST_SHUTDOWN %>"><a id="<%= VmPowerOperationsAction.OP_GUEST_SHUTDOWN %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_GUEST_SHUTDOWN %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_shutdown">
                        <bean:message key="vmDetails.tab.summary.commands.shutdown"/>
                     </span></a>
                  </li>

                  <li id="cmd_<%= VmPowerOperationsAction.OP_VM_SUSPEND %>"><a id="<%= VmPowerOperationsAction.OP_VM_SUSPEND %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_VM_SUSPEND %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_suspend">
                        <bean:message key="vmDetails.tab.summary.commands.suspend"/>
                     </span></a>
                  </li>

                  <li id="cmd_<%= VmPowerOperationsAction.OP_VM_RESET %>"><a id="<%= VmPowerOperationsAction.OP_VM_RESET %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_VM_RESET %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_reset">
                        <bean:message key="vmDetails.tab.summary.commands.reset"/>
                     </span></a>
                  </li>
                  
                  <li id="cmd_<%= VmPowerOperationsAction.OP_GUEST_REBOOT %>"><a id="<%= VmPowerOperationsAction.OP_GUEST_REBOOT %>" href="javascript:doPowerOp('<%= VmPowerOperationsAction.OP_GUEST_REBOOT %>');">
                     <span id="l10n_vmDetails_tab_summary_commands_reboot">
                        <bean:message key="vmDetails.tab.summary.commands.reboot"/>
                     </span></a>
                  </li>

                  <%-- XXX Will not be implemented for WebCenter's Beta1/Beta2. Uncomment if brought back
                  <li><a class="disabled" href="javascript:alert('N/A M6');">
                     <span id="l10n_vmDetails_tab_summary_commands_migrate">
                        <bean:message key="vmDetails.tab.summary.commands.migrate"/>
                     </span></a>
                  </li>
                  --%>

                  <li>
                     <span id="l10n_vmDetails_tab_summary_commands_addHardware">
                        <a id="aAddHardware" href="wzrdHardwareInit.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>">
                           <bean:message key="vmDetails.tab.summary.commands.addHardware"/>
                        </a>
                     </span>
                  </li>
                  <li class="collapsed" onclick="toggleShadeState('vmOptions'); toggleShadeIcon(this);">
                     <span id="l10n_vmDetails_tab_summary_commands_configureOptions">
                        <bean:message key="vmDetails.tab.summary.commands.configureOptions"/>
                     </span>
                  </li>

                  <ul id="vmOptions" class="shaded">
                     <li>
                        <a href="vmConfigGeneralOptionsSetup.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>">
                           <span id="l10n_vmDetails_tab_summary_commands_configureOptions_general">
                              <bean:message key="vmDetails.tab.summary.commands.configureOptions.general"/>
                           </span>
                        </a>
                     </li>
                     <li>
                        <a href="vmConfigPowerOptionsSetup.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>">
                           <span id="l10n_vmDetails_tab_summary_commands_configureOptions_power">
                              <bean:message key="vmDetails.tab.summary.commands.configureOptions.power"/>
                           </span>
                        </a>
                     </li>
                     <li>
                        <a href="vmConfigAdvancedOptionsSetup.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>">
                           <span id="l10n_vmDetails_tab_summary_commands_configureOptions_advanced">
                              <bean:message key="vmDetails.tab.summary.commands.configureOptions.advanced"/>
                           </span>
                        </a>
                     </li>
                  </ul>
                  <li>
                     <script language="JavaScript">document.write('<a href="VMDirectSetup.do?&vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>&vmName='+escape('<wc:jsSafe name="vmTabView" property="vmDataItem.name"/>')+'">');</script>
                        <bean:message key="vmDetails.tab.summary.commands.vmDirect.heading"/>
                     </a>
                  </li>        
                   
               </ul>
            </dd>
         </dl>
      </div>
   </div>
</div>
