<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.view.viewhelper.VmDiskView,
                 com.vmware.webcenter.control.action.vmconfiguration.RemoveHardwareAction" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="BACKINGTYPE_FLATVER2BACKING"
   value="<%= VmDiskView.BACKINGTYPE_FLATVER2BACKING %>" scope="page" />
<c:set var="BACKINGTYPE_RAWDISKMAPPINGBACKING"
   value="<%= VmDiskView.BACKINGTYPE_RAWDISKMAPPINGBACKING %>" scope="page" />
<c:set var="BACKINGTYPE_FILEBACKING"
   value="<%= Constants.DEVICE_FILEBACKING %>" scope="page" />

<script type="text/javascript">
   window.hardware = {
      oDiv : null,
      iDiv : null,
      handleSelect : null,
      onClickFunc : null,
      title : null
   };

   window.hardware.handleSelect = function(type, id, display, canRemove, fileOpOffer) {
      var h = window.hardware;

      //reset any selected node - idiv,odiv, onclick
      if (h.oDiv) { h.oDiv.className = "listKeyHilite"; }
      if (h.iDiv) { h.iDiv.className = "listKey"; }
      if (h.onClickFunc) {
         h.oDiv.parentNode.ondblclick = h.oDiv.parentNode.onclick;
         h.oDiv.parentNode.onclick = h.onClickFunc;
      }
      if(h.title) {
         h.oDiv.parentNode.title = h.title;
      }

      //select new node - idiv, odiv, onclick (equal to the dblclick)
      var divKey = type + (id != null ? ("_" + id) : "");
      h.oDiv = document.getElementById("hardware_outer_" + divKey);
      h.iDiv = document.getElementById("hardware_inner_" + divKey);
      h.onClickFunc = h.oDiv.parentNode.onclick;
      h.title = h.oDiv.parentNode.title;

      h.oDiv.parentNode.onclick = h.oDiv.parentNode.ondblclick;
      if (!vpx.xua.ie) {
         /**
          * IE behaves differently than other browsers upon double click. It
          * sends one "click" event, and one "double click" event, whereas
          * most user agents send two "click" events and one "double click"
          * event. Thus, upon receiving a "double click" event in IE, you
          * know that to mimic other user agents, you need to send a synthetic
          * "click" event.
          */
         h.oDiv.parentNode.ondblclick = null;
      }
      h.oDiv.className = "listKeyHilite listKeyHilited";
      h.iDiv.className = "listKey listKeySlctd listKeyParent";
      h.oDiv.parentNode.title = "<bean:message key="vpxbrowser.node.branch.tooltip.selected"/>";

      //setup the command section
      showHardwareCommands(canRemove, fileOpOffer);
      document.getElementById("cmd_hardware").innerHTML = display;
      document.getElementById("cmd_hardware_none").style.display = "none";
      var aTag = h.oDiv.parentNode;
      document.getElementById("cmd_hardware_edit").firstChild.onclick = aTag.onclick;
      var removeLink = "vmConfigRemoveHardware.do?<%=RemoveHardwareAction.PARAM_TYPE%>=" + type + "&<%=RemoveHardwareAction.PARAM_ID%>=" + id;
      document.getElementById("cmd_hardware_remove").firstChild.href = removeLink;
      document.getElementById("cmd_hardware_remove-delete").firstChild.href = removeLink + "&<%=RemoveHardwareAction.PARAM_FILEOP%>=" + fileOpOffer;


   };


   /**
    * This is a workaround for BUG 95807-  Random device links appear blue and misbehave
    * For some reason, sometimes extra "<a>" tags are generated above and below the hardware names.
    * These <a> tags have nothing in between the open and closing </a>.
    * This workaround looks for these misplaced <a> sets, and reloads the page if any are detected.
    */
   window.hardware.selfCheck = function () {
      var hardwareContainer = document.getElementById("hardwareTableContainer");
      var links = hardwareContainer.getElementsByTagName("a");
      for (i = 0; i < links.length; i++ ) {
         if (!links[i].getElementsByTagName("div")[0]) {
            document.location.reload();
         }
      }
   }
</script>

<div class="titlebar">
   <table border="0" cellspacing="0" cellpadding="0">
      <tr>
         <td width="100%">
            <span id="l10n_vmDetails_tab_summary_hardware_header" class="sectionTitle">
               <bean:message key="vmDetails.tab.summary.hardware.header"/>
            </span>
         </td>
         <%--
         <td>
            <div class="maximize-12x12 icon" title="<bean:message key="sectionWindow.tab.tip"/>"
            onclick="window.parent.onTabSelect('<%= Constants.TAB_VM_HARDWARE %>')"/>
         </td>
         --%>
         <td>
            <div class="shadeCtrl-12x12 icon" title="<bean:message key="sectionWindow.fold.tip"/>"
            onclick="toggleShadeState('hardware');" />
         </td>
      </tr>
   </table>
</div>

<div id="hardwareTableContainer" class="listView" style="overflow:auto;">
   <table id="hardwareTable" class="listView deviceList" border="0" cellspacing="0" cellpadding="0">
      <colgroup>
         <col />
         <col style="width:40%;" />
         <col style="width:60%;" />
      </colgroup>
      <tr>
         <td class="lcol listKeyIcon"><div class="processor-16x16 icon"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               onclick="window.hardware.handleSelect('cpu', null, '<bean:message key="vmDetails.tab.summary.hardware.vCpus"/>', false, null); return false;"
               ondblclick="window.location.href = 'vmConfigCpuSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}' />'; return false;">
               <div id="hardware_outer_cpu" class="listKeyHilite">
                  <div id="hardware_inner_cpu" class="listKey">
                     <span id="l10n_vmDetails_tab_summary_hardware_vCpus">
                        <bean:message key="vmDetails.tab.summary.hardware.vCpus"/>
                     </span>
                  </div>
               </div>
            </a>
         </td>
         <!-- td class="listKey"><div class="listKeyHilite" style="cursor:pointer; color:#999; border-color:#f90; background-color:#fc0;"><div class="listKey" style="border-right: solid 1px #f90; background-color:#fff;">Processors</div></div></td -->
         <td>
            <div>
               <span id="<c:out value='${vmTabView.vmDataItem.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.virtualCPUs.count"/>"><c:out value="${vmTabView.vmDataItem.numCpus}"/></span>
            </div>
         </td>
      </tr>
      <tr>
         <td class="lcol listKeyIcon"><div class="memory-16x16 icon"></div></td>
         <!-- td class="listKey"><div class="listKeyHilite" style="cursor:pointer; color:#999; border-color:#f90; background-color:#fc0;"><div class="listKey" style="border-right: solid 1px #f90; background-color:#fff;">Memory</div></div></td -->
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               onclick="window.hardware.handleSelect('mem', null, '<bean:message key="vmDetails.tab.summary.hardware.memory"/>', false, null); return false;"
               ondblclick="window.location.href = 'vmConfigMemorySetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>'; return false;">
               <div id="hardware_outer_mem" class="listKeyHilite">
                  <div id="hardware_inner_mem" class="listKey">
                     <span id="l10n_vmDetails_tab_summary_hardware_memory"><bean:message key="vmDetails.tab.summary.hardware.memory"/></span>
                  </div>
               </div>
            </a>
         </td>
         <td>
            <div>
               <span id="<c:out value='${vmTabView.vmDataItem.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.memory.sizeMb"/>">
                  <wc:out name="vmTabView" property="vmDataItem.memoryMB" in="mb"/>
               </span>
            </div>
         </td>
      </tr>

   <logic:iterate id="hd" name="vmView" property="disks">
      <tr>
         <td class="lcol listKeyIcon"><div class="virtualDisk-16x16 icon"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               <c:choose>
                  <c:when test="${hd.backingType == BACKINGTYPE_RAWDISKMAPPINGBACKING}">
                     onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.DISK%>', '<c:out value='${hd.ID}'/>', '<c:out value='${hd.name}'/>', <c:out value='${vmTabView.vmDataItem.canRemoveRDMPrivilege}'/>, '<%=RemoveHardwareAction.FILE_OP_DELETE%>'); return false;"
                  </c:when>
                  <c:otherwise>
                     onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.DISK%>', '<c:out value='${hd.ID}'/>', '<c:out value='${hd.name}'/>', <c:out value='${vmTabView.vmDataItem.canRemoveDiskPrivilege}'/>, '<%=RemoveHardwareAction.FILE_OP_DELETE%>'); return false;"
                  </c:otherwise>
               </c:choose>
               ondblclick="window.location.href = 'vmConfigHdSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&hdKey=<c:out value='${hd.key}'/>'; return false;">
               <div id="hardware_outer_<%=RemoveHardwareAction.DISK%>_<c:out value='${hd.ID}'/>" class="listKeyHilite">
                  <div id="hardware_inner_<%=RemoveHardwareAction.DISK%>_<c:out value='${hd.ID}'/>" class="listKey">
                     <span id="<c:out value='${hd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.hardDisk.name"/>"><c:out value="${hd.name}"/></span>&nbsp;(<span id="<c:out value='${hd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.hardDisk.controllerType"/>"><logic:equal name="hd" property="controllerType" value="<%=Constants.CONTROLLER_SCSI%>"><bean:message key="vmDetails.tab.summary.hardware.controller.scsi"/></logic:equal><logic:equal name="hd" property="controllerType" value="<%=Constants.CONTROLLER_IDE%>"><bean:message key="vmDetails.tab.summary.hardware.controller.ide"/></logic:equal></span>&nbsp;<span id="<c:out value='${hd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.hardDisk.controllerId"/>"><c:out value="${hd.controllerId}"/></span>:<span id="<c:out value='${hd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.hardDisk.deviceNumber"/>"><c:out value="${hd.deviceNumber}"/></span>)
                  </div>
               </div>
            </a>
         </td>
         <td>
            <div>
               <span id="<c:out value='${hd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.hardDisk.size"/>"><wc:out name="hd" property="sizeKB" in="kb"/></span>
            </div>
         </td>
      </tr>
   </logic:iterate>

   <logic:iterate id="nic" name="vmView" property="networkAdaptors">
      <tr>
         <td class="lcol listKeyIcon"><div class="networkAdapter<logic:equal name="nic" property="connected" value="false">Disconnected</logic:equal>-16x16 icon"
                                           id="<c:out value='${nic.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.NETWORK_ADAPTOR%>', '<c:out value='${nic.ID}'/>', '<c:out value='${nic.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, null); return false;"
               ondblclick="window.location.href = 'vmConfigNicSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&nicKey=<c:out value='${nic.key}'/>'; return false;">
               <div id="hardware_outer_<%=RemoveHardwareAction.NETWORK_ADAPTOR%>_<c:out value='${nic.ID}'/>" class="listKeyHilite">
                  <div id="hardware_inner_<%=RemoveHardwareAction.NETWORK_ADAPTOR%>_<c:out value='${nic.ID}'/>" class="listKey">
                     <span id="<c:out value='${nic.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.nic.name"/>"><c:out value="${nic.name}"/></span>
                  </div>
               </div>
            </a>
         </td>
         <td>
            <div>
               <span id="<c:out value='${nic.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.nic.network"/>"><c:out value="${nic.networkName}"/></span>
            </div>
         </td>
      </tr>
   </logic:iterate>

   <logic:iterate id="cd" name="vmView" property="cdDvds">
      <tr>
         <td class="lcol listKeyIcon"><div class="cdDvdDrive<logic:equal name="cd" property="connected" value="false">Disconnected</logic:equal>-16x16 icon"
                                           id="<c:out value='${cd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.CD_DVD%>', '<c:out value='${cd.ID}'/>', '<c:out value='${cd.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, null); return false;"
               ondblclick="window.location.href = 'vmConfigCdDvdSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&cdKey=<c:out value='${cd.key}'/>'; return false;">
               <div id="hardware_outer_<%=RemoveHardwareAction.CD_DVD%>_<c:out value='${cd.ID}'/>" class="listKeyHilite">
                  <div id="hardware_inner_<%=RemoveHardwareAction.CD_DVD%>_<c:out value='${cd.ID}'/>" class="listKey">
                     <span id="<c:out value='${cd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.cd.name"/>"><c:out value="${cd.name}"/></span>&nbsp;(<span id="<c:out value='${cd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.cd.controllerType"/>"><logic:equal name="cd" property="controllerType" value="<%=Constants.CONTROLLER_IDE%>"><bean:message key="vmDetails.tab.summary.hardware.controller.ide"/></logic:equal><logic:equal name="cd" property="controllerType" value="<%=Constants.CONTROLLER_SCSI%>"><bean:message key="vmDetails.tab.summary.hardware.controller.scsi"/></logic:equal></span>&nbsp;<span id="<c:out value='${cd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.cd.controllerId"/>"><c:out value="${cd.controllerId}"/></span>:<span id="<c:out value='${cd.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.cd.deviceNumber"/>"><c:out value="${cd.deviceNumber}"/></span>)
                  </div>
               </div>
            </a>
         </td>
         <td id="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>">
            <div id="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type.device' bundle='${internalResources}'/>"
               name="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="cd" property="backingType" value="<%= Constants.DEVICE_DEVICEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <c:set var='deviceArg'>
                  </span><span class="nowrap" id="<c:out value='${cd.deviceBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.deviceName'/>"><c:out value="${cd.deviceBacking.deviceName}"/></span>
               </c:set>
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_deviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.deviceBacking" arg0="${deviceArg}"/>
            </div>
            <div id="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type.file' bundle='${internalResources}'/>"
               name="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="cd" property="backingType" value="<%= Constants.DEVICE_FILEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_fileBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.fileBacking"/></span>
               <span class="nowrap" id="<c:out value='${cd.fileBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.fileName'/>"><c:out value="${cd.fileBacking.fileName}"/></span>
            </div>
            <div id="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type.remote' bundle='${internalResources}'/>"
               name="<c:out value='${cd.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="cd" property="backingType" value="<%= Constants.DEVICE_REMOTE_BACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_remoteDeviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.remoteDeviceBacking"/></span>
            </div>
         </td>
      </tr>
   </logic:iterate>

   <logic:iterate id="flp" name="vmView" property="floppies">
      <tr>
         <td class="lcol listKeyIcon"><div class="floppyDrive<logic:equal name="flp" property="connected" value="false">Disconnected</logic:equal>-16x16 icon"
                                           id="<c:out value='${flp.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               <c:choose>
                  <c:when test="${flp.backingType == BACKINGTYPE_FILEBACKING}">
                     onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.FLOPPY%>', '<c:out value='${flp.ID}'/>', '<c:out value='${flp.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, '<%=RemoveHardwareAction.FILE_OP_DELETE%>'); return false;"
                  </c:when>
                  <c:otherwise>
                     onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.FLOPPY%>', '<c:out value='${flp.ID}'/>', '<c:out value='${flp.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, null); return false;"
                  </c:otherwise>
               </c:choose>
               ondblclick="window.location.href = 'vmConfigFloppySetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&flpKey=<c:out value='${flp.key}'/>'; return false;">
               <div id="hardware_outer_<%=RemoveHardwareAction.FLOPPY%>_<c:out value='${flp.ID}'/>" class="listKeyHilite">
                  <div id="hardware_inner_<%=RemoveHardwareAction.FLOPPY%>_<c:out value='${flp.ID}'/>" class="listKey">
                     <span id="<c:out value='${flp.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.floppy.name"/>"><c:out value="${flp.name}"/></span>
                  </div>
               </div>
            </a>
         </td>
         <td id="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>">
            <div id="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type.device' bundle='${internalResources}'/>"
               name="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="flp" property="backingType" value="<%= Constants.DEVICE_DEVICEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <c:set var='deviceArg'>
                  </span><span class="nowrap" id="<c:out value='${flp.deviceBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.deviceName'/>"><c:out value="${flp.deviceBacking.deviceName}"/></span>
               </c:set>
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_deviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.deviceBacking" arg0="${deviceArg}"/></span>
            </div>
            <div id="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type.file' bundle='${internalResources}'/>"
               name="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="flp" property="backingType" value="<%= Constants.DEVICE_FILEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_fileBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.fileBacking"/></span>
               <span class="nowrap" id="<c:out value='${flp.fileBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.fileName'/>"><c:out value="${flp.fileBacking.fileName}"/></span>
            </div>
            <div id="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type.remote' bundle='${internalResources}'/>"
               name="<c:out value='${flp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="flp" property="backingType" value="<%= Constants.DEVICE_REMOTE_BACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_remoteDeviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.remoteDeviceBacking"/></span>
            </div>
         </td>
      </tr>
   </logic:iterate>

   <logic:iterate id="scsiCtrl" name="vmView" property="scsiControllers">
      <tr>
         <td class="lcol listKeyIcon"><div class="scsiDevice-16x16 icon"></div></td>
         <td class="listKey">
            <a href="#"
               title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
               onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.SCSI_CONTROLLER%>', '<c:out value='${scsiCtrl.ID}'/>', '<c:out value='${scsiCtrl.name}'/>', false, null); return false;"
               ondblclick="window.location.href = 'vmConfigScsiCtrlSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&ctrlKey=<c:out value='${scsiCtrl.key}'/>'; return false;">
               <div id="hardware_outer_<%=RemoveHardwareAction.SCSI_CONTROLLER%>_<c:out value='${scsiCtrl.ID}'/>" class="listKeyHilite">
                  <div id="hardware_inner_<%=RemoveHardwareAction.SCSI_CONTROLLER%>_<c:out value='${scsiCtrl.ID}'/>" class="listKey">
                     <span id="<c:out value='${scsiCtrl.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiCtrl.name"/>"><c:out value="${scsiCtrl.name}"/></span>
                  </div>
               </div>
            </a>
         </td>
         <td>
            <div>
               <span id="<c:out value='${scsiCtrl.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiCtrl.scsiType"/>">
               <logic:equal name="scsiCtrl" property="scsiType" value="<%= Constants.DEVICE_SCSI_LSILOGIC %>">
                  <bean:message key="vmConfiguration.scsiCtrl.virtualDevice.type.lsiLogic"/>
               </logic:equal>
               <logic:equal name="scsiCtrl" property="scsiType" value="<%= Constants.DEVICE_SCSI_BUSLOGIC %>">
                  <bean:message key="vmConfiguration.scsiCtrl.virtualDevice.type.busLogic"/>
               </logic:equal>
               </span>
            </div>
         </td>
      </tr>
   </logic:iterate>

   <logic:iterate id="scsiPt" name="vmView" property="scsiPassthroughs">
      <tr>
         <td class="lcol listKeyIcon"><div class="scsiDevice-16x16 icon"
                                           id="<c:out value='${scsiPt.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
            <td class="listKey">
               <a href="#"
                  title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
                  onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.SCSI_PASSTHROUGH%>', '<c:out value='${scsiPt.ID}'/>', '<c:out value='${scsiPt.name}'/>', <c:out value='${vmTabView.vmDataItem.canRemoveRDMPrivilege}'/>, null); return false;"
                  ondblclick="window.location.href = 'vmConfigGenericScsiSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&sptKey=<c:out value='${scsiPt.key}'/>'; return false;">
                  <div id="hardware_outer_<%=RemoveHardwareAction.SCSI_PASSTHROUGH%>_<c:out value='${scsiPt.ID}'/>" class="listKeyHilite">
                     <div id="hardware_inner_<%=RemoveHardwareAction.SCSI_PASSTHROUGH%>_<c:out value='${scsiPt.ID}'/>" class="listKey">
                        <span id="<c:out value='${scsiPt.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiPt.name"/>"><c:out value="${scsiPt.name}"/></span>&nbsp;(<span id="<c:out value='${scsiPt.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiPt.controllerType"/>"><c:out value="${scsiPt.controllerType}"/></span>&nbsp;<span id="<c:out value='${scsiPt.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiPt.controllerId"/>"><c:out value="${scsiPt.controllerId}"/></span>:<span id="<c:out value='${scsiPt.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.scsiPt.deviceNumber"/>"><c:out value="${scsiPt.deviceNumber}"/></span>)
                     </div>
                  </div>
               </a>
            </td>
            <td>
               <div>
                  <c:out value="${scsiPt.summary}"/>
               </div>
            </td>
         </tr>
      </logic:iterate>

      <logic:iterate id="sp" name="vmView" property="serialPorts">
         <tr>
            <td class="lcol listKeyIcon"><div class="serialPort<logic:equal name="sp" property="connected" value="false">Disconnected</logic:equal>-16x16 icon"
                                              id="<c:out value='${sp.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
            <td class="listKey">
               <a href="#"
                  title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
                  onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.SERIAL_PORT%>', '<c:out value='${sp.ID}'/>', '<c:out value='${sp.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, null); return false;"
                  ondblclick="window.location.href = 'vmConfigSerialPortSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&spKey=<c:out value='${sp.key}'/>'; return false;">
                  <div id="hardware_outer_<%=RemoveHardwareAction.SERIAL_PORT%>_<c:out value='${sp.ID}'/>" class="listKeyHilite">
                     <div id="hardware_inner_<%=RemoveHardwareAction.SERIAL_PORT%>_<c:out value='${sp.ID}'/>" class="listKey">
                        <span><c:out value="${sp.name}"/></span>
                     </div>
                  </div>
               </a>
            </td>
         <td id="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>">
            <div id="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type.device' bundle='${internalResources}'/>"
               name="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="sp" property="backingType" value="<%= Constants.DEVICE_DEVICEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <c:set var='deviceArg'>
                  </span><span class="nowrap" id="<c:out value='${sp.deviceBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.deviceName'/>"><c:out value="${sp.deviceBacking.deviceName}"/></span>
               </c:set>
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_deviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.deviceBacking" arg0="${deviceArg}"/></span>
            </div>
            <div id="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type.file' bundle='${internalResources}'/>"
               name="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="sp" property="backingType" value="<%= Constants.DEVICE_FILEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_fileBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.fileBacking"/></span>
               <span class="nowrap" id="<c:out value='${sp.fileBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.fileName'/>"><c:out value="${sp.fileBacking.fileName}"/></span>
            </div>
            <div id="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type.pipe' bundle='${internalResources}'/>"
               name="<c:out value='${sp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="sp" property="backingType" value="<%= Constants.DEVICE_PIPEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_pipeBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.pipeBacking"/></span>
               <span class="nowrap" id="<c:out value='${sp.pipeBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.pipeName'/>"><c:out value="${sp.pipeBacking.pipeName}"/></span>
            </div>
         </td>
         </tr>
      </logic:iterate>

      <logic:iterate id="pp" name="vmView" property="parallelPorts">
         <tr>
            <td class="lcol listKeyIcon"><div class="parallelPort<logic:equal name="pp" property="connected" value="false">Disconnected</logic:equal>-16x16 icon"
                                              id="<c:out value='${pp.ID}'/>_<bean:message bundle="internalResources" key="vm.hardware.connected"/>"></div></td>
            <td class="listKey">
               <a href="#"
                  title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>"
                  onclick="window.hardware.handleSelect('<%=RemoveHardwareAction.PARALLEL_PORT%>', '<c:out value='${pp.ID}'/>', '<c:out value='${pp.name}'/>', <c:out value='${vmTabView.vmDataItem.canAddRemoveDevicePrivilege}'/>, null); return false;"
                  ondblclick="window.location.href = 'vmConfigParallelPortSetup.do?vmId=<c:out value='${vmTabView.vmDataItem.ID}'/>&ppKey=<c:out value='${pp.key}'/>'; return false;">
                  <div id="hardware_outer_<%=RemoveHardwareAction.PARALLEL_PORT%>_<c:out value='${pp.ID}'/>" class="listKeyHilite">
                     <div id="hardware_inner_<%=RemoveHardwareAction.PARALLEL_PORT%>_<c:out value='${pp.ID}'/>" class="listKey">
                        <span><c:out value="${pp.name}"/></span>
                     </div>
                  </div>
               </a>
            </td>
            <td id="<c:out value='${pp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>">
            <div id="<c:out value='${pp.ID}'/>_<fmt:message key='vm.hardware.backing.type.device' bundle='${internalResources}'/>"
               name="<c:out value='${pp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="pp" property="backingType" value="<%= Constants.DEVICE_DEVICEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <c:set var='deviceArg'>
                  </span><span class="nowrap" id="<c:out value='${pp.deviceBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.deviceName'/>"><c:out value="${pp.deviceBacking.deviceName}"/></span>
               </c:set>
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_deviceBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.deviceBacking" arg0="${deviceArg}"/></span>
            </div>
            <div id="<c:out value='${pp.ID}'/>_<fmt:message key='vm.hardware.backing.type.file' bundle='${internalResources}'/>"
               name="<c:out value='${pp.ID}'/>_<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>"
               <logic:notEqual name="pp" property="backingType" value="<%= Constants.DEVICE_FILEBACKING %>">
                  style="display:none;"
               </logic:notEqual>
            >
               <span class="nowrap" id="l10n_vmDetails_tab_summary_hardware_connected_fileBacking"><bean:message key="vmDetails.tab.summary.hardware.connected.fileBacking"/></span>
               <span class="nowrap" id="<c:out value='${pp.fileBacking.ID}'/>_<bean:message bundle='internalResources' key='vm.hardware.backing.fileName'/>"><c:out value="${pp.fileBacking.fileName}"/></span>
            </div>
         </td>
         </tr>
      </logic:iterate>

      <%-- Not implemented for Beta1
         <tr>
            <td class="lcol listKeyIcon"><div class="usbDevice-16x16 icon" /></td>
            <td class="listKey">
               <a href="vmConfigUSBSetup.do?vmId=mockup_ID" title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">

               <div class="listKeyHilite">
                  <div class="listKey">
                     <span>mockup USB controller</span>

                  </div>
               </div>
                </a>
            </td>
            <td><div>autoconnect xxx</div></td>
         </tr>
      --%>
      
      <%-- CreateVm link was provided onlye for QA on Gilad's request
      
          <tr>
            <td class="lcol listKeyIcon"><div class="usbDevice-16x16 icon" /></td>
            <td class="listKey">
               <a href="wzrdVMInit.do" title="<bean:message key="vpxbrowser.node.branch.tooltip.unselected"/>">

               <div class="listKeyHilite">
                  <div class="listKey">
                     <span>Create VM</span>

                  </div>
               </div>
                </a>
            </td>
            <td>&nbsp;</td>
         </tr>
         
         --%>
      
   </table>
</div>
