<%@ page import="com.vmware.webcenter.util.VMODLConstants, 
   com.vmware.webcenter.control.action.VmToolsOperationsAction,
   com.vmware.webcenter.view.viewhelper.Constants" %>
<%@ taglib uri="/tags/struts-bean" prefix="bean" %>
<%@ taglib uri="/tags/struts-logic" prefix="logic" %>

<script language="JavaScript" type="text/javascript">


function setPowerState(state) {

   var powerIcon = document.getElementById("statusPowerStateIcon");
   var powerIconToolTip = document.getElementById("statusPowerStateText");

   switch (state) {
      case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>" :
	 powerIcon.className = "powerOff-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_poweredOff'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.poweredOff"/>" +
	     "</span>";
	 break;
      case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" :
	 powerIcon.className = "powerOn-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_poweredOn'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.poweredOn"/>" +
	     "</span>";
	 break;
      case "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>" :
	 powerIcon.className = "suspend-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_suspended'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.suspended"/>" +
	     "</span>";
	 break;

      case "<%= Constants.POWERING_OFF %>" :
	 powerIcon.className = "poweringOff-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_poweringOff'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.poweringOff"/>" +
	     "</span>";
	 break;
     case "<%= Constants.POWERING_ON %>" :
	 powerIcon.className = "poweringOn-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_poweringOn'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.poweringOn"/>" +
	     "</span>";
	 break;
      case "<%= Constants.SUSPENDING %>" :
	 powerIcon.className = "suspending-16x16";
	 powerIconToolTip.innerHTML = "<span id='l10n_vmDetails_tab_summary_status_powerState_suspending'>" +
	     "<bean:message key="vmDetails.tab.summary.status.powerState.suspending"/>" +
	     "</span>";
	 break;

   }
 }

function setGos(strGosText, strGosFamily) {
  var imgGosIcon = document.getElementById("statusGosIcon");
  var spanGosText = document.getElementById("statusGosText");
  if (strGosText == null || strGosText == "") {
    strGosText = "<bean:message key="vmDetails.tab.summary.status.guestOS.noSupport"/>";
  }
  spanGosText.innerHTML = strGosText;
  switch (strGosFamily) {
    case "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_WINDOWSGUEST %>" :
	  imgGosIcon.className = "win32-16x16";
	  break;
    case "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_LINUXGUEST %>" :
	  imgGosIcon.className = "linux-16x16";
	  break;
    case "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_NETWAREGUEST %>" :
	  imgGosIcon.className = "netware-16x16";
	  break;
    case "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_SOLARISGUEST %>" :
	  imgGosIcon.className = "solaris-16x16";
	  break;
    case "<%= VMODLConstants.VIRTUALMACHINEGUESTOSFAMILY_OTHERGUESTFAMILY %>" :
	  imgGosIcon.className = "unknownGuestOs-16x16";
	  break;
    default: 
	  imgGosIcon.className = "unknownGuestOs-16x16";
  }
}

function setToolsState(strToolsState, strPowerState, boolToolsMounted) {
  hideToolsStatusTexts();
   
  var imgToolsIcon = document.getElementById("statusToolsIcon");
  if (strToolsState == "<%= VMODLConstants.VIRTUALMACHINETOOLSSTATUS_TOOLSOK %>") {
     imgToolsIcon.className = "tools-16x16";
  } else {
     imgToolsIcon.className = "toolsNotAvailable-16x16";
  }
 
  if (boolToolsMounted == true && strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>" ) {
  	  toggleToolsUnMountText(true);
  	  return;
  } 
  
  switch (strToolsState) {
	case "<%= VMODLConstants.VIRTUALMACHINETOOLSSTATUS_TOOLSNOTINSTALLED %>" :
	  if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>") {
	    document.getElementById("lnkInstallTools").style.display = "";	       	    
	  } else {
	    document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_notInstalled").style.display = "";
	  }
	  break;
	case "<%= VMODLConstants.VIRTUALMACHINETOOLSSTATUS_TOOLSNOTRUNNING %>" :
	  document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_notRunning").style.display = "";
	  break;
	case "<%= VMODLConstants.VIRTUALMACHINETOOLSSTATUS_TOOLSOLD %>" :
	  if (strPowerState == "<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDON %>") {
	    document.getElementById("lnkUpgradeTools").style.display = "";
	  } else {
	    document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_old").style.display = "";
	  }
	  break;
	case "<%= VMODLConstants.VIRTUALMACHINETOOLSSTATUS_TOOLSOK %>" :
	  document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_ok").style.display = "";
	  break;
	default :
	  document.getElementById("l10n_vmDetails_tab_summary_status_unknown").style.display = "";
  }
}

function hideToolsStatusTexts(){
	document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_notInstalled").style.display = "none";
	document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_notRunning").style.display = "none";
	document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_old").style.display = "none";
	document.getElementById("l10n_vmDetails_tab_summary_status_vmwareTools_ok").style.display = "none";
	document.getElementById("l10n_vmDetails_tab_summary_status_unknown").style.display = "none";
	document.getElementById("lnkUpgradeTools").style.display = "none";
	document.getElementById("lnkInstallTools").style.display = "none";
	document.getElementById("divUnmountTools").style.display = "none";
	document.getElementById("divMountingTools").style.display = "none";
}

function performToolsOp(strToolsOp) {
  var strToolsCmd = "vmToolsOps.do?vmId=<bean:write name="vmTabView" property="vmDataItem.ID"/>&toolsOp=" + strToolsOp ;  
  req = tle.getRequest(strToolsCmd);
  try {
    req.send();
  } finally {
    tle.releaseRequest(req);
  }
}

function mountToolsCd(){
  performToolsOp("<%= VmToolsOperationsAction.OP_VM_TOOLS_MOUNT %>");
  displayMountingStatus(); 
}

function upgradeTools(){
  performToolsOp("<%= VmToolsOperationsAction.OP_VM_TOOLS_UPGRADE %>");
  displayMountingStatus(); 
}

function unMountToolsCd(){
  performToolsOp("<%= VmToolsOperationsAction.OP_VM_TOOLS_UNMOUNT %>");
}

function toggleToolsUnMountText(boolShow){
  document.getElementById("divUnmountTools").style.display = boolShow ? "" : "none";	
}

function toggleToolsUnMountTextDisabled(boolDisabled){
   var unmountLink = document.getElementById("aHrefUnmountTools");
   if (boolDisabled) {
      vpx.xua.addClass(unmountLink, "disabled");
      unmountLink.href = "javascript:;";      
   } else {
      vpx.xua.removeClass(unmountLink, "disabled");
      unmountLink.href = "javascript:unMountToolsCd();";
   }
}

function toggleToolsMountTextDisabled(boolDisabled){
   var installToolsLink = document.getElementById("lnkInstallTools");
   var upgradeToolsLink = document.getElementById("lnkUpgradeTools");
   if (boolDisabled) {
      vpx.xua.addClass(installToolsLink, "disabled");
      installToolsLink.href = "javascript:;";
      vpx.xua.addClass(upgradeToolsLink, "disabled");
      upgradeToolsLink.href = "javascript:;";
   } else {
      vpx.xua.removeClass(installToolsLink, "disabled");      
      installToolsLink.href = "javascript:mountToolsCd();";
      vpx.xua.removeClass(upgradeToolsLink, "disabled");      
      upgradeToolsLink.href = "javascript:upgradeTools();";
   }
}

function displayMountingStatus(){
  hideToolsStatusTexts();
  document.getElementById("divMountingTools").style.display = "";
}


</script>
	<div class="titlebar">
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td width="100%">
					<span class="sectionTitle" id="l10n_vmDetails_tab_summary_status_header">
                  <bean:message key="vmDetails.tab.summary.status.header"/>
               </span>
				</td>
            <td>
               <div class="shadeCtrl-12x12 icon" title="<bean:message key="sectionWindow.fold.tip"/>" onclick="toggleShadeState('status');" />
  			</td>
			</tr>
    </table>
  </div>
	<div class="enum">
		<div class="cntnr">
         <div>
            <dl>
               <dt>
			<div class="statusIcons">
				<div>
					<img id="statusPowerStateIcon" src="imx/spacer.png" />
				</div>
			</div>
						<span id="l10n_vmDetails_tab_summary_status_powerState">
                     <bean:message key="vmDetails.tab.summary.status.powerState"/>
                  </span>
					</dt>
               <dd>
                  <div id="statusPowerStateText">&nbsp;</div>
               </dd>

					<dt>
                  <div class="statusIcons">
                     <div>
                        <img id="statusGosIcon" src="imx/spacer.png" />
                     </div>
                  </div>
						<span id="l10n_vmDetails_tab_summary_status_guestOS">
                     <bean:message key="vmDetails.tab.summary.status.guestOS"/>
                  </span>
					</dt>
               <dd>
                  <span id="statusGosText">&nbsp;</span>
               </dd>

					<dt>
                  <div class="statusIcons">
                     <div>
                        <img id="statusToolsIcon" src="imx/spacer.png" />
                     </div>
                  </div>
						<span id="l10n_vmDetails_tab_summary_status_vmwareTools">
                     <bean:message key="vmDetails.tab.summary.status.vmwareTools"/>
                  </span>
					</dt>
               <dd>
                  <div id="statusToolsText">
					      <span id='l10n_vmDetails_tab_summary_status_vmwareTools_notRunning' style="display:none;">
                        <bean:message key="vmDetails.tab.summary.status.vmwareTools.notRunning"/>
                     </span>
					      <span id='l10n_vmDetails_tab_summary_status_vmwareTools_notInstalled' style="display:none;">
                        <bean:message key="vmDetails.tab.summary.status.vmwareTools.notInstalled"/>
                     </span>
                     <a href='javascript:mountToolsCd();' id="lnkInstallTools" style="display:none;"><span id='l10n_vmDetails_tab_summary_status_vmwareTools_installTools'><bean:message key="vmDetails.tab.summary.status.vmwareTools.installTools"/></span></a>
                     <span id='l10n_vmDetails_tab_summary_status_vmwareTools_old' style="display:none;">
                        <bean:message key="vmDetails.tab.summary.status.vmwareTools.old"/>
                     </span>
                     <a href='javascript:upgradeTools();' id="lnkUpgradeTools" style="display:none;"><span id='l10n_vmDetails_tab_summary_status_vmwareTools_upgradeTools'><bean:message key="vmDetails.tab.summary.status.vmwareTools.upgradeTools"/></span></a>
                     <span id='l10n_vmDetails_tab_summary_status_vmwareTools_ok' style="display:none;">
                        <bean:message key="vmDetails.tab.summary.status.vmwareTools.ok"/>
                     </span>
                     <span id='l10n_vmDetails_tab_summary_status_unknown' style="display:none;">
                        <bean:message key="vmDetails.tab.summary.status.unknown"/>
                     </span>
                     
                     <div id="divMountingTools"  style="display:none;">
                        <span id="l10n_vmDetails_tab_summary_status_vmwareTools_mountingToolsCd"><bean:message key="vmDetails.tab.summary.status.vmwareTools.mountingToolsCd"/></span>
                     </div>
                     
                     <div id="divUnmountTools"   style="display:none;">
                        <div id='l10n_vmDetails_tab_summary_status_vmwareTools_toolsMounted'>
                           <bean:message key="vmDetails.tab.summary.status.vmwareTools.toolsMounted"/>
                        </div>
                        <p>
                        <div id='l10n_vmDetails_tab_summary_status_vmwareTools_unmount'>
                           <bean:message key="vmDetails.tab.summary.status.vmwareTools.unmount" arg0="javascript:unMountToolsCd()"/>
                        </div>
                     </div>
                  </div>
               </dd>
               
					<dt>
						<span id="l10n_vmDetails_tab_summary_status_dnsName">
                     <bean:message key="vmDetails.tab.summary.status.dnsName"/>
                  </span>
					</dt>
               <dd><div id="dnsName">
						<logic:notEmpty name="vmTabView" property="guestInfo.dnsName">
							<bean:write name="vmTabView" property="guestInfo.dnsName"/>
						</logic:notEmpty>
						<logic:empty name="vmTabView" property="guestInfo.dnsName">
							<span id="l10n_vmDetails.tab.summary.status.notAvailable">
                        <bean:message key="vmDetails.tab.summary.status.notAvailable"/>
                     </span>
						</logic:empty>
               </div></dd>

					<dt>
						<span id="l10n_vmDetails_tab_summary_status_ipAddresses">
                     <bean:message key="vmDetails.tab.summary.status.ipAddresses"/>
                  </span>
					</dt>
               <dd><div id="ipAddress">
						<logic:notEmpty name="vmTabView" property="guestInfo.ipAddress">
							<ul>
								<li><bean:write name="vmTabView" property="guestInfo.ipAddress"/></li>
							</ul>
						</logic:notEmpty>
						<logic:empty name="vmTabView" property="guestInfo.ipAddress">
							<span id="l10n_vmDetails.tab.summary.status.notAvailable">
                        <bean:message key="vmDetails.tab.summary.status.notAvailable"/>
                     </span>
						</logic:empty>
               </div></dd>
				</dl>
			</div>
		</div>
      
		<iframe id="toolsCb" name="toolsCb" src="html/blank.html" style="display:none" height="200" width="200"></iframe>
	</div>
