<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp" %>
<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 com.vmware.webcenter.view.viewhelper.ActiveTasksViewImpl,
                 com.vmware.webcenter.util.SortCriteria " %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<c:set var="TASKINFOSTATE_RUNNING" value="<%= VMODLConstants.TASKINFOSTATE_RUNNING %>" scope="page" />
<c:set var="TASKINFOSTATE_ERROR" value="<%= VMODLConstants.TASKINFOSTATE_ERROR %>" scope="page" />
<c:set var="TASKINFOSTATE_SUCCESS" value="<%= VMODLConstants.TASKINFOSTATE_SUCCESS %>" scope="page" />
<c:set var="TASKINFOSTATE_QUEUED" value="<%= VMODLConstants.TASKINFOSTATE_QUEUED %>" scope="page" />

<browserPane
   page="<c:out value='${vmActiveTasksView.currentPageNumber}' />"
   total="<c:out value='${vmActiveTasksView.totalSize}' />">

   <cols sort="<c:out value='${vmActiveTasksView.primarySortCriteria.property}' />"
      dir="<c:out value='${vmActiveTasksView.primarySortCriteria.sortOrder}' />" >

      <col
         name="<%= ActiveTasksViewImpl.SORT_KEY_TRIGGERED %>"
         display="<fmt:message key='vmDetails.tab.summary.activeTasks.colHeader.triggered' bundle='${messageResources}' />"
         canSort="true" />
      <col
         name="<%= ActiveTasksViewImpl.SORT_KEY_TRIGGEREDBY %>"
         display="<fmt:message key='vmDetails.tab.summary.activeTasks.colHeader.triggeredBy' bundle='${messageResources}' />"
         canSort="true" />
      <col
         name="<%= ActiveTasksViewImpl.SORT_KEY_STATE %>"
         display="<fmt:message key='vmDetails.tab.summary.activeTasks.colHeader.status' bundle='${messageResources}' />"
         canSort="true" />
       <col
         name="<%= ActiveTasksViewImpl.SORT_KEY_NAME %>"
         display="<fmt:message key='vmDetails.tab.summary.activeTasks.colHeader.taskName' bundle='${messageResources}' />"
         canSort="true"
         widest="true" />
   </cols>

   <nodes>
      <c:forEach items="${vmActiveTasksView.currentPage}" var="task" varStatus="iterStatus">
        <c:set var="status" value="${task.state}"/>
         <node id="<c:out value='${task.ID}' />" iconClass="task-16x16" selectable="false">
            <col><cell>
               <fmt:formatDate value="${task.triggered}"  type="both" timeStyle="long" dateStyle="short"/>
            </cell></col>
            <col><cell><c:out value="${task.triggeredBy}"/></cell></col>
            <col><cell>
               <c:if test="${status == TASKINFOSTATE_SUCCESS || status == TASKINFOSTATE_QUEUED}">
                    <table><tr><td> <div class="okay-12x12 icon"/> </td><td class="nowrap"><c:out value="${task.stateDisplay}"/></td></tr></table>
               </c:if>
               <c:if test="${status == TASKINFOSTATE_ERROR}">
                    <table><tr><td><div class="error-12x12 icon"/> </td><td class="nowrap"><c:out value="${task.stateDisplay}"/></td></tr></table>
               </c:if>
               <c:if test="${status == TASKINFOSTATE_RUNNING}">
                 <table id="${'progressBarTable'}:${task.ID}">
                   <tr>
                  <c:choose>
                     <c:when test="${task.progress >= 0}">
                        <c:set var="taskBarPct" value="${'taskBarPct'}:${task.ID}"/>
                        <c:set var="taskBarLabel" value="${'taskBarLabel'}:${task.ID}"/>
                        <c:set var="bgPosition" value="${'background-position:'}${task.progress}${'px;'}"/>  
                                  <td>
                                    <div id="<c:out value="${taskBarPct}"/>" class="perfBarCompact"
                                         style="<c:out value="${bgPosition}"/>" >
                                       <img src="spacer.png" class="vstrut"/>
                                       <table class="perfBarFg">
                                          <tr>
                                             <td class="lcol"/><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td><td></td>
                                          </tr>
                                       </table>
                                    </div>
                                 </td>
                                 <td>
                                    <div class="perfBarLabelCompact nowrap">
                                       <span id="<c:out value='${taskBarLabel}'/>"><c:out value="${task.progress}"/>%</span>
                                    </div>
                                 </td>                     
                      </c:when>
                     <c:otherwise>
                     <td><div id="runningTask:${task.ID}" class="loading-9x9 icon"/> </td><td class="nowrap"><c:out value="${task.stateDisplay}"/></td>
                     </c:otherwise>                     
                  </c:choose>
                    </tr>
                  </table>
               </c:if>
            </cell></col>
            <col><cell><c:out value="${task.displayName}" /></cell></col>
              <attrs>               
               <attr name="taskId" value="<c:out value='${task.ID}' />" />
             </attrs>
         </node>
      </c:forEach>
   </nodes>

   <attrs>
      <attr name="viewId" value="<c:out value='${vmActiveTasksView.ID}' />" />
   </attrs>

</browserPane>
