<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.control.action.passive.UnitsConversionAction,
                 com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/contextTest.jsp" %>

<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>

<link href="css/default.css" rel="stylesheet" type="text/css" />
<link href="css/summary.css" rel="stylesheet" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua,gui,browser,util" />
</jsp:include>
<jsp:include page="/WEB-INF/jsp/common/global.jsp"/>

<script type="text/javascript" src="js/details/tabs/common.js"></script>
<script type="text/javascript" src="js/details/tabs/vmSummary.js"></script>
<script type="text/javascript" src="js/common/performance.js"></script>
<%-- The following javaScript file "fullScreenButtonChecker.js" should be 
     included for all the tabs except the Console tab
--%>
<script type="text/javascript" src="js/details/tabs/fullScreenButtonChecker.js"></script>

<script type="text/javascript">
// initialize performance values
var intMaxCpuUsage = null;
var intMaxMemoryUsage = null;
<logic:notEmpty name="vmTabView" property="vmDataItem.maxCpuUsage" >
   intMaxCpuUsage = <bean:write name="vmTabView" property="vmDataItem.maxCpuUsage" />;
</logic:notEmpty>
<logic:notEmpty name="vmTabView" property="vmDataItem.maxMemoryUsage" >
   intMaxMemoryUsage = <bean:write name="vmTabView" property="vmDataItem.maxMemoryUsage" />;
</logic:notEmpty>

vpx.context.ToolsListener = function() {};
vpx.context.ToolsListener.prototype.propertiesUpdated = function(e) {
   var pc = e.getSource();
   var vmtool = pc.getProperty("<c:out value='${vmTabView.ID}'/>",
      "vmDataItem.guestInfo.vmtool");
   var powerState = pc.getProperty("<c:out value='${vmTabView.ID}'/>",
      "vmDataItem.powerState");
   var instMounted = pc.getProperty("<c:out value='${vmTabView.ID}'/>",
      "vmDataItem.toolsInstallerMounted");


   <%-- see sectionWindows/vmStatusSectionWindow.jsp --%>
   setToolsState(vmtool, powerState, instMounted.toBool());
};

vpx.context.GuestListener = function GuestListener() {};
vpx.context.GuestListener.prototype.propertiesUpdated = function(e) {
   var pc = e.getSource();
   var fullName = pc.getProperty("<c:out value='${vmTabView.ID}'/>",
      "vmDataItem.gosFullName");
   var family = pc.getProperty("<c:out value='${vmTabView.ID}'/>",
      "guestOsDescriptor.family");

   <%-- see sectionWindows/vmStatusSectionWindow.jsp --%>
   setGos(fullName, family);
};

vpx.context.NetworksListener = function() {};
vpx.context.NetworksListener.prototype.propertiesUpdated = function(e) {
   var pc = e.getSource();
   var networkNames = pc.getProperty("<c:out value='${vmView.ID}'/>", "networkNames").split(',');
   var listEl = document.getElementById("related_networks_list");
   var html = '';
   if (networkNames.length == 0) {
      html = '<li><span id="l10n_vmDetails_tab_summary_related_networks_none"><bean:message key="vmDetails.tab.summary.related.networks.none"/></span></li>';
   } else {
      for (var i = 0; i < networkNames.length; i++) {
         html += '<li>' + networkNames[i] + '</li>';
      }
   }
   listEl.innerHTML = html;
};

function vmSummaryOnLoad() {

   <%-- The following function is in fullScreenButtonChecker.js --%>
   initMonitorableFullScreenButton();

   window.parent.switchTab("<%= Constants.TAB_VM_SUMMARY %>");
   window.parent.setTitleIcon("VM");

   window.vmSummaryUpdatesIds = [
      tle.listenForUpdates("<c:out value='${vmTabView.ID}' />", "VmSummaryView",
                           handleVmSummaryUpdates),
      tle.listenForUpdates("<c:out value='${vmView.ID}' />", "VmView",
                           handleVmSummaryUpdates)
   ];

   // Sync view to persistent state
   tle.syncView();

   setupHelp("<bean:message bundle="helpFiles" key="help.vm.summary"/>");

   //Recent Alarms
   <c:if test="${viewManager.multiHost}">
      vpx.context.recentAlarms.browserInit();  <%-- see sectionWindows/vmAlarms.jsp --%>
   </c:if>

   //Active Tasks
   vpx.context.activeTasks.browserInit();   <%-- see sectionWindows/vmActiveTasks.jsp --%>

   // status section window
   setPowerState("<c:out value='${vmView.overallPowerStatus}' />");<%-- see sectionWindows/vmStatusSectionWindow.jsp --%>
   toggleToolsMountTextDisabled("<c:out value='${vmView.vmDataItem.MountToolsInstaller}' />".toBool());
   toggleToolsUnMountTextDisabled("<c:out value='${vmView.vmDataItem.UnmountToolsInstaller}' />".toBool());

   // commands section window
   setCommands("<bean:write name="vmTabView" property="vmDataItem.powerState"/>"); <%-- see sectionWindows/vmCommandsSectionWindow.jsp --%>

   setGos("<bean:write name="vmTabView" property="vmDataItem.gosFullName"/>","<bean:write name="vmTabView" property="guestOsDescriptor.family"/>"); <%-- see sectionWindows/vmStatusSectionWindow.jsp --%>
   setToolsState("<bean:write name="vmTabView" property="guestInfo.vmtool"/>","<bean:write name="vmTabView" property="vmDataItem.powerState"/>",<bean:write name="vmTabView" property="vmDataItem.toolsInstallerMounted"/>); <%-- see sectionWindows/vmStatusSectionWindow.jsp --%>

   // performance section window
   <%-- test whether cpuUsage or memoryUsage are empty or zero --%>
   <bean:define id="vmHasCpuEntry" value="false" />
   <bean:define id="vmHasMemEntry" value="false" />
   <logic:notEmpty name="vmTabView" property="vmDataItem.cpuUsage" >
      <logic:notEqual name="vmTabView" property="vmDataItem.cpuUsage" value="0">
            <bean:define id="vmHasCpuEntry" value="true" />
      </logic:notEqual>
   </logic:notEmpty>
   <logic:notEmpty name="vmTabView" property="vmDataItem.memoryUsage" >
      <logic:notEqual name="vmTabView" property="vmDataItem.memoryUsage" value="0">
            <bean:define id="vmHasMemEntry" value="true" />
      </logic:notEqual>
   </logic:notEmpty>

   <logic:equal name="vmHasMemEntry" value="true">
      setMemoryPerf(<bean:write name="vmTabView" property="vmDataItem.memoryUsage"/>, intMaxMemoryUsage, 'memBarLabel', 'memBarPct'); <%-- see sectionWindows/vmPerformanceSectionWindow.jsp --%>
   </logic:equal>
   <logic:equal name="vmHasCpuEntry" value="true">
      setCpuPerf(<bean:write name="vmTabView" property="vmDataItem.cpuUsage"/>, intMaxCpuUsage, 'cpuBarLabel', 'cpuBarPct'); <%-- see sectionWindows/vmPerformanceSectionWindow.jsp --%>
   </logic:equal>

   <logic:equal name="vmHasCpuEntry" value="false">
      setCpuUnavailable('cpuBarLabel', 'cpuBarPct');
   </logic:equal>
   <logic:equal name="vmHasMemEntry" value="false">
      setMemoryUnavailable('memBarLabel', 'memBarPct', '<bean:message key="vmDetails.tab.summary.performance.notAvailable" />');
   </logic:equal>

   vmSummarySetHardwareOverflow();
   vpx.xua.event.listen(self, "resize", vmSummarySetHardwareOverflow);


   //set alarm state icon in VM title bar
   <c:if test="${viewManager.multiHost}">
     <c:if test="${!empty vmView.vmDataItem.state}">
       window.parent.setTitleAlarm("<c:out value='${vmView.vmDataItem.state}' />");
     </c:if>
   </c:if>

   window.hardware.selfCheck();
}


function vmSummarySetHardwareOverflow() {
   var hwContainer = $("hardwareTableContainer");
   var hwTable = $("hardwareTable");

   var minWidth = vpx.xua.getMinWidth(hwTable);
   var minHeight = vpx.xua.getMinHeight(hwTable);

   if (minWidth > vpx.xua.getWidth(hwContainer) ||
      minHeight > vpx.xua.getHeight(hwContainer)) {
      vpx.xua.setStyle(hwContainer, "overflow", "auto");
   } else {
      vpx.xua.setStyle(hwContainer, "overflow", "hidden");
   }
}


function vmSummaryOnUnload() {
   resetHelp();

   for (var i = 0; i < window.vmSummaryUpdatesIds.length; i++) {
      tle.ignoreUpdates(window.vmSummaryUpdatesIds[i]);
   }

   <c:if test="${viewManager.multiHost}">
      // Recent Alarms
      vpx.context.recentAlarms.destroy();  <%-- @see sectionWindows/vmAlarms.jsp --%>
   </c:if>

   // Active Tasks
   vpx.context.activeTasks.destroy();   <%-- @see sectionWindows/vmActiveTasks.jsp --%>
}

function handleVmSummaryUpdates(agent, refresh, changeSets) {
   if (refresh) {
      <%-- XXX Can we be more clever than simply reloading the whole page? --%>
      window.location.reload(false);
      return;
   }

   var pc = new vpx.util.view.PropertyCollector();
   for (var i = 0; i < changeSets.length; i++) {
      var changeSet = changeSets[i];
      vpx.log.debug("vmSummary: received changeSet (id=" + changeSet.id +
                    ";type=" + changeSet.type + ")");
      switch (changeSet.type) {
      case "VirtualMachine":
         processVmUpdates(pc, changeSet);
         break;
      case "Host":
         processHostUpdates(changeSet);
         break;
      case "vm_summary_view.guestInfo":
         processGuestInfoUpdates(pc, changeSet);
         break;
      case "vm_view.disk":
         processHdUpdates(changeSet);
         break;
      case "vm_view.nic":
         processNicUpdates(pc, changeSet);
         break;
      case "vm_view.cdrom":
      case "vm_view.floppyDrive":
      case "vm_view.parallelPort":
      case "vm_view.serialPort":
         processHardwareUpdates(changeSet);
         break;
      case "vm_view.cdromDeviceBacking":
      case "vm_view.floppyDeviceBacking":
      case "vm_view.pPortDeviceBacking":
      case "vm_view.sPortDeviceBacking":
         processHardwareBackingUpdates(changeSet, "<fmt:message key='vm.hardware.backing.deviceName' bundle='${internalResources}'/>");
         break;
      case "vm_view.cdromFileBacking":
      case "vm_view.floppyFileBacking":
      case "vm_view.pPortFileBacking":
      case "vm_view.sPortFileBacking":
         processHardwareBackingUpdates(changeSet, "<fmt:message key='vm.hardware.backing.fileName' bundle='${internalResources}'/>");
         break;
      case "vm_view.cdromRemoteDeviceBacking":
      case "vm_view.floppyRemoteDeviceBacking":
         <%-- Per changeset 369604, these are no longer displayed; ignore --%>
         break;
      case "vm_view.sPortPipeBacking":
         processHardwareBackingUpdates(changeSet, "<fmt:message key='vm.hardware.backing.pipeName' bundle='${internalResources}'/>");
         break;
      default:
         processUnknownUpdates(changeSet);
      }
   }
   pc.sync();
}

function processVmUpdates(pc, changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "<fmt:message key='vm.performance.virtualCPUs.maxUsage' bundle='${internalResources}' />":
         intMaxCpuUsage = change.value;
         break;
      case "<fmt:message key='vm.performance.memory.maxUsage' bundle='${internalResources}' />":
         intMaxMemoryUsage = change.value;
         break;
      case "<fmt:message key='vm.performance.virtualCPUs.usage' bundle='${internalResources}' />":
         <%-- see sectionWindows/vmPerformanceSectionWindow.jsp --%>
         setCpuPerf(change.value, intMaxCpuUsage, 'cpuBarLabel', 'cpuBarPct');
         break;
      case "<fmt:message key='vm.performance.memory.usage' bundle='${internalResources}' />":
         <%-- see sectionWindows/vmPerformanceSectionWindow.jsp --%>
         setMemoryPerf(change.value, intMaxMemoryUsage, 'memBarLabel', 'memBarPct');
         break;
      case "<%= Constants.POWER_STATE %>":
         if ( change.value == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_SUSPENDED %>' ||
              change.value == '<%= VMODLConstants.VIRTUALMACHINEPOWERSTATE_POWEREDOFF %>' )
         {
            setPerfUnavailable('cpuBarLabel', 'memBarLabel', 'cpuBarPct', 'memBarPct');
         }
         break;
      case "<fmt:message key='vm.hardware.memory.sizeMb' bundle='${internalResources}' />":
         setMemorySize(changeSet, change, "mb");
         break;
      case "guestId":
         processGuestUpdates(pc, changeSet, change);
         break;
      case "<fmt:message key='vm.status.toolsInstallerMounted' bundle='${internalResources}' />":
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.guestInfo.vmtool");
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.powerState");
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.toolsInstallerMounted");
         pc.addPropertyListener(new vpx.context.ToolsListener());
         break;
      default:
         updateDataItemValue(changeSet, change);
      }
   }

}

function processHostUpdates(changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      updateDataItemValue(changeSet, change);
   }
}

function processGuestUpdates(pc, changeSet, change) {
   pc.addProperty("<c:out value='${vmTabView.ID}'/>", "guestOsDescriptor.fullName");
   pc.addProperty("<c:out value='${vmTabView.ID}'/>", "guestOsDescriptor.family");
   pc.addPropertyListener(new vpx.context.GuestListener());
}

function processGuestInfoUpdates(pc, changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "vmtool":
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.guestInfo.vmtool");
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.powerState");
         pc.addProperty("<c:out value='${vmTabView.ID}'/>",
            "vmDataItem.toolsInstallerMounted");
         pc.addPropertyListener(new vpx.context.ToolsListener());
         break;
      case "dnsName":
         var el = document.getElementById("dnsName");
         if (change.value == "") {
            el.innerHTML = '<span id="l10n_vmDetails.tab.summary.status.notAvailable">' +
               '<fmt:message key="vmDetails.tab.summary.status.notAvailable" bundle="${messageResources}"/></span>';
         } else {
            el.innerHTML = change.value;
         }
         break;
      case "ipAddress":
         var el = document.getElementById("ipAddress");
         if (change.value == "") {
            el.innerHTML = '<span id="l10n_vmDetails.tab.summary.status.notAvailable">' +
               '<fmt:message key="vmDetails.tab.summary.status.notAvailable" bundle="${messageResources}"/></span>';
         } else {
            el.innerHTML = '<ul><li>' + change.value + '</li></ul>';
         }
         break;
   }
   }
}

function processHdUpdates(changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "sizeKB":
         setMemorySize(changeSet, change, "kb");
         break;
      case "key":
         // we do not support dynamic key changes yet so we refresh instead
         window.location.reload(false);
         return;
      }
   }
}

function processNicUpdates(pc, changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "networkName":
         var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.nic.network' bundle='${internalResources}'/>");
         el.innerHTML = change.value.escapeElement();
         pc.addProperty("<c:out value='${vmView.ID}'/>", "networkNames");
         pc.addPropertyListener(new vpx.context.NetworksListener());
         break;
      case "connected":
         var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.connected' bundle='${internalResources}'/>");
         var isConnected = change.value.toBool();
         if (isConnected) {
            vpx.xua.removeClass(el, "networkAdapterDisconnected-16x16");
            vpx.xua.addClass(el, "networkAdapter-16x16");
         } else {
            vpx.xua.removeClass(el, "networkAdapter-16x16");
            vpx.xua.addClass(el, "networkAdapterDisconnected-16x16");
         }
         break;
      case "key":
         // we do not support dynamic key changes yet so we refresh instead
         window.location.reload(false);
         return;
      }
   }
}

function processHardwareUpdates(changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "backingType":
         var backingTypeStr = "<fmt:message key='vm.hardware.backing.type' bundle='${internalResources}'/>";
         var elsId = changeSet.id + "_" + backingTypeStr;
         var els = document.getElementById(elsId).getElementsByTagName("DIV");
         switch (change.value) {
         case "deviceBacking":
            var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.backing.type.device' bundle='${internalResources}'/>");
            break;
         case "fileBacking":
            var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.backing.type.file' bundle='${internalResources}'/>");
            break;
         case "remoteDeviceBacking":
            var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.backing.type.remote' bundle='${internalResources}'/>");
            break;
         case "pipeBacking":
            var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.backing.type.pipe' bundle='${internalResources}'/>");
            break;
         }
         for (var i = 0; i < els.length; i++) {
            if (els[i].getAttribute("name") == elsId) {
               <%-- Passed safety check of being a DIV that we care about --%>
               if (els[i] == el) {
                  els[i].style.display = "";
               } else {
                  els[i].style.display = "none";
               }
            }
         }
         break;
      case "connected":
         var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.connected' bundle='${internalResources}'/>");
         var isConnected = change.value.toBool();
         var classDisconnected = null;
         var classConnected = null;

         switch (changeSet.type) {
            case "vm_view.cdrom":
               classConnected = "cdDvdDrive-16x16";
               classDisconnected = "cdDvdDriveDisconnected-16x16";
               break;
            case "vm_view.floppyDrive":
               classConnected = "floppyDrive-16x16";
               classDisconnected = "floppyDriveDisconnected-16x16";
               break;
            case "vm_view.parallelPort":
               classConnected = "parallelPort-16x16";
               classDisconnected = "parallelPortDisconnected-16x16";
               break;
            case "vm_view.serialPort":
               classConnected = "serialPort-16x16";
               classDisconnected = "serialPortDisconnected-16x16";
               break;
            default:
               break;
         }

         if (isConnected) {
            vpx.xua.removeClass(el, classDisconnected);
            vpx.xua.addClass(el, classConnected);
         } else {
            vpx.xua.removeClass(el, classConnected);
            vpx.xua.addClass(el, classDisconnected);
         }
         break;
      case "deviceNumber":
         var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.cd.deviceNumber' bundle='${internalResources}'/>");
         el.innerHTML = change.value;
         break;
      case "controllerId":
         var el = document.getElementById(changeSet.id + "_<fmt:message key='vm.hardware.cd.controllerId' bundle='${internalResources}'/>");
         el.innerHTML = change.value;
         break;
      case "key":
         // we do not support dynamic key changes yet so we refresh instead
         window.location.reload(false);
         return;
      }
   }
}

function processHardwareBackingUpdates(changeSet, backingKey) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: received change (property=" + change.property +
                    ";value=" + change.value + ")");
      switch (change.property) {
      case "deviceName":
      case "fileName":
      case "pipeName":
         var el = document.getElementById(changeSet.id + "_" + backingKey);
         el.innerHTML = change.value.escapeElement();
         break;
      case "key":
         // we do not support dynamic key changes yet so we refresh instead
         window.location.reload(false);
         return;
      }
   }
}

function processUnknownUpdates(changeSet) {
   for (var i = 0; i < changeSet.changes.length; i++) {
      var change = changeSet.changes[i];
      vpx.log.debug("vmSummary: IGNORING change (property=" + change.property +
                    ";value=" + change.value + ")");
   }
}

function setMemorySize(changeSet, change, units) {
   var span = document.getElementById(changeSet.id + "_" + change.property);
   if (span != null) {
      var req = tle.getRequest("unitsConvert.do?<%= UnitsConversionAction.PARAM_AMT %>=" + change.value +
                               "&<%= UnitsConversionAction.PARAM_INPUT_UNIT %>=" + units +
                               "&<%= UnitsConversionAction.PARAM_TYPE %>=byte" );
      if (req == null) {
         <%-- Wait for thread to become available and try again --%>
         window.setTimeout(setMemorySize.bind(this, changeSet, change, units), 500);
         return;
      }
      try {
         req.addResponseListener(new vpx.util.HtmlEditor(span));
         req.send();
      } finally {
         tle.releaseRequest(req);
      }
   }
}

function updateDataItemValue(changeSet, change) {
   var span = document.getElementById(changeSet.id + "_" + change.property);
   updateSpanValue(span, change.value);
}

function updateSpanValue(span, value) {
   if (value != null && span) {
      if (span.filters && span.filters[0]) {
         span.filters[0].apply();
         span.filters[0].play();
      }
      span.innerHTML = value.escapeElement();
   }
}

</script>

</head>
<body onload="vmSummaryOnLoad();" onunload="vmSummaryOnUnload();" scroll="yes">
<form name="summaryForm" id="summaryForm">
   <%-- start column0 --%>
   <div id="column0">
      <c:if test="${viewManager.multiHost}">
	 <jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmAlarms.jsp" >
	    <jsp:param name="dialogId" value="recentAlarms"/>
	 </jsp:include>
      </c:if>

      <jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmActiveTasks.jsp">
	 <jsp:param name="dialogId" value="activeTasks"/>
      </jsp:include>

      <div id="performance" class="dialog"><jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmPerformanceSectionWindow.jsp"/></div>

      <!-- Start Hardware section window -->
      <div id="hardware" class="dialog"><jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmHardwareSectionWindow.jsp"/></div>
      <!-- End Hardware section window -->
   </div>
   <%-- end column0 --%>

   <%-- start column1 --%>
   <div id="column1">
      <div id="status" class="dialog"><jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmStatusSectionWindow.jsp"/></div>
      <div id="commands" class="dialog"><jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmCommandsSectionWindow.jsp"/></div>
      <div id="relationships" class="dialog"><jsp:include page="/WEB-INF/jsp/details/vm/tabs/summary/sectionWindows/vmRelatedSectionWindow.jsp"/></div>
   </div>
   <%-- end column1 --%>
  </form>
</body>
</html:html>
