<%@ include file="/WEB-INF/jsp/common/xmlHeader.jsp"%>
<%@ page import="com.vmware.webcenter.util.VMODLConstants,
                 java.util.Date,
                 com.vmware.webcenter.view.viewhelper.VmTasksListView,
                 com.vmware.webcenter.util.SortCriteria "%>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>

<browserPane page="<c:out value='${vmTasksListView.currentPageNumber}' />"
             total="<c:out value='${vmTasksListView.totalSize}' />">
   <cols sort="<c:out value='${vmTasksListView.primarySortCriteria.property}' />"
      dir="<c:out value='${vmTasksListView.primarySortCriteria.sortOrder}' />">

      <col name="<%= VmTasksListView.TASK_TRIGGERED %>"
           display="<fmt:message key='vmDetails.tab.tasks.list.col.triggered' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmTasksListView.TASK_TRIGGERED_BY %>"
           display="<fmt:message key='vmDetails.tab.tasks.list.col.triggeredBy' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmTasksListView.TASK_STATUS %>"
           display="<fmt:message key='vmDetails.tab.tasks.list.col.status' bundle='${messageResources}' />"
           canSort="true"/>

      <col name="<%= VmTasksListView.TASK_MESSAGE %>"
           display="<fmt:message key='vmDetails.tab.tasks.list.col.desc' bundle='${messageResources}' />"
           canSort="true"
           widest="true"/>
   </cols>

   <nodes>
      <c:forEach var="task" items="${vmTasksListView.currentPage}" varStatus="iterStatus">
         <c:set var="status" value="${task.state}"/>
         <c:set var="stateDesc">
            vmDetails.tab.tasks.status.state.<c:out value="${task.state}"/>
         </c:set>

         <node id="<c:out value='${task.ID}'/>" iconClass="task-16x16">
            <col>
               <cell>
                  <fmt:formatDate value="${task.triggeredDate}"  type="both" timeStyle="long" dateStyle="short"/>
               </cell>
            </col>

            <col>
               <cell>
                  <c:out value="${task.triggeredBy}"/>
               </cell>
            </col>

            <col>
               <c:if test="${status == 'success' || status == 'queued'}">

                  <cell>
                    <table><tr><td> <div class="okay-12x12 icon"/> </td><td class="nowrap"><fmt:message key='${stateDesc}' bundle='${messageResources}'/></td></tr></table>
                  </cell>
               </c:if>

               <c:if test="${status == 'error'}">

                  <cell>
                    <table><tr><td><div class="error-12x12 icon"/> </td><td class="nowrap"><fmt:message key='${stateDesc}' bundle='${messageResources}'/></td></tr></table>
                  </cell>
               </c:if>

               <c:if test="${status == 'running'}">
                  <c:choose>
                     <c:when test="${task.progress > 0}">
                        <c:set var="taskBarPct" value="${'taskBarPct'}:${iterStatus.index}"/>
                        <c:set var="taskBarLabel" value="${'taskBarLabel'}:${iterStatus.index}"/>
                        <c:set var="bgPosition" value="${'background-position:'}${task.progress}${'px;'}"/>
                        <cell>
                           <table>
                              <tr>
                                 <td>
                                    <div id="<c:out value="${taskBarPct}"/>" class="perfBarCompact"
                                         style="<c:out value="${bgPosition}"/>" >
                                       <img src="spacer.png" class="vstrut"/>
                                       <table class="perfBarFg">
                                          <!-- <colgroup><col id="colWidth" span="10" style="width:10%"/></colgroup> -->
                                          <tr>
                                             <td class="lcol"/><td /><td /><td /><td /><td /><td /><td /><td /><td />
                                          </tr>
                                       </table>
                                    </div>
                                 </td>
                                 <td>
                                    <div class="perfBarLabelCompact nowrap">
                                       <span id="<c:out value='${taskBarLabel}'/>"><c:out value="${task.progress}"/>%</span>
                                    </div>
                                 </td>
                              </tr>
                           </table>
                        </cell>
                     </c:when>
                     <c:otherwise>
                        <cell>
                           <table><tr><td><div class="loading-9x9 icon"/> </td><td class="nowrap"><fmt:message key='${stateDesc}' bundle='${messageResources}'/></td></tr></table>
                        </cell>
                     </c:otherwise>
                  </c:choose>
               </c:if>
            </col>

            <col>
               <cell>
                  <c:out value="${task.description}"/>
               </cell>
            </col>
         </node>
      </c:forEach>
   </nodes>

   <attrs>
      <attr name="viewId" value="<c:out value='${vmTasksListView.ID}' />"/>
   </attrs>

   <c:if test="${vmTasksListView.selectedItem != null}">
      <selections>
         <selection id="<c:out value='${vmTasksListView.selectedItem.ID}' />"/>
      </selections>
   </c:if>
</browserPane>
