<%@ page import="com.vmware.webcenter.control.action.DataCollectionBaseAction,
                 com.vmware.webcenter.control.action.VmTasksListAction,
                 com.vmware.webcenter.control.action.VmTaskDetailsAction,
                 com.vmware.webcenter.view.viewhelper.Constants"%>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp"%>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
<head>
<link href="css/default.css" rel="stylesheet" type="text/css"/>
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp"%>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua,gui,browser"/>
</jsp:include>
<%@ include file="/WEB-INF/jsp/common/helpJs.jsp" %>
<script type="text/javascript" src="js/details/tabs/common.js"></script>
<%-- The following javaScript file "fullScreenButtonChecker.js" should be 
     included for all the tabs except the Console tab
--%>
<script type="text/javascript" src="js/details/tabs/fullScreenButtonChecker.js"></script>

<%-- Common JS file for Alarms and Tasks --%>

<script src="js/details/tabs/vmAlarmNTasks.js"></script>

<%--
  The following parameters can be shared across Alarms and Tasks.
  XML_ACTION       : Action name for generating the browser XML.
  SELECTION_ACTION : Action for selecting the each row. This will
		     be called during the handleSelectionChanged.
  FRAME_ID         : Frame ID is to locate the iFrame for related events.
  TAB_NAME         : Current tab i.e tasks tab, alarms tab.
 --%>

<script type="text/javascript">
vpx.context.curr = vpx.context["vmTasks"] = {
	xmlSpec                : null,
	paginator              : null,
	browser                : null,
	updatesId              : null,
	updatesRunning         : false,
	PAGE_SIZE              : "<%= Constants.PAGE_DEFAULT_SIZE %>",
	DC_PREV_PAGE           : "<%= DataCollectionBaseAction.DC_PREV_PAGE %>",
	DC_NEXT_PAGE           : "<%= DataCollectionBaseAction.DC_NEXT_PAGE %>",
	PARAM_NAME_PAGE        : "<%= VmTasksListAction.PARAM_NAME_PAGE %>",
	PARAM_NAME_SORT_COL    : "<%= VmTasksListAction.PARAM_NAME_SORT_COL %>",
	PARAM_NAME_SORT_DIR    : "<%= VmTasksListAction.PARAM_NAME_SORT_DIR %>",
	PARAM_NAME_ENTITY_ID   : "<%= VmTasksListAction.PARAM_NAME_ENTITY_ID %>",
	PARAM_NAME_SLCT_ID     : "<%= VmTaskDetailsAction.PARAM_NAME_SLCT_ID %>",
	PARAM_NAME_VIEW_ID     : "<%= VmTaskDetailsAction.PARAM_NAME_VIEW_ID %>",
	VM_NAME                : "<wc:jsSafe name="vmTabView" property="vmDataItem.name" />",
	ENTITY_ID              : "<c:out value='${vmTabView.vmDataItem.ID}' />",
	XML_ACTION             : "vmTasksListView.do",
	SELECTION_ACTION       : "vmTaskDetialsView.do",
	FRAME_ID               : "taskDetails",
	TAB_NAME               : "<%= Constants.TAB_VM_TASKS %>"
};

function init() {
   <%-- The following function is in fullScreenButtonChecker.js --%>
   initMonitorableFullScreenButton();

   setupHelp("<bean:message bundle="helpFiles" key="help.vm.tasks"/>");
   handleBodyLoad('tasks');
   setTimeout(handleResize, 0);
   vpx.xua.event.listen(self, "resize", handleResize);
}

function tearDown() {
   resetHelp();
   handleBodyUnload('tasks');
}

function handleResize() {
   var tbh = vpx.xua.getHeight("listTitlebar");
   var pch = vpx.xua.getHeight("paginatorContainer");
   var dch = vpx.xua.getHeight("details");
   var off = vpx.xua.getY("list") * 4;
   var height = vpx.xua.viewport.getHeight(self);

   vpx.xua.setHeight("browserContainer", height - dch - tbh - pch - off);
}
</script>
</head>

<body onload="init();" onunload="tearDown();" style="overflow:hidden; margin:0px; padding:0px;" scroll="no">
<div id="list" class="dialog">
   <div id="listTitlebar" class="titlebar">
      <table border="0" cellspacing="0" cellpadding="0">
	 <tr>
	    <td width="100%"><span class="sectionTitle"><bean:message key="vmDetails.tab.tasks.list.header"/></span></td>
	 </tr>
      </table>
   </div>

   <div style="border-bottom: solid 1px #B3B3B3; padding: 0px;">
      <div id="browserContainer" class="cntnr" style="overflow:auto;"></div>
      <div id="paginatorContainer"></div>
   </div>
</div>

<div id="details" class="dialog">
   <div class="titlebar">
      <table border="0" cellspacing="0" cellpadding="0">
	 <tr>
	    <td width="100%"><span class="sectionTitle"><bean:message key="vmDetails.tab.tasks.details.header"/></span></td>
	 </tr>
      </table>
   </div>

   <div class="pagedList" style="width:100%">
      <table class="listView" width="100%">
	 <tr>
	    <td>
	       <iframe name="taskDetails" frameborder="no" src="html/blank.html" style="width:100%;"></iframe>
	    </td>
	 </tr>
      </table>
   </div>
</div>
</body>
</html:html>
