<%@ page import="com.vmware.webcenter.view.viewhelper.Constants,
                 com.vmware.webcenter.util.VMODLConstants" %>
<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>
<%@ include file="/WEB-INF/jsp/common/contextTest.jsp" %>
<%@ include file="/WEB-INF/jsp/common/docType.jsp" %>
<c:set var="VIEW_MANAGER_KEY" value="<%= Constants.BEAN_VIEW_MANAGER %>" scope="page" />
<c:set var="viewManager" value="${sessionScope[VIEW_MANAGER_KEY]}" scope="page" />
<bean:parameter id="vmTab" name="vmTab" value=""/>
<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
   <head>
   <link rel="stylesheet" type="text/css" href="css/details/detailsMain.css" />

   <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
   <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
      <jsp:param name="packages" value="xua,win,drag,util" />
   </jsp:include>
   <script type="text/javascript" src="js/details/entityDetails.js"></script>

   <script type="text/javascript">
   vpx.context.stateUpdates = {
      updatesRunning : false,
      updatesId      : null
   };

   vpx.context.titleUpdates = {
      updatesRunning : false,
      updatesId      : null
   };

   vpx.context.deviceMenuUpdates = {
      viewId         : "<c:out value='${vmView.ID}' />",
      updatesRunning : false,
      updatesId      : null
   };

   // written by the jsp page
   var tabUrls = new Array();
   tabUrls['<%= Constants.TAB_VM_SUMMARY %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_SUMMARY %>";
   tabUrls['<%= Constants.TAB_VM_EVENTS %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_EVENTS %>";

   <c:if test="${viewManager.multiHost}">
      tabUrls['<%= Constants.TAB_VM_ALARMS %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_ALARMS %>";
      tabUrls['<%= Constants.TAB_VM_TASKS %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_TASKS %>";
   </c:if>
   <%--
   tabUrls['<%= Constants.TAB_VM_PERFORMANCE %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_PERFORMANCE %>";
   tabUrls['<%= Constants.TAB_VM_HARDWARE %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_HARDWARE %>";
   --%>
   tabUrls['<%= Constants.TAB_VM_CONSOLE %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_CONSOLE %>";

   tabUrls['<%= Constants.TAB_VM_SNAPSHOTS %>'] = "vmTabView.do?entityId=<%= request.getParameter("entityId") %>&vmTab=<%= Constants.TAB_VM_SNAPSHOTS %>";

   var isTabRefreshNeeded = false;
   var toolbar = null;
   var toolbarPowerIconStatePC = null;

   function initialize() {
      toolbarPowerIconStatePC = new vpx.util.view.PropertyCollector();
      toolbarPowerIconStatePC.addProperty("<c:out value='${vmView.ID}' />", "vmDataItem.SuspendVM");
      toolbarPowerIconStatePC.addProperty("<c:out value='${vmView.ID}' />", "vmDataItem.PowerOnVM");
      toolbarPowerIconStatePC.addProperty("<c:out value='${vmView.ID}' />", "vmDataItem.PowerOffVM");
      toolbarPowerIconStatePC.addProperty("<c:out value='${vmView.ID}' />", "vmDataItem.ResetVM");
      toolbarPowerIconStatePC.addPropertyListener(new vpx.context.toolbarPowerIconStateListener());

      tle.getTopBarPane().setupToolbar.monitoredInvoke(
         "<c:out value='${vmView.overallPowerStatus}' />",
         "<c:out value='${vmView.vmDataItem.powerOffType}'/>",
         "<c:out value='${vmView.vmDataItem.powerOffPreset}'/>",
         "<c:out value='${vmView.vmDataItem.resetType}'/>",
         "<c:out value='${vmView.vmDataItem.resetPreset}'/>",
         <c:out value='${vmView.vmDataItem.PowerOffVM}'/>,
         <c:out value='${vmView.vmDataItem.PowerOnVM}'/>,
         <c:out value='${vmView.vmDataItem.SuspendVM}'/>,
         <c:out value='${vmView.vmDataItem.ResetVM}'/>,
         <c:out value='${vmView.vmDataItem.ShutdownGuest}'/>,
         <c:out value='${vmView.vmDataItem.RebootGuest}'/>
      );

      toolbar = tle.getTopBarPane().toolbar;
      startStateUpdates("<c:out value='${vmView.ID}' />");
      startTitleUpdates("<c:out value='${vmView.ID}' />", "name");

      initDeviceMenus("<c:out value='${vmView.ID}' />");
   }

   function handleBodyUnload() {
      stopStateUpdates();
      stopTitleUpdates();
      tle.getTopBarPane().disableToolbarNMenu();
      destroyDeviceMenus();
   }

   <%--
   /**
    * Callback that gets run when the workspace details' tab page signals that
    * it now allows a page refresh.  If we're waiting to refresh the page, we
    * will respond by refreshing the tab page.  If we weren't waiting to
    * refresh, nothing happens.
    */
   --%>
   function tabRefreshAllowed() {
      if (window.isTabRefreshNeeded) {
         window.isTabRefreshNeeded = false;
         var context = vpx.xua.viewport.getView($("workspaceDetails"));
         if (isDefined(context)) {
            context.location.reload(false);
         }
      }
   }

   <%--
   /**
    * start toolbar updates
    * @param viewId Id of the view to register updates
    */
   --%>
   function startStateUpdates(viewId) {
      // Shorthand for brevity's sake
      var c = vpx.context.stateUpdates;

      if (c.updatesRunning) {
	      //?? TODO Check for existing listenerId's viewId & NO-OP if same as viewId
	      stopStateUpdates();
      }

      c.updatesRunning = true;
      c.updatesId = tle.listenForUpdates(viewId, "VmView", handleStateNToolbarUpdates);
   }


   <%--
   /**
    *
    */
   --%>
   function stopStateUpdates() {
      // Shorthand for brevity's sake
      var c = vpx.context.stateUpdates;
      if (c.updatesRunning) {
         tle.ignoreUpdates(c.updatesId);
         c.updatesRunning = false;
      }
   }


   <%--
   /**
    * Starts listening for server updates that pertain to the vm's title
    *
    * @param viewId String
    *    ID of the VmView
    * @param property String
    *    Property key in the view that will signal a change in vm name
    */
   --%>
   function startTitleUpdates(viewId, property) {
      // Shorthand for brevity's sake
      var c = vpx.context.titleUpdates;

      if (c.updatesRunning) {
         //?? TODO Check for existing listenerId's viewId & NO-OP if same as viewId
         stopTitleUpdates();
      }

      c.property = property;
      c.updatesRunning = true;
      c.updatesId = tle.listenForUpdates(viewId, "VmView", handleTitleUpdates);
   }


   <%--
   /**
    * Stops updates for the vm's title from being requested from the
    * server.
    */
   --%>
   function stopTitleUpdates() {
      // Shorthand for brevity's sake
      var c = vpx.context.titleUpdates;
      if (c.updatesRunning) {
         tle.ignoreUpdates(c.updatesId);
         c.updatesRunning = false;
      }
   }


   <%--
   /**
    * Initializes the device menus from the given view.  If any existing device
    * menus have already been instantiated, they will be torn down before the
    * new one(s) are added.
    *
    * @param viewId String
    *    The id of the view that contains device info
    */
   --%>
   function initDeviceMenus(viewId) {
      var c = vpx.context.deviceMenuUpdates;

      var view = tle.getTopBarPane();
      if (view.vpx.context.deviceMenus != null) {
         <%-- We need to tear down existing device menus --%>
         destroyDeviceMenus();
      }

      if (c.updatesRunning) {
         tle.ignoreUpdates(c.updatesId);
         c.updatesRunning = false;
      }
      c.updatesRunning = true;
      c.updatesId = tle.listenForUpdates(viewId, "VmView.DeviceMenus",
                                         checkDeviceMenuRefresh);

      view.vpx.context.deviceMenus = tle.createGui(view,
          "vmDeviceMenuXml.do?viewId=" + viewId);
   }

   <%--
   /**
    * Destroys any device menus that have been instantiated.
    */
   --%>
   function destroyDeviceMenus() {
      var c = vpx.context.deviceMenuUpdates;
      if (c.updatesRunning) {
         tle.ignoreUpdates(c.updatesId);
         c.updatesRunning = false;
      }

      var view = tle.getTopBarPane();
      var container = view.document.getElementById("toolbarDeviceMenus");
      var oldMenus = view.vpx.context.deviceMenus;
      for (var i = 0; i < oldMenus.length; i++) {
         var menu = oldMenus[i];
         //?? TODO Destroy menu, not simply remove it from parent container
         container.removeChild(menu.getPeer());
      }
      delete view.vpx.context.deviceMenus;
      view.vpx.context.deviceMenus = null;
   }

   <%--
   /**
    * Check for a refresh update on the view that controls device menu data.
    * The device menu buttons will internally handle changeSet updates, so we
    * need only concern ourselves with refresh updates by re-initializing all
    * device menus.
    *
    * @param agent vpx.updates.Agent
    *    The agent that fired the event
    * @param refresh boolean
    *    true if a full refresh is required; false otherwise
    * @param changeSets Object[]
    *    An array of changeSet objects
    */
   --%>
   function checkDeviceMenuRefresh(agent, refresh, changeSets) {
      if (refresh) {
         initDeviceMenus(vpx.context.deviceMenuUpdates.viewId);
      }
   }

   <%--
   /**
    * handle state and toolbar updates. Process the changesets toolbar and
    * menu's interested in
    *
    * @param agent vpx.updates.Agent
    *    The agent that fired the event
    * @param refresh boolean
    *    true if a full refresh is required; false otherwise
    * @param changeSets Object[]
    *    An array of changeSet objects, each having the
    *    following attributes:
    *       id      : String
    *       type    : String
    *       changes : Object[] {property:String, value:String}
    */
   --%>
   function handleStateNToolbarUpdates(agent, refresh, changeSets){
      if (refresh) {
         // Make sure to update the toolbar as well.
         toolbarPowerIconStatePC.sync();
         var context = vpx.xua.viewport.getView($("workspaceDetails"));
         if (isDefined(context) && context.isRefreshAllowed) {
            context.location.reload(false);
         } else {
            window.isTabRefreshNeeded = true;
         }
         return;
      }

      if (changeSets == null || changeSets.length == 0){
         return;
      }

      var wsPane = tle.getWorkspacePane().workspaceDetails;
      var form = wsPane.document.forms[0];

      if (!isNull(form) && form.name == 'summaryForm') {
         if (!isNull(wsPane.updateCommands)) {
            wsPane.updateCommands(changeSets);
         }
      }

      for (var i = 0; i < changeSets.length; i++) {
         var changeSet = changeSets[i];
         vpx.log.debug("changeSet: (id=" + changeSet.id + " type=" + changeSet.type + ")");

         for (var j = 0; j < changeSet.changes.length; j++) {
            var change = changeSet.changes[j];
            vpx.log.debug("change: (prop=" + change.property + " val=" + change.value + ")");

            // connection state requires reload
            if (change.property == "connectionState") {
               window.location.reload(false);
            }

            // Set the VM title alaram icon
            if (change.property == "state") {
              setTitleAlarm(change.value);
            }

            var syncPowerStates = false;
            if (!isNull(form) && form.name == 'summaryForm') {
               switch (change.property) {
                  case "overallPowerStatus":
                     wsPane.setPowerState(change.value);
                     syncPowerStates = true;
                     break;
                  case "MountToolsInstaller":
                     wsPane.toggleToolsMountTextDisabled(change.value.toBool());
                     break;
                  case "UnmountToolsInstaller":
                     wsPane.toggleToolsUnMountTextDisabled(change.value.toBool());
                     break;
                  default:
                     break;
               }
            }

            toolbar.updateVMMenu(change);
            toolbar.updateToolbar(change);

            if (syncPowerStates) {
               toolbarPowerIconStatePC.sync();
            }
         }
      }
   }

   <%--
   /**
    * Handles updates to the vm's name (shown in the title bar).  All other
    * updates will be ignored.
    */
   --%>
   function handleTitleUpdates(agent, refresh, changeSets) {
      var c = vpx.context.titleUpdates;

      if (refresh) {
         <%-- Title update will never come as refresh update --%>
         return;
      }

      if (changeSets == null) {
         return;
      }

      for (var i = 0; i < changeSets.length; i++) {
         var changeSet = changeSets[i];
         if (changeSet.type == "<%= Constants.TYPE_VM %>") {
            for (var j = 0; j < changeSet.changes.length; j++) {
               var change = changeSet.changes[j];
               if (change.property == c.property) {
                  setTitleBar("VM", change.value);
               }
            }
         }
      }
   }

   vpx.context.toolbarPowerIconStateListener = function toolbarPowerIconStateListener () {};
   vpx.context.toolbarPowerIconStateListener.prototype.propertiesUpdated = function(e) {
      var pc = e.getSource();

      var suspendVM =
         pc.getProperty("<c:out value='${vmView.ID}' />", "vmDataItem.SuspendVM");
      var powerOnVM =
         pc.getProperty("<c:out value='${vmView.ID}' />", "vmDataItem.PowerOnVM");
      var powerOffVM =
         pc.getProperty("<c:out value='${vmView.ID}' />", "vmDataItem.PowerOffVM");
      var resetVM =
         pc.getProperty("<c:out value='${vmView.ID}' />", "vmDataItem.ResetVM");

      toolbar.updateToolbar({property: "SuspendVM", value:suspendVM});
      toolbar.updateToolbar({property: "PowerOnVM", value:powerOnVM});
      toolbar.updateToolbar({property: "PowerOffVM", value:powerOffVM});
      toolbar.updateToolbar({property: "ResetVM", value:resetVM});
   };

   </script>
   </head>

   <body onload="initialize();" onunload="handleBodyUnload();">

<c:url var="titledUrl" value="detailsTitle.do">
  <c:param name="title" value="${vmView.vmDataItem.name}" />
</c:url>

   <iframe id="workspaceTitle" name="workspaceTitle" src="${titledUrl}" frameborder="no" scrolling="no"></iframe>
   <iframe id="workspaceTabs" name="workspaceTabs" style="display:none;" src="vmDetailsTabs.do" frameborder="no" scrolling="no"></iframe>
   <iframe id="workspaceDetails" class="workspaceDetailsNonExclusive" style="display:none;" name="workspaceDetails" src="vmTabView.do?entityId=<c:out value='${param.entityId}' />&vmTab=<c:out value='${vmTab}' />" frameborder="no" Allowtransparency="true"></iframe>
   </body>
</html:html>
