<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<%-- Note that the locale attribute will be deprecated in Struts 1.2 and turned into "lang" --%>
<html:html locale="true">
   <head>

      <link href="css/default.css" rel="stylesheet" type="text/css" />
      <link href="css/summary.css" rel="stylesheet" type="text/css" />
      <!--[if IE]>
      <link href="css/default-ie.css" rel="stylesheet" type="text/css" />
      <![endif]-->

      <%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
      <jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
         <jsp:param name="packages" value="xua,win,drag" />
      </jsp:include>

      <c:set var="canAnswer" value="${permissionToAnswerQuestion}" />

      <script type="text/javascript" src="js/details/tabs/vmSummary.js"></script>

      <script type="text/javascript">
         function handleBodyOnLoad(){
            window.parent.setTitleBar('VM','<wc:jsSafe name="vmView" property="vmDataItem.name" />')
            window.parent.startStateUpdates("<c:out value='${vmView.ID}' />");

            // Waiting for input is transient state; don't save changes to view
            tle.setTabsVisible(false, true);
            tle.setToolbarVisible(false, true);

            showQuestion();
         }

         function showQuestion() {
            var rootUrl = "vmWaitForInput.do?viewId=<c:out value='${vmView.ID}' />&render=dialog&canAnswer=<c:out value='${canAnswer}'/>";
            var rs = new vpx.win.RootSpec(new vpx.win.SourceSpec(vpx.win.SOURCE_TYPE_URL, rootUrl));

            var msgBox = new vpx.win.Frame(null /* contentSpec */, null /* frameSpec */, rs, self);

            msgBox.listen("ready", function (o) {
               o.setPlacementPolicy(o.PLACEMENT_POLICY_CENTER);
               o.setModal(true);
               o.open();
            });

            msgBox.listen("okay", respond.bind(msgBox));
            msgBox.listen("cancel", cancel.bind(msgBox));

            msgBox.init();
         }

         function respond() {
            var form = document.answerForm;
            form.questionId.value = this.questionId;
            form.choice.value = this.choice;
            form.submit();
         }

         function cancel() {
            // They can't cancel; Make them answer the quesiton
            showQuestion();
         }
      </script>

   </head>
   <body onload="handleBodyOnLoad()">
      <form name="answerForm" action="vmAnswerQuestion.do" method="GET">
         <input type="hidden" name="viewId" value="<c:out value='${vmView.ID}' />" />
         <input type="hidden" name="questionId" value="" />
         <input type="hidden" name="choice" value="" />
      </form>
   </body>
</html:html>
