<%@ include file="/WEB-INF/jsp/common/taglibs.jsp" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">

<html>
<head>
<title>Question</title>
<link href="css/default.css" rel="stylesheet" type="text/css" />
<link href="css/messageBox.css" rel="stylesheet" type="text/css" />
<!--[if IE]>
<link href="css/default-ie.css" rel="stylesheet" type="text/css" />
<![endif]-->
<style type="text/css">
   body {
      margin: 0px;
      padding: 0px;
      border: none;
      overflow: hidden;
   }
   .titlebar .title {
      margin-left: 0px;
   }
   div.commandButtons {
      border-top: solid 1px #e6e6e6;
      margin: 8px;
      margin-top: 0px;
      padding-top: 8px;
   }
</style>

<%@ include file="/WEB-INF/jsp/common/commonJs.jsp" %>
<jsp:include page="/WEB-INF/jsp/common/vpxJs.jsp">
   <jsp:param name="packages" value="xua,drag" />
</jsp:include>

<script>
var vpxWin;
var methods = {};
methods.setFocus = function () {
   var index = <c:out value="${vmView.question.choice.defaultIndex}" />
   $("button_" + index).focus();
};

methods.getContentDimension = function() {
   var windowPane = $("windowPane");
   var wpw = vpx.xua.getWidth(windowPane);

   var btns = $("windowControls");
   vpx.xua.setStyle(btns, "overflow", "auto");
   var w = btns.scrollWidth;

   // The buttons do not fit in the allocated width.
   if (w > wpw) {
      // Without this assignment, w does not include the right margin,
      // which is significant.
      w += parseInt(vpx.xua.getStyle("commandButtons", "marginRight"), 10);
      w = vpx.xua.setWidth(windowPane, w + 2);
   } else {
      w = vpx.xua.setWidth(windowPane, wpw);
   }

   vpx.xua.setStyle(btns, "overflow", "hidden");

   // XXX: IE doesn't adjust window pane's height appropriately. The
   // result is excessive padding.
   var h = vpx.xua.getMinHeight(windowPane);

   return new Dimension(w, h);
};

function initPane(o) {
   vpxWin = o;
   var handles = $("windowTitleCell");
   if (! isArray(handles)) {
      handles = [handles];
   }

   // XXX: We should locate the draggable context programatically.
   //vpxWin.context.vpx.drag.init(handles, [vpxWin.element]);
   //vpxWin.context.vpx.drag.setBoundaryByElement(handles, vpxWin.context);
   //vpxWin.context.vpx.drag.listen(handles, "start", dragStart);
   //vpxWin.context.vpx.drag.listen(handles, "drag", dragDrag);
   //vpxWin.context.vpx.drag.listen(handles, "end", dragEnd);

   extendObject(vpxWin, methods);

   document.onkeyup = function (e) {
      if (vpx.xua.event.getKeyCode(e) == 27) {
	 vpxWin.cancel();
      }
   };


   var btns = [];
   <c:forEach items="${vmView.question.choice.choiceInfo}" var="choice">
   btns.push($("button_<c:out value='${choice.key}' />"));
   </c:forEach>

   // XXX: Make button widths comfortable manually because width:auto;
   // min-width:72px; aligns the button labels left.
   for (var i = 0; i < btns.length; i++) {
      var w = vpx.xua.getWidth(btns[i]);

      if (w < 72) {
	 vpx.xua.setWidth(btns[i], 72);
      }
   }

   vpxWin.ready();
   vpx.xua.setPosition("windowPane", 0, 0);
};


dragStart = function (e) {
   vpx.xua.setStyle("windowViewport", "position", "absolute");
   var dim = vpx.xua.getDimension("windowViewport");
   vpx.xua.setPosition("windowViewport", new Position(0,0).subtract(dim.toPosition()));
   vpx.xua.setStyle("windowControls", "display", "none");
};


dragDrag = function (e) {
   window.status = vpx.xua.event.getPosition(e);
   return true;
};

dragEnd = function (e) {
   vpx.xua.setStyle("windowViewport", "position", "static");
   vpx.xua.setStyle("windowControls", "display", "");
};

function handleRespond(questionId, choice) {
   vpxWin.questionId = questionId;
   vpxWin.choice = choice;
   vpxWin.okay();
}
</script>
</head>

<body>
<div id="windowPane" class="dialog half" style="position:absolute; top:0px; left:0px; border-bottom:solid 1px #b3b3b3; margin:0px; padding-bottom:0px;">
   <div id="windowTitleBar" class="titlebar">
      <table border="0" cellspacing="0" cellpadding="0">
	 <tr>
	    <td id="windowTitleCell" width="100%"><span id="windowTitle" class="title"><bean:message key="vmDetails.tab.WFIDialog.question.title"/></span></td>
	 </tr>
      </table>
   </div>
   <!-- div style="width:100%; height:120px; background-color:#c00;" / -->

   <c:set var="canAnswer" value="${param.canAnswer}" />
   <div style="margin: 8px;">
      <table style="border-collapse: collapse;" border="0" cellpadding="0" cellspacing="0">
	 <tr>
	    <td valign="top"><div id="windowIcon" class="icon question-32x32" /></td>
	    <td>
          <div id="synopsis" class="titleText"><bean:message key="vmDetails.tab.WFIDialog.vmWaiting.titleText"/></div>
	       <div id="windowMessage" class="detailsText"><c:out value="${fn:replace(vmView.question.text, \"/\", \"/<wbr />\")}" escapeXml="false" /></div>
	       <!-- XXX: According to the spec, these should be the non-cancel
		    options, but which option corresponds to cancel cannot be
		    determined programatically without parsing a potentially
		    localized string. -->
	       <c:forEach items="${vmView.question.choice.choiceInfo}" var="choice">
		  <c:if test="${choice.key != vmView.question.choice.defaultIndex}">
                     <c:choose>
                         <c:when test="${canAnswer == 'true'}">
		             <div class="operationText"><a id="button_<c:out value='${choice.key}' />" href="javascript:handleRespond('<c:out value='${vmView.question.id}' />', '<c:out value='${choice.key}' />');"><c:out value='${choice.summary}' /></a></div>
                         </c:when>
                         <c:otherwise>
		             <div class="detailsText" id="button_<c:out value='${choice.key}' />"><c:out value='${choice.summary}' /></div>
                         </c:otherwise>
                     </c:choose>
		  </c:if>
	       </c:forEach>
	    </td>
	 </tr>
      </table>
   </div>
   <div id="windowControls">
      <div id="commandButtons" class="commandButtons"><c:forEach items="${vmView.question.choice.choiceInfo}" var="choice">
	 <!-- XXX: According to the spec, this should be the cancel option, but
              which option corresponds to cancel cannot be determined
	      programatically without parsing a potentially localized string. -->
	 <c:if test="${choice.key == vmView.question.choice.defaultIndex}">
                     <c:choose>
                         <c:when test="${canAnswer == 'true'}">
	    <input class="buttonCtrl" style="width:auto; min-width:inherit;" type="button" id="button_<c:out value='${choice.key}' />" value="<c:out value='${choice.summary}' />" onclick="handleRespond('<c:out value='${vmView.question.id}' />', '<c:out value='${choice.key}' />');" />
                         </c:when>
                         <c:otherwise>
	    <input class="buttonCtrl disabled" style="width:auto; min-width:inherit;" type="button" id="button_<c:out value='${choice.key}' />" value="<c:out value='${choice.summary}' />" />
                         </c:otherwise>
                     </c:choose>
	 </c:if>
      </c:forEach></div>
   </div>
</div>
</body>
</html>
